/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.CurrentTransactionProvider;
import com.google.appengine.api.datastore.DatastoreCallbacks;
import com.google.appengine.api.datastore.DeleteContext;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FutureHelper;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.PostOpFuture;
import com.google.appengine.api.datastore.PutContext;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionStack;
import com.google.appengine.api.utils.FutureWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;

class TransactionImpl
implements Transaction,
CurrentTransactionProvider {
    private static final Logger logger = Logger.getLogger(TransactionImpl.class.getName());
    private final String app;
    private final TransactionStack txnStack;
    private final DatastoreCallbacks callbacks;
    private final boolean isExplicit;
    private final InternalTransaction internalTransaction;
    TransactionState state = TransactionState.BEGUN;

    TransactionImpl(String app, TransactionStack txnStack, DatastoreCallbacks callbacks, boolean isExplicit, InternalTransaction txnProvider) {
        this.app = app;
        this.txnStack = txnStack;
        this.callbacks = callbacks;
        this.isExplicit = isExplicit;
        this.internalTransaction = txnProvider;
    }

    @Override
    public String getId() {
        return this.internalTransaction.getId();
    }

    public boolean equals(@Nullable Object o) {
        if (o instanceof TransactionImpl) {
            return this.internalTransaction.equals(((TransactionImpl)o).internalTransaction);
        }
        return false;
    }

    public int hashCode() {
        return this.internalTransaction.hashCode();
    }

    @Override
    public void commit() {
        FutureHelper.quietGet(this.commitAsync());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> commitAsync() {
        TransactionImpl.ensureTxnActive(this);
        try {
            ArrayList<RuntimeException> exceptions = new ArrayList<RuntimeException>();
            for (Future future : this.txnStack.getFutures(this)) {
                try {
                    FutureHelper.quietGet(future);
                }
                catch (RuntimeException e) {
                    exceptions.add(e);
                }
            }
            if (!exceptions.isEmpty()) {
                for (int i = 1; i < exceptions.size(); ++i) {
                    RuntimeException runtimeException = (RuntimeException)exceptions.get(i);
                    logger.log(Level.WARNING, "Failure while waiting to commit", runtimeException);
                }
                throw (RuntimeException)exceptions.get(0);
            }
            Future<Void> commitResponse = this.internalTransaction.doCommitAsync();
            this.state = TransactionState.COMPLETION_IN_PROGRESS;
            FutureWrapper<Void, Void> futureWrapper = new FutureWrapper<Void, Void>(commitResponse){

                @Override
                protected Void wrap(Void ignore) throws Exception {
                    TransactionImpl.this.state = TransactionState.COMMITTED;
                    return null;
                }

                @Override
                protected Throwable convertException(Throwable cause) {
                    TransactionImpl.this.state = TransactionState.ERROR;
                    return cause;
                }
            };
            PostCommitFuture postCommitFuture = new PostCommitFuture(this.txnStack.getPutEntities(this), this.txnStack.getDeletedKeys(this), futureWrapper);
            return postCommitFuture;
        }
        finally {
            if (this.isExplicit) {
                this.txnStack.remove(this);
            }
        }
    }

    @Override
    public void rollback() {
        FutureHelper.quietGet(this.rollbackAsync());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> rollbackAsync() {
        TransactionImpl.ensureTxnActive(this);
        try {
            for (Future futureWrapper : this.txnStack.getFutures(this)) {
                try {
                    FutureHelper.quietGet(futureWrapper);
                }
                catch (RuntimeException e) {
                    logger.log(Level.INFO, "Failure while waiting to rollback", e);
                }
            }
            Future<Void> future = this.internalTransaction.doRollbackAsync();
            this.state = TransactionState.COMPLETION_IN_PROGRESS;
            FutureWrapper<Void, Void> futureWrapper = new FutureWrapper<Void, Void>(future){

                @Override
                protected Void wrap(Void ignore) throws Exception {
                    TransactionImpl.this.state = TransactionState.ROLLED_BACK;
                    return null;
                }

                @Override
                protected Void absorbParentException(Throwable cause) throws Throwable {
                    logger.log(Level.INFO, "Rollback of transaction failed", cause);
                    TransactionImpl.this.state = TransactionState.ERROR;
                    return null;
                }

                @Override
                protected Throwable convertException(Throwable cause) {
                    TransactionImpl.this.state = TransactionState.ERROR;
                    return cause;
                }
            };
            return futureWrapper;
        }
        finally {
            if (this.isExplicit) {
                this.txnStack.remove(this);
            }
        }
    }

    @Override
    public String getApp() {
        return this.app;
    }

    @Override
    public boolean isActive() {
        return this.state == TransactionState.BEGUN;
    }

    @Override
    public Transaction getCurrentTransaction(Transaction defaultValue) {
        return this;
    }

    static void ensureTxnActive(Transaction txn) {
        if (txn != null && !txn.isActive()) {
            throw new IllegalStateException("Transaction with which this operation is associated is not active.");
        }
    }

    public String toString() {
        String string = this.app;
        String string2 = this.getId();
        String string3 = String.valueOf((Object)this.state);
        return new StringBuilder(9 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Txn [").append(string).append(".").append(string2).append(", ").append(string3).append("]").toString();
    }

    private class PostCommitFuture
    extends PostOpFuture<Void> {
        private final List<Entity> putEntities;
        private final List<Key> deletedKeys;

        private PostCommitFuture(List<Entity> putEntities, List<Key> deletedKeys, Future<Void> delegate) {
            super(delegate, TransactionImpl.this.callbacks);
            this.putEntities = putEntities;
            this.deletedKeys = deletedKeys;
        }

        @Override
        void executeCallbacks(Void ignoreMe) {
            PutContext putContext = new PutContext((CurrentTransactionProvider)TransactionImpl.this, this.putEntities);
            TransactionImpl.this.callbacks.executePostPutCallbacks(putContext);
            DeleteContext deleteContext = new DeleteContext((CurrentTransactionProvider)TransactionImpl.this, this.deletedKeys);
            TransactionImpl.this.callbacks.executePostDeleteCallbacks(deleteContext);
        }
    }

    static enum TransactionState {
        BEGUN,
        COMPLETION_IN_PROGRESS,
        COMMITTED,
        ROLLED_BACK,
        ERROR;

    }

    static interface InternalTransaction {
        public Future<Void> doCommitAsync();

        public Future<Void> doRollbackAsync();

        public String getId();

        public boolean equals(@Nullable Object var1);

        public int hashCode();
    }
}

