/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.repackaged.com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;

class PrefixTrie<T> {
    private final char rangeOffset;
    private final int rangeSize;
    private final Node<T> root;

    PrefixTrie() {
        this.rangeOffset = '\u0000';
        this.rangeSize = 128;
        this.root = new Node(this.rangeSize);
    }

    PrefixTrie(char firstCharInRange, char lastCharInRange) {
        this.rangeOffset = firstCharInRange;
        this.rangeSize = lastCharInRange - firstCharInRange + 1;
        if (this.rangeSize <= 0) {
            throw new IllegalArgumentException("Char range must include some chars");
        }
        this.root = new Node(this.rangeSize);
    }

    T put(CharSequence prefix, T value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return this.putInternal(prefix, value);
    }

    private T putInternal(CharSequence prefix, T value) {
        Node<T> current = this.root;
        for (int i = 0; i < prefix.length(); ++i) {
            int nodeIndex = prefix.charAt(i) - this.rangeOffset;
            try {
                Node next = current.next[nodeIndex];
                if (next == null) {
                    next = current.next[nodeIndex] = new Node(this.rangeSize);
                }
                current = next;
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                char c = prefix.charAt(i);
                throw new IllegalArgumentException(new StringBuilder(36).append("'").append(c).append("' is not a legal prefix character.").toString());
            }
        }
        Object oldValue = current.value;
        current.value = value;
        return oldValue;
    }

    T get(CharSequence s) {
        Node<T> deepestWithValue = this.root;
        Node<T> current = this.root;
        for (int i = 0; i < s.length(); ++i) {
            int nodeIndex = s.charAt(i) - this.rangeOffset;
            if (nodeIndex < 0 || this.rangeSize <= nodeIndex) {
                return null;
            }
            current = current.next[nodeIndex];
            if (current == null) break;
            if (current.value == null) continue;
            deepestWithValue = current;
        }
        return deepestWithValue.value;
    }

    T remove(CharSequence prefix) {
        return this.putInternal(prefix, null);
    }

    Map<String, T> toMap() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        this.addEntries(this.root, new StringBuilder(), map);
        return map;
    }

    private void addEntries(Node<T> node, StringBuilder builder, Map<String, T> map) {
        if (node.value != null) {
            map.put(builder.toString(), node.value);
        }
        for (int i = 0; i < node.next.length; ++i) {
            Node next = node.next[i];
            if (next == null) continue;
            builder.append((char)(i + this.rangeOffset));
            this.addEntries(next, builder, map);
            builder.deleteCharAt(builder.length() - 1);
        }
    }

    private static class Node<T> {
        T value;
        final Node<T>[] next;

        Node(int numChildren) {
            this.next = new Node[numChildren];
        }
    }
}

