/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api;

import com.google.apphosting.api.ApiProxy;
import java.util.regex.Pattern;

public final class NamespaceManager {
    private static final int NAMESPACE_MAX_LENGTH = 100;
    private static final String NAMESPACE_REGEX = "[0-9A-Za-z._-]{0,100}";
    private static final Pattern NAMESPACE_PATTERN = Pattern.compile("[0-9A-Za-z._-]{0,100}");
    private static final String CURRENT_NAMESPACE_KEY = String.valueOf(NamespaceManager.class.getName()).concat(".currentNamespace");
    private static final String APPS_NAMESPACE_KEY = String.valueOf(NamespaceManager.class.getName()).concat(".appsNamespace");

    public static void set(String newNamespace) {
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        if (newNamespace == null) {
            if (environment != null) {
                environment.getAttributes().remove(CURRENT_NAMESPACE_KEY);
            }
        } else {
            NamespaceManager.validateNamespace(newNamespace);
            if (environment == null) {
                throw new NullPointerException("Operation not allowed in a thread that is neither the original request thread nor a thread created by ThreadManager");
            }
            environment.getAttributes().put(CURRENT_NAMESPACE_KEY, newNamespace);
        }
    }

    public static String get() {
        return NamespaceManager.getNamespaceForKey(CURRENT_NAMESPACE_KEY);
    }

    public static String getGoogleAppsNamespace() {
        String appsNamespace = NamespaceManager.getNamespaceForKey(APPS_NAMESPACE_KEY);
        return appsNamespace == null ? "" : appsNamespace;
    }

    private static String getNamespaceForKey(String key) {
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        if (environment == null) {
            return null;
        }
        return (String)environment.getAttributes().get(key);
    }

    public static void validateNamespace(String namespace) {
        if (!NAMESPACE_PATTERN.matcher(namespace).matches()) {
            String string = String.valueOf(NAMESPACE_PATTERN);
            throw new IllegalArgumentException(new StringBuilder(39 + String.valueOf(namespace).length() + String.valueOf(string).length()).append("Namespace '").append(namespace).append("' does not match pattern '").append(string).append("'.").toString());
        }
    }

    private NamespaceManager() {
    }
}

