/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.images;

import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.blobstore.BlobstoreServiceFactory;
import com.google.appengine.api.images.Composite;
import com.google.appengine.api.images.CompositeImpl;
import com.google.appengine.api.images.CompositeTransform;
import com.google.appengine.api.images.Crop;
import com.google.appengine.api.images.HorizontalFlip;
import com.google.appengine.api.images.ImFeelingLucky;
import com.google.appengine.api.images.Image;
import com.google.appengine.api.images.ImageImpl;
import com.google.appengine.api.images.ImagesService;
import com.google.appengine.api.images.ImagesServiceImpl;
import com.google.appengine.api.images.Resize;
import com.google.appengine.api.images.Rotate;
import com.google.appengine.api.images.Transform;
import com.google.appengine.api.images.VerticalFlip;
import java.util.Collection;

public final class ImagesServiceFactory {
    public static ImagesService getImagesService() {
        return new ImagesServiceImpl();
    }

    public static Image makeImage(byte[] imageData) {
        return new ImageImpl(imageData);
    }

    public static Image makeImageFromBlob(BlobKey blobKey) {
        return new ImageImpl(blobKey);
    }

    public static Image makeImageFromFilename(String filename) {
        BlobKey blobKey = BlobstoreServiceFactory.getBlobstoreService().createGsBlobKey(filename);
        return new ImageImpl(blobKey);
    }

    public static Transform makeResize(int width, int height) {
        return new Resize(width, height, false, 0.0f, 0.0f);
    }

    public static Transform makeResize(int width, int height, boolean allowStretch) {
        return new Resize(width, height, allowStretch);
    }

    public static Transform makeResize(int width, int height, float cropOffsetX, float cropOffsetY) {
        return new Resize(width, height, true, cropOffsetX, cropOffsetY);
    }

    public static Transform makeResize(int width, int height, double cropOffsetX, double cropOffsetY) {
        return new Resize(width, height, true, (float)cropOffsetX, (float)cropOffsetY);
    }

    public static Transform makeCrop(float leftX, float topY, float rightX, float bottomY) {
        return new Crop(leftX, topY, rightX, bottomY);
    }

    public static Transform makeCrop(double leftX, double topY, double rightX, double bottomY) {
        return ImagesServiceFactory.makeCrop((float)leftX, (float)topY, (float)rightX, (float)bottomY);
    }

    public static Transform makeVerticalFlip() {
        return new VerticalFlip();
    }

    public static Transform makeHorizontalFlip() {
        return new HorizontalFlip();
    }

    public static Transform makeRotate(int degrees) {
        return new Rotate(degrees);
    }

    public static Transform makeImFeelingLucky() {
        return new ImFeelingLucky();
    }

    public static CompositeTransform makeCompositeTransform(Collection<Transform> transforms) {
        return new CompositeTransform(transforms);
    }

    public static CompositeTransform makeCompositeTransform() {
        return new CompositeTransform();
    }

    public static Composite makeComposite(Image image, int xOffset, int yOffset, float opacity, Composite.Anchor anchor) {
        return new CompositeImpl(image, xOffset, yOffset, opacity, anchor);
    }

    private ImagesServiceFactory() {
    }
}

