/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-05-05 20:00:12 UTC)
 * on 2015-05-14 at 00:48:04 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.storage.model;

/**
 * A Compose request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Storage API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ComposeRequest extends com.google.api.client.json.GenericJson {

  /**
   * Properties of the resulting object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private StorageObject destination;

  /**
   * The kind of item this is.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The list of source objects that will be concatenated into a single object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<SourceObjects> sourceObjects;

  static {
    // hack to force ProGuard to consider SourceObjects used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(SourceObjects.class);
  }

  /**
   * Properties of the resulting object.
   * @return value or {@code null} for none
   */
  public StorageObject getDestination() {
    return destination;
  }

  /**
   * Properties of the resulting object.
   * @param destination destination or {@code null} for none
   */
  public ComposeRequest setDestination(StorageObject destination) {
    this.destination = destination;
    return this;
  }

  /**
   * The kind of item this is.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The kind of item this is.
   * @param kind kind or {@code null} for none
   */
  public ComposeRequest setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The list of source objects that will be concatenated into a single object.
   * @return value or {@code null} for none
   */
  public java.util.List<SourceObjects> getSourceObjects() {
    return sourceObjects;
  }

  /**
   * The list of source objects that will be concatenated into a single object.
   * @param sourceObjects sourceObjects or {@code null} for none
   */
  public ComposeRequest setSourceObjects(java.util.List<SourceObjects> sourceObjects) {
    this.sourceObjects = sourceObjects;
    return this;
  }

  @Override
  public ComposeRequest set(String fieldName, Object value) {
    return (ComposeRequest) super.set(fieldName, value);
  }

  @Override
  public ComposeRequest clone() {
    return (ComposeRequest) super.clone();
  }

  /**
   * Model definition for ComposeRequestSourceObjects.
   */
  public static final class SourceObjects extends com.google.api.client.json.GenericJson {

    /**
     * The generation of this object to use as the source.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key @com.google.api.client.json.JsonString
    private java.lang.Long generation;

    /**
     * The source object's name. The source object's bucket is implicitly the destination bucket.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String name;

    /**
     * Conditions that must be met for this operation to execute.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private ObjectPreconditions objectPreconditions;

    /**
     * The generation of this object to use as the source.
     * @return value or {@code null} for none
     */
    public java.lang.Long getGeneration() {
      return generation;
    }

    /**
     * The generation of this object to use as the source.
     * @param generation generation or {@code null} for none
     */
    public SourceObjects setGeneration(java.lang.Long generation) {
      this.generation = generation;
      return this;
    }

    /**
     * The source object's name. The source object's bucket is implicitly the destination bucket.
     * @return value or {@code null} for none
     */
    public java.lang.String getName() {
      return name;
    }

    /**
     * The source object's name. The source object's bucket is implicitly the destination bucket.
     * @param name name or {@code null} for none
     */
    public SourceObjects setName(java.lang.String name) {
      this.name = name;
      return this;
    }

    /**
     * Conditions that must be met for this operation to execute.
     * @return value or {@code null} for none
     */
    public ObjectPreconditions getObjectPreconditions() {
      return objectPreconditions;
    }

    /**
     * Conditions that must be met for this operation to execute.
     * @param objectPreconditions objectPreconditions or {@code null} for none
     */
    public SourceObjects setObjectPreconditions(ObjectPreconditions objectPreconditions) {
      this.objectPreconditions = objectPreconditions;
      return this;
    }

    @Override
    public SourceObjects set(String fieldName, Object value) {
      return (SourceObjects) super.set(fieldName, value);
    }

    @Override
    public SourceObjects clone() {
      return (SourceObjects) super.clone();
    }

    /**
     * Conditions that must be met for this operation to execute.
     */
    public static final class ObjectPreconditions extends com.google.api.client.json.GenericJson {

      /**
       * Only perform the composition if the generation of the source object that would be used matches
       * this value. If this value and a generation are both specified, they must be the same value or
       * the call will fail.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key @com.google.api.client.json.JsonString
      private java.lang.Long ifGenerationMatch;

      /**
       * Only perform the composition if the generation of the source object that would be used matches
       * this value. If this value and a generation are both specified, they must be the same value or
       * the call will fail.
       * @return value or {@code null} for none
       */
      public java.lang.Long getIfGenerationMatch() {
        return ifGenerationMatch;
      }

      /**
       * Only perform the composition if the generation of the source object that would be used matches
       * this value. If this value and a generation are both specified, they must be the same value or
       * the call will fail.
       * @param ifGenerationMatch ifGenerationMatch or {@code null} for none
       */
      public ObjectPreconditions setIfGenerationMatch(java.lang.Long ifGenerationMatch) {
        this.ifGenerationMatch = ifGenerationMatch;
        return this;
      }

      @Override
      public ObjectPreconditions set(String fieldName, Object value) {
        return (ObjectPreconditions) super.set(fieldName, value);
      }

      @Override
      public ObjectPreconditions clone() {
        return (ObjectPreconditions) super.clone();
      }

    }
  }

}
