/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * The table row properties.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TableRowsProperties extends com.google.api.client.json.GenericJson {

  /**
   * The first color that is alternating. If this field is set, the first banded row is filled with
   * the specified color. Otherwise, the first banded row is filled with a default color.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ColorStyle firstBandColorStyle;

  /**
   * The color of the last row. If this field is not set a footer is not added, the last row is
   * filled with either first_band_color_style or second_band_color_style, depending on the color of
   * the previous row. If updating an existing table without a footer to have a footer, the range
   * will be expanded by 1 row. If updating an existing table with a footer and removing a footer,
   * the range will be shrunk by 1 row.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ColorStyle footerColorStyle;

  /**
   * The color of the header row. If this field is set, the header row is filled with the specified
   * color. Otherwise, the header row is filled with a default color.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ColorStyle headerColorStyle;

  /**
   * The second color that is alternating. If this field is set, the second banded row is filled
   * with the specified color. Otherwise, the second banded row is filled with a default color.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ColorStyle secondBandColorStyle;

  /**
   * The first color that is alternating. If this field is set, the first banded row is filled with
   * the specified color. Otherwise, the first banded row is filled with a default color.
   * @return value or {@code null} for none
   */
  public ColorStyle getFirstBandColorStyle() {
    return firstBandColorStyle;
  }

  /**
   * The first color that is alternating. If this field is set, the first banded row is filled with
   * the specified color. Otherwise, the first banded row is filled with a default color.
   * @param firstBandColorStyle firstBandColorStyle or {@code null} for none
   */
  public TableRowsProperties setFirstBandColorStyle(ColorStyle firstBandColorStyle) {
    this.firstBandColorStyle = firstBandColorStyle;
    return this;
  }

  /**
   * The color of the last row. If this field is not set a footer is not added, the last row is
   * filled with either first_band_color_style or second_band_color_style, depending on the color of
   * the previous row. If updating an existing table without a footer to have a footer, the range
   * will be expanded by 1 row. If updating an existing table with a footer and removing a footer,
   * the range will be shrunk by 1 row.
   * @return value or {@code null} for none
   */
  public ColorStyle getFooterColorStyle() {
    return footerColorStyle;
  }

  /**
   * The color of the last row. If this field is not set a footer is not added, the last row is
   * filled with either first_band_color_style or second_band_color_style, depending on the color of
   * the previous row. If updating an existing table without a footer to have a footer, the range
   * will be expanded by 1 row. If updating an existing table with a footer and removing a footer,
   * the range will be shrunk by 1 row.
   * @param footerColorStyle footerColorStyle or {@code null} for none
   */
  public TableRowsProperties setFooterColorStyle(ColorStyle footerColorStyle) {
    this.footerColorStyle = footerColorStyle;
    return this;
  }

  /**
   * The color of the header row. If this field is set, the header row is filled with the specified
   * color. Otherwise, the header row is filled with a default color.
   * @return value or {@code null} for none
   */
  public ColorStyle getHeaderColorStyle() {
    return headerColorStyle;
  }

  /**
   * The color of the header row. If this field is set, the header row is filled with the specified
   * color. Otherwise, the header row is filled with a default color.
   * @param headerColorStyle headerColorStyle or {@code null} for none
   */
  public TableRowsProperties setHeaderColorStyle(ColorStyle headerColorStyle) {
    this.headerColorStyle = headerColorStyle;
    return this;
  }

  /**
   * The second color that is alternating. If this field is set, the second banded row is filled
   * with the specified color. Otherwise, the second banded row is filled with a default color.
   * @return value or {@code null} for none
   */
  public ColorStyle getSecondBandColorStyle() {
    return secondBandColorStyle;
  }

  /**
   * The second color that is alternating. If this field is set, the second banded row is filled
   * with the specified color. Otherwise, the second banded row is filled with a default color.
   * @param secondBandColorStyle secondBandColorStyle or {@code null} for none
   */
  public TableRowsProperties setSecondBandColorStyle(ColorStyle secondBandColorStyle) {
    this.secondBandColorStyle = secondBandColorStyle;
    return this;
  }

  @Override
  public TableRowsProperties set(String fieldName, Object value) {
    return (TableRowsProperties) super.set(fieldName, value);
  }

  @Override
  public TableRowsProperties clone() {
    return (TableRowsProperties) super.clone();
  }

}
