/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * A table.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Table extends com.google.api.client.json.GenericJson {

  /**
   * The table column properties.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TableColumnProperties> columnProperties;

  /**
   * The table name. This is unique to all tables in the same spreadsheet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The table range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GridRange range;

  /**
   * The table rows properties.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableRowsProperties rowsProperties;

  /**
   * The id of the table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tableId;

  /**
   * The table column properties.
   * @return value or {@code null} for none
   */
  public java.util.List<TableColumnProperties> getColumnProperties() {
    return columnProperties;
  }

  /**
   * The table column properties.
   * @param columnProperties columnProperties or {@code null} for none
   */
  public Table setColumnProperties(java.util.List<TableColumnProperties> columnProperties) {
    this.columnProperties = columnProperties;
    return this;
  }

  /**
   * The table name. This is unique to all tables in the same spreadsheet.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The table name. This is unique to all tables in the same spreadsheet.
   * @param name name or {@code null} for none
   */
  public Table setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The table range.
   * @return value or {@code null} for none
   */
  public GridRange getRange() {
    return range;
  }

  /**
   * The table range.
   * @param range range or {@code null} for none
   */
  public Table setRange(GridRange range) {
    this.range = range;
    return this;
  }

  /**
   * The table rows properties.
   * @return value or {@code null} for none
   */
  public TableRowsProperties getRowsProperties() {
    return rowsProperties;
  }

  /**
   * The table rows properties.
   * @param rowsProperties rowsProperties or {@code null} for none
   */
  public Table setRowsProperties(TableRowsProperties rowsProperties) {
    this.rowsProperties = rowsProperties;
    return this;
  }

  /**
   * The id of the table.
   * @return value or {@code null} for none
   */
  public java.lang.String getTableId() {
    return tableId;
  }

  /**
   * The id of the table.
   * @param tableId tableId or {@code null} for none
   */
  public Table setTableId(java.lang.String tableId) {
    this.tableId = tableId;
    return this;
  }

  @Override
  public Table set(String fieldName, Object value) {
    return (Table) super.set(fieldName, value);
  }

  @Override
  public Table clone() {
    return (Table) super.clone();
  }

}
