/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Properties of a link to a Google resource (such as a file in Drive, a YouTube video, a Maps
 * address, or a Calendar event). Only Drive files can be written as chips. All other rich link
 * types are read only. URIs cannot exceed 2000 bytes when writing. NOTE: Writing Drive file chips
 * requires at least one of the `drive.file`, `drive.readonly`, or `drive` OAuth scopes.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RichLinkProperties extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The [MIME type](https://developers.google.com/drive/api/v3/mime-types) of the
   * link, if there's one (for example, when it's a file in Drive).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mimeType;

  /**
   * Required. The URI to the link. This is always present.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String uri;

  /**
   * Output only. The [MIME type](https://developers.google.com/drive/api/v3/mime-types) of the
   * link, if there's one (for example, when it's a file in Drive).
   * @return value or {@code null} for none
   */
  public java.lang.String getMimeType() {
    return mimeType;
  }

  /**
   * Output only. The [MIME type](https://developers.google.com/drive/api/v3/mime-types) of the
   * link, if there's one (for example, when it's a file in Drive).
   * @param mimeType mimeType or {@code null} for none
   */
  public RichLinkProperties setMimeType(java.lang.String mimeType) {
    this.mimeType = mimeType;
    return this;
  }

  /**
   * Required. The URI to the link. This is always present.
   * @return value or {@code null} for none
   */
  public java.lang.String getUri() {
    return uri;
  }

  /**
   * Required. The URI to the link. This is always present.
   * @param uri uri or {@code null} for none
   */
  public RichLinkProperties setUri(java.lang.String uri) {
    this.uri = uri;
    return this;
  }

  @Override
  public RichLinkProperties set(String fieldName, Object value) {
    return (RichLinkProperties) super.set(fieldName, value);
  }

  @Override
  public RichLinkProperties clone() {
    return (RichLinkProperties) super.clone();
  }

}
