/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Properties specific to a linked person.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PersonProperties extends com.google.api.client.json.GenericJson {

  /**
   * Optional. The display format of the person chip. If not set, the default display format is
   * used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayFormat;

  /**
   * Required. The email address linked to this person. This field is always present.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String email;

  /**
   * Optional. The display format of the person chip. If not set, the default display format is
   * used.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayFormat() {
    return displayFormat;
  }

  /**
   * Optional. The display format of the person chip. If not set, the default display format is
   * used.
   * @param displayFormat displayFormat or {@code null} for none
   */
  public PersonProperties setDisplayFormat(java.lang.String displayFormat) {
    this.displayFormat = displayFormat;
    return this;
  }

  /**
   * Required. The email address linked to this person. This field is always present.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmail() {
    return email;
  }

  /**
   * Required. The email address linked to this person. This field is always present.
   * @param email email or {@code null} for none
   */
  public PersonProperties setEmail(java.lang.String email) {
    this.email = email;
    return this;
  }

  @Override
  public PersonProperties set(String fieldName, Object value) {
    return (PersonProperties) super.set(fieldName, value);
  }

  @Override
  public PersonProperties clone() {
    return (PersonProperties) super.clone();
  }

}
