/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * The run of a chip. The chip continues until the start index of the next run.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ChipRun extends com.google.api.client.json.GenericJson {

  /**
   * Optional. The chip of this run.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Chip chip;

  /**
   * Required. The zero-based character index where this run starts, in UTF-16 code units.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer startIndex;

  /**
   * Optional. The chip of this run.
   * @return value or {@code null} for none
   */
  public Chip getChip() {
    return chip;
  }

  /**
   * Optional. The chip of this run.
   * @param chip chip or {@code null} for none
   */
  public ChipRun setChip(Chip chip) {
    this.chip = chip;
    return this;
  }

  /**
   * Required. The zero-based character index where this run starts, in UTF-16 code units.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getStartIndex() {
    return startIndex;
  }

  /**
   * Required. The zero-based character index where this run starts, in UTF-16 code units.
   * @param startIndex startIndex or {@code null} for none
   */
  public ChipRun setStartIndex(java.lang.Integer startIndex) {
    this.startIndex = startIndex;
    return this;
  }

  @Override
  public ChipRun set(String fieldName, Object value) {
    return (ChipRun) super.set(fieldName, value);
  }

  @Override
  public ChipRun clone() {
    return (ChipRun) super.clone();
  }

}
