/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Cancels one or multiple refreshes of data source objects in the spreadsheet by the specified
 * references. The request requires an additional `bigquery.readonly` OAuth scope if you are
 * cancelling a refresh on a BigQuery data source.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CancelDataSourceRefreshRequest extends com.google.api.client.json.GenericJson {

  /**
   * Reference to a DataSource. If specified, cancels all associated data source object refreshes
   * for this data source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dataSourceId;

  /**
   * Cancels all existing data source object refreshes for all data sources in the spreadsheet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isAll;

  /**
   * References to data source objects whose refreshes are to be cancelled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DataSourceObjectReferences references;

  /**
   * Reference to a DataSource. If specified, cancels all associated data source object refreshes
   * for this data source.
   * @return value or {@code null} for none
   */
  public java.lang.String getDataSourceId() {
    return dataSourceId;
  }

  /**
   * Reference to a DataSource. If specified, cancels all associated data source object refreshes
   * for this data source.
   * @param dataSourceId dataSourceId or {@code null} for none
   */
  public CancelDataSourceRefreshRequest setDataSourceId(java.lang.String dataSourceId) {
    this.dataSourceId = dataSourceId;
    return this;
  }

  /**
   * Cancels all existing data source object refreshes for all data sources in the spreadsheet.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsAll() {
    return isAll;
  }

  /**
   * Cancels all existing data source object refreshes for all data sources in the spreadsheet.
   * @param isAll isAll or {@code null} for none
   */
  public CancelDataSourceRefreshRequest setIsAll(java.lang.Boolean isAll) {
    this.isAll = isAll;
    return this;
  }

  /**
   * References to data source objects whose refreshes are to be cancelled.
   * @return value or {@code null} for none
   */
  public DataSourceObjectReferences getReferences() {
    return references;
  }

  /**
   * References to data source objects whose refreshes are to be cancelled.
   * @param references references or {@code null} for none
   */
  public CancelDataSourceRefreshRequest setReferences(DataSourceObjectReferences references) {
    this.references = references;
    return this;
  }

  @Override
  public CancelDataSourceRefreshRequest set(String fieldName, Object value) {
    return (CancelDataSourceRefreshRequest) super.set(fieldName, value);
  }

  @Override
  public CancelDataSourceRefreshRequest clone() {
    return (CancelDataSourceRefreshRequest) super.clone();
  }

}
