/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * The specification of a Looker data source.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LookerDataSourceSpec extends com.google.api.client.json.GenericJson {

  /**
   * Name of a Looker model explore.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String explore;

  /**
   * A Looker instance URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String instanceUri;

  /**
   * Name of a Looker model.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String model;

  /**
   * Name of a Looker model explore.
   * @return value or {@code null} for none
   */
  public java.lang.String getExplore() {
    return explore;
  }

  /**
   * Name of a Looker model explore.
   * @param explore explore or {@code null} for none
   */
  public LookerDataSourceSpec setExplore(java.lang.String explore) {
    this.explore = explore;
    return this;
  }

  /**
   * A Looker instance URL.
   * @return value or {@code null} for none
   */
  public java.lang.String getInstanceUri() {
    return instanceUri;
  }

  /**
   * A Looker instance URL.
   * @param instanceUri instanceUri or {@code null} for none
   */
  public LookerDataSourceSpec setInstanceUri(java.lang.String instanceUri) {
    this.instanceUri = instanceUri;
    return this;
  }

  /**
   * Name of a Looker model.
   * @return value or {@code null} for none
   */
  public java.lang.String getModel() {
    return model;
  }

  /**
   * Name of a Looker model.
   * @param model model or {@code null} for none
   */
  public LookerDataSourceSpec setModel(java.lang.String model) {
    this.model = model;
    return this;
  }

  @Override
  public LookerDataSourceSpec set(String fieldName, Object value) {
    return (LookerDataSourceSpec) super.set(fieldName, value);
  }

  @Override
  public LookerDataSourceSpec clone() {
    return (LookerDataSourceSpec) super.clone();
  }

}
