/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-01-30 at 11:38:08 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.pagespeedonline.model;

/**
 * Model definition for PagespeedApiPagespeedResponseV5.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the PageSpeed Insights API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PagespeedApiPagespeedResponseV5 extends com.google.api.client.json.GenericJson {

  /**
   * The UTC timestamp of this analysis.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String analysisUTCTimestamp;

  /**
   * The captcha verify result
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String captchaResult;

  /**
   * Canonicalized and final URL for the document, after following page redirects (if any).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Kind of result.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Lighthouse response for the audit url as an object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LighthouseResultV5 lighthouseResult;

  /**
   * Metrics of end users' page loading experience.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PagespeedApiLoadingExperienceV5 loadingExperience;

  /**
   * Metrics of the aggregated page loading experience of the origin
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PagespeedApiLoadingExperienceV5 originLoadingExperience;

  /**
   * The version of PageSpeed used to generate these results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Version version;

  /**
   * The UTC timestamp of this analysis.
   * @return value or {@code null} for none
   */
  public java.lang.String getAnalysisUTCTimestamp() {
    return analysisUTCTimestamp;
  }

  /**
   * The UTC timestamp of this analysis.
   * @param analysisUTCTimestamp analysisUTCTimestamp or {@code null} for none
   */
  public PagespeedApiPagespeedResponseV5 setAnalysisUTCTimestamp(java.lang.String analysisUTCTimestamp) {
    this.analysisUTCTimestamp = analysisUTCTimestamp;
    return this;
  }

  /**
   * The captcha verify result
   * @return value or {@code null} for none
   */
  public java.lang.String getCaptchaResult() {
    return captchaResult;
  }

  /**
   * The captcha verify result
   * @param captchaResult captchaResult or {@code null} for none
   */
  public PagespeedApiPagespeedResponseV5 setCaptchaResult(java.lang.String captchaResult) {
    this.captchaResult = captchaResult;
    return this;
  }

  /**
   * Canonicalized and final URL for the document, after following page redirects (if any).
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Canonicalized and final URL for the document, after following page redirects (if any).
   * @param id id or {@code null} for none
   */
  public PagespeedApiPagespeedResponseV5 setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Kind of result.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Kind of result.
   * @param kind kind or {@code null} for none
   */
  public PagespeedApiPagespeedResponseV5 setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Lighthouse response for the audit url as an object.
   * @return value or {@code null} for none
   */
  public LighthouseResultV5 getLighthouseResult() {
    return lighthouseResult;
  }

  /**
   * Lighthouse response for the audit url as an object.
   * @param lighthouseResult lighthouseResult or {@code null} for none
   */
  public PagespeedApiPagespeedResponseV5 setLighthouseResult(LighthouseResultV5 lighthouseResult) {
    this.lighthouseResult = lighthouseResult;
    return this;
  }

  /**
   * Metrics of end users' page loading experience.
   * @return value or {@code null} for none
   */
  public PagespeedApiLoadingExperienceV5 getLoadingExperience() {
    return loadingExperience;
  }

  /**
   * Metrics of end users' page loading experience.
   * @param loadingExperience loadingExperience or {@code null} for none
   */
  public PagespeedApiPagespeedResponseV5 setLoadingExperience(PagespeedApiLoadingExperienceV5 loadingExperience) {
    this.loadingExperience = loadingExperience;
    return this;
  }

  /**
   * Metrics of the aggregated page loading experience of the origin
   * @return value or {@code null} for none
   */
  public PagespeedApiLoadingExperienceV5 getOriginLoadingExperience() {
    return originLoadingExperience;
  }

  /**
   * Metrics of the aggregated page loading experience of the origin
   * @param originLoadingExperience originLoadingExperience or {@code null} for none
   */
  public PagespeedApiPagespeedResponseV5 setOriginLoadingExperience(PagespeedApiLoadingExperienceV5 originLoadingExperience) {
    this.originLoadingExperience = originLoadingExperience;
    return this;
  }

  /**
   * The version of PageSpeed used to generate these results.
   * @return value or {@code null} for none
   */
  public Version getVersion() {
    return version;
  }

  /**
   * The version of PageSpeed used to generate these results.
   * @param version version or {@code null} for none
   */
  public PagespeedApiPagespeedResponseV5 setVersion(Version version) {
    this.version = version;
    return this;
  }

  @Override
  public PagespeedApiPagespeedResponseV5 set(String fieldName, Object value) {
    return (PagespeedApiPagespeedResponseV5) super.set(fieldName, value);
  }

  @Override
  public PagespeedApiPagespeedResponseV5 clone() {
    return (PagespeedApiPagespeedResponseV5) super.clone();
  }

  /**
   * The version of PageSpeed used to generate these results.
   */
  public static final class Version extends com.google.api.client.json.GenericJson {

    /**
     * The major version number of PageSpeed used to generate these results.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer major;

    /**
     * The minor version number of PageSpeed used to generate these results.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer minor;

    /**
     * The major version number of PageSpeed used to generate these results.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getMajor() {
      return major;
    }

    /**
     * The major version number of PageSpeed used to generate these results.
     * @param major major or {@code null} for none
     */
    public Version setMajor(java.lang.Integer major) {
      this.major = major;
      return this;
    }

    /**
     * The minor version number of PageSpeed used to generate these results.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getMinor() {
      return minor;
    }

    /**
     * The minor version number of PageSpeed used to generate these results.
     * @param minor minor or {@code null} for none
     */
    public Version setMinor(java.lang.Integer minor) {
      this.minor = minor;
      return this;
    }

    @Override
    public Version set(String fieldName, Object value) {
      return (Version) super.set(fieldName, value);
    }

    @Override
    public Version clone() {
      return (Version) super.clone();
    }

  }
}
