/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-01-30 at 11:38:08 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.pagespeedonline.model;

/**
 * Model definition for PagespeedApiLoadingExperienceV5.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the PageSpeed Insights API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PagespeedApiLoadingExperienceV5 extends com.google.api.client.json.GenericJson {

  /**
   * The url, pattern or origin which the metrics are on.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("initial_url")
  private java.lang.String initialUrl;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, MetricsElement> metrics;

  static {
    // hack to force ProGuard to consider MetricsElement used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(MetricsElement.class);
  }

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("overall_category")
  private java.lang.String overallCategory;

  /**
   * The url, pattern or origin which the metrics are on.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The url, pattern or origin which the metrics are on.
   * @param id id or {@code null} for none
   */
  public PagespeedApiLoadingExperienceV5 setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getInitialUrl() {
    return initialUrl;
  }

  /**
   * @param initialUrl initialUrl or {@code null} for none
   */
  public PagespeedApiLoadingExperienceV5 setInitialUrl(java.lang.String initialUrl) {
    this.initialUrl = initialUrl;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.util.Map<String, MetricsElement> getMetrics() {
    return metrics;
  }

  /**
   * @param metrics metrics or {@code null} for none
   */
  public PagespeedApiLoadingExperienceV5 setMetrics(java.util.Map<String, MetricsElement> metrics) {
    this.metrics = metrics;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getOverallCategory() {
    return overallCategory;
  }

  /**
   * @param overallCategory overallCategory or {@code null} for none
   */
  public PagespeedApiLoadingExperienceV5 setOverallCategory(java.lang.String overallCategory) {
    this.overallCategory = overallCategory;
    return this;
  }

  @Override
  public PagespeedApiLoadingExperienceV5 set(String fieldName, Object value) {
    return (PagespeedApiLoadingExperienceV5) super.set(fieldName, value);
  }

  @Override
  public PagespeedApiLoadingExperienceV5 clone() {
    return (PagespeedApiLoadingExperienceV5) super.clone();
  }

  /**
   * The type of the metric.
   */
  public static final class MetricsElement extends com.google.api.client.json.GenericJson {

    /**
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String category;

    /**
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<Distributions> distributions;

    static {
      // hack to force ProGuard to consider Distributions used, since otherwise it would be stripped out
      // see https://github.com/google/google-api-java-client/issues/543
      com.google.api.client.util.Data.nullOf(Distributions.class);
    }

    /**
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer percentile;

    /**
     * @return value or {@code null} for none
     */
    public java.lang.String getCategory() {
      return category;
    }

    /**
     * @param category category or {@code null} for none
     */
    public MetricsElement setCategory(java.lang.String category) {
      this.category = category;
      return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public java.util.List<Distributions> getDistributions() {
      return distributions;
    }

    /**
     * @param distributions distributions or {@code null} for none
     */
    public MetricsElement setDistributions(java.util.List<Distributions> distributions) {
      this.distributions = distributions;
      return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public java.lang.Integer getPercentile() {
      return percentile;
    }

    /**
     * @param percentile percentile or {@code null} for none
     */
    public MetricsElement setPercentile(java.lang.Integer percentile) {
      this.percentile = percentile;
      return this;
    }

    @Override
    public MetricsElement set(String fieldName, Object value) {
      return (MetricsElement) super.set(fieldName, value);
    }

    @Override
    public MetricsElement clone() {
      return (MetricsElement) super.clone();
    }

    /**
     * Model definition for PagespeedApiLoadingExperienceV5MetricsElementDistributions.
     */
    public static final class Distributions extends com.google.api.client.json.GenericJson {

      /**
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer max;

      /**
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer min;

      /**
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Double proportion;

      /**
       * @return value or {@code null} for none
       */
      public java.lang.Integer getMax() {
        return max;
      }

      /**
       * @param max max or {@code null} for none
       */
      public Distributions setMax(java.lang.Integer max) {
        this.max = max;
        return this;
      }

      /**
       * @return value or {@code null} for none
       */
      public java.lang.Integer getMin() {
        return min;
      }

      /**
       * @param min min or {@code null} for none
       */
      public Distributions setMin(java.lang.Integer min) {
        this.min = min;
        return this;
      }

      /**
       * @return value or {@code null} for none
       */
      public java.lang.Double getProportion() {
        return proportion;
      }

      /**
       * @param proportion proportion or {@code null} for none
       */
      public Distributions setProportion(java.lang.Double proportion) {
        this.proportion = proportion;
        return this;
      }

      @Override
      public Distributions set(String fieldName, Object value) {
        return (Distributions) super.set(fieldName, value);
      }

      @Override
      public Distributions clone() {
        return (Distributions) super.clone();
      }

    }
  }

}
