/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-01-30 at 11:38:08 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.pagespeedonline.model;

/**
 * Model definition for LighthouseResultV5.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the PageSpeed Insights API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LighthouseResultV5 extends com.google.api.client.json.GenericJson {

  /**
   * Map of audits in the LHR.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, LighthouseAuditResultV5> audits;

  static {
    // hack to force ProGuard to consider LighthouseAuditResultV5 used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(LighthouseAuditResultV5.class);
  }

  /**
   * Map of categories in the LHR.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Categories categories;

  /**
   * Map of category groups in the LHR.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, CategoryGroupsElement> categoryGroups;

  static {
    // hack to force ProGuard to consider CategoryGroupsElement used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(CategoryGroupsElement.class);
  }

  /**
   * The configuration settings for this LHR.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ConfigSettings configSettings;

  /**
   * Environment settings that were used when making this LHR.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Environment environment;

  /**
   * The time that this run was fetched.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fetchTime;

  /**
   * The final resolved url that was audited.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String finalUrl;

  /**
   * The internationalization strings that are required to render the LHR.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private I18n i18n;

  /**
   * The lighthouse version that was used to generate this LHR.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String lighthouseVersion;

  /**
   * The original requested url.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String requestedUrl;

  /**
   * List of all run warnings in the LHR. Will always output to at least `[]`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.Object> runWarnings;

  /**
   * A top-level error message that, if present, indicates a serious enough problem that this
   * Lighthouse result may need to be discarded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RuntimeError runtimeError;

  /**
   * The Stack Pack advice strings.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<StackPacks> stackPacks;

  static {
    // hack to force ProGuard to consider StackPacks used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(StackPacks.class);
  }

  /**
   * Timing information for this LHR.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Timing timing;

  /**
   * The user agent that was used to run this LHR.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String userAgent;

  /**
   * Map of audits in the LHR.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, LighthouseAuditResultV5> getAudits() {
    return audits;
  }

  /**
   * Map of audits in the LHR.
   * @param audits audits or {@code null} for none
   */
  public LighthouseResultV5 setAudits(java.util.Map<String, LighthouseAuditResultV5> audits) {
    this.audits = audits;
    return this;
  }

  /**
   * Map of categories in the LHR.
   * @return value or {@code null} for none
   */
  public Categories getCategories() {
    return categories;
  }

  /**
   * Map of categories in the LHR.
   * @param categories categories or {@code null} for none
   */
  public LighthouseResultV5 setCategories(Categories categories) {
    this.categories = categories;
    return this;
  }

  /**
   * Map of category groups in the LHR.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, CategoryGroupsElement> getCategoryGroups() {
    return categoryGroups;
  }

  /**
   * Map of category groups in the LHR.
   * @param categoryGroups categoryGroups or {@code null} for none
   */
  public LighthouseResultV5 setCategoryGroups(java.util.Map<String, CategoryGroupsElement> categoryGroups) {
    this.categoryGroups = categoryGroups;
    return this;
  }

  /**
   * The configuration settings for this LHR.
   * @return value or {@code null} for none
   */
  public ConfigSettings getConfigSettings() {
    return configSettings;
  }

  /**
   * The configuration settings for this LHR.
   * @param configSettings configSettings or {@code null} for none
   */
  public LighthouseResultV5 setConfigSettings(ConfigSettings configSettings) {
    this.configSettings = configSettings;
    return this;
  }

  /**
   * Environment settings that were used when making this LHR.
   * @return value or {@code null} for none
   */
  public Environment getEnvironment() {
    return environment;
  }

  /**
   * Environment settings that were used when making this LHR.
   * @param environment environment or {@code null} for none
   */
  public LighthouseResultV5 setEnvironment(Environment environment) {
    this.environment = environment;
    return this;
  }

  /**
   * The time that this run was fetched.
   * @return value or {@code null} for none
   */
  public java.lang.String getFetchTime() {
    return fetchTime;
  }

  /**
   * The time that this run was fetched.
   * @param fetchTime fetchTime or {@code null} for none
   */
  public LighthouseResultV5 setFetchTime(java.lang.String fetchTime) {
    this.fetchTime = fetchTime;
    return this;
  }

  /**
   * The final resolved url that was audited.
   * @return value or {@code null} for none
   */
  public java.lang.String getFinalUrl() {
    return finalUrl;
  }

  /**
   * The final resolved url that was audited.
   * @param finalUrl finalUrl or {@code null} for none
   */
  public LighthouseResultV5 setFinalUrl(java.lang.String finalUrl) {
    this.finalUrl = finalUrl;
    return this;
  }

  /**
   * The internationalization strings that are required to render the LHR.
   * @return value or {@code null} for none
   */
  public I18n getI18n() {
    return i18n;
  }

  /**
   * The internationalization strings that are required to render the LHR.
   * @param i18n i18n or {@code null} for none
   */
  public LighthouseResultV5 setI18n(I18n i18n) {
    this.i18n = i18n;
    return this;
  }

  /**
   * The lighthouse version that was used to generate this LHR.
   * @return value or {@code null} for none
   */
  public java.lang.String getLighthouseVersion() {
    return lighthouseVersion;
  }

  /**
   * The lighthouse version that was used to generate this LHR.
   * @param lighthouseVersion lighthouseVersion or {@code null} for none
   */
  public LighthouseResultV5 setLighthouseVersion(java.lang.String lighthouseVersion) {
    this.lighthouseVersion = lighthouseVersion;
    return this;
  }

  /**
   * The original requested url.
   * @return value or {@code null} for none
   */
  public java.lang.String getRequestedUrl() {
    return requestedUrl;
  }

  /**
   * The original requested url.
   * @param requestedUrl requestedUrl or {@code null} for none
   */
  public LighthouseResultV5 setRequestedUrl(java.lang.String requestedUrl) {
    this.requestedUrl = requestedUrl;
    return this;
  }

  /**
   * List of all run warnings in the LHR. Will always output to at least `[]`.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Object> getRunWarnings() {
    return runWarnings;
  }

  /**
   * List of all run warnings in the LHR. Will always output to at least `[]`.
   * @param runWarnings runWarnings or {@code null} for none
   */
  public LighthouseResultV5 setRunWarnings(java.util.List<java.lang.Object> runWarnings) {
    this.runWarnings = runWarnings;
    return this;
  }

  /**
   * A top-level error message that, if present, indicates a serious enough problem that this
   * Lighthouse result may need to be discarded.
   * @return value or {@code null} for none
   */
  public RuntimeError getRuntimeError() {
    return runtimeError;
  }

  /**
   * A top-level error message that, if present, indicates a serious enough problem that this
   * Lighthouse result may need to be discarded.
   * @param runtimeError runtimeError or {@code null} for none
   */
  public LighthouseResultV5 setRuntimeError(RuntimeError runtimeError) {
    this.runtimeError = runtimeError;
    return this;
  }

  /**
   * The Stack Pack advice strings.
   * @return value or {@code null} for none
   */
  public java.util.List<StackPacks> getStackPacks() {
    return stackPacks;
  }

  /**
   * The Stack Pack advice strings.
   * @param stackPacks stackPacks or {@code null} for none
   */
  public LighthouseResultV5 setStackPacks(java.util.List<StackPacks> stackPacks) {
    this.stackPacks = stackPacks;
    return this;
  }

  /**
   * Timing information for this LHR.
   * @return value or {@code null} for none
   */
  public Timing getTiming() {
    return timing;
  }

  /**
   * Timing information for this LHR.
   * @param timing timing or {@code null} for none
   */
  public LighthouseResultV5 setTiming(Timing timing) {
    this.timing = timing;
    return this;
  }

  /**
   * The user agent that was used to run this LHR.
   * @return value or {@code null} for none
   */
  public java.lang.String getUserAgent() {
    return userAgent;
  }

  /**
   * The user agent that was used to run this LHR.
   * @param userAgent userAgent or {@code null} for none
   */
  public LighthouseResultV5 setUserAgent(java.lang.String userAgent) {
    this.userAgent = userAgent;
    return this;
  }

  @Override
  public LighthouseResultV5 set(String fieldName, Object value) {
    return (LighthouseResultV5) super.set(fieldName, value);
  }

  @Override
  public LighthouseResultV5 clone() {
    return (LighthouseResultV5) super.clone();
  }

  /**
   * Map of categories in the LHR.
   */
  public static final class Categories extends com.google.api.client.json.GenericJson {

    /**
     * The accessibility category, containing all accessibility related audits.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private LighthouseCategoryV5 accessibility;

    /**
     * The best practices category, containing all web best practice related audits.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key("best-practices")
    private LighthouseCategoryV5 bestPractices;

    /**
     * The performance category, containing all performance related audits.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private LighthouseCategoryV5 performance;

    /**
     * The Progressive-Web-App (PWA) category, containing all pwa related audits.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private LighthouseCategoryV5 pwa;

    /**
     * The Search-Engine-Optimization (SEO) category, containing all seo related audits.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private LighthouseCategoryV5 seo;

    /**
     * The accessibility category, containing all accessibility related audits.
     * @return value or {@code null} for none
     */
    public LighthouseCategoryV5 getAccessibility() {
      return accessibility;
    }

    /**
     * The accessibility category, containing all accessibility related audits.
     * @param accessibility accessibility or {@code null} for none
     */
    public Categories setAccessibility(LighthouseCategoryV5 accessibility) {
      this.accessibility = accessibility;
      return this;
    }

    /**
     * The best practices category, containing all web best practice related audits.
     * @return value or {@code null} for none
     */
    public LighthouseCategoryV5 getBestPractices() {
      return bestPractices;
    }

    /**
     * The best practices category, containing all web best practice related audits.
     * @param bestPractices bestPractices or {@code null} for none
     */
    public Categories setBestPractices(LighthouseCategoryV5 bestPractices) {
      this.bestPractices = bestPractices;
      return this;
    }

    /**
     * The performance category, containing all performance related audits.
     * @return value or {@code null} for none
     */
    public LighthouseCategoryV5 getPerformance() {
      return performance;
    }

    /**
     * The performance category, containing all performance related audits.
     * @param performance performance or {@code null} for none
     */
    public Categories setPerformance(LighthouseCategoryV5 performance) {
      this.performance = performance;
      return this;
    }

    /**
     * The Progressive-Web-App (PWA) category, containing all pwa related audits.
     * @return value or {@code null} for none
     */
    public LighthouseCategoryV5 getPwa() {
      return pwa;
    }

    /**
     * The Progressive-Web-App (PWA) category, containing all pwa related audits.
     * @param pwa pwa or {@code null} for none
     */
    public Categories setPwa(LighthouseCategoryV5 pwa) {
      this.pwa = pwa;
      return this;
    }

    /**
     * The Search-Engine-Optimization (SEO) category, containing all seo related audits.
     * @return value or {@code null} for none
     */
    public LighthouseCategoryV5 getSeo() {
      return seo;
    }

    /**
     * The Search-Engine-Optimization (SEO) category, containing all seo related audits.
     * @param seo seo or {@code null} for none
     */
    public Categories setSeo(LighthouseCategoryV5 seo) {
      this.seo = seo;
      return this;
    }

    @Override
    public Categories set(String fieldName, Object value) {
      return (Categories) super.set(fieldName, value);
    }

    @Override
    public Categories clone() {
      return (Categories) super.clone();
    }

  }

  /**
   * A grouping contained in a category that groups similar audits together.
   */
  public static final class CategoryGroupsElement extends com.google.api.client.json.GenericJson {

    /**
     * An optional human readable description of the category group.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String description;

    /**
     * The title of the category group.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String title;

    /**
     * An optional human readable description of the category group.
     * @return value or {@code null} for none
     */
    public java.lang.String getDescription() {
      return description;
    }

    /**
     * An optional human readable description of the category group.
     * @param description description or {@code null} for none
     */
    public CategoryGroupsElement setDescription(java.lang.String description) {
      this.description = description;
      return this;
    }

    /**
     * The title of the category group.
     * @return value or {@code null} for none
     */
    public java.lang.String getTitle() {
      return title;
    }

    /**
     * The title of the category group.
     * @param title title or {@code null} for none
     */
    public CategoryGroupsElement setTitle(java.lang.String title) {
      this.title = title;
      return this;
    }

    @Override
    public CategoryGroupsElement set(String fieldName, Object value) {
      return (CategoryGroupsElement) super.set(fieldName, value);
    }

    @Override
    public CategoryGroupsElement clone() {
      return (CategoryGroupsElement) super.clone();
    }

  }

  /**
   * The configuration settings for this LHR.
   */
  public static final class ConfigSettings extends com.google.api.client.json.GenericJson {

    /**
     * The form factor the emulation should use.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String emulatedFormFactor;

    /**
     * The locale setting.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String locale;

    /**
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Object onlyCategories;

    /**
     * The form factor the emulation should use.
     * @return value or {@code null} for none
     */
    public java.lang.String getEmulatedFormFactor() {
      return emulatedFormFactor;
    }

    /**
     * The form factor the emulation should use.
     * @param emulatedFormFactor emulatedFormFactor or {@code null} for none
     */
    public ConfigSettings setEmulatedFormFactor(java.lang.String emulatedFormFactor) {
      this.emulatedFormFactor = emulatedFormFactor;
      return this;
    }

    /**
     * The locale setting.
     * @return value or {@code null} for none
     */
    public java.lang.String getLocale() {
      return locale;
    }

    /**
     * The locale setting.
     * @param locale locale or {@code null} for none
     */
    public ConfigSettings setLocale(java.lang.String locale) {
      this.locale = locale;
      return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public java.lang.Object getOnlyCategories() {
      return onlyCategories;
    }

    /**
     * @param onlyCategories onlyCategories or {@code null} for none
     */
    public ConfigSettings setOnlyCategories(java.lang.Object onlyCategories) {
      this.onlyCategories = onlyCategories;
      return this;
    }

    @Override
    public ConfigSettings set(String fieldName, Object value) {
      return (ConfigSettings) super.set(fieldName, value);
    }

    @Override
    public ConfigSettings clone() {
      return (ConfigSettings) super.clone();
    }

  }

  /**
   * Environment settings that were used when making this LHR.
   */
  public static final class Environment extends com.google.api.client.json.GenericJson {

    /**
     * The benchmark index number that indicates rough device class.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Double benchmarkIndex;

    /**
     * The user agent string of the version of Chrome used.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String hostUserAgent;

    /**
     * The user agent string that was sent over the network.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String networkUserAgent;

    /**
     * The benchmark index number that indicates rough device class.
     * @return value or {@code null} for none
     */
    public java.lang.Double getBenchmarkIndex() {
      return benchmarkIndex;
    }

    /**
     * The benchmark index number that indicates rough device class.
     * @param benchmarkIndex benchmarkIndex or {@code null} for none
     */
    public Environment setBenchmarkIndex(java.lang.Double benchmarkIndex) {
      this.benchmarkIndex = benchmarkIndex;
      return this;
    }

    /**
     * The user agent string of the version of Chrome used.
     * @return value or {@code null} for none
     */
    public java.lang.String getHostUserAgent() {
      return hostUserAgent;
    }

    /**
     * The user agent string of the version of Chrome used.
     * @param hostUserAgent hostUserAgent or {@code null} for none
     */
    public Environment setHostUserAgent(java.lang.String hostUserAgent) {
      this.hostUserAgent = hostUserAgent;
      return this;
    }

    /**
     * The user agent string that was sent over the network.
     * @return value or {@code null} for none
     */
    public java.lang.String getNetworkUserAgent() {
      return networkUserAgent;
    }

    /**
     * The user agent string that was sent over the network.
     * @param networkUserAgent networkUserAgent or {@code null} for none
     */
    public Environment setNetworkUserAgent(java.lang.String networkUserAgent) {
      this.networkUserAgent = networkUserAgent;
      return this;
    }

    @Override
    public Environment set(String fieldName, Object value) {
      return (Environment) super.set(fieldName, value);
    }

    @Override
    public Environment clone() {
      return (Environment) super.clone();
    }

  }

  /**
   * The internationalization strings that are required to render the LHR.
   */
  public static final class I18n extends com.google.api.client.json.GenericJson {

    /**
     * Internationalized strings that are formatted to the locale in configSettings.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private RendererFormattedStrings rendererFormattedStrings;

    /**
     * Internationalized strings that are formatted to the locale in configSettings.
     * @return value or {@code null} for none
     */
    public RendererFormattedStrings getRendererFormattedStrings() {
      return rendererFormattedStrings;
    }

    /**
     * Internationalized strings that are formatted to the locale in configSettings.
     * @param rendererFormattedStrings rendererFormattedStrings or {@code null} for none
     */
    public I18n setRendererFormattedStrings(RendererFormattedStrings rendererFormattedStrings) {
      this.rendererFormattedStrings = rendererFormattedStrings;
      return this;
    }

    @Override
    public I18n set(String fieldName, Object value) {
      return (I18n) super.set(fieldName, value);
    }

    @Override
    public I18n clone() {
      return (I18n) super.clone();
    }

    /**
     * Internationalized strings that are formatted to the locale in configSettings.
     */
    public static final class RendererFormattedStrings extends com.google.api.client.json.GenericJson {

      /**
       * The tooltip text on an expandable chevron icon.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String auditGroupExpandTooltip;

      /**
       * The label for the initial request in a critical request chain.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String crcInitialNavigation;

      /**
       * The label for values shown in the summary of critical request chains.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String crcLongestDurationLabel;

      /**
       * The label shown next to an audit or metric that has had an error.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String errorLabel;

      /**
       * The error string shown next to an erroring audit.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String errorMissingAuditInfo;

      /**
       * The title of the lab data performance category.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String labDataTitle;

      /**
       * The disclaimer shown under performance explaning that the network can vary.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String lsPerformanceCategoryDescription;

      /**
       * The heading shown above a list of audits that were not computerd in the run.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String manualAuditsGroupTitle;

      /**
       * The heading shown above a list of audits that do not apply to a page.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String notApplicableAuditsGroupTitle;

      /**
       * The heading for the estimated page load savings opportunity of an audit.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String opportunityResourceColumnLabel;

      /**
       * The heading for the estimated page load savings of opportunity audits.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String opportunitySavingsColumnLabel;

      /**
       * The heading that is shown above a list of audits that are passing.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String passedAuditsGroupTitle;

      /**
       * The label that explains the score gauges scale (0-49, 50-89, 90-100).
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String scorescaleLabel;

      /**
       * The label shown preceding important warnings that may have invalidated an entire report.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String toplevelWarningsMessage;

      /**
       * The disclaimer shown below a performance metric value.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String varianceDisclaimer;

      /**
       * The label shown above a bulleted list of warnings.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String warningHeader;

      /**
       * The tooltip text on an expandable chevron icon.
       * @return value or {@code null} for none
       */
      public java.lang.String getAuditGroupExpandTooltip() {
        return auditGroupExpandTooltip;
      }

      /**
       * The tooltip text on an expandable chevron icon.
       * @param auditGroupExpandTooltip auditGroupExpandTooltip or {@code null} for none
       */
      public RendererFormattedStrings setAuditGroupExpandTooltip(java.lang.String auditGroupExpandTooltip) {
        this.auditGroupExpandTooltip = auditGroupExpandTooltip;
        return this;
      }

      /**
       * The label for the initial request in a critical request chain.
       * @return value or {@code null} for none
       */
      public java.lang.String getCrcInitialNavigation() {
        return crcInitialNavigation;
      }

      /**
       * The label for the initial request in a critical request chain.
       * @param crcInitialNavigation crcInitialNavigation or {@code null} for none
       */
      public RendererFormattedStrings setCrcInitialNavigation(java.lang.String crcInitialNavigation) {
        this.crcInitialNavigation = crcInitialNavigation;
        return this;
      }

      /**
       * The label for values shown in the summary of critical request chains.
       * @return value or {@code null} for none
       */
      public java.lang.String getCrcLongestDurationLabel() {
        return crcLongestDurationLabel;
      }

      /**
       * The label for values shown in the summary of critical request chains.
       * @param crcLongestDurationLabel crcLongestDurationLabel or {@code null} for none
       */
      public RendererFormattedStrings setCrcLongestDurationLabel(java.lang.String crcLongestDurationLabel) {
        this.crcLongestDurationLabel = crcLongestDurationLabel;
        return this;
      }

      /**
       * The label shown next to an audit or metric that has had an error.
       * @return value or {@code null} for none
       */
      public java.lang.String getErrorLabel() {
        return errorLabel;
      }

      /**
       * The label shown next to an audit or metric that has had an error.
       * @param errorLabel errorLabel or {@code null} for none
       */
      public RendererFormattedStrings setErrorLabel(java.lang.String errorLabel) {
        this.errorLabel = errorLabel;
        return this;
      }

      /**
       * The error string shown next to an erroring audit.
       * @return value or {@code null} for none
       */
      public java.lang.String getErrorMissingAuditInfo() {
        return errorMissingAuditInfo;
      }

      /**
       * The error string shown next to an erroring audit.
       * @param errorMissingAuditInfo errorMissingAuditInfo or {@code null} for none
       */
      public RendererFormattedStrings setErrorMissingAuditInfo(java.lang.String errorMissingAuditInfo) {
        this.errorMissingAuditInfo = errorMissingAuditInfo;
        return this;
      }

      /**
       * The title of the lab data performance category.
       * @return value or {@code null} for none
       */
      public java.lang.String getLabDataTitle() {
        return labDataTitle;
      }

      /**
       * The title of the lab data performance category.
       * @param labDataTitle labDataTitle or {@code null} for none
       */
      public RendererFormattedStrings setLabDataTitle(java.lang.String labDataTitle) {
        this.labDataTitle = labDataTitle;
        return this;
      }

      /**
       * The disclaimer shown under performance explaning that the network can vary.
       * @return value or {@code null} for none
       */
      public java.lang.String getLsPerformanceCategoryDescription() {
        return lsPerformanceCategoryDescription;
      }

      /**
       * The disclaimer shown under performance explaning that the network can vary.
       * @param lsPerformanceCategoryDescription lsPerformanceCategoryDescription or {@code null} for none
       */
      public RendererFormattedStrings setLsPerformanceCategoryDescription(java.lang.String lsPerformanceCategoryDescription) {
        this.lsPerformanceCategoryDescription = lsPerformanceCategoryDescription;
        return this;
      }

      /**
       * The heading shown above a list of audits that were not computerd in the run.
       * @return value or {@code null} for none
       */
      public java.lang.String getManualAuditsGroupTitle() {
        return manualAuditsGroupTitle;
      }

      /**
       * The heading shown above a list of audits that were not computerd in the run.
       * @param manualAuditsGroupTitle manualAuditsGroupTitle or {@code null} for none
       */
      public RendererFormattedStrings setManualAuditsGroupTitle(java.lang.String manualAuditsGroupTitle) {
        this.manualAuditsGroupTitle = manualAuditsGroupTitle;
        return this;
      }

      /**
       * The heading shown above a list of audits that do not apply to a page.
       * @return value or {@code null} for none
       */
      public java.lang.String getNotApplicableAuditsGroupTitle() {
        return notApplicableAuditsGroupTitle;
      }

      /**
       * The heading shown above a list of audits that do not apply to a page.
       * @param notApplicableAuditsGroupTitle notApplicableAuditsGroupTitle or {@code null} for none
       */
      public RendererFormattedStrings setNotApplicableAuditsGroupTitle(java.lang.String notApplicableAuditsGroupTitle) {
        this.notApplicableAuditsGroupTitle = notApplicableAuditsGroupTitle;
        return this;
      }

      /**
       * The heading for the estimated page load savings opportunity of an audit.
       * @return value or {@code null} for none
       */
      public java.lang.String getOpportunityResourceColumnLabel() {
        return opportunityResourceColumnLabel;
      }

      /**
       * The heading for the estimated page load savings opportunity of an audit.
       * @param opportunityResourceColumnLabel opportunityResourceColumnLabel or {@code null} for none
       */
      public RendererFormattedStrings setOpportunityResourceColumnLabel(java.lang.String opportunityResourceColumnLabel) {
        this.opportunityResourceColumnLabel = opportunityResourceColumnLabel;
        return this;
      }

      /**
       * The heading for the estimated page load savings of opportunity audits.
       * @return value or {@code null} for none
       */
      public java.lang.String getOpportunitySavingsColumnLabel() {
        return opportunitySavingsColumnLabel;
      }

      /**
       * The heading for the estimated page load savings of opportunity audits.
       * @param opportunitySavingsColumnLabel opportunitySavingsColumnLabel or {@code null} for none
       */
      public RendererFormattedStrings setOpportunitySavingsColumnLabel(java.lang.String opportunitySavingsColumnLabel) {
        this.opportunitySavingsColumnLabel = opportunitySavingsColumnLabel;
        return this;
      }

      /**
       * The heading that is shown above a list of audits that are passing.
       * @return value or {@code null} for none
       */
      public java.lang.String getPassedAuditsGroupTitle() {
        return passedAuditsGroupTitle;
      }

      /**
       * The heading that is shown above a list of audits that are passing.
       * @param passedAuditsGroupTitle passedAuditsGroupTitle or {@code null} for none
       */
      public RendererFormattedStrings setPassedAuditsGroupTitle(java.lang.String passedAuditsGroupTitle) {
        this.passedAuditsGroupTitle = passedAuditsGroupTitle;
        return this;
      }

      /**
       * The label that explains the score gauges scale (0-49, 50-89, 90-100).
       * @return value or {@code null} for none
       */
      public java.lang.String getScorescaleLabel() {
        return scorescaleLabel;
      }

      /**
       * The label that explains the score gauges scale (0-49, 50-89, 90-100).
       * @param scorescaleLabel scorescaleLabel or {@code null} for none
       */
      public RendererFormattedStrings setScorescaleLabel(java.lang.String scorescaleLabel) {
        this.scorescaleLabel = scorescaleLabel;
        return this;
      }

      /**
       * The label shown preceding important warnings that may have invalidated an entire report.
       * @return value or {@code null} for none
       */
      public java.lang.String getToplevelWarningsMessage() {
        return toplevelWarningsMessage;
      }

      /**
       * The label shown preceding important warnings that may have invalidated an entire report.
       * @param toplevelWarningsMessage toplevelWarningsMessage or {@code null} for none
       */
      public RendererFormattedStrings setToplevelWarningsMessage(java.lang.String toplevelWarningsMessage) {
        this.toplevelWarningsMessage = toplevelWarningsMessage;
        return this;
      }

      /**
       * The disclaimer shown below a performance metric value.
       * @return value or {@code null} for none
       */
      public java.lang.String getVarianceDisclaimer() {
        return varianceDisclaimer;
      }

      /**
       * The disclaimer shown below a performance metric value.
       * @param varianceDisclaimer varianceDisclaimer or {@code null} for none
       */
      public RendererFormattedStrings setVarianceDisclaimer(java.lang.String varianceDisclaimer) {
        this.varianceDisclaimer = varianceDisclaimer;
        return this;
      }

      /**
       * The label shown above a bulleted list of warnings.
       * @return value or {@code null} for none
       */
      public java.lang.String getWarningHeader() {
        return warningHeader;
      }

      /**
       * The label shown above a bulleted list of warnings.
       * @param warningHeader warningHeader or {@code null} for none
       */
      public RendererFormattedStrings setWarningHeader(java.lang.String warningHeader) {
        this.warningHeader = warningHeader;
        return this;
      }

      @Override
      public RendererFormattedStrings set(String fieldName, Object value) {
        return (RendererFormattedStrings) super.set(fieldName, value);
      }

      @Override
      public RendererFormattedStrings clone() {
        return (RendererFormattedStrings) super.clone();
      }

    }
  }

  /**
   * A top-level error message that, if present, indicates a serious enough problem that this
   * Lighthouse result may need to be discarded.
   */
  public static final class RuntimeError extends com.google.api.client.json.GenericJson {

    /**
     * The enumerated Lighthouse Error code.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String code;

    /**
     * A human readable message explaining the error code.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String message;

    /**
     * The enumerated Lighthouse Error code.
     * @return value or {@code null} for none
     */
    public java.lang.String getCode() {
      return code;
    }

    /**
     * The enumerated Lighthouse Error code.
     * @param code code or {@code null} for none
     */
    public RuntimeError setCode(java.lang.String code) {
      this.code = code;
      return this;
    }

    /**
     * A human readable message explaining the error code.
     * @return value or {@code null} for none
     */
    public java.lang.String getMessage() {
      return message;
    }

    /**
     * A human readable message explaining the error code.
     * @param message message or {@code null} for none
     */
    public RuntimeError setMessage(java.lang.String message) {
      this.message = message;
      return this;
    }

    @Override
    public RuntimeError set(String fieldName, Object value) {
      return (RuntimeError) super.set(fieldName, value);
    }

    @Override
    public RuntimeError clone() {
      return (RuntimeError) super.clone();
    }

  }

  /**
   * Model definition for LighthouseResultV5StackPacks.
   */
  public static final class StackPacks extends com.google.api.client.json.GenericJson {

    /**
     * The stack pack advice strings.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.Map<String, java.lang.String> descriptions;

    /**
     * The stack pack icon data uri.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String iconDataURL;

    /**
     * The stack pack id.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String id;

    /**
     * The stack pack title.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String title;

    /**
     * The stack pack advice strings.
     * @return value or {@code null} for none
     */
    public java.util.Map<String, java.lang.String> getDescriptions() {
      return descriptions;
    }

    /**
     * The stack pack advice strings.
     * @param descriptions descriptions or {@code null} for none
     */
    public StackPacks setDescriptions(java.util.Map<String, java.lang.String> descriptions) {
      this.descriptions = descriptions;
      return this;
    }

    /**
     * The stack pack icon data uri.
     * @return value or {@code null} for none
     */
    public java.lang.String getIconDataURL() {
      return iconDataURL;
    }

    /**
     * The stack pack icon data uri.
     * @param iconDataURL iconDataURL or {@code null} for none
     */
    public StackPacks setIconDataURL(java.lang.String iconDataURL) {
      this.iconDataURL = iconDataURL;
      return this;
    }

    /**
     * The stack pack id.
     * @return value or {@code null} for none
     */
    public java.lang.String getId() {
      return id;
    }

    /**
     * The stack pack id.
     * @param id id or {@code null} for none
     */
    public StackPacks setId(java.lang.String id) {
      this.id = id;
      return this;
    }

    /**
     * The stack pack title.
     * @return value or {@code null} for none
     */
    public java.lang.String getTitle() {
      return title;
    }

    /**
     * The stack pack title.
     * @param title title or {@code null} for none
     */
    public StackPacks setTitle(java.lang.String title) {
      this.title = title;
      return this;
    }

    @Override
    public StackPacks set(String fieldName, Object value) {
      return (StackPacks) super.set(fieldName, value);
    }

    @Override
    public StackPacks clone() {
      return (StackPacks) super.clone();
    }

  }

  /**
   * Timing information for this LHR.
   */
  public static final class Timing extends com.google.api.client.json.GenericJson {

    /**
     * The total duration of Lighthouse's run.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Double total;

    /**
     * The total duration of Lighthouse's run.
     * @return value or {@code null} for none
     */
    public java.lang.Double getTotal() {
      return total;
    }

    /**
     * The total duration of Lighthouse's run.
     * @param total total or {@code null} for none
     */
    public Timing setTotal(java.lang.Double total) {
      this.total = total;
      return this;
    }

    @Override
    public Timing set(String fieldName, Object value) {
      return (Timing) super.set(fieldName, value);
    }

    @Override
    public Timing clone() {
      return (Timing) super.clone();
    }

  }

}
