/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-01-30 at 11:38:08 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.pagespeedonline.model;

/**
 * Model definition for LighthouseCategoryV5.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the PageSpeed Insights API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LighthouseCategoryV5 extends com.google.api.client.json.GenericJson {

  /**
   * An array of references to all the audit members of this category.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AuditRefs> auditRefs;

  static {
    // hack to force ProGuard to consider AuditRefs used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(AuditRefs.class);
  }

  /**
   * A more detailed description of the category and its importance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * The string identifier of the category.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * A description for the manual audits in the category.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String manualDescription;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Object score;

  /**
   * The human-friendly name of the category.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * An array of references to all the audit members of this category.
   * @return value or {@code null} for none
   */
  public java.util.List<AuditRefs> getAuditRefs() {
    return auditRefs;
  }

  /**
   * An array of references to all the audit members of this category.
   * @param auditRefs auditRefs or {@code null} for none
   */
  public LighthouseCategoryV5 setAuditRefs(java.util.List<AuditRefs> auditRefs) {
    this.auditRefs = auditRefs;
    return this;
  }

  /**
   * A more detailed description of the category and its importance.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * A more detailed description of the category and its importance.
   * @param description description or {@code null} for none
   */
  public LighthouseCategoryV5 setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * The string identifier of the category.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The string identifier of the category.
   * @param id id or {@code null} for none
   */
  public LighthouseCategoryV5 setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * A description for the manual audits in the category.
   * @return value or {@code null} for none
   */
  public java.lang.String getManualDescription() {
    return manualDescription;
  }

  /**
   * A description for the manual audits in the category.
   * @param manualDescription manualDescription or {@code null} for none
   */
  public LighthouseCategoryV5 setManualDescription(java.lang.String manualDescription) {
    this.manualDescription = manualDescription;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.Object getScore() {
    return score;
  }

  /**
   * @param score score or {@code null} for none
   */
  public LighthouseCategoryV5 setScore(java.lang.Object score) {
    this.score = score;
    return this;
  }

  /**
   * The human-friendly name of the category.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * The human-friendly name of the category.
   * @param title title or {@code null} for none
   */
  public LighthouseCategoryV5 setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  @Override
  public LighthouseCategoryV5 set(String fieldName, Object value) {
    return (LighthouseCategoryV5) super.set(fieldName, value);
  }

  @Override
  public LighthouseCategoryV5 clone() {
    return (LighthouseCategoryV5) super.clone();
  }

  /**
   * Model definition for LighthouseCategoryV5AuditRefs.
   */
  public static final class AuditRefs extends com.google.api.client.json.GenericJson {

    /**
     * The category group that the audit belongs to (optional).
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String group;

    /**
     * The audit ref id.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String id;

    /**
     * The weight this audit's score has on the overall category score.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Double weight;

    /**
     * The category group that the audit belongs to (optional).
     * @return value or {@code null} for none
     */
    public java.lang.String getGroup() {
      return group;
    }

    /**
     * The category group that the audit belongs to (optional).
     * @param group group or {@code null} for none
     */
    public AuditRefs setGroup(java.lang.String group) {
      this.group = group;
      return this;
    }

    /**
     * The audit ref id.
     * @return value or {@code null} for none
     */
    public java.lang.String getId() {
      return id;
    }

    /**
     * The audit ref id.
     * @param id id or {@code null} for none
     */
    public AuditRefs setId(java.lang.String id) {
      this.id = id;
      return this;
    }

    /**
     * The weight this audit's score has on the overall category score.
     * @return value or {@code null} for none
     */
    public java.lang.Double getWeight() {
      return weight;
    }

    /**
     * The weight this audit's score has on the overall category score.
     * @param weight weight or {@code null} for none
     */
    public AuditRefs setWeight(java.lang.Double weight) {
      this.weight = weight;
      return this;
    }

    @Override
    public AuditRefs set(String fieldName, Object value) {
      return (AuditRefs) super.set(fieldName, value);
    }

    @Override
    public AuditRefs clone() {
      return (AuditRefs) super.clone();
    }

  }

}
