/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-01-30 at 11:38:08 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.pagespeedonline.model;

/**
 * Model definition for LighthouseAuditResultV5.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the PageSpeed Insights API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LighthouseAuditResultV5 extends com.google.api.client.json.GenericJson {

  /**
   * The description of the audit.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Freeform details section of the audit.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.Object> details;

  /**
   * The value that should be displayed on the UI for this audit.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayValue;

  /**
   * An error message from a thrown error inside the audit.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String errorMessage;

  /**
   * An explanation of the errors in the audit.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String explanation;

  /**
   * The audit's id.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * A numeric value that has a meaning specific to the audit, e.g. the number of nodes in the DOM
   * or the timestamp of a specific load event. More information can be found in the audit details,
   * if present.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double numericValue;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Object score;

  /**
   * The enumerated score display mode.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String scoreDisplayMode;

  /**
   * The human readable title.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Object warnings;

  /**
   * The description of the audit.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * The description of the audit.
   * @param description description or {@code null} for none
   */
  public LighthouseAuditResultV5 setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Freeform details section of the audit.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.Object> getDetails() {
    return details;
  }

  /**
   * Freeform details section of the audit.
   * @param details details or {@code null} for none
   */
  public LighthouseAuditResultV5 setDetails(java.util.Map<String, java.lang.Object> details) {
    this.details = details;
    return this;
  }

  /**
   * The value that should be displayed on the UI for this audit.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayValue() {
    return displayValue;
  }

  /**
   * The value that should be displayed on the UI for this audit.
   * @param displayValue displayValue or {@code null} for none
   */
  public LighthouseAuditResultV5 setDisplayValue(java.lang.String displayValue) {
    this.displayValue = displayValue;
    return this;
  }

  /**
   * An error message from a thrown error inside the audit.
   * @return value or {@code null} for none
   */
  public java.lang.String getErrorMessage() {
    return errorMessage;
  }

  /**
   * An error message from a thrown error inside the audit.
   * @param errorMessage errorMessage or {@code null} for none
   */
  public LighthouseAuditResultV5 setErrorMessage(java.lang.String errorMessage) {
    this.errorMessage = errorMessage;
    return this;
  }

  /**
   * An explanation of the errors in the audit.
   * @return value or {@code null} for none
   */
  public java.lang.String getExplanation() {
    return explanation;
  }

  /**
   * An explanation of the errors in the audit.
   * @param explanation explanation or {@code null} for none
   */
  public LighthouseAuditResultV5 setExplanation(java.lang.String explanation) {
    this.explanation = explanation;
    return this;
  }

  /**
   * The audit's id.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The audit's id.
   * @param id id or {@code null} for none
   */
  public LighthouseAuditResultV5 setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * A numeric value that has a meaning specific to the audit, e.g. the number of nodes in the DOM
   * or the timestamp of a specific load event. More information can be found in the audit details,
   * if present.
   * @return value or {@code null} for none
   */
  public java.lang.Double getNumericValue() {
    return numericValue;
  }

  /**
   * A numeric value that has a meaning specific to the audit, e.g. the number of nodes in the DOM
   * or the timestamp of a specific load event. More information can be found in the audit details,
   * if present.
   * @param numericValue numericValue or {@code null} for none
   */
  public LighthouseAuditResultV5 setNumericValue(java.lang.Double numericValue) {
    this.numericValue = numericValue;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.Object getScore() {
    return score;
  }

  /**
   * @param score score or {@code null} for none
   */
  public LighthouseAuditResultV5 setScore(java.lang.Object score) {
    this.score = score;
    return this;
  }

  /**
   * The enumerated score display mode.
   * @return value or {@code null} for none
   */
  public java.lang.String getScoreDisplayMode() {
    return scoreDisplayMode;
  }

  /**
   * The enumerated score display mode.
   * @param scoreDisplayMode scoreDisplayMode or {@code null} for none
   */
  public LighthouseAuditResultV5 setScoreDisplayMode(java.lang.String scoreDisplayMode) {
    this.scoreDisplayMode = scoreDisplayMode;
    return this;
  }

  /**
   * The human readable title.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * The human readable title.
   * @param title title or {@code null} for none
   */
  public LighthouseAuditResultV5 setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.Object getWarnings() {
    return warnings;
  }

  /**
   * @param warnings warnings or {@code null} for none
   */
  public LighthouseAuditResultV5 setWarnings(java.lang.Object warnings) {
    this.warnings = warnings;
    return this;
  }

  @Override
  public LighthouseAuditResultV5 set(String fieldName, Object value) {
    return (LighthouseAuditResultV5) super.set(fieldName, value);
  }

  @Override
  public LighthouseAuditResultV5 clone() {
    return (LighthouseAuditResultV5) super.clone();
  }

}
