/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.pagespeedonline;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Data;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.pagespeedonline.PagespeedonlineRequest;
import com.google.api.services.pagespeedonline.PagespeedonlineRequestInitializer;
import com.google.api.services.pagespeedonline.model.PagespeedApiPagespeedResponseV4;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pagespeedonline
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "pagespeedonline/v4/";
    public static final String DEFAULT_BATCH_PATH = "batch/pagespeedonline/v4";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/pagespeedonline/v4/";

    public Pagespeedonline(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Pagespeedonline(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Pagespeedapi pagespeedapi() {
        return new Pagespeedapi();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.25.0 of the PageSpeed Insights API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, Pagespeedonline.DEFAULT_ROOT_URL, Pagespeedonline.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Pagespeedonline.DEFAULT_BATCH_PATH);
        }

        public Pagespeedonline build() {
            return new Pagespeedonline(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setPagespeedonlineRequestInitializer(PagespeedonlineRequestInitializer pagespeedonlineRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)pagespeedonlineRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Pagespeedapi {
        public Runpagespeed runpagespeed(String string) throws IOException {
            Runpagespeed runpagespeed = new Runpagespeed(string);
            Pagespeedonline.this.initialize((AbstractGoogleClientRequest<?>)runpagespeed);
            return runpagespeed;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Runpagespeed
        extends PagespeedonlineRequest<PagespeedApiPagespeedResponseV4> {
            private static final String REST_PATH = "runPagespeed";
            private final Pattern URL_PATTERN;
            private final Pattern LOCALE_PATTERN;
            private final Pattern RULE_PATTERN;
            @Key
            private String url;
            @Key(value="filter_third_party_resources")
            private Boolean filterThirdPartyResources;
            @Key
            private String locale;
            @Key
            private List<String> rule;
            @Key
            private Boolean screenshot;
            @Key
            private Boolean snapshots;
            @Key
            private String strategy;
            @Key(value="utm_campaign")
            private String utmCampaign;
            @Key(value="utm_source")
            private String utmSource;

            protected Runpagespeed(String string) {
                super(Pagespeedonline.this, "GET", REST_PATH, null, PagespeedApiPagespeedResponseV4.class);
                this.URL_PATTERN = Pattern.compile("(?i)(site:|origin:)?http(s)?://.*");
                this.LOCALE_PATTERN = Pattern.compile("[a-zA-Z]+(_[a-zA-Z]+)?");
                this.RULE_PATTERN = Pattern.compile("[a-zA-Z]+");
                this.url = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter url must be specified.");
                if (!Pagespeedonline.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.URL_PATTERN.matcher(string).matches(), (Object)"Parameter url must conform to the pattern (?i)(site:|origin:)?http(s)?://.*");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Runpagespeed setAlt(String string) {
                return (Runpagespeed)super.setAlt(string);
            }

            public Runpagespeed setFields(String string) {
                return (Runpagespeed)super.setFields(string);
            }

            public Runpagespeed setKey(String string) {
                return (Runpagespeed)super.setKey(string);
            }

            public Runpagespeed setOauthToken(String string) {
                return (Runpagespeed)super.setOauthToken(string);
            }

            public Runpagespeed setPrettyPrint(Boolean bl) {
                return (Runpagespeed)super.setPrettyPrint(bl);
            }

            public Runpagespeed setQuotaUser(String string) {
                return (Runpagespeed)super.setQuotaUser(string);
            }

            public Runpagespeed setUserIp(String string) {
                return (Runpagespeed)super.setUserIp(string);
            }

            public String getUrl() {
                return this.url;
            }

            public Runpagespeed setUrl(String string) {
                if (!Pagespeedonline.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.URL_PATTERN.matcher(string).matches(), (Object)"Parameter url must conform to the pattern (?i)(site:|origin:)?http(s)?://.*");
                }
                this.url = string;
                return this;
            }

            public Boolean getFilterThirdPartyResources() {
                return this.filterThirdPartyResources;
            }

            public Runpagespeed setFilterThirdPartyResources(Boolean bl) {
                this.filterThirdPartyResources = bl;
                return this;
            }

            public boolean isFilterThirdPartyResources() {
                if (this.filterThirdPartyResources == null || this.filterThirdPartyResources == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.filterThirdPartyResources;
            }

            public String getLocale() {
                return this.locale;
            }

            public Runpagespeed setLocale(String string) {
                if (!Pagespeedonline.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.LOCALE_PATTERN.matcher(string).matches(), (Object)"Parameter locale must conform to the pattern [a-zA-Z]+(_[a-zA-Z]+)?");
                }
                this.locale = string;
                return this;
            }

            public List<String> getRule() {
                return this.rule;
            }

            public Runpagespeed setRule(List<String> list) {
                if (!Pagespeedonline.this.getSuppressPatternChecks()) {
                    for (String string : list) {
                        Preconditions.checkArgument((boolean)this.RULE_PATTERN.matcher(string).matches(), (Object)"Parameter rule elements must conform to the pattern [a-zA-Z]+");
                    }
                }
                this.rule = list;
                return this;
            }

            public Boolean getScreenshot() {
                return this.screenshot;
            }

            public Runpagespeed setScreenshot(Boolean bl) {
                this.screenshot = bl;
                return this;
            }

            public boolean isScreenshot() {
                if (this.screenshot == null || this.screenshot == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.screenshot;
            }

            public Boolean getSnapshots() {
                return this.snapshots;
            }

            public Runpagespeed setSnapshots(Boolean bl) {
                this.snapshots = bl;
                return this;
            }

            public boolean isSnapshots() {
                if (this.snapshots == null || this.snapshots == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.snapshots;
            }

            public String getStrategy() {
                return this.strategy;
            }

            public Runpagespeed setStrategy(String string) {
                this.strategy = string;
                return this;
            }

            public String getUtmCampaign() {
                return this.utmCampaign;
            }

            public Runpagespeed setUtmCampaign(String string) {
                this.utmCampaign = string;
                return this;
            }

            public String getUtmSource() {
                return this.utmSource;
            }

            public Runpagespeed setUtmSource(String string) {
                this.utmSource = string;
                return this;
            }

            @Override
            public Runpagespeed set(String string, Object object) {
                return (Runpagespeed)super.set(string, object);
            }
        }
    }
}

