/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-01-30 at 04:27:35 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.pagespeedonline.model;

/**
 * Model definition for PagespeedApiPagespeedResponseV4.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the PageSpeed Insights API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PagespeedApiPagespeedResponseV4 extends com.google.api.client.json.GenericJson {

  /**
   * The captcha verify result
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String captchaResult;

  /**
   * Localized PageSpeed results. Contains a ruleResults entry for each PageSpeed rule instantiated
   * and run by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FormattedResults formattedResults;

  /**
   * Canonicalized and final URL for the document, after following page redirects (if any).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * List of rules that were specified in the request, but which the server did not know how to
   * instantiate.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> invalidRules;

  /**
   * Kind of result.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Metrics of end users' page loading experience.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LoadingExperience loadingExperience;

  /**
   * Summary statistics for the page, such as number of JavaScript bytes, number of HTML bytes, etc.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PageStats pageStats;

  /**
   * Response code for the document. 200 indicates a normal page load. 4xx/5xx indicates an error.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer responseCode;

  /**
   * A map with one entry for each rule group in these results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, RuleGroupsElement> ruleGroups;

  static {
    // hack to force ProGuard to consider RuleGroupsElement used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(RuleGroupsElement.class);
  }

  /**
   * Base64-encoded screenshot of the page that was analyzed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PagespeedApiImageV4 screenshot;

  /**
   * Additional base64-encoded screenshots of the page, in various partial render states.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PagespeedApiImageV4> snapshots;

  static {
    // hack to force ProGuard to consider PagespeedApiImageV4 used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(PagespeedApiImageV4.class);
  }

  /**
   * Title of the page, as displayed in the browser's title bar.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * The version of PageSpeed used to generate these results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Version version;

  /**
   * The captcha verify result
   * @return value or {@code null} for none
   */
  public java.lang.String getCaptchaResult() {
    return captchaResult;
  }

  /**
   * The captcha verify result
   * @param captchaResult captchaResult or {@code null} for none
   */
  public PagespeedApiPagespeedResponseV4 setCaptchaResult(java.lang.String captchaResult) {
    this.captchaResult = captchaResult;
    return this;
  }

  /**
   * Localized PageSpeed results. Contains a ruleResults entry for each PageSpeed rule instantiated
   * and run by the server.
   * @return value or {@code null} for none
   */
  public FormattedResults getFormattedResults() {
    return formattedResults;
  }

  /**
   * Localized PageSpeed results. Contains a ruleResults entry for each PageSpeed rule instantiated
   * and run by the server.
   * @param formattedResults formattedResults or {@code null} for none
   */
  public PagespeedApiPagespeedResponseV4 setFormattedResults(FormattedResults formattedResults) {
    this.formattedResults = formattedResults;
    return this;
  }

  /**
   * Canonicalized and final URL for the document, after following page redirects (if any).
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Canonicalized and final URL for the document, after following page redirects (if any).
   * @param id id or {@code null} for none
   */
  public PagespeedApiPagespeedResponseV4 setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * List of rules that were specified in the request, but which the server did not know how to
   * instantiate.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getInvalidRules() {
    return invalidRules;
  }

  /**
   * List of rules that were specified in the request, but which the server did not know how to
   * instantiate.
   * @param invalidRules invalidRules or {@code null} for none
   */
  public PagespeedApiPagespeedResponseV4 setInvalidRules(java.util.List<java.lang.String> invalidRules) {
    this.invalidRules = invalidRules;
    return this;
  }

  /**
   * Kind of result.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Kind of result.
   * @param kind kind or {@code null} for none
   */
  public PagespeedApiPagespeedResponseV4 setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Metrics of end users' page loading experience.
   * @return value or {@code null} for none
   */
  public LoadingExperience getLoadingExperience() {
    return loadingExperience;
  }

  /**
   * Metrics of end users' page loading experience.
   * @param loadingExperience loadingExperience or {@code null} for none
   */
  public PagespeedApiPagespeedResponseV4 setLoadingExperience(LoadingExperience loadingExperience) {
    this.loadingExperience = loadingExperience;
    return this;
  }

  /**
   * Summary statistics for the page, such as number of JavaScript bytes, number of HTML bytes, etc.
   * @return value or {@code null} for none
   */
  public PageStats getPageStats() {
    return pageStats;
  }

  /**
   * Summary statistics for the page, such as number of JavaScript bytes, number of HTML bytes, etc.
   * @param pageStats pageStats or {@code null} for none
   */
  public PagespeedApiPagespeedResponseV4 setPageStats(PageStats pageStats) {
    this.pageStats = pageStats;
    return this;
  }

  /**
   * Response code for the document. 200 indicates a normal page load. 4xx/5xx indicates an error.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getResponseCode() {
    return responseCode;
  }

  /**
   * Response code for the document. 200 indicates a normal page load. 4xx/5xx indicates an error.
   * @param responseCode responseCode or {@code null} for none
   */
  public PagespeedApiPagespeedResponseV4 setResponseCode(java.lang.Integer responseCode) {
    this.responseCode = responseCode;
    return this;
  }

  /**
   * A map with one entry for each rule group in these results.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, RuleGroupsElement> getRuleGroups() {
    return ruleGroups;
  }

  /**
   * A map with one entry for each rule group in these results.
   * @param ruleGroups ruleGroups or {@code null} for none
   */
  public PagespeedApiPagespeedResponseV4 setRuleGroups(java.util.Map<String, RuleGroupsElement> ruleGroups) {
    this.ruleGroups = ruleGroups;
    return this;
  }

  /**
   * Base64-encoded screenshot of the page that was analyzed.
   * @return value or {@code null} for none
   */
  public PagespeedApiImageV4 getScreenshot() {
    return screenshot;
  }

  /**
   * Base64-encoded screenshot of the page that was analyzed.
   * @param screenshot screenshot or {@code null} for none
   */
  public PagespeedApiPagespeedResponseV4 setScreenshot(PagespeedApiImageV4 screenshot) {
    this.screenshot = screenshot;
    return this;
  }

  /**
   * Additional base64-encoded screenshots of the page, in various partial render states.
   * @return value or {@code null} for none
   */
  public java.util.List<PagespeedApiImageV4> getSnapshots() {
    return snapshots;
  }

  /**
   * Additional base64-encoded screenshots of the page, in various partial render states.
   * @param snapshots snapshots or {@code null} for none
   */
  public PagespeedApiPagespeedResponseV4 setSnapshots(java.util.List<PagespeedApiImageV4> snapshots) {
    this.snapshots = snapshots;
    return this;
  }

  /**
   * Title of the page, as displayed in the browser's title bar.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * Title of the page, as displayed in the browser's title bar.
   * @param title title or {@code null} for none
   */
  public PagespeedApiPagespeedResponseV4 setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  /**
   * The version of PageSpeed used to generate these results.
   * @return value or {@code null} for none
   */
  public Version getVersion() {
    return version;
  }

  /**
   * The version of PageSpeed used to generate these results.
   * @param version version or {@code null} for none
   */
  public PagespeedApiPagespeedResponseV4 setVersion(Version version) {
    this.version = version;
    return this;
  }

  @Override
  public PagespeedApiPagespeedResponseV4 set(String fieldName, Object value) {
    return (PagespeedApiPagespeedResponseV4) super.set(fieldName, value);
  }

  @Override
  public PagespeedApiPagespeedResponseV4 clone() {
    return (PagespeedApiPagespeedResponseV4) super.clone();
  }

  /**
   * Localized PageSpeed results. Contains a ruleResults entry for each PageSpeed rule instantiated
   * and run by the server.
   */
  public static final class FormattedResults extends com.google.api.client.json.GenericJson {

    /**
     * The locale of the formattedResults, e.g. "en_US".
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String locale;

    /**
     * Dictionary of formatted rule results, with one entry for each PageSpeed rule instantiated and
     * run by the server.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.Map<String, RuleResultsElement> ruleResults;

    static {
      // hack to force ProGuard to consider RuleResultsElement used, since otherwise it would be stripped out
      // see https://github.com/google/google-api-java-client/issues/543
      com.google.api.client.util.Data.nullOf(RuleResultsElement.class);
    }

    /**
     * The locale of the formattedResults, e.g. "en_US".
     * @return value or {@code null} for none
     */
    public java.lang.String getLocale() {
      return locale;
    }

    /**
     * The locale of the formattedResults, e.g. "en_US".
     * @param locale locale or {@code null} for none
     */
    public FormattedResults setLocale(java.lang.String locale) {
      this.locale = locale;
      return this;
    }

    /**
     * Dictionary of formatted rule results, with one entry for each PageSpeed rule instantiated and
     * run by the server.
     * @return value or {@code null} for none
     */
    public java.util.Map<String, RuleResultsElement> getRuleResults() {
      return ruleResults;
    }

    /**
     * Dictionary of formatted rule results, with one entry for each PageSpeed rule instantiated and
     * run by the server.
     * @param ruleResults ruleResults or {@code null} for none
     */
    public FormattedResults setRuleResults(java.util.Map<String, RuleResultsElement> ruleResults) {
      this.ruleResults = ruleResults;
      return this;
    }

    @Override
    public FormattedResults set(String fieldName, Object value) {
      return (FormattedResults) super.set(fieldName, value);
    }

    @Override
    public FormattedResults clone() {
      return (FormattedResults) super.clone();
    }

    /**
     * The enum-like identifier for this rule. For instance "EnableKeepAlive" or "AvoidCssImport". Not
     * localized.
     */
    public static final class RuleResultsElement extends com.google.api.client.json.GenericJson {

      /**
       * Whether this rule is in 'beta'. Rules in beta are new rules that are being tested, which do not
       * impact the overall score.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean beta;

      /**
       * List of rule groups that this rule belongs to. Each entry in the list is one of "SPEED",
       * "USABILITY", or "SECURITY".
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> groups;

      /**
       * Localized name of the rule, intended for presentation to a user.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String localizedRuleName;

      /**
       * The impact (unbounded floating point value) that implementing the suggestions for this rule
       * would have on making the page faster. Impact is comparable between rules to determine which
       * rule's suggestions would have a higher or lower impact on making a page faster. For instance,
       * if enabling compression would save 1MB, while optimizing images would save 500kB, the enable
       * compression rule would have 2x the impact of the image optimization rule, all other things
       * being equal.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Double ruleImpact;

      /**
       * A brief summary description for the rule, indicating at a high level what should be done to
       * follow the rule and what benefit can be gained by doing so.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private PagespeedApiFormatStringV4 summary;

      /**
       * List of blocks of URLs. Each block may contain a heading and a list of URLs. Each URL may
       * optionally include additional details.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.util.List<UrlBlocks> urlBlocks;

      static {
        // hack to force ProGuard to consider UrlBlocks used, since otherwise it would be stripped out
        // see https://github.com/google/google-api-java-client/issues/543
        com.google.api.client.util.Data.nullOf(UrlBlocks.class);
      }

      /**
       * Whether this rule is in 'beta'. Rules in beta are new rules that are being tested, which do not
       * impact the overall score.
       * @return value or {@code null} for none
       */
      public java.lang.Boolean getBeta() {
        return beta;
      }

      /**
       * Whether this rule is in 'beta'. Rules in beta are new rules that are being tested, which do not
       * impact the overall score.
       * @param beta beta or {@code null} for none
       */
      public RuleResultsElement setBeta(java.lang.Boolean beta) {
        this.beta = beta;
        return this;
      }

      /**
       * List of rule groups that this rule belongs to. Each entry in the list is one of "SPEED",
       * "USABILITY", or "SECURITY".
       * @return value or {@code null} for none
       */
      public java.util.List<java.lang.String> getGroups() {
        return groups;
      }

      /**
       * List of rule groups that this rule belongs to. Each entry in the list is one of "SPEED",
       * "USABILITY", or "SECURITY".
       * @param groups groups or {@code null} for none
       */
      public RuleResultsElement setGroups(java.util.List<java.lang.String> groups) {
        this.groups = groups;
        return this;
      }

      /**
       * Localized name of the rule, intended for presentation to a user.
       * @return value or {@code null} for none
       */
      public java.lang.String getLocalizedRuleName() {
        return localizedRuleName;
      }

      /**
       * Localized name of the rule, intended for presentation to a user.
       * @param localizedRuleName localizedRuleName or {@code null} for none
       */
      public RuleResultsElement setLocalizedRuleName(java.lang.String localizedRuleName) {
        this.localizedRuleName = localizedRuleName;
        return this;
      }

      /**
       * The impact (unbounded floating point value) that implementing the suggestions for this rule
       * would have on making the page faster. Impact is comparable between rules to determine which
       * rule's suggestions would have a higher or lower impact on making a page faster. For instance,
       * if enabling compression would save 1MB, while optimizing images would save 500kB, the enable
       * compression rule would have 2x the impact of the image optimization rule, all other things
       * being equal.
       * @return value or {@code null} for none
       */
      public java.lang.Double getRuleImpact() {
        return ruleImpact;
      }

      /**
       * The impact (unbounded floating point value) that implementing the suggestions for this rule
       * would have on making the page faster. Impact is comparable between rules to determine which
       * rule's suggestions would have a higher or lower impact on making a page faster. For instance,
       * if enabling compression would save 1MB, while optimizing images would save 500kB, the enable
       * compression rule would have 2x the impact of the image optimization rule, all other things
       * being equal.
       * @param ruleImpact ruleImpact or {@code null} for none
       */
      public RuleResultsElement setRuleImpact(java.lang.Double ruleImpact) {
        this.ruleImpact = ruleImpact;
        return this;
      }

      /**
       * A brief summary description for the rule, indicating at a high level what should be done to
       * follow the rule and what benefit can be gained by doing so.
       * @return value or {@code null} for none
       */
      public PagespeedApiFormatStringV4 getSummary() {
        return summary;
      }

      /**
       * A brief summary description for the rule, indicating at a high level what should be done to
       * follow the rule and what benefit can be gained by doing so.
       * @param summary summary or {@code null} for none
       */
      public RuleResultsElement setSummary(PagespeedApiFormatStringV4 summary) {
        this.summary = summary;
        return this;
      }

      /**
       * List of blocks of URLs. Each block may contain a heading and a list of URLs. Each URL may
       * optionally include additional details.
       * @return value or {@code null} for none
       */
      public java.util.List<UrlBlocks> getUrlBlocks() {
        return urlBlocks;
      }

      /**
       * List of blocks of URLs. Each block may contain a heading and a list of URLs. Each URL may
       * optionally include additional details.
       * @param urlBlocks urlBlocks or {@code null} for none
       */
      public RuleResultsElement setUrlBlocks(java.util.List<UrlBlocks> urlBlocks) {
        this.urlBlocks = urlBlocks;
        return this;
      }

      @Override
      public RuleResultsElement set(String fieldName, Object value) {
        return (RuleResultsElement) super.set(fieldName, value);
      }

      @Override
      public RuleResultsElement clone() {
        return (RuleResultsElement) super.clone();
      }

      /**
       * Model definition for PagespeedApiPagespeedResponseV4FormattedResultsRuleResultsElementUrlBlocks.
       */
      public static final class UrlBlocks extends com.google.api.client.json.GenericJson {

        /**
         * Heading to be displayed with the list of URLs.
         * The value may be {@code null}.
         */
        @com.google.api.client.util.Key
        private PagespeedApiFormatStringV4 header;

        /**
         * List of entries that provide information about URLs in the url block. Optional.
         * The value may be {@code null}.
         */
        @com.google.api.client.util.Key
        private java.util.List<Urls> urls;

        static {
          // hack to force ProGuard to consider Urls used, since otherwise it would be stripped out
          // see https://github.com/google/google-api-java-client/issues/543
          com.google.api.client.util.Data.nullOf(Urls.class);
        }

        /**
         * Heading to be displayed with the list of URLs.
         * @return value or {@code null} for none
         */
        public PagespeedApiFormatStringV4 getHeader() {
          return header;
        }

        /**
         * Heading to be displayed with the list of URLs.
         * @param header header or {@code null} for none
         */
        public UrlBlocks setHeader(PagespeedApiFormatStringV4 header) {
          this.header = header;
          return this;
        }

        /**
         * List of entries that provide information about URLs in the url block. Optional.
         * @return value or {@code null} for none
         */
        public java.util.List<Urls> getUrls() {
          return urls;
        }

        /**
         * List of entries that provide information about URLs in the url block. Optional.
         * @param urls urls or {@code null} for none
         */
        public UrlBlocks setUrls(java.util.List<Urls> urls) {
          this.urls = urls;
          return this;
        }

        @Override
        public UrlBlocks set(String fieldName, Object value) {
          return (UrlBlocks) super.set(fieldName, value);
        }

        @Override
        public UrlBlocks clone() {
          return (UrlBlocks) super.clone();
        }

        /**
         * Model definition for
         * PagespeedApiPagespeedResponseV4FormattedResultsRuleResultsElementUrlBlocksUrls.
         */
        public static final class Urls extends com.google.api.client.json.GenericJson {

          /**
           * List of entries that provide additional details about a single URL. Optional.
           * The value may be {@code null}.
           */
          @com.google.api.client.util.Key
          private java.util.List<PagespeedApiFormatStringV4> details;

          static {
            // hack to force ProGuard to consider PagespeedApiFormatStringV4 used, since otherwise it would be stripped out
            // see https://github.com/google/google-api-java-client/issues/543
            com.google.api.client.util.Data.nullOf(PagespeedApiFormatStringV4.class);
          }

          /**
           * A format string that gives information about the URL, and a list of arguments for that format
           * string.
           * The value may be {@code null}.
           */
          @com.google.api.client.util.Key
          private PagespeedApiFormatStringV4 result;

          /**
           * List of entries that provide additional details about a single URL. Optional.
           * @return value or {@code null} for none
           */
          public java.util.List<PagespeedApiFormatStringV4> getDetails() {
            return details;
          }

          /**
           * List of entries that provide additional details about a single URL. Optional.
           * @param details details or {@code null} for none
           */
          public Urls setDetails(java.util.List<PagespeedApiFormatStringV4> details) {
            this.details = details;
            return this;
          }

          /**
           * A format string that gives information about the URL, and a list of arguments for that format
           * string.
           * @return value or {@code null} for none
           */
          public PagespeedApiFormatStringV4 getResult() {
            return result;
          }

          /**
           * A format string that gives information about the URL, and a list of arguments for that format
           * string.
           * @param result result or {@code null} for none
           */
          public Urls setResult(PagespeedApiFormatStringV4 result) {
            this.result = result;
            return this;
          }

          @Override
          public Urls set(String fieldName, Object value) {
            return (Urls) super.set(fieldName, value);
          }

          @Override
          public Urls clone() {
            return (Urls) super.clone();
          }

        }
      }
    }
  }

  /**
   * Metrics of end users' page loading experience.
   */
  public static final class LoadingExperience extends com.google.api.client.json.GenericJson {

    /**
     * The url, pattern or origin which the metrics are on.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String id;

    /**
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key("initial_url")
    private java.lang.String initialUrl;

    /**
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.Map<String, MetricsElement> metrics;

    static {
      // hack to force ProGuard to consider MetricsElement used, since otherwise it would be stripped out
      // see https://github.com/google/google-api-java-client/issues/543
      com.google.api.client.util.Data.nullOf(MetricsElement.class);
    }

    /**
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key("overall_category")
    private java.lang.String overallCategory;

    /**
     * The url, pattern or origin which the metrics are on.
     * @return value or {@code null} for none
     */
    public java.lang.String getId() {
      return id;
    }

    /**
     * The url, pattern or origin which the metrics are on.
     * @param id id or {@code null} for none
     */
    public LoadingExperience setId(java.lang.String id) {
      this.id = id;
      return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public java.lang.String getInitialUrl() {
      return initialUrl;
    }

    /**
     * @param initialUrl initialUrl or {@code null} for none
     */
    public LoadingExperience setInitialUrl(java.lang.String initialUrl) {
      this.initialUrl = initialUrl;
      return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public java.util.Map<String, MetricsElement> getMetrics() {
      return metrics;
    }

    /**
     * @param metrics metrics or {@code null} for none
     */
    public LoadingExperience setMetrics(java.util.Map<String, MetricsElement> metrics) {
      this.metrics = metrics;
      return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public java.lang.String getOverallCategory() {
      return overallCategory;
    }

    /**
     * @param overallCategory overallCategory or {@code null} for none
     */
    public LoadingExperience setOverallCategory(java.lang.String overallCategory) {
      this.overallCategory = overallCategory;
      return this;
    }

    @Override
    public LoadingExperience set(String fieldName, Object value) {
      return (LoadingExperience) super.set(fieldName, value);
    }

    @Override
    public LoadingExperience clone() {
      return (LoadingExperience) super.clone();
    }

    /**
     * The type of the metric.
     */
    public static final class MetricsElement extends com.google.api.client.json.GenericJson {

      /**
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String category;

      /**
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.util.List<Distributions> distributions;

      static {
        // hack to force ProGuard to consider Distributions used, since otherwise it would be stripped out
        // see https://github.com/google/google-api-java-client/issues/543
        com.google.api.client.util.Data.nullOf(Distributions.class);
      }

      /**
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer median;

      /**
       * @return value or {@code null} for none
       */
      public java.lang.String getCategory() {
        return category;
      }

      /**
       * @param category category or {@code null} for none
       */
      public MetricsElement setCategory(java.lang.String category) {
        this.category = category;
        return this;
      }

      /**
       * @return value or {@code null} for none
       */
      public java.util.List<Distributions> getDistributions() {
        return distributions;
      }

      /**
       * @param distributions distributions or {@code null} for none
       */
      public MetricsElement setDistributions(java.util.List<Distributions> distributions) {
        this.distributions = distributions;
        return this;
      }

      /**
       * @return value or {@code null} for none
       */
      public java.lang.Integer getMedian() {
        return median;
      }

      /**
       * @param median median or {@code null} for none
       */
      public MetricsElement setMedian(java.lang.Integer median) {
        this.median = median;
        return this;
      }

      @Override
      public MetricsElement set(String fieldName, Object value) {
        return (MetricsElement) super.set(fieldName, value);
      }

      @Override
      public MetricsElement clone() {
        return (MetricsElement) super.clone();
      }

      /**
       * Model definition for PagespeedApiPagespeedResponseV4LoadingExperienceMetricsElementDistributions.
       */
      public static final class Distributions extends com.google.api.client.json.GenericJson {

        /**
         * The value may be {@code null}.
         */
        @com.google.api.client.util.Key
        private java.lang.Integer max;

        /**
         * The value may be {@code null}.
         */
        @com.google.api.client.util.Key
        private java.lang.Integer min;

        /**
         * The value may be {@code null}.
         */
        @com.google.api.client.util.Key
        private java.lang.Double proportion;

        /**
         * @return value or {@code null} for none
         */
        public java.lang.Integer getMax() {
          return max;
        }

        /**
         * @param max max or {@code null} for none
         */
        public Distributions setMax(java.lang.Integer max) {
          this.max = max;
          return this;
        }

        /**
         * @return value or {@code null} for none
         */
        public java.lang.Integer getMin() {
          return min;
        }

        /**
         * @param min min or {@code null} for none
         */
        public Distributions setMin(java.lang.Integer min) {
          this.min = min;
          return this;
        }

        /**
         * @return value or {@code null} for none
         */
        public java.lang.Double getProportion() {
          return proportion;
        }

        /**
         * @param proportion proportion or {@code null} for none
         */
        public Distributions setProportion(java.lang.Double proportion) {
          this.proportion = proportion;
          return this;
        }

        @Override
        public Distributions set(String fieldName, Object value) {
          return (Distributions) super.set(fieldName, value);
        }

        @Override
        public Distributions clone() {
          return (Distributions) super.clone();
        }

      }
    }
  }

  /**
   * Summary statistics for the page, such as number of JavaScript bytes, number of HTML bytes, etc.
   */
  public static final class PageStats extends com.google.api.client.json.GenericJson {

    /**
     * Content management system (CMS) used for the page.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String cms;

    /**
     * Number of uncompressed response bytes for CSS resources on the page.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key @com.google.api.client.json.JsonString
    private java.lang.Long cssResponseBytes;

    /**
     * Number of response bytes for flash resources on the page.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key @com.google.api.client.json.JsonString
    private java.lang.Long flashResponseBytes;

    /**
     * Number of uncompressed response bytes for the main HTML document and all iframes on the page.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key @com.google.api.client.json.JsonString
    private java.lang.Long htmlResponseBytes;

    /**
     * Number of response bytes for image resources on the page.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key @com.google.api.client.json.JsonString
    private java.lang.Long imageResponseBytes;

    /**
     * Number of uncompressed response bytes for JS resources on the page.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key @com.google.api.client.json.JsonString
    private java.lang.Long javascriptResponseBytes;

    /**
     * The needed round trips to load render blocking resources
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer numRenderBlockingRoundTrips;

    /**
     * The needed round trips to load the full page
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer numTotalRoundTrips;

    /**
     * Number of CSS resources referenced by the page.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer numberCssResources;

    /**
     * Number of unique hosts referenced by the page.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer numberHosts;

    /**
     * Number of JavaScript resources referenced by the page.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer numberJsResources;

    /**
     * Number of HTTP resources loaded by the page.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer numberResources;

    /**
     * Number of roboted resources.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer numberRobotedResources;

    /**
     * Number of static (i.e. cacheable) resources on the page.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer numberStaticResources;

    /**
     * Number of transient-failed resources.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer numberTransientFetchFailureResources;

    /**
     * Number of response bytes for other resources on the page.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key @com.google.api.client.json.JsonString
    private java.lang.Long otherResponseBytes;

    /**
     * Number of over-the-wire bytes, uses the default gzip compression strategy as an estimation.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key @com.google.api.client.json.JsonString
    private java.lang.Long overTheWireResponseBytes;

    /**
     * List of roboted urls.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<java.lang.String> robotedUrls;

    /**
     * Number of uncompressed response bytes for text resources not covered by other statistics (i.e
     * non-HTML, non-script, non-CSS resources) on the page.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key @com.google.api.client.json.JsonString
    private java.lang.Long textResponseBytes;

    /**
     * Total size of all request bytes sent by the page.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key @com.google.api.client.json.JsonString
    private java.lang.Long totalRequestBytes;

    /**
     * List of transient fetch failure urls.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<java.lang.String> transientFetchFailureUrls;

    /**
     * Content management system (CMS) used for the page.
     * @return value or {@code null} for none
     */
    public java.lang.String getCms() {
      return cms;
    }

    /**
     * Content management system (CMS) used for the page.
     * @param cms cms or {@code null} for none
     */
    public PageStats setCms(java.lang.String cms) {
      this.cms = cms;
      return this;
    }

    /**
     * Number of uncompressed response bytes for CSS resources on the page.
     * @return value or {@code null} for none
     */
    public java.lang.Long getCssResponseBytes() {
      return cssResponseBytes;
    }

    /**
     * Number of uncompressed response bytes for CSS resources on the page.
     * @param cssResponseBytes cssResponseBytes or {@code null} for none
     */
    public PageStats setCssResponseBytes(java.lang.Long cssResponseBytes) {
      this.cssResponseBytes = cssResponseBytes;
      return this;
    }

    /**
     * Number of response bytes for flash resources on the page.
     * @return value or {@code null} for none
     */
    public java.lang.Long getFlashResponseBytes() {
      return flashResponseBytes;
    }

    /**
     * Number of response bytes for flash resources on the page.
     * @param flashResponseBytes flashResponseBytes or {@code null} for none
     */
    public PageStats setFlashResponseBytes(java.lang.Long flashResponseBytes) {
      this.flashResponseBytes = flashResponseBytes;
      return this;
    }

    /**
     * Number of uncompressed response bytes for the main HTML document and all iframes on the page.
     * @return value or {@code null} for none
     */
    public java.lang.Long getHtmlResponseBytes() {
      return htmlResponseBytes;
    }

    /**
     * Number of uncompressed response bytes for the main HTML document and all iframes on the page.
     * @param htmlResponseBytes htmlResponseBytes or {@code null} for none
     */
    public PageStats setHtmlResponseBytes(java.lang.Long htmlResponseBytes) {
      this.htmlResponseBytes = htmlResponseBytes;
      return this;
    }

    /**
     * Number of response bytes for image resources on the page.
     * @return value or {@code null} for none
     */
    public java.lang.Long getImageResponseBytes() {
      return imageResponseBytes;
    }

    /**
     * Number of response bytes for image resources on the page.
     * @param imageResponseBytes imageResponseBytes or {@code null} for none
     */
    public PageStats setImageResponseBytes(java.lang.Long imageResponseBytes) {
      this.imageResponseBytes = imageResponseBytes;
      return this;
    }

    /**
     * Number of uncompressed response bytes for JS resources on the page.
     * @return value or {@code null} for none
     */
    public java.lang.Long getJavascriptResponseBytes() {
      return javascriptResponseBytes;
    }

    /**
     * Number of uncompressed response bytes for JS resources on the page.
     * @param javascriptResponseBytes javascriptResponseBytes or {@code null} for none
     */
    public PageStats setJavascriptResponseBytes(java.lang.Long javascriptResponseBytes) {
      this.javascriptResponseBytes = javascriptResponseBytes;
      return this;
    }

    /**
     * The needed round trips to load render blocking resources
     * @return value or {@code null} for none
     */
    public java.lang.Integer getNumRenderBlockingRoundTrips() {
      return numRenderBlockingRoundTrips;
    }

    /**
     * The needed round trips to load render blocking resources
     * @param numRenderBlockingRoundTrips numRenderBlockingRoundTrips or {@code null} for none
     */
    public PageStats setNumRenderBlockingRoundTrips(java.lang.Integer numRenderBlockingRoundTrips) {
      this.numRenderBlockingRoundTrips = numRenderBlockingRoundTrips;
      return this;
    }

    /**
     * The needed round trips to load the full page
     * @return value or {@code null} for none
     */
    public java.lang.Integer getNumTotalRoundTrips() {
      return numTotalRoundTrips;
    }

    /**
     * The needed round trips to load the full page
     * @param numTotalRoundTrips numTotalRoundTrips or {@code null} for none
     */
    public PageStats setNumTotalRoundTrips(java.lang.Integer numTotalRoundTrips) {
      this.numTotalRoundTrips = numTotalRoundTrips;
      return this;
    }

    /**
     * Number of CSS resources referenced by the page.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getNumberCssResources() {
      return numberCssResources;
    }

    /**
     * Number of CSS resources referenced by the page.
     * @param numberCssResources numberCssResources or {@code null} for none
     */
    public PageStats setNumberCssResources(java.lang.Integer numberCssResources) {
      this.numberCssResources = numberCssResources;
      return this;
    }

    /**
     * Number of unique hosts referenced by the page.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getNumberHosts() {
      return numberHosts;
    }

    /**
     * Number of unique hosts referenced by the page.
     * @param numberHosts numberHosts or {@code null} for none
     */
    public PageStats setNumberHosts(java.lang.Integer numberHosts) {
      this.numberHosts = numberHosts;
      return this;
    }

    /**
     * Number of JavaScript resources referenced by the page.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getNumberJsResources() {
      return numberJsResources;
    }

    /**
     * Number of JavaScript resources referenced by the page.
     * @param numberJsResources numberJsResources or {@code null} for none
     */
    public PageStats setNumberJsResources(java.lang.Integer numberJsResources) {
      this.numberJsResources = numberJsResources;
      return this;
    }

    /**
     * Number of HTTP resources loaded by the page.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getNumberResources() {
      return numberResources;
    }

    /**
     * Number of HTTP resources loaded by the page.
     * @param numberResources numberResources or {@code null} for none
     */
    public PageStats setNumberResources(java.lang.Integer numberResources) {
      this.numberResources = numberResources;
      return this;
    }

    /**
     * Number of roboted resources.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getNumberRobotedResources() {
      return numberRobotedResources;
    }

    /**
     * Number of roboted resources.
     * @param numberRobotedResources numberRobotedResources or {@code null} for none
     */
    public PageStats setNumberRobotedResources(java.lang.Integer numberRobotedResources) {
      this.numberRobotedResources = numberRobotedResources;
      return this;
    }

    /**
     * Number of static (i.e. cacheable) resources on the page.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getNumberStaticResources() {
      return numberStaticResources;
    }

    /**
     * Number of static (i.e. cacheable) resources on the page.
     * @param numberStaticResources numberStaticResources or {@code null} for none
     */
    public PageStats setNumberStaticResources(java.lang.Integer numberStaticResources) {
      this.numberStaticResources = numberStaticResources;
      return this;
    }

    /**
     * Number of transient-failed resources.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getNumberTransientFetchFailureResources() {
      return numberTransientFetchFailureResources;
    }

    /**
     * Number of transient-failed resources.
     * @param numberTransientFetchFailureResources numberTransientFetchFailureResources or {@code null} for none
     */
    public PageStats setNumberTransientFetchFailureResources(java.lang.Integer numberTransientFetchFailureResources) {
      this.numberTransientFetchFailureResources = numberTransientFetchFailureResources;
      return this;
    }

    /**
     * Number of response bytes for other resources on the page.
     * @return value or {@code null} for none
     */
    public java.lang.Long getOtherResponseBytes() {
      return otherResponseBytes;
    }

    /**
     * Number of response bytes for other resources on the page.
     * @param otherResponseBytes otherResponseBytes or {@code null} for none
     */
    public PageStats setOtherResponseBytes(java.lang.Long otherResponseBytes) {
      this.otherResponseBytes = otherResponseBytes;
      return this;
    }

    /**
     * Number of over-the-wire bytes, uses the default gzip compression strategy as an estimation.
     * @return value or {@code null} for none
     */
    public java.lang.Long getOverTheWireResponseBytes() {
      return overTheWireResponseBytes;
    }

    /**
     * Number of over-the-wire bytes, uses the default gzip compression strategy as an estimation.
     * @param overTheWireResponseBytes overTheWireResponseBytes or {@code null} for none
     */
    public PageStats setOverTheWireResponseBytes(java.lang.Long overTheWireResponseBytes) {
      this.overTheWireResponseBytes = overTheWireResponseBytes;
      return this;
    }

    /**
     * List of roboted urls.
     * @return value or {@code null} for none
     */
    public java.util.List<java.lang.String> getRobotedUrls() {
      return robotedUrls;
    }

    /**
     * List of roboted urls.
     * @param robotedUrls robotedUrls or {@code null} for none
     */
    public PageStats setRobotedUrls(java.util.List<java.lang.String> robotedUrls) {
      this.robotedUrls = robotedUrls;
      return this;
    }

    /**
     * Number of uncompressed response bytes for text resources not covered by other statistics (i.e
     * non-HTML, non-script, non-CSS resources) on the page.
     * @return value or {@code null} for none
     */
    public java.lang.Long getTextResponseBytes() {
      return textResponseBytes;
    }

    /**
     * Number of uncompressed response bytes for text resources not covered by other statistics (i.e
     * non-HTML, non-script, non-CSS resources) on the page.
     * @param textResponseBytes textResponseBytes or {@code null} for none
     */
    public PageStats setTextResponseBytes(java.lang.Long textResponseBytes) {
      this.textResponseBytes = textResponseBytes;
      return this;
    }

    /**
     * Total size of all request bytes sent by the page.
     * @return value or {@code null} for none
     */
    public java.lang.Long getTotalRequestBytes() {
      return totalRequestBytes;
    }

    /**
     * Total size of all request bytes sent by the page.
     * @param totalRequestBytes totalRequestBytes or {@code null} for none
     */
    public PageStats setTotalRequestBytes(java.lang.Long totalRequestBytes) {
      this.totalRequestBytes = totalRequestBytes;
      return this;
    }

    /**
     * List of transient fetch failure urls.
     * @return value or {@code null} for none
     */
    public java.util.List<java.lang.String> getTransientFetchFailureUrls() {
      return transientFetchFailureUrls;
    }

    /**
     * List of transient fetch failure urls.
     * @param transientFetchFailureUrls transientFetchFailureUrls or {@code null} for none
     */
    public PageStats setTransientFetchFailureUrls(java.util.List<java.lang.String> transientFetchFailureUrls) {
      this.transientFetchFailureUrls = transientFetchFailureUrls;
      return this;
    }

    @Override
    public PageStats set(String fieldName, Object value) {
      return (PageStats) super.set(fieldName, value);
    }

    @Override
    public PageStats clone() {
      return (PageStats) super.clone();
    }

  }

  /**
   * The name of this rule group: one of "SPEED", "USABILITY", or "SECURITY".
   */
  public static final class RuleGroupsElement extends com.google.api.client.json.GenericJson {

    /**
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean pass;

    /**
     * The score (0-100) for this rule group, which indicates how much better a page could be in that
     * category (e.g. how much faster, or how much more usable, or how much more secure). A high score
     * indicates little room for improvement, while a lower score indicates more room for improvement.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer score;

    /**
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getPass() {
      return pass;
    }

    /**
     * @param pass pass or {@code null} for none
     */
    public RuleGroupsElement setPass(java.lang.Boolean pass) {
      this.pass = pass;
      return this;
    }

    /**
     * The score (0-100) for this rule group, which indicates how much better a page could be in that
     * category (e.g. how much faster, or how much more usable, or how much more secure). A high score
     * indicates little room for improvement, while a lower score indicates more room for improvement.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getScore() {
      return score;
    }

    /**
     * The score (0-100) for this rule group, which indicates how much better a page could be in that
     * category (e.g. how much faster, or how much more usable, or how much more secure). A high score
     * indicates little room for improvement, while a lower score indicates more room for improvement.
     * @param score score or {@code null} for none
     */
    public RuleGroupsElement setScore(java.lang.Integer score) {
      this.score = score;
      return this;
    }

    @Override
    public RuleGroupsElement set(String fieldName, Object value) {
      return (RuleGroupsElement) super.set(fieldName, value);
    }

    @Override
    public RuleGroupsElement clone() {
      return (RuleGroupsElement) super.clone();
    }

  }

  /**
   * The version of PageSpeed used to generate these results.
   */
  public static final class Version extends com.google.api.client.json.GenericJson {

    /**
     * The major version number of PageSpeed used to generate these results.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer major;

    /**
     * The minor version number of PageSpeed used to generate these results.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer minor;

    /**
     * The major version number of PageSpeed used to generate these results.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getMajor() {
      return major;
    }

    /**
     * The major version number of PageSpeed used to generate these results.
     * @param major major or {@code null} for none
     */
    public Version setMajor(java.lang.Integer major) {
      this.major = major;
      return this;
    }

    /**
     * The minor version number of PageSpeed used to generate these results.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getMinor() {
      return minor;
    }

    /**
     * The minor version number of PageSpeed used to generate these results.
     * @param minor minor or {@code null} for none
     */
    public Version setMinor(java.lang.Integer minor) {
      this.minor = minor;
      return this;
    }

    @Override
    public Version set(String fieldName, Object value) {
      return (Version) super.set(fieldName, value);
    }

    @Override
    public Version clone() {
      return (Version) super.clone();
    }

  }
}
