/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-01-30 at 04:27:35 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.pagespeedonline.model;

/**
 * Model definition for PagespeedApiImageV4.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the PageSpeed Insights API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PagespeedApiImageV4 extends com.google.api.client.json.GenericJson {

  /**
   * Image data base64 encoded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String data;

  /**
   * Height of screenshot in pixels.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer height;

  /**
   * Unique string key, if any, identifying this image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String key;

  /**
   * Mime type of image data (e.g. "image/jpeg").
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("mime_type")
  private java.lang.String mimeType;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("page_rect")
  private PageRect pageRect;

  /**
   * Width of screenshot in pixels.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer width;

  /**
   * Image data base64 encoded.
   * @see #decodeData()
   * @return value or {@code null} for none
   */
  public java.lang.String getData() {
    return data;
  }

  /**
   * Image data base64 encoded.
   * @see #getData()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeData() {
    return com.google.api.client.util.Base64.decodeBase64(data);
  }

  /**
   * Image data base64 encoded.
   * @see #encodeData()
   * @param data data or {@code null} for none
   */
  public PagespeedApiImageV4 setData(java.lang.String data) {
    this.data = data;
    return this;
  }

  /**
   * Image data base64 encoded.
   * @see #setData()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public PagespeedApiImageV4 encodeData(byte[] data) {
    this.data = com.google.api.client.util.Base64.encodeBase64URLSafeString(data);
    return this;
  }

  /**
   * Height of screenshot in pixels.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getHeight() {
    return height;
  }

  /**
   * Height of screenshot in pixels.
   * @param height height or {@code null} for none
   */
  public PagespeedApiImageV4 setHeight(java.lang.Integer height) {
    this.height = height;
    return this;
  }

  /**
   * Unique string key, if any, identifying this image.
   * @return value or {@code null} for none
   */
  public java.lang.String getKey() {
    return key;
  }

  /**
   * Unique string key, if any, identifying this image.
   * @param key key or {@code null} for none
   */
  public PagespeedApiImageV4 setKey(java.lang.String key) {
    this.key = key;
    return this;
  }

  /**
   * Mime type of image data (e.g. "image/jpeg").
   * @return value or {@code null} for none
   */
  public java.lang.String getMimeType() {
    return mimeType;
  }

  /**
   * Mime type of image data (e.g. "image/jpeg").
   * @param mimeType mimeType or {@code null} for none
   */
  public PagespeedApiImageV4 setMimeType(java.lang.String mimeType) {
    this.mimeType = mimeType;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public PageRect getPageRect() {
    return pageRect;
  }

  /**
   * @param pageRect pageRect or {@code null} for none
   */
  public PagespeedApiImageV4 setPageRect(PageRect pageRect) {
    this.pageRect = pageRect;
    return this;
  }

  /**
   * Width of screenshot in pixels.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getWidth() {
    return width;
  }

  /**
   * Width of screenshot in pixels.
   * @param width width or {@code null} for none
   */
  public PagespeedApiImageV4 setWidth(java.lang.Integer width) {
    this.width = width;
    return this;
  }

  @Override
  public PagespeedApiImageV4 set(String fieldName, Object value) {
    return (PagespeedApiImageV4) super.set(fieldName, value);
  }

  @Override
  public PagespeedApiImageV4 clone() {
    return (PagespeedApiImageV4) super.clone();
  }

  /**
   * Model definition for PagespeedApiImageV4PageRect.
   */
  public static final class PageRect extends com.google.api.client.json.GenericJson {

    /**
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer height;

    /**
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer left;

    /**
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer top;

    /**
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer width;

    /**
     * @return value or {@code null} for none
     */
    public java.lang.Integer getHeight() {
      return height;
    }

    /**
     * @param height height or {@code null} for none
     */
    public PageRect setHeight(java.lang.Integer height) {
      this.height = height;
      return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public java.lang.Integer getLeft() {
      return left;
    }

    /**
     * @param left left or {@code null} for none
     */
    public PageRect setLeft(java.lang.Integer left) {
      this.left = left;
      return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public java.lang.Integer getTop() {
      return top;
    }

    /**
     * @param top top or {@code null} for none
     */
    public PageRect setTop(java.lang.Integer top) {
      this.top = top;
      return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public java.lang.Integer getWidth() {
      return width;
    }

    /**
     * @param width width or {@code null} for none
     */
    public PageRect setWidth(java.lang.Integer width) {
      this.width = width;
      return this;
    }

    @Override
    public PageRect set(String fieldName, Object value) {
      return (PageRect) super.set(fieldName, value);
    }

    @Override
    public PageRect clone() {
      return (PageRect) super.clone();
    }

  }

}
