/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-01-30 at 04:27:35 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.pagespeedonline.model;

/**
 * Model definition for PagespeedApiFormatStringV4.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the PageSpeed Insights API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PagespeedApiFormatStringV4 extends com.google.api.client.json.GenericJson {

  /**
   * List of arguments for the format string.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Args> args;

  static {
    // hack to force ProGuard to consider Args used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Args.class);
  }

  /**
   * A localized format string with {{FOO}} placeholders, where 'FOO' is the key of the argument
   * whose value should be substituted. For HYPERLINK arguments, the format string will instead
   * contain {{BEGIN_FOO}} and {{END_FOO}} for the argument with key 'FOO'.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String format;

  /**
   * List of arguments for the format string.
   * @return value or {@code null} for none
   */
  public java.util.List<Args> getArgs() {
    return args;
  }

  /**
   * List of arguments for the format string.
   * @param args args or {@code null} for none
   */
  public PagespeedApiFormatStringV4 setArgs(java.util.List<Args> args) {
    this.args = args;
    return this;
  }

  /**
   * A localized format string with {{FOO}} placeholders, where 'FOO' is the key of the argument
   * whose value should be substituted. For HYPERLINK arguments, the format string will instead
   * contain {{BEGIN_FOO}} and {{END_FOO}} for the argument with key 'FOO'.
   * @return value or {@code null} for none
   */
  public java.lang.String getFormat() {
    return format;
  }

  /**
   * A localized format string with {{FOO}} placeholders, where 'FOO' is the key of the argument
   * whose value should be substituted. For HYPERLINK arguments, the format string will instead
   * contain {{BEGIN_FOO}} and {{END_FOO}} for the argument with key 'FOO'.
   * @param format format or {@code null} for none
   */
  public PagespeedApiFormatStringV4 setFormat(java.lang.String format) {
    this.format = format;
    return this;
  }

  @Override
  public PagespeedApiFormatStringV4 set(String fieldName, Object value) {
    return (PagespeedApiFormatStringV4) super.set(fieldName, value);
  }

  @Override
  public PagespeedApiFormatStringV4 clone() {
    return (PagespeedApiFormatStringV4) super.clone();
  }

  /**
   * Model definition for PagespeedApiFormatStringV4Args.
   */
  public static final class Args extends com.google.api.client.json.GenericJson {

    /**
     * The placeholder key for this arg, as a string.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String key;

    /**
     * The screen rectangles being referred to, with dimensions measured in CSS pixels. This is only
     * ever used for SNAPSHOT_RECT arguments. If this is absent for a SNAPSHOT_RECT argument, it means
     * that that argument refers to the entire snapshot.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<Rects> rects;

    static {
      // hack to force ProGuard to consider Rects used, since otherwise it would be stripped out
      // see https://github.com/google/google-api-java-client/issues/543
      com.google.api.client.util.Data.nullOf(Rects.class);
    }

    /**
     * Secondary screen rectangles being referred to, with dimensions measured in CSS pixels. This is
     * only ever used for SNAPSHOT_RECT arguments.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key("secondary_rects")
    private java.util.List<SecondaryRects> secondaryRects;

    static {
      // hack to force ProGuard to consider SecondaryRects used, since otherwise it would be stripped out
      // see https://github.com/google/google-api-java-client/issues/543
      com.google.api.client.util.Data.nullOf(SecondaryRects.class);
    }

    /**
     * Type of argument. One of URL, STRING_LITERAL, INT_LITERAL, BYTES, DURATION, VERBATIM_STRING,
     * PERCENTAGE, HYPERLINK, or SNAPSHOT_RECT.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String type;

    /**
     * Argument value, as a localized string.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String value;

    /**
     * The placeholder key for this arg, as a string.
     * @return value or {@code null} for none
     */
    public java.lang.String getKey() {
      return key;
    }

    /**
     * The placeholder key for this arg, as a string.
     * @param key key or {@code null} for none
     */
    public Args setKey(java.lang.String key) {
      this.key = key;
      return this;
    }

    /**
     * The screen rectangles being referred to, with dimensions measured in CSS pixels. This is only
     * ever used for SNAPSHOT_RECT arguments. If this is absent for a SNAPSHOT_RECT argument, it means
     * that that argument refers to the entire snapshot.
     * @return value or {@code null} for none
     */
    public java.util.List<Rects> getRects() {
      return rects;
    }

    /**
     * The screen rectangles being referred to, with dimensions measured in CSS pixels. This is only
     * ever used for SNAPSHOT_RECT arguments. If this is absent for a SNAPSHOT_RECT argument, it means
     * that that argument refers to the entire snapshot.
     * @param rects rects or {@code null} for none
     */
    public Args setRects(java.util.List<Rects> rects) {
      this.rects = rects;
      return this;
    }

    /**
     * Secondary screen rectangles being referred to, with dimensions measured in CSS pixels. This is
     * only ever used for SNAPSHOT_RECT arguments.
     * @return value or {@code null} for none
     */
    public java.util.List<SecondaryRects> getSecondaryRects() {
      return secondaryRects;
    }

    /**
     * Secondary screen rectangles being referred to, with dimensions measured in CSS pixels. This is
     * only ever used for SNAPSHOT_RECT arguments.
     * @param secondaryRects secondaryRects or {@code null} for none
     */
    public Args setSecondaryRects(java.util.List<SecondaryRects> secondaryRects) {
      this.secondaryRects = secondaryRects;
      return this;
    }

    /**
     * Type of argument. One of URL, STRING_LITERAL, INT_LITERAL, BYTES, DURATION, VERBATIM_STRING,
     * PERCENTAGE, HYPERLINK, or SNAPSHOT_RECT.
     * @return value or {@code null} for none
     */
    public java.lang.String getType() {
      return type;
    }

    /**
     * Type of argument. One of URL, STRING_LITERAL, INT_LITERAL, BYTES, DURATION, VERBATIM_STRING,
     * PERCENTAGE, HYPERLINK, or SNAPSHOT_RECT.
     * @param type type or {@code null} for none
     */
    public Args setType(java.lang.String type) {
      this.type = type;
      return this;
    }

    /**
     * Argument value, as a localized string.
     * @return value or {@code null} for none
     */
    public java.lang.String getValue() {
      return value;
    }

    /**
     * Argument value, as a localized string.
     * @param value value or {@code null} for none
     */
    public Args setValue(java.lang.String value) {
      this.value = value;
      return this;
    }

    @Override
    public Args set(String fieldName, Object value) {
      return (Args) super.set(fieldName, value);
    }

    @Override
    public Args clone() {
      return (Args) super.clone();
    }

    /**
     * Model definition for PagespeedApiFormatStringV4ArgsRects.
     */
    public static final class Rects extends com.google.api.client.json.GenericJson {

      /**
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer height;

      /**
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer left;

      /**
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer top;

      /**
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer width;

      /**
       * @return value or {@code null} for none
       */
      public java.lang.Integer getHeight() {
        return height;
      }

      /**
       * @param height height or {@code null} for none
       */
      public Rects setHeight(java.lang.Integer height) {
        this.height = height;
        return this;
      }

      /**
       * @return value or {@code null} for none
       */
      public java.lang.Integer getLeft() {
        return left;
      }

      /**
       * @param left left or {@code null} for none
       */
      public Rects setLeft(java.lang.Integer left) {
        this.left = left;
        return this;
      }

      /**
       * @return value or {@code null} for none
       */
      public java.lang.Integer getTop() {
        return top;
      }

      /**
       * @param top top or {@code null} for none
       */
      public Rects setTop(java.lang.Integer top) {
        this.top = top;
        return this;
      }

      /**
       * @return value or {@code null} for none
       */
      public java.lang.Integer getWidth() {
        return width;
      }

      /**
       * @param width width or {@code null} for none
       */
      public Rects setWidth(java.lang.Integer width) {
        this.width = width;
        return this;
      }

      @Override
      public Rects set(String fieldName, Object value) {
        return (Rects) super.set(fieldName, value);
      }

      @Override
      public Rects clone() {
        return (Rects) super.clone();
      }

    }
    /**
     * Model definition for PagespeedApiFormatStringV4ArgsSecondaryRects.
     */
    public static final class SecondaryRects extends com.google.api.client.json.GenericJson {

      /**
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer height;

      /**
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer left;

      /**
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer top;

      /**
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer width;

      /**
       * @return value or {@code null} for none
       */
      public java.lang.Integer getHeight() {
        return height;
      }

      /**
       * @param height height or {@code null} for none
       */
      public SecondaryRects setHeight(java.lang.Integer height) {
        this.height = height;
        return this;
      }

      /**
       * @return value or {@code null} for none
       */
      public java.lang.Integer getLeft() {
        return left;
      }

      /**
       * @param left left or {@code null} for none
       */
      public SecondaryRects setLeft(java.lang.Integer left) {
        this.left = left;
        return this;
      }

      /**
       * @return value or {@code null} for none
       */
      public java.lang.Integer getTop() {
        return top;
      }

      /**
       * @param top top or {@code null} for none
       */
      public SecondaryRects setTop(java.lang.Integer top) {
        this.top = top;
        return this;
      }

      /**
       * @return value or {@code null} for none
       */
      public java.lang.Integer getWidth() {
        return width;
      }

      /**
       * @param width width or {@code null} for none
       */
      public SecondaryRects setWidth(java.lang.Integer width) {
        this.width = width;
        return this;
      }

      @Override
      public SecondaryRects set(String fieldName, Object value) {
        return (SecondaryRects) super.set(fieldName, value);
      }

      @Override
      public SecondaryRects clone() {
        return (SecondaryRects) super.clone();
      }

    }
  }

}
