/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.iamcredentials.v1.model;

/**
 * Model definition for GenerateIdentityBindingAccessTokenRequest.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the IAM Service Account Credentials API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GenerateIdentityBindingAccessTokenRequest extends com.google.api.client.json.GenericJson {

  /**
   * Required. Input token. Must be in JWT format according to RFC7523
   * (https://tools.ietf.org/html/rfc7523) and must have 'kid' field in the header. Supported
   * signing algorithms: RS256 (RS512, ES256, ES512 coming soon). Mandatory payload fields (along
   * the lines of RFC 7523, section 3): - iss: issuer of the token. Must provide a discovery
   * document at        $iss/.well-known/openid-configuration . The document needs to be
   * formatted according to section 4.2 of the OpenID Connect Discovery        1.0 specification. -
   * iat: Issue time in seconds since epoch. Must be in the past. - exp: Expiration time in seconds
   * since epoch. Must be less than 48 hours        after iat. We recommend to create tokens that
   * last shorter than 6        hours to improve security unless business reasons mandate longer
   * expiration times. Shorter token lifetimes are generally more secure        since tokens that
   * have been exfiltrated by attackers can be used for        a shorter time. you can configure the
   * maximum lifetime of the        incoming token in the configuration of the mapper.        The
   * resulting Google token will expire within an hour or at "exp",        whichever is earlier. -
   * sub: JWT subject, identity asserted in the JWT. - aud: Configured in the mapper policy. By
   * default the service account        email.
   *
   * Claims from the incoming token can be transferred into the output token accoding to the mapper
   * configuration. The outgoing claim size is limited. Outgoing claims size must be less than 4kB
   * serialized as JSON without whitespace.
   *
   * Example header: {   "alg": "RS256",   "kid": "92a4265e14ab04d4d228a48d10d4ca31610936f8" }
   * Example payload: {   "iss": "https://accounts.google.com",   "iat": 1517963104,   "exp":
   * 1517966704,   "aud":
   * "https://iamcredentials.googleapis.com/google.iam.credentials.v1.CloudGaia",   "sub":
   * "113475438248934895348",   "my_claims": {     "additional_claim": "value"   } }
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String jwt;

  /**
   * Code to identify the scopes to be included in the OAuth 2.0 access token. See
   * https://developers.google.com/identity/protocols/googlescopes for more information. At least
   * one value required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> scope;

  /**
   * Required. Input token. Must be in JWT format according to RFC7523
   * (https://tools.ietf.org/html/rfc7523) and must have 'kid' field in the header. Supported
   * signing algorithms: RS256 (RS512, ES256, ES512 coming soon). Mandatory payload fields (along
   * the lines of RFC 7523, section 3): - iss: issuer of the token. Must provide a discovery
   * document at        $iss/.well-known/openid-configuration . The document needs to be
   * formatted according to section 4.2 of the OpenID Connect Discovery        1.0 specification. -
   * iat: Issue time in seconds since epoch. Must be in the past. - exp: Expiration time in seconds
   * since epoch. Must be less than 48 hours        after iat. We recommend to create tokens that
   * last shorter than 6        hours to improve security unless business reasons mandate longer
   * expiration times. Shorter token lifetimes are generally more secure        since tokens that
   * have been exfiltrated by attackers can be used for        a shorter time. you can configure the
   * maximum lifetime of the        incoming token in the configuration of the mapper.        The
   * resulting Google token will expire within an hour or at "exp",        whichever is earlier. -
   * sub: JWT subject, identity asserted in the JWT. - aud: Configured in the mapper policy. By
   * default the service account        email.
   *
   * Claims from the incoming token can be transferred into the output token accoding to the mapper
   * configuration. The outgoing claim size is limited. Outgoing claims size must be less than 4kB
   * serialized as JSON without whitespace.
   *
   * Example header: {   "alg": "RS256",   "kid": "92a4265e14ab04d4d228a48d10d4ca31610936f8" }
   * Example payload: {   "iss": "https://accounts.google.com",   "iat": 1517963104,   "exp":
   * 1517966704,   "aud":
   * "https://iamcredentials.googleapis.com/google.iam.credentials.v1.CloudGaia",   "sub":
   * "113475438248934895348",   "my_claims": {     "additional_claim": "value"   } }
   * @return value or {@code null} for none
   */
  public java.lang.String getJwt() {
    return jwt;
  }

  /**
   * Required. Input token. Must be in JWT format according to RFC7523
   * (https://tools.ietf.org/html/rfc7523) and must have 'kid' field in the header. Supported
   * signing algorithms: RS256 (RS512, ES256, ES512 coming soon). Mandatory payload fields (along
   * the lines of RFC 7523, section 3): - iss: issuer of the token. Must provide a discovery
   * document at        $iss/.well-known/openid-configuration . The document needs to be
   * formatted according to section 4.2 of the OpenID Connect Discovery        1.0 specification. -
   * iat: Issue time in seconds since epoch. Must be in the past. - exp: Expiration time in seconds
   * since epoch. Must be less than 48 hours        after iat. We recommend to create tokens that
   * last shorter than 6        hours to improve security unless business reasons mandate longer
   * expiration times. Shorter token lifetimes are generally more secure        since tokens that
   * have been exfiltrated by attackers can be used for        a shorter time. you can configure the
   * maximum lifetime of the        incoming token in the configuration of the mapper.        The
   * resulting Google token will expire within an hour or at "exp",        whichever is earlier. -
   * sub: JWT subject, identity asserted in the JWT. - aud: Configured in the mapper policy. By
   * default the service account        email.
   *
   * Claims from the incoming token can be transferred into the output token accoding to the mapper
   * configuration. The outgoing claim size is limited. Outgoing claims size must be less than 4kB
   * serialized as JSON without whitespace.
   *
   * Example header: {   "alg": "RS256",   "kid": "92a4265e14ab04d4d228a48d10d4ca31610936f8" }
   * Example payload: {   "iss": "https://accounts.google.com",   "iat": 1517963104,   "exp":
   * 1517966704,   "aud":
   * "https://iamcredentials.googleapis.com/google.iam.credentials.v1.CloudGaia",   "sub":
   * "113475438248934895348",   "my_claims": {     "additional_claim": "value"   } }
   * @param jwt jwt or {@code null} for none
   */
  public GenerateIdentityBindingAccessTokenRequest setJwt(java.lang.String jwt) {
    this.jwt = jwt;
    return this;
  }

  /**
   * Code to identify the scopes to be included in the OAuth 2.0 access token. See
   * https://developers.google.com/identity/protocols/googlescopes for more information. At least
   * one value required.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getScope() {
    return scope;
  }

  /**
   * Code to identify the scopes to be included in the OAuth 2.0 access token. See
   * https://developers.google.com/identity/protocols/googlescopes for more information. At least
   * one value required.
   * @param scope scope or {@code null} for none
   */
  public GenerateIdentityBindingAccessTokenRequest setScope(java.util.List<java.lang.String> scope) {
    this.scope = scope;
    return this;
  }

  @Override
  public GenerateIdentityBindingAccessTokenRequest set(String fieldName, Object value) {
    return (GenerateIdentityBindingAccessTokenRequest) super.set(fieldName, value);
  }

  @Override
  public GenerateIdentityBindingAccessTokenRequest clone() {
    return (GenerateIdentityBindingAccessTokenRequest) super.clone();
  }

}
