/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.gmail.model;

/**
 * The configuration of a CSE identity that uses different key pairs for signing and encryption.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Gmail API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SignAndEncryptKeyPairs extends com.google.api.client.json.GenericJson {

  /**
   * The ID of the CseKeyPair that encrypts signed outgoing mail.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String encryptionKeyPairId;

  /**
   * The ID of the CseKeyPair that signs outgoing mail.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String signingKeyPairId;

  /**
   * The ID of the CseKeyPair that encrypts signed outgoing mail.
   * @return value or {@code null} for none
   */
  public java.lang.String getEncryptionKeyPairId() {
    return encryptionKeyPairId;
  }

  /**
   * The ID of the CseKeyPair that encrypts signed outgoing mail.
   * @param encryptionKeyPairId encryptionKeyPairId or {@code null} for none
   */
  public SignAndEncryptKeyPairs setEncryptionKeyPairId(java.lang.String encryptionKeyPairId) {
    this.encryptionKeyPairId = encryptionKeyPairId;
    return this;
  }

  /**
   * The ID of the CseKeyPair that signs outgoing mail.
   * @return value or {@code null} for none
   */
  public java.lang.String getSigningKeyPairId() {
    return signingKeyPairId;
  }

  /**
   * The ID of the CseKeyPair that signs outgoing mail.
   * @param signingKeyPairId signingKeyPairId or {@code null} for none
   */
  public SignAndEncryptKeyPairs setSigningKeyPairId(java.lang.String signingKeyPairId) {
    this.signingKeyPairId = signingKeyPairId;
    return this;
  }

  @Override
  public SignAndEncryptKeyPairs set(String fieldName, Object value) {
    return (SignAndEncryptKeyPairs) super.set(fieldName, value);
  }

  @Override
  public SignAndEncryptKeyPairs clone() {
    return (SignAndEncryptKeyPairs) super.clone();
  }

}
