/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.gmail.model;

/**
 * Model definition for ListThreadsResponse.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Gmail API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListThreadsResponse extends com.google.api.client.json.GenericJson {

  /**
   * Page token to retrieve the next page of results in the list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * Estimated total number of results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long resultSizeEstimate;

  /**
   * List of threads. Note that each thread resource does not contain a list of `messages`. The list
   * of `messages` for a given thread can be fetched using the [`threads.get`](https://developers.go
   * ogle.com/workspace/gmail/api/v1/reference/users/threads/get) method.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Thread> threads;

  /**
   * Page token to retrieve the next page of results in the list.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * Page token to retrieve the next page of results in the list.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListThreadsResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * Estimated total number of results.
   * @return value or {@code null} for none
   */
  public java.lang.Long getResultSizeEstimate() {
    return resultSizeEstimate;
  }

  /**
   * Estimated total number of results.
   * @param resultSizeEstimate resultSizeEstimate or {@code null} for none
   */
  public ListThreadsResponse setResultSizeEstimate(java.lang.Long resultSizeEstimate) {
    this.resultSizeEstimate = resultSizeEstimate;
    return this;
  }

  /**
   * List of threads. Note that each thread resource does not contain a list of `messages`. The list
   * of `messages` for a given thread can be fetched using the [`threads.get`](https://developers.go
   * ogle.com/workspace/gmail/api/v1/reference/users/threads/get) method.
   * @return value or {@code null} for none
   */
  public java.util.List<Thread> getThreads() {
    return threads;
  }

  /**
   * List of threads. Note that each thread resource does not contain a list of `messages`. The list
   * of `messages` for a given thread can be fetched using the [`threads.get`](https://developers.go
   * ogle.com/workspace/gmail/api/v1/reference/users/threads/get) method.
   * @param threads threads or {@code null} for none
   */
  public ListThreadsResponse setThreads(java.util.List<Thread> threads) {
    this.threads = threads;
    return this;
  }

  @Override
  public ListThreadsResponse set(String fieldName, Object value) {
    return (ListThreadsResponse) super.set(fieldName, value);
  }

  @Override
  public ListThreadsResponse clone() {
    return (ListThreadsResponse) super.clone();
  }

}
