/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.gmail.model;

/**
 * Language settings for an account. These settings correspond to the "Language settings" feature in
 * the web interface.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Gmail API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LanguageSettings extends com.google.api.client.json.GenericJson {

  /**
   * The language to display Gmail in, formatted as an RFC 3066 Language Tag (for example `en-GB`,
   * `fr` or `ja` for British English, French, or Japanese respectively). The set of languages
   * supported by Gmail evolves over time, so please refer to the "Language" dropdown in the Gmail
   * settings for all available options, as described in the language settings help article. For a
   * table of sample values, see [Manage language
   * settings](https://developers.google.com/workspace/gmail/api/guides/language-settings). Not all
   * Gmail clients can display the same set of languages. In the case that a user's display language
   * is not available for use on a particular client, said client automatically chooses to display
   * in the closest supported variant (or a reasonable default).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayLanguage;

  /**
   * The language to display Gmail in, formatted as an RFC 3066 Language Tag (for example `en-GB`,
   * `fr` or `ja` for British English, French, or Japanese respectively). The set of languages
   * supported by Gmail evolves over time, so please refer to the "Language" dropdown in the Gmail
   * settings for all available options, as described in the language settings help article. For a
   * table of sample values, see [Manage language
   * settings](https://developers.google.com/workspace/gmail/api/guides/language-settings). Not all
   * Gmail clients can display the same set of languages. In the case that a user's display language
   * is not available for use on a particular client, said client automatically chooses to display
   * in the closest supported variant (or a reasonable default).
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayLanguage() {
    return displayLanguage;
  }

  /**
   * The language to display Gmail in, formatted as an RFC 3066 Language Tag (for example `en-GB`,
   * `fr` or `ja` for British English, French, or Japanese respectively). The set of languages
   * supported by Gmail evolves over time, so please refer to the "Language" dropdown in the Gmail
   * settings for all available options, as described in the language settings help article. For a
   * table of sample values, see [Manage language
   * settings](https://developers.google.com/workspace/gmail/api/guides/language-settings). Not all
   * Gmail clients can display the same set of languages. In the case that a user's display language
   * is not available for use on a particular client, said client automatically chooses to display
   * in the closest supported variant (or a reasonable default).
   * @param displayLanguage displayLanguage or {@code null} for none
   */
  public LanguageSettings setDisplayLanguage(java.lang.String displayLanguage) {
    this.displayLanguage = displayLanguage;
    return this;
  }

  @Override
  public LanguageSettings set(String fieldName, Object value) {
    return (LanguageSettings) super.set(fieldName, value);
  }

  @Override
  public LanguageSettings clone() {
    return (LanguageSettings) super.clone();
  }

}
