/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.gmail.model;

/**
 * Metadata for hardware keys. If [hardware key
 * encryption](https://support.google.com/a/answer/14153163) is set up for the Google Workspace
 * organization, users can optionally store their private key on their smart card and use it to sign
 * and decrypt email messages in Gmail by inserting their smart card into a reader attached to their
 * Windows device.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Gmail API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class HardwareKeyMetadata extends com.google.api.client.json.GenericJson {

  /**
   * Description about the hardware key.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Description about the hardware key.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * Description about the hardware key.
   * @param description description or {@code null} for none
   */
  public HardwareKeyMetadata setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  @Override
  public HardwareKeyMetadata set(String fieldName, Object value) {
    return (HardwareKeyMetadata) super.set(fieldName, value);
  }

  @Override
  public HardwareKeyMetadata clone() {
    return (HardwareKeyMetadata) super.clone();
  }

}
