/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.gmail.model;

/**
 * Message matching criteria.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Gmail API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FilterCriteria extends com.google.api.client.json.GenericJson {

  /**
   * Whether the response should exclude chats.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean excludeChats;

  /**
   * The sender's display name or email address.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String from;

  /**
   * Whether the message has any attachment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean hasAttachment;

  /**
   * Only return messages not matching the specified query. Supports the same query format as the
   * Gmail search box. For example, `"from:someuser@example.com rfc822msgid: is:unread"`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String negatedQuery;

  /**
   * Only return messages matching the specified query. Supports the same query format as the Gmail
   * search box. For example, `"from:someuser@example.com rfc822msgid: is:unread"`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String query;

  /**
   * The size of the entire RFC822 message in bytes, including all headers and attachments.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer size;

  /**
   * How the message size in bytes should be in relation to the size field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sizeComparison;

  /**
   * Case-insensitive phrase found in the message's subject. Trailing and leading whitespace are be
   * trimmed and adjacent spaces are collapsed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String subject;

  /**
   * The recipient's display name or email address. Includes recipients in the "to", "cc", and "bcc"
   * header fields. You can use simply the local part of the email address. For example, "example"
   * and "example@" both match "example@gmail.com". This field is case-insensitive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String to;

  /**
   * Whether the response should exclude chats.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getExcludeChats() {
    return excludeChats;
  }

  /**
   * Whether the response should exclude chats.
   * @param excludeChats excludeChats or {@code null} for none
   */
  public FilterCriteria setExcludeChats(java.lang.Boolean excludeChats) {
    this.excludeChats = excludeChats;
    return this;
  }

  /**
   * The sender's display name or email address.
   * @return value or {@code null} for none
   */
  public java.lang.String getFrom() {
    return from;
  }

  /**
   * The sender's display name or email address.
   * @param from from or {@code null} for none
   */
  public FilterCriteria setFrom(java.lang.String from) {
    this.from = from;
    return this;
  }

  /**
   * Whether the message has any attachment.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getHasAttachment() {
    return hasAttachment;
  }

  /**
   * Whether the message has any attachment.
   * @param hasAttachment hasAttachment or {@code null} for none
   */
  public FilterCriteria setHasAttachment(java.lang.Boolean hasAttachment) {
    this.hasAttachment = hasAttachment;
    return this;
  }

  /**
   * Only return messages not matching the specified query. Supports the same query format as the
   * Gmail search box. For example, `"from:someuser@example.com rfc822msgid: is:unread"`.
   * @return value or {@code null} for none
   */
  public java.lang.String getNegatedQuery() {
    return negatedQuery;
  }

  /**
   * Only return messages not matching the specified query. Supports the same query format as the
   * Gmail search box. For example, `"from:someuser@example.com rfc822msgid: is:unread"`.
   * @param negatedQuery negatedQuery or {@code null} for none
   */
  public FilterCriteria setNegatedQuery(java.lang.String negatedQuery) {
    this.negatedQuery = negatedQuery;
    return this;
  }

  /**
   * Only return messages matching the specified query. Supports the same query format as the Gmail
   * search box. For example, `"from:someuser@example.com rfc822msgid: is:unread"`.
   * @return value or {@code null} for none
   */
  public java.lang.String getQuery() {
    return query;
  }

  /**
   * Only return messages matching the specified query. Supports the same query format as the Gmail
   * search box. For example, `"from:someuser@example.com rfc822msgid: is:unread"`.
   * @param query query or {@code null} for none
   */
  public FilterCriteria setQuery(java.lang.String query) {
    this.query = query;
    return this;
  }

  /**
   * The size of the entire RFC822 message in bytes, including all headers and attachments.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getSize() {
    return size;
  }

  /**
   * The size of the entire RFC822 message in bytes, including all headers and attachments.
   * @param size size or {@code null} for none
   */
  public FilterCriteria setSize(java.lang.Integer size) {
    this.size = size;
    return this;
  }

  /**
   * How the message size in bytes should be in relation to the size field.
   * @return value or {@code null} for none
   */
  public java.lang.String getSizeComparison() {
    return sizeComparison;
  }

  /**
   * How the message size in bytes should be in relation to the size field.
   * @param sizeComparison sizeComparison or {@code null} for none
   */
  public FilterCriteria setSizeComparison(java.lang.String sizeComparison) {
    this.sizeComparison = sizeComparison;
    return this;
  }

  /**
   * Case-insensitive phrase found in the message's subject. Trailing and leading whitespace are be
   * trimmed and adjacent spaces are collapsed.
   * @return value or {@code null} for none
   */
  public java.lang.String getSubject() {
    return subject;
  }

  /**
   * Case-insensitive phrase found in the message's subject. Trailing and leading whitespace are be
   * trimmed and adjacent spaces are collapsed.
   * @param subject subject or {@code null} for none
   */
  public FilterCriteria setSubject(java.lang.String subject) {
    this.subject = subject;
    return this;
  }

  /**
   * The recipient's display name or email address. Includes recipients in the "to", "cc", and "bcc"
   * header fields. You can use simply the local part of the email address. For example, "example"
   * and "example@" both match "example@gmail.com". This field is case-insensitive.
   * @return value or {@code null} for none
   */
  public java.lang.String getTo() {
    return to;
  }

  /**
   * The recipient's display name or email address. Includes recipients in the "to", "cc", and "bcc"
   * header fields. You can use simply the local part of the email address. For example, "example"
   * and "example@" both match "example@gmail.com". This field is case-insensitive.
   * @param to to or {@code null} for none
   */
  public FilterCriteria setTo(java.lang.String to) {
    this.to = to;
    return this;
  }

  @Override
  public FilterCriteria set(String fieldName, Object value) {
    return (FilterCriteria) super.set(fieldName, value);
  }

  @Override
  public FilterCriteria clone() {
    return (FilterCriteria) super.clone();
  }

}
