/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.gmail.model;

/**
 * A set of actions to perform on a message.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Gmail API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FilterAction extends com.google.api.client.json.GenericJson {

  /**
   * List of labels to add to the message.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> addLabelIds;

  /**
   * Email address that the message should be forwarded to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String forward;

  /**
   * List of labels to remove from the message.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> removeLabelIds;

  /**
   * List of labels to add to the message.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getAddLabelIds() {
    return addLabelIds;
  }

  /**
   * List of labels to add to the message.
   * @param addLabelIds addLabelIds or {@code null} for none
   */
  public FilterAction setAddLabelIds(java.util.List<java.lang.String> addLabelIds) {
    this.addLabelIds = addLabelIds;
    return this;
  }

  /**
   * Email address that the message should be forwarded to.
   * @return value or {@code null} for none
   */
  public java.lang.String getForward() {
    return forward;
  }

  /**
   * Email address that the message should be forwarded to.
   * @param forward forward or {@code null} for none
   */
  public FilterAction setForward(java.lang.String forward) {
    this.forward = forward;
    return this;
  }

  /**
   * List of labels to remove from the message.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getRemoveLabelIds() {
    return removeLabelIds;
  }

  /**
   * List of labels to remove from the message.
   * @param removeLabelIds removeLabelIds or {@code null} for none
   */
  public FilterAction setRemoveLabelIds(java.util.List<java.lang.String> removeLabelIds) {
    this.removeLabelIds = removeLabelIds;
    return this;
  }

  @Override
  public FilterAction set(String fieldName, Object value) {
    return (FilterAction) super.set(fieldName, value);
  }

  @Override
  public FilterAction clone() {
    return (FilterAction) super.clone();
  }

}
