/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.gmail.model;

/**
 * The client-side encryption (CSE) configuration for the email address of an authenticated user.
 * Gmail uses CSE configurations to save drafts of client-side encrypted email messages, and to sign
 * and send encrypted email messages. For administrators managing identities and keypairs for users
 * in their organization, requests require authorization with a [service
 * account](https://developers.google.com/identity/protocols/OAuth2ServiceAccount) that has [domain-
 * wide delegation authority](https://developers.google.com/identity/protocols/OAuth2ServiceAccount#
 * delegatingauthority) to impersonate users with the
 * `https://www.googleapis.com/auth/gmail.settings.basic` scope. For users managing their own
 * identities and keypairs, requests require [hardware key
 * encryption](https://support.google.com/a/answer/14153163) turned on and configured.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Gmail API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CseIdentity extends com.google.api.client.json.GenericJson {

  /**
   * The email address for the sending identity. The email address must be the primary email address
   * of the authenticated user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String emailAddress;

  /**
   * If a key pair is associated, the ID of the key pair, CseKeyPair.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String primaryKeyPairId;

  /**
   * The configuration of a CSE identity that uses different key pairs for signing and encryption.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SignAndEncryptKeyPairs signAndEncryptKeyPairs;

  /**
   * The email address for the sending identity. The email address must be the primary email address
   * of the authenticated user.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmailAddress() {
    return emailAddress;
  }

  /**
   * The email address for the sending identity. The email address must be the primary email address
   * of the authenticated user.
   * @param emailAddress emailAddress or {@code null} for none
   */
  public CseIdentity setEmailAddress(java.lang.String emailAddress) {
    this.emailAddress = emailAddress;
    return this;
  }

  /**
   * If a key pair is associated, the ID of the key pair, CseKeyPair.
   * @return value or {@code null} for none
   */
  public java.lang.String getPrimaryKeyPairId() {
    return primaryKeyPairId;
  }

  /**
   * If a key pair is associated, the ID of the key pair, CseKeyPair.
   * @param primaryKeyPairId primaryKeyPairId or {@code null} for none
   */
  public CseIdentity setPrimaryKeyPairId(java.lang.String primaryKeyPairId) {
    this.primaryKeyPairId = primaryKeyPairId;
    return this;
  }

  /**
   * The configuration of a CSE identity that uses different key pairs for signing and encryption.
   * @return value or {@code null} for none
   */
  public SignAndEncryptKeyPairs getSignAndEncryptKeyPairs() {
    return signAndEncryptKeyPairs;
  }

  /**
   * The configuration of a CSE identity that uses different key pairs for signing and encryption.
   * @param signAndEncryptKeyPairs signAndEncryptKeyPairs or {@code null} for none
   */
  public CseIdentity setSignAndEncryptKeyPairs(SignAndEncryptKeyPairs signAndEncryptKeyPairs) {
    this.signAndEncryptKeyPairs = signAndEncryptKeyPairs;
    return this;
  }

  @Override
  public CseIdentity set(String fieldName, Object value) {
    return (CseIdentity) super.set(fieldName, value);
  }

  @Override
  public CseIdentity clone() {
    return (CseIdentity) super.clone();
  }

}
