/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.gmail.model;

/**
 * Classification Labels applied to the email message. Classification Labels are different from
 * Gmail inbox labels. Only used for Google Workspace accounts. [Learn more about classification
 * labels](https://support.google.com/a/answer/9292382).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Gmail API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ClassificationLabelValue extends com.google.api.client.json.GenericJson {

  /**
   * Field values for the given classification label ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ClassificationLabelFieldValue> fields;

  static {
    // hack to force ProGuard to consider ClassificationLabelFieldValue used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ClassificationLabelFieldValue.class);
  }

  /**
   * Required. The canonical or raw alphanumeric classification label ID. Maps to the ID field of
   * the Google Drive Label resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String labelId;

  /**
   * Field values for the given classification label ID.
   * @return value or {@code null} for none
   */
  public java.util.List<ClassificationLabelFieldValue> getFields() {
    return fields;
  }

  /**
   * Field values for the given classification label ID.
   * @param fields fields or {@code null} for none
   */
  public ClassificationLabelValue setFields(java.util.List<ClassificationLabelFieldValue> fields) {
    this.fields = fields;
    return this;
  }

  /**
   * Required. The canonical or raw alphanumeric classification label ID. Maps to the ID field of
   * the Google Drive Label resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getLabelId() {
    return labelId;
  }

  /**
   * Required. The canonical or raw alphanumeric classification label ID. Maps to the ID field of
   * the Google Drive Label resource.
   * @param labelId labelId or {@code null} for none
   */
  public ClassificationLabelValue setLabelId(java.lang.String labelId) {
    this.labelId = labelId;
    return this;
  }

  @Override
  public ClassificationLabelValue set(String fieldName, Object value) {
    return (ClassificationLabelValue) super.set(fieldName, value);
  }

  @Override
  public ClassificationLabelValue clone() {
    return (ClassificationLabelValue) super.clone();
  }

}
