/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.gmail.model;

/**
 * Field values for a classification label.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Gmail API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ClassificationLabelFieldValue extends com.google.api.client.json.GenericJson {

  /**
   * Required. The field ID for the Classification Label Value. Maps to the ID field of the Google
   * Drive `Label.Field` object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fieldId;

  /**
   * Selection choice ID for the selection option. Should only be set if the field type is
   * `SELECTION` in the Google Drive `Label.Field` object. Maps to the id field of the Google Drive
   * `Label.Field.SelectionOptions` resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selection;

  /**
   * Required. The field ID for the Classification Label Value. Maps to the ID field of the Google
   * Drive `Label.Field` object.
   * @return value or {@code null} for none
   */
  public java.lang.String getFieldId() {
    return fieldId;
  }

  /**
   * Required. The field ID for the Classification Label Value. Maps to the ID field of the Google
   * Drive `Label.Field` object.
   * @param fieldId fieldId or {@code null} for none
   */
  public ClassificationLabelFieldValue setFieldId(java.lang.String fieldId) {
    this.fieldId = fieldId;
    return this;
  }

  /**
   * Selection choice ID for the selection option. Should only be set if the field type is
   * `SELECTION` in the Google Drive `Label.Field` object. Maps to the id field of the Google Drive
   * `Label.Field.SelectionOptions` resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelection() {
    return selection;
  }

  /**
   * Selection choice ID for the selection option. Should only be set if the field type is
   * `SELECTION` in the Google Drive `Label.Field` object. Maps to the id field of the Google Drive
   * `Label.Field.SelectionOptions` resource.
   * @param selection selection or {@code null} for none
   */
  public ClassificationLabelFieldValue setSelection(java.lang.String selection) {
    this.selection = selection;
    return this;
  }

  @Override
  public ClassificationLabelFieldValue set(String fieldName, Object value) {
    return (ClassificationLabelFieldValue) super.set(fieldName, value);
  }

  @Override
  public ClassificationLabelFieldValue clone() {
    return (ClassificationLabelFieldValue) super.clone();
  }

}
