/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.gmail.model;

/**
 * Metadata for private keys managed by an external key access control list service. For details
 * about managing key access, see [Google Workspace CSE API
 * Reference](https://developers.google.com/workspace/cse/reference).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Gmail API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class KaclsKeyMetadata extends com.google.api.client.json.GenericJson {

  /**
   * Opaque data generated and used by the key access control list service. Maximum size: 8 KiB.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kaclsData;

  /**
   * The URI of the key access control list service that manages the private key.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kaclsUri;

  /**
   * Opaque data generated and used by the key access control list service. Maximum size: 8 KiB.
   * @return value or {@code null} for none
   */
  public java.lang.String getKaclsData() {
    return kaclsData;
  }

  /**
   * Opaque data generated and used by the key access control list service. Maximum size: 8 KiB.
   * @param kaclsData kaclsData or {@code null} for none
   */
  public KaclsKeyMetadata setKaclsData(java.lang.String kaclsData) {
    this.kaclsData = kaclsData;
    return this;
  }

  /**
   * The URI of the key access control list service that manages the private key.
   * @return value or {@code null} for none
   */
  public java.lang.String getKaclsUri() {
    return kaclsUri;
  }

  /**
   * The URI of the key access control list service that manages the private key.
   * @param kaclsUri kaclsUri or {@code null} for none
   */
  public KaclsKeyMetadata setKaclsUri(java.lang.String kaclsUri) {
    this.kaclsUri = kaclsUri;
    return this;
  }

  @Override
  public KaclsKeyMetadata set(String fieldName, Object value) {
    return (KaclsKeyMetadata) super.set(fieldName, value);
  }

  @Override
  public KaclsKeyMetadata clone() {
    return (KaclsKeyMetadata) super.clone();
  }

}
