/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * A response on an Approval made by a specific Reviewer.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Drive API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReviewerResponse extends com.google.api.client.json.GenericJson {

  /**
   * This is always drive#reviewerResponse.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * A Reviewer’s Response for the Approval.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String response;

  /**
   * The user that is responsible for this response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private User reviewer;

  /**
   * This is always drive#reviewerResponse.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This is always drive#reviewerResponse.
   * @param kind kind or {@code null} for none
   */
  public ReviewerResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * A Reviewer’s Response for the Approval.
   * @return value or {@code null} for none
   */
  public java.lang.String getResponse() {
    return response;
  }

  /**
   * A Reviewer’s Response for the Approval.
   * @param response response or {@code null} for none
   */
  public ReviewerResponse setResponse(java.lang.String response) {
    this.response = response;
    return this;
  }

  /**
   * The user that is responsible for this response.
   * @return value or {@code null} for none
   */
  public User getReviewer() {
    return reviewer;
  }

  /**
   * The user that is responsible for this response.
   * @param reviewer reviewer or {@code null} for none
   */
  public ReviewerResponse setReviewer(User reviewer) {
    this.reviewer = reviewer;
    return this;
  }

  @Override
  public ReviewerResponse set(String fieldName, Object value) {
    return (ReviewerResponse) super.set(fieldName, value);
  }

  @Override
  public ReviewerResponse clone() {
    return (ReviewerResponse) super.clone();
  }

}
