/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * Request message for resolving an AccessProposal on a file.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Drive API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ResolveAccessProposalRequest extends com.google.api.client.json.GenericJson {

  /**
   * Required. The action to take on the access proposal.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String action;

  /**
   * Optional. The roles that the approver has allowed, if any. For more information, see [Roles and
   * permissions](https://developers.google.com/workspace/drive/api/guides/ref-roles). Note: This
   * field is required for the `ACCEPT` action.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> role;

  /**
   * Optional. Whether to send an email to the requester when the access proposal is denied or
   * accepted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean sendNotification;

  /**
   * Optional. Indicates the view for this access proposal. This should only be set when the
   * proposal belongs to a view. Only `published` is supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String view;

  /**
   * Required. The action to take on the access proposal.
   * @return value or {@code null} for none
   */
  public java.lang.String getAction() {
    return action;
  }

  /**
   * Required. The action to take on the access proposal.
   * @param action action or {@code null} for none
   */
  public ResolveAccessProposalRequest setAction(java.lang.String action) {
    this.action = action;
    return this;
  }

  /**
   * Optional. The roles that the approver has allowed, if any. For more information, see [Roles and
   * permissions](https://developers.google.com/workspace/drive/api/guides/ref-roles). Note: This
   * field is required for the `ACCEPT` action.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getRole() {
    return role;
  }

  /**
   * Optional. The roles that the approver has allowed, if any. For more information, see [Roles and
   * permissions](https://developers.google.com/workspace/drive/api/guides/ref-roles). Note: This
   * field is required for the `ACCEPT` action.
   * @param role role or {@code null} for none
   */
  public ResolveAccessProposalRequest setRole(java.util.List<java.lang.String> role) {
    this.role = role;
    return this;
  }

  /**
   * Optional. Whether to send an email to the requester when the access proposal is denied or
   * accepted.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSendNotification() {
    return sendNotification;
  }

  /**
   * Optional. Whether to send an email to the requester when the access proposal is denied or
   * accepted.
   * @param sendNotification sendNotification or {@code null} for none
   */
  public ResolveAccessProposalRequest setSendNotification(java.lang.Boolean sendNotification) {
    this.sendNotification = sendNotification;
    return this;
  }

  /**
   * Optional. Indicates the view for this access proposal. This should only be set when the
   * proposal belongs to a view. Only `published` is supported.
   * @return value or {@code null} for none
   */
  public java.lang.String getView() {
    return view;
  }

  /**
   * Optional. Indicates the view for this access proposal. This should only be set when the
   * proposal belongs to a view. Only `published` is supported.
   * @param view view or {@code null} for none
   */
  public ResolveAccessProposalRequest setView(java.lang.String view) {
    this.view = view;
    return this;
  }

  @Override
  public ResolveAccessProposalRequest set(String fieldName, Object value) {
    return (ResolveAccessProposalRequest) super.set(fieldName, value);
  }

  @Override
  public ResolveAccessProposalRequest clone() {
    return (ResolveAccessProposalRequest) super.clone();
  }

}
