/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * A reply to a comment on a file. Some resource methods (such as `replies.update`) require a
 * `replyId`. Use the `replies.list` method to retrieve the ID for a reply.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Drive API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Reply extends com.google.api.client.json.GenericJson {

  /**
   * The action the reply performed to the parent comment. The supported values are: * `resolve` *
   * `reopen`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String action;

  /**
   * Output only. The email address of the user assigned to this comment. If no user is assigned,
   * the field is unset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String assigneeEmailAddress;

  /**
   * Output only. The author of the reply. The author's email address and permission ID won't be
   * populated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private User author;

  /**
   * The plain text content of the reply. This field is used for setting the content, while
   * `htmlContent` should be displayed. This field is required by the `create` method if no `action`
   * value is specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String content;

  /**
   * The time at which the reply was created (RFC 3339 date-time).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime createdTime;

  /**
   * Output only. Whether the reply has been deleted. A deleted reply has no content.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean deleted;

  /**
   * Output only. The content of the reply with HTML formatting.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String htmlContent;

  /**
   * Output only. The ID of the reply.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Output only. Identifies what kind of resource this is. Value: the fixed string `"drive#reply"`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Output only. A list of email addresses for users mentioned in this comment. If no users are
   * mentioned, the list is empty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> mentionedEmailAddresses;

  /**
   * The last time the reply was modified (RFC 3339 date-time).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime modifiedTime;

  /**
   * The action the reply performed to the parent comment. The supported values are: * `resolve` *
   * `reopen`
   * @return value or {@code null} for none
   */
  public java.lang.String getAction() {
    return action;
  }

  /**
   * The action the reply performed to the parent comment. The supported values are: * `resolve` *
   * `reopen`
   * @param action action or {@code null} for none
   */
  public Reply setAction(java.lang.String action) {
    this.action = action;
    return this;
  }

  /**
   * Output only. The email address of the user assigned to this comment. If no user is assigned,
   * the field is unset.
   * @return value or {@code null} for none
   */
  public java.lang.String getAssigneeEmailAddress() {
    return assigneeEmailAddress;
  }

  /**
   * Output only. The email address of the user assigned to this comment. If no user is assigned,
   * the field is unset.
   * @param assigneeEmailAddress assigneeEmailAddress or {@code null} for none
   */
  public Reply setAssigneeEmailAddress(java.lang.String assigneeEmailAddress) {
    this.assigneeEmailAddress = assigneeEmailAddress;
    return this;
  }

  /**
   * Output only. The author of the reply. The author's email address and permission ID won't be
   * populated.
   * @return value or {@code null} for none
   */
  public User getAuthor() {
    return author;
  }

  /**
   * Output only. The author of the reply. The author's email address and permission ID won't be
   * populated.
   * @param author author or {@code null} for none
   */
  public Reply setAuthor(User author) {
    this.author = author;
    return this;
  }

  /**
   * The plain text content of the reply. This field is used for setting the content, while
   * `htmlContent` should be displayed. This field is required by the `create` method if no `action`
   * value is specified.
   * @return value or {@code null} for none
   */
  public java.lang.String getContent() {
    return content;
  }

  /**
   * The plain text content of the reply. This field is used for setting the content, while
   * `htmlContent` should be displayed. This field is required by the `create` method if no `action`
   * value is specified.
   * @param content content or {@code null} for none
   */
  public Reply setContent(java.lang.String content) {
    this.content = content;
    return this;
  }

  /**
   * The time at which the reply was created (RFC 3339 date-time).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getCreatedTime() {
    return createdTime;
  }

  /**
   * The time at which the reply was created (RFC 3339 date-time).
   * @param createdTime createdTime or {@code null} for none
   */
  public Reply setCreatedTime(com.google.api.client.util.DateTime createdTime) {
    this.createdTime = createdTime;
    return this;
  }

  /**
   * Output only. Whether the reply has been deleted. A deleted reply has no content.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDeleted() {
    return deleted;
  }

  /**
   * Output only. Whether the reply has been deleted. A deleted reply has no content.
   * @param deleted deleted or {@code null} for none
   */
  public Reply setDeleted(java.lang.Boolean deleted) {
    this.deleted = deleted;
    return this;
  }

  /**
   * Output only. The content of the reply with HTML formatting.
   * @return value or {@code null} for none
   */
  public java.lang.String getHtmlContent() {
    return htmlContent;
  }

  /**
   * Output only. The content of the reply with HTML formatting.
   * @param htmlContent htmlContent or {@code null} for none
   */
  public Reply setHtmlContent(java.lang.String htmlContent) {
    this.htmlContent = htmlContent;
    return this;
  }

  /**
   * Output only. The ID of the reply.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Output only. The ID of the reply.
   * @param id id or {@code null} for none
   */
  public Reply setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Output only. Identifies what kind of resource this is. Value: the fixed string `"drive#reply"`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Output only. Identifies what kind of resource this is. Value: the fixed string `"drive#reply"`.
   * @param kind kind or {@code null} for none
   */
  public Reply setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Output only. A list of email addresses for users mentioned in this comment. If no users are
   * mentioned, the list is empty.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getMentionedEmailAddresses() {
    return mentionedEmailAddresses;
  }

  /**
   * Output only. A list of email addresses for users mentioned in this comment. If no users are
   * mentioned, the list is empty.
   * @param mentionedEmailAddresses mentionedEmailAddresses or {@code null} for none
   */
  public Reply setMentionedEmailAddresses(java.util.List<java.lang.String> mentionedEmailAddresses) {
    this.mentionedEmailAddresses = mentionedEmailAddresses;
    return this;
  }

  /**
   * The last time the reply was modified (RFC 3339 date-time).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getModifiedTime() {
    return modifiedTime;
  }

  /**
   * The last time the reply was modified (RFC 3339 date-time).
   * @param modifiedTime modifiedTime or {@code null} for none
   */
  public Reply setModifiedTime(com.google.api.client.util.DateTime modifiedTime) {
    this.modifiedTime = modifiedTime;
    return this;
  }

  @Override
  public Reply set(String fieldName, Object value) {
    return (Reply) super.set(fieldName, value);
  }

  @Override
  public Reply clone() {
    return (Reply) super.clone();
  }

}
