/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * Metadata for an approval. An approval is a review/approve process for a Drive item.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Drive API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Approval extends com.google.api.client.json.GenericJson {

  /**
   * The Approval ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String approvalId;

  /**
   * Output only. The time time the approval was completed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String completeTime;

  /**
   * Output only. The time the approval was created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * The time that the approval is due.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String dueTime;

  /**
   * The user that requested the Approval.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private User initiator;

  /**
   * This is always drive#approval.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Output only. The most recent time the approval was modified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String modifyTime;

  /**
   * The responses made on the Approval by reviewers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ReviewerResponse> reviewerResponses;

  /**
   * Output only. The status of the approval at the time this resource was requested.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * Target file id of the approval.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String targetFileId;

  /**
   * The Approval ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getApprovalId() {
    return approvalId;
  }

  /**
   * The Approval ID.
   * @param approvalId approvalId or {@code null} for none
   */
  public Approval setApprovalId(java.lang.String approvalId) {
    this.approvalId = approvalId;
    return this;
  }

  /**
   * Output only. The time time the approval was completed.
   * @return value or {@code null} for none
   */
  public String getCompleteTime() {
    return completeTime;
  }

  /**
   * Output only. The time time the approval was completed.
   * @param completeTime completeTime or {@code null} for none
   */
  public Approval setCompleteTime(String completeTime) {
    this.completeTime = completeTime;
    return this;
  }

  /**
   * Output only. The time the approval was created.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * Output only. The time the approval was created.
   * @param createTime createTime or {@code null} for none
   */
  public Approval setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * The time that the approval is due.
   * @return value or {@code null} for none
   */
  public String getDueTime() {
    return dueTime;
  }

  /**
   * The time that the approval is due.
   * @param dueTime dueTime or {@code null} for none
   */
  public Approval setDueTime(String dueTime) {
    this.dueTime = dueTime;
    return this;
  }

  /**
   * The user that requested the Approval.
   * @return value or {@code null} for none
   */
  public User getInitiator() {
    return initiator;
  }

  /**
   * The user that requested the Approval.
   * @param initiator initiator or {@code null} for none
   */
  public Approval setInitiator(User initiator) {
    this.initiator = initiator;
    return this;
  }

  /**
   * This is always drive#approval.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This is always drive#approval.
   * @param kind kind or {@code null} for none
   */
  public Approval setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Output only. The most recent time the approval was modified.
   * @return value or {@code null} for none
   */
  public String getModifyTime() {
    return modifyTime;
  }

  /**
   * Output only. The most recent time the approval was modified.
   * @param modifyTime modifyTime or {@code null} for none
   */
  public Approval setModifyTime(String modifyTime) {
    this.modifyTime = modifyTime;
    return this;
  }

  /**
   * The responses made on the Approval by reviewers.
   * @return value or {@code null} for none
   */
  public java.util.List<ReviewerResponse> getReviewerResponses() {
    return reviewerResponses;
  }

  /**
   * The responses made on the Approval by reviewers.
   * @param reviewerResponses reviewerResponses or {@code null} for none
   */
  public Approval setReviewerResponses(java.util.List<ReviewerResponse> reviewerResponses) {
    this.reviewerResponses = reviewerResponses;
    return this;
  }

  /**
   * Output only. The status of the approval at the time this resource was requested.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * Output only. The status of the approval at the time this resource was requested.
   * @param status status or {@code null} for none
   */
  public Approval setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  /**
   * Target file id of the approval.
   * @return value or {@code null} for none
   */
  public java.lang.String getTargetFileId() {
    return targetFileId;
  }

  /**
   * Target file id of the approval.
   * @param targetFileId targetFileId or {@code null} for none
   */
  public Approval setTargetFileId(java.lang.String targetFileId) {
    this.targetFileId = targetFileId;
    return this;
  }

  @Override
  public Approval set(String fieldName, Object value) {
    return (Approval) super.set(fieldName, value);
  }

  @Override
  public Approval clone() {
    return (Approval) super.clone();
  }

}
