/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * Manage outstanding access proposals on a file.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Drive API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AccessProposal extends com.google.api.client.json.GenericJson {

  /**
   * The creation time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * The file ID that the proposal for access is on.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fileId;

  /**
   * The ID of the access proposal.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String proposalId;

  /**
   * The email address of the user that will receive permissions, if accepted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String recipientEmailAddress;

  /**
   * The message that the requester added to the proposal.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String requestMessage;

  /**
   * The email address of the requesting user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String requesterEmailAddress;

  /**
   * A wrapper for the role and view of an access proposal. For more information, see [Roles and
   * permissions](https://developers.google.com/workspace/drive/api/guides/ref-roles).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AccessProposalRoleAndView> rolesAndViews;

  /**
   * The creation time.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * The creation time.
   * @param createTime createTime or {@code null} for none
   */
  public AccessProposal setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * The file ID that the proposal for access is on.
   * @return value or {@code null} for none
   */
  public java.lang.String getFileId() {
    return fileId;
  }

  /**
   * The file ID that the proposal for access is on.
   * @param fileId fileId or {@code null} for none
   */
  public AccessProposal setFileId(java.lang.String fileId) {
    this.fileId = fileId;
    return this;
  }

  /**
   * The ID of the access proposal.
   * @return value or {@code null} for none
   */
  public java.lang.String getProposalId() {
    return proposalId;
  }

  /**
   * The ID of the access proposal.
   * @param proposalId proposalId or {@code null} for none
   */
  public AccessProposal setProposalId(java.lang.String proposalId) {
    this.proposalId = proposalId;
    return this;
  }

  /**
   * The email address of the user that will receive permissions, if accepted.
   * @return value or {@code null} for none
   */
  public java.lang.String getRecipientEmailAddress() {
    return recipientEmailAddress;
  }

  /**
   * The email address of the user that will receive permissions, if accepted.
   * @param recipientEmailAddress recipientEmailAddress or {@code null} for none
   */
  public AccessProposal setRecipientEmailAddress(java.lang.String recipientEmailAddress) {
    this.recipientEmailAddress = recipientEmailAddress;
    return this;
  }

  /**
   * The message that the requester added to the proposal.
   * @return value or {@code null} for none
   */
  public java.lang.String getRequestMessage() {
    return requestMessage;
  }

  /**
   * The message that the requester added to the proposal.
   * @param requestMessage requestMessage or {@code null} for none
   */
  public AccessProposal setRequestMessage(java.lang.String requestMessage) {
    this.requestMessage = requestMessage;
    return this;
  }

  /**
   * The email address of the requesting user.
   * @return value or {@code null} for none
   */
  public java.lang.String getRequesterEmailAddress() {
    return requesterEmailAddress;
  }

  /**
   * The email address of the requesting user.
   * @param requesterEmailAddress requesterEmailAddress or {@code null} for none
   */
  public AccessProposal setRequesterEmailAddress(java.lang.String requesterEmailAddress) {
    this.requesterEmailAddress = requesterEmailAddress;
    return this;
  }

  /**
   * A wrapper for the role and view of an access proposal. For more information, see [Roles and
   * permissions](https://developers.google.com/workspace/drive/api/guides/ref-roles).
   * @return value or {@code null} for none
   */
  public java.util.List<AccessProposalRoleAndView> getRolesAndViews() {
    return rolesAndViews;
  }

  /**
   * A wrapper for the role and view of an access proposal. For more information, see [Roles and
   * permissions](https://developers.google.com/workspace/drive/api/guides/ref-roles).
   * @param rolesAndViews rolesAndViews or {@code null} for none
   */
  public AccessProposal setRolesAndViews(java.util.List<AccessProposalRoleAndView> rolesAndViews) {
    this.rolesAndViews = rolesAndViews;
    return this;
  }

  @Override
  public AccessProposal set(String fieldName, Object value) {
    return (AccessProposal) super.set(fieldName, value);
  }

  @Override
  public AccessProposal clone() {
    return (AccessProposal) super.clone();
  }

}
