/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.drive;

/**
 * Service definition for Drive (v3).
 *
 * <p>
 * The Google Drive API allows clients to access resources from Google Drive.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/workspace/drive/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link DriveRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Drive extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        (com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 32 ||
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION == 31 &&
        com.google.api.client.googleapis.GoogleUtils.BUGFIX_VERSION >= 1))) ||
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION >= 2,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.31.1 of google-api-client to run version " +
        "2.0.0 of the Google Drive API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";

  /**
   * The default encoded mTLS root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.31
   */
  public static final String DEFAULT_MTLS_ROOT_URL = "https://www.mtls.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "drive/v3/";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch/drive/v3";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Drive(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Drive(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the About collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.About.List request = drive.about().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public About about() {
    return new About();
  }

  /**
   * The "about" collection of methods.
   */
  public class About {

    /**
     * Gets information about the user, the user's Drive, and system capabilities. For more information,
     * see [Return user info](https://developers.google.com/workspace/drive/api/guides/user-info).
     * Required: The `fields` parameter must be set. To return the exact fields you need, see [Return
     * specific fields](https://developers.google.com/workspace/drive/api/guides/fields-parameter).
     *
     * Create a request for the method "about.get".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public Get get() throws java.io.IOException {
      Get result = new Get();
      initialize(result);
      return result;
    }

    public class Get extends DriveRequest<com.google.api.services.drive.model.About> {

      private static final String REST_PATH = "about";

      /**
       * Gets information about the user, the user's Drive, and system capabilities. For more
       * information, see [Return user
       * info](https://developers.google.com/workspace/drive/api/guides/user-info). Required: The
       * `fields` parameter must be set. To return the exact fields you need, see [Return specific
       * fields](https://developers.google.com/workspace/drive/api/guides/fields-parameter).
       *
       * Create a request for the method "about.get".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected Get() {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.About.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Accessproposals collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Accessproposals.List request = drive.accessproposals().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Accessproposals accessproposals() {
    return new Accessproposals();
  }

  /**
   * The "accessproposals" collection of methods.
   */
  public class Accessproposals {

    /**
     * Retrieves an access proposal by ID. For more information, see [Manage pending access
     * proposals](https://developers.google.com/workspace/drive/api/guides/pending-access).
     *
     * Create a request for the method "accessproposals.get".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param fileId Required. The ID of the item the request is on.
     * @param proposalId Required. The ID of the access proposal to resolve.
     * @return the request
     */
    public Get get(java.lang.String fileId, java.lang.String proposalId) throws java.io.IOException {
      Get result = new Get(fileId, proposalId);
      initialize(result);
      return result;
    }

    public class Get extends DriveRequest<com.google.api.services.drive.model.AccessProposal> {

      private static final String REST_PATH = "files/{fileId}/accessproposals/{proposalId}";

      /**
       * Retrieves an access proposal by ID. For more information, see [Manage pending access
       * proposals](https://developers.google.com/workspace/drive/api/guides/pending-access).
       *
       * Create a request for the method "accessproposals.get".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId Required. The ID of the item the request is on.
       * @param proposalId Required. The ID of the access proposal to resolve.
       * @since 1.13
       */
      protected Get(java.lang.String fileId, java.lang.String proposalId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.AccessProposal.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.proposalId = com.google.api.client.util.Preconditions.checkNotNull(proposalId, "Required parameter proposalId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. The ID of the item the request is on. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** Required. The ID of the item the request is on.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** Required. The ID of the item the request is on. */
      public Get setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** Required. The ID of the access proposal to resolve. */
      @com.google.api.client.util.Key
      private java.lang.String proposalId;

      /** Required. The ID of the access proposal to resolve.
       */
      public java.lang.String getProposalId() {
        return proposalId;
      }

      /** Required. The ID of the access proposal to resolve. */
      public Get setProposalId(java.lang.String proposalId) {
        this.proposalId = proposalId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * List the access proposals on a file. For more information, see [Manage pending access
     * proposals](https://developers.google.com/workspace/drive/api/guides/pending-access). Note: Only
     * approvers are able to list access proposals on a file. If the user isn't an approver, a 403 error
     * is returned.
     *
     * Create a request for the method "accessproposals.list".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param fileId Required. The ID of the item the request is on.
     * @return the request
     */
    public List list(java.lang.String fileId) throws java.io.IOException {
      List result = new List(fileId);
      initialize(result);
      return result;
    }

    public class List extends DriveRequest<com.google.api.services.drive.model.ListAccessProposalsResponse> {

      private static final String REST_PATH = "files/{fileId}/accessproposals";

      /**
       * List the access proposals on a file. For more information, see [Manage pending access
       * proposals](https://developers.google.com/workspace/drive/api/guides/pending-access). Note: Only
       * approvers are able to list access proposals on a file. If the user isn't an approver, a 403
       * error is returned.
       *
       * Create a request for the method "accessproposals.list".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId Required. The ID of the item the request is on.
       * @since 1.13
       */
      protected List(java.lang.String fileId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.ListAccessProposalsResponse.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. The ID of the item the request is on. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** Required. The ID of the item the request is on.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** Required. The ID of the item the request is on. */
      public List setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** Optional. The number of results per page. */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** Optional. The number of results per page.
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /** Optional. The number of results per page. */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /** Optional. The continuation token on the list of access requests. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. The continuation token on the list of access requests.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Optional. The continuation token on the list of access requests. */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Approves or denies an access proposal. For more information, see [Manage pending access
     * proposals](https://developers.google.com/workspace/drive/api/guides/pending-access).
     *
     * Create a request for the method "accessproposals.resolve".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Resolve#execute()} method to invoke the remote operation.
     *
     * @param fileId Required. The ID of the item the request is on.
     * @param proposalId Required. The ID of the access proposal to resolve.
     * @param content the {@link com.google.api.services.drive.model.ResolveAccessProposalRequest}
     * @return the request
     */
    public Resolve resolve(java.lang.String fileId, java.lang.String proposalId, com.google.api.services.drive.model.ResolveAccessProposalRequest content) throws java.io.IOException {
      Resolve result = new Resolve(fileId, proposalId, content);
      initialize(result);
      return result;
    }

    public class Resolve extends DriveRequest<Void> {

      private static final String REST_PATH = "files/{fileId}/accessproposals/{proposalId}:resolve";

      /**
       * Approves or denies an access proposal. For more information, see [Manage pending access
       * proposals](https://developers.google.com/workspace/drive/api/guides/pending-access).
       *
       * Create a request for the method "accessproposals.resolve".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Resolve#execute()} method to invoke the remote operation. <p>
       * {@link
       * Resolve#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId Required. The ID of the item the request is on.
       * @param proposalId Required. The ID of the access proposal to resolve.
       * @param content the {@link com.google.api.services.drive.model.ResolveAccessProposalRequest}
       * @since 1.13
       */
      protected Resolve(java.lang.String fileId, java.lang.String proposalId, com.google.api.services.drive.model.ResolveAccessProposalRequest content) {
        super(Drive.this, "POST", REST_PATH, content, Void.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.proposalId = com.google.api.client.util.Preconditions.checkNotNull(proposalId, "Required parameter proposalId must be specified.");
      }

      @Override
      public Resolve set$Xgafv(java.lang.String $Xgafv) {
        return (Resolve) super.set$Xgafv($Xgafv);
      }

      @Override
      public Resolve setAccessToken(java.lang.String accessToken) {
        return (Resolve) super.setAccessToken(accessToken);
      }

      @Override
      public Resolve setAlt(java.lang.String alt) {
        return (Resolve) super.setAlt(alt);
      }

      @Override
      public Resolve setCallback(java.lang.String callback) {
        return (Resolve) super.setCallback(callback);
      }

      @Override
      public Resolve setFields(java.lang.String fields) {
        return (Resolve) super.setFields(fields);
      }

      @Override
      public Resolve setKey(java.lang.String key) {
        return (Resolve) super.setKey(key);
      }

      @Override
      public Resolve setOauthToken(java.lang.String oauthToken) {
        return (Resolve) super.setOauthToken(oauthToken);
      }

      @Override
      public Resolve setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Resolve) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Resolve setQuotaUser(java.lang.String quotaUser) {
        return (Resolve) super.setQuotaUser(quotaUser);
      }

      @Override
      public Resolve setUploadType(java.lang.String uploadType) {
        return (Resolve) super.setUploadType(uploadType);
      }

      @Override
      public Resolve setUploadProtocol(java.lang.String uploadProtocol) {
        return (Resolve) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. The ID of the item the request is on. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** Required. The ID of the item the request is on.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** Required. The ID of the item the request is on. */
      public Resolve setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** Required. The ID of the access proposal to resolve. */
      @com.google.api.client.util.Key
      private java.lang.String proposalId;

      /** Required. The ID of the access proposal to resolve.
       */
      public java.lang.String getProposalId() {
        return proposalId;
      }

      /** Required. The ID of the access proposal to resolve. */
      public Resolve setProposalId(java.lang.String proposalId) {
        this.proposalId = proposalId;
        return this;
      }

      @Override
      public Resolve set(String parameterName, Object value) {
        return (Resolve) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Approvals collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Approvals.List request = drive.approvals().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Approvals approvals() {
    return new Approvals();
  }

  /**
   * The "approvals" collection of methods.
   */
  public class Approvals {

    /**
     * Gets an Approval by ID.
     *
     * Create a request for the method "approvals.get".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param fileId Required. The ID of the file the Approval is on.
     * @param approvalId Required. The ID of the Approval.
     * @return the request
     */
    public Get get(java.lang.String fileId, java.lang.String approvalId) throws java.io.IOException {
      Get result = new Get(fileId, approvalId);
      initialize(result);
      return result;
    }

    public class Get extends DriveRequest<com.google.api.services.drive.model.Approval> {

      private static final String REST_PATH = "files/{fileId}/approvals/{approvalId}";

      /**
       * Gets an Approval by ID.
       *
       * Create a request for the method "approvals.get".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId Required. The ID of the file the Approval is on.
       * @param approvalId Required. The ID of the Approval.
       * @since 1.13
       */
      protected Get(java.lang.String fileId, java.lang.String approvalId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.Approval.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.approvalId = com.google.api.client.util.Preconditions.checkNotNull(approvalId, "Required parameter approvalId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. The ID of the file the Approval is on. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** Required. The ID of the file the Approval is on.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** Required. The ID of the file the Approval is on. */
      public Get setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** Required. The ID of the Approval. */
      @com.google.api.client.util.Key
      private java.lang.String approvalId;

      /** Required. The ID of the Approval.
       */
      public java.lang.String getApprovalId() {
        return approvalId;
      }

      /** Required. The ID of the Approval. */
      public Get setApprovalId(java.lang.String approvalId) {
        this.approvalId = approvalId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Lists the Approvals on a file.
     *
     * Create a request for the method "approvals.list".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param fileId Required. The ID of the file the Approval is on.
     * @return the request
     */
    public List list(java.lang.String fileId) throws java.io.IOException {
      List result = new List(fileId);
      initialize(result);
      return result;
    }

    public class List extends DriveRequest<com.google.api.services.drive.model.ApprovalList> {

      private static final String REST_PATH = "files/{fileId}/approvals";

      /**
       * Lists the Approvals on a file.
       *
       * Create a request for the method "approvals.list".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId Required. The ID of the file the Approval is on.
       * @since 1.13
       */
      protected List(java.lang.String fileId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.ApprovalList.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. The ID of the file the Approval is on. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** Required. The ID of the file the Approval is on.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** Required. The ID of the file the Approval is on. */
      public List setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /**
       * The maximum number of Approvals to return. When not set, at most 100 Approvals will be
       * returned.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** The maximum number of Approvals to return. When not set, at most 100 Approvals will be returned.
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /**
       * The maximum number of Approvals to return. When not set, at most 100 Approvals will be
       * returned.
       */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /**
       * The token for continuing a previous list request on the next page. This should be set to
       * the value of nextPageToken from a previous response.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The token for continuing a previous list request on the next page. This should be set to the value
     of nextPageToken from a previous response.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The token for continuing a previous list request on the next page. This should be set to
       * the value of nextPageToken from a previous response.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Apps collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Apps.List request = drive.apps().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Apps apps() {
    return new Apps();
  }

  /**
   * The "apps" collection of methods.
   */
  public class Apps {

    /**
     * Gets a specific app. For more information, see [Return user
     * info](https://developers.google.com/workspace/drive/api/guides/user-info).
     *
     * Create a request for the method "apps.get".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param appId The ID of the app.
     * @return the request
     */
    public Get get(java.lang.String appId) throws java.io.IOException {
      Get result = new Get(appId);
      initialize(result);
      return result;
    }

    public class Get extends DriveRequest<com.google.api.services.drive.model.App> {

      private static final String REST_PATH = "apps/{appId}";

      /**
       * Gets a specific app. For more information, see [Return user
       * info](https://developers.google.com/workspace/drive/api/guides/user-info).
       *
       * Create a request for the method "apps.get".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param appId The ID of the app.
       * @since 1.13
       */
      protected Get(java.lang.String appId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.App.class);
        this.appId = com.google.api.client.util.Preconditions.checkNotNull(appId, "Required parameter appId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the app. */
      @com.google.api.client.util.Key
      private java.lang.String appId;

      /** The ID of the app.
       */
      public java.lang.String getAppId() {
        return appId;
      }

      /** The ID of the app. */
      public Get setAppId(java.lang.String appId) {
        this.appId = appId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Lists a user's installed apps. For more information, see [Return user
     * info](https://developers.google.com/workspace/drive/api/guides/user-info).
     *
     * Create a request for the method "apps.list".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends DriveRequest<com.google.api.services.drive.model.AppList> {

      private static final String REST_PATH = "apps";

      /**
       * Lists a user's installed apps. For more information, see [Return user
       * info](https://developers.google.com/workspace/drive/api/guides/user-info).
       *
       * Create a request for the method "apps.list".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.AppList.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * A comma-separated list of file extensions to limit returned results. All results within the
       * given app query scope which can open any of the given file extensions are included in the
       * response. If `appFilterMimeTypes` are provided as well, the result is a union of the two
       * resulting app lists.
       */
      @com.google.api.client.util.Key
      private java.lang.String appFilterExtensions;

      /** A comma-separated list of file extensions to limit returned results. All results within the given
     app query scope which can open any of the given file extensions are included in the response. If
     `appFilterMimeTypes` are provided as well, the result is a union of the two resulting app lists.
       */
      public java.lang.String getAppFilterExtensions() {
        return appFilterExtensions;
      }

      /**
       * A comma-separated list of file extensions to limit returned results. All results within the
       * given app query scope which can open any of the given file extensions are included in the
       * response. If `appFilterMimeTypes` are provided as well, the result is a union of the two
       * resulting app lists.
       */
      public List setAppFilterExtensions(java.lang.String appFilterExtensions) {
        this.appFilterExtensions = appFilterExtensions;
        return this;
      }

      /**
       * A comma-separated list of file extensions to limit returned results. All results within the
       * given app query scope which can open any of the given MIME types will be included in the
       * response. If `appFilterExtensions` are provided as well, the result is a union of the two
       * resulting app lists.
       */
      @com.google.api.client.util.Key
      private java.lang.String appFilterMimeTypes;

      /** A comma-separated list of file extensions to limit returned results. All results within the given
     app query scope which can open any of the given MIME types will be included in the response. If
     `appFilterExtensions` are provided as well, the result is a union of the two resulting app lists.
       */
      public java.lang.String getAppFilterMimeTypes() {
        return appFilterMimeTypes;
      }

      /**
       * A comma-separated list of file extensions to limit returned results. All results within the
       * given app query scope which can open any of the given MIME types will be included in the
       * response. If `appFilterExtensions` are provided as well, the result is a union of the two
       * resulting app lists.
       */
      public List setAppFilterMimeTypes(java.lang.String appFilterMimeTypes) {
        this.appFilterMimeTypes = appFilterMimeTypes;
        return this;
      }

      /**
       * A language or locale code, as defined by BCP 47, with some extensions from Unicode's LDML
       * format (http://www.unicode.org/reports/tr35/).
       */
      @com.google.api.client.util.Key
      private java.lang.String languageCode;

      /** A language or locale code, as defined by BCP 47, with some extensions from Unicode's LDML format
     (http://www.unicode.org/reports/tr35/).
       */
      public java.lang.String getLanguageCode() {
        return languageCode;
      }

      /**
       * A language or locale code, as defined by BCP 47, with some extensions from Unicode's LDML
       * format (http://www.unicode.org/reports/tr35/).
       */
      public List setLanguageCode(java.lang.String languageCode) {
        this.languageCode = languageCode;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Changes collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Changes.List request = drive.changes().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Changes changes() {
    return new Changes();
  }

  /**
   * The "changes" collection of methods.
   */
  public class Changes {

    /**
     * Gets the starting pageToken for listing future changes. For more information, see [Retrieve
     * changes](https://developers.google.com/workspace/drive/api/guides/manage-changes).
     *
     * Create a request for the method "changes.getStartPageToken".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link GetStartPageToken#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public GetStartPageToken getStartPageToken() throws java.io.IOException {
      GetStartPageToken result = new GetStartPageToken();
      initialize(result);
      return result;
    }

    public class GetStartPageToken extends DriveRequest<com.google.api.services.drive.model.StartPageToken> {

      private static final String REST_PATH = "changes/startPageToken";

      /**
       * Gets the starting pageToken for listing future changes. For more information, see [Retrieve
       * changes](https://developers.google.com/workspace/drive/api/guides/manage-changes).
       *
       * Create a request for the method "changes.getStartPageToken".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link GetStartPageToken#execute()} method to invoke the remote operation.
       * <p> {@link GetStartPageToken#initialize(com.google.api.client.googleapis.services.AbstractGoogl
       * eClientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @since 1.13
       */
      protected GetStartPageToken() {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.StartPageToken.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetStartPageToken set$Xgafv(java.lang.String $Xgafv) {
        return (GetStartPageToken) super.set$Xgafv($Xgafv);
      }

      @Override
      public GetStartPageToken setAccessToken(java.lang.String accessToken) {
        return (GetStartPageToken) super.setAccessToken(accessToken);
      }

      @Override
      public GetStartPageToken setAlt(java.lang.String alt) {
        return (GetStartPageToken) super.setAlt(alt);
      }

      @Override
      public GetStartPageToken setCallback(java.lang.String callback) {
        return (GetStartPageToken) super.setCallback(callback);
      }

      @Override
      public GetStartPageToken setFields(java.lang.String fields) {
        return (GetStartPageToken) super.setFields(fields);
      }

      @Override
      public GetStartPageToken setKey(java.lang.String key) {
        return (GetStartPageToken) super.setKey(key);
      }

      @Override
      public GetStartPageToken setOauthToken(java.lang.String oauthToken) {
        return (GetStartPageToken) super.setOauthToken(oauthToken);
      }

      @Override
      public GetStartPageToken setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetStartPageToken) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetStartPageToken setQuotaUser(java.lang.String quotaUser) {
        return (GetStartPageToken) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetStartPageToken setUploadType(java.lang.String uploadType) {
        return (GetStartPageToken) super.setUploadType(uploadType);
      }

      @Override
      public GetStartPageToken setUploadProtocol(java.lang.String uploadProtocol) {
        return (GetStartPageToken) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The ID of the shared drive for which the starting pageToken for listing future changes from
       * that shared drive will be returned.
       */
      @com.google.api.client.util.Key
      private java.lang.String driveId;

      /** The ID of the shared drive for which the starting pageToken for listing future changes from that
     shared drive will be returned.
       */
      public java.lang.String getDriveId() {
        return driveId;
      }

      /**
       * The ID of the shared drive for which the starting pageToken for listing future changes from
       * that shared drive will be returned.
       */
      public GetStartPageToken setDriveId(java.lang.String driveId) {
        this.driveId = driveId;
        return this;
      }

      /** Whether the requesting application supports both My Drives and shared drives. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsAllDrives;

      /** Whether the requesting application supports both My Drives and shared drives. [default: false]
       */
      public java.lang.Boolean getSupportsAllDrives() {
        return supportsAllDrives;
      }

      /** Whether the requesting application supports both My Drives and shared drives. */
      public GetStartPageToken setSupportsAllDrives(java.lang.Boolean supportsAllDrives) {
        this.supportsAllDrives = supportsAllDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the requesting application supports both My Drives and shared drives.
       * </p>
       */
      public boolean isSupportsAllDrives() {
        if (supportsAllDrives == null || supportsAllDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsAllDrives;
      }

      /** Deprecated: Use `supportsAllDrives` instead. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsTeamDrives;

      /** Deprecated: Use `supportsAllDrives` instead. [default: false]
       */
      public java.lang.Boolean getSupportsTeamDrives() {
        return supportsTeamDrives;
      }

      /** Deprecated: Use `supportsAllDrives` instead. */
      public GetStartPageToken setSupportsTeamDrives(java.lang.Boolean supportsTeamDrives) {
        this.supportsTeamDrives = supportsTeamDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Deprecated: Use `supportsAllDrives` instead.
       * </p>
       */
      public boolean isSupportsTeamDrives() {
        if (supportsTeamDrives == null || supportsTeamDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsTeamDrives;
      }

      /** Deprecated: Use `driveId` instead. */
      @com.google.api.client.util.Key
      private java.lang.String teamDriveId;

      /** Deprecated: Use `driveId` instead.
       */
      public java.lang.String getTeamDriveId() {
        return teamDriveId;
      }

      /** Deprecated: Use `driveId` instead. */
      public GetStartPageToken setTeamDriveId(java.lang.String teamDriveId) {
        this.teamDriveId = teamDriveId;
        return this;
      }

      @Override
      public GetStartPageToken set(String parameterName, Object value) {
        return (GetStartPageToken) super.set(parameterName, value);
      }
    }
    /**
     * Lists the changes for a user or shared drive. For more information, see [Retrieve
     * changes](https://developers.google.com/workspace/drive/api/guides/manage-changes).
     *
     * Create a request for the method "changes.list".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param pageToken The token for continuing a previous list request on the next page. This should be set to the value
     *        of 'nextPageToken' from the previous response or to the response from the
     *        getStartPageToken method.
     * @return the request
     */
    public List list(java.lang.String pageToken) throws java.io.IOException {
      List result = new List(pageToken);
      initialize(result);
      return result;
    }

    public class List extends DriveRequest<com.google.api.services.drive.model.ChangeList> {

      private static final String REST_PATH = "changes";

      /**
       * Lists the changes for a user or shared drive. For more information, see [Retrieve
       * changes](https://developers.google.com/workspace/drive/api/guides/manage-changes).
       *
       * Create a request for the method "changes.list".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param pageToken The token for continuing a previous list request on the next page. This should be set to the value
     *        of 'nextPageToken' from the previous response or to the response from the
     *        getStartPageToken method.
       * @since 1.13
       */
      protected List(java.lang.String pageToken) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.ChangeList.class);
        this.pageToken = com.google.api.client.util.Preconditions.checkNotNull(pageToken, "Required parameter pageToken must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The token for continuing a previous list request on the next page. This should be set to
       * the value of 'nextPageToken' from the previous response or to the response from the
       * getStartPageToken method.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The token for continuing a previous list request on the next page. This should be set to the value
     of 'nextPageToken' from the previous response or to the response from the getStartPageToken method.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The token for continuing a previous list request on the next page. This should be set to
       * the value of 'nextPageToken' from the previous response or to the response from the
       * getStartPageToken method.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * The shared drive from which changes will be returned. If specified the change IDs will be
       * reflective of the shared drive; use the combined drive ID and change ID as an identifier.
       */
      @com.google.api.client.util.Key
      private java.lang.String driveId;

      /** The shared drive from which changes will be returned. If specified the change IDs will be
     reflective of the shared drive; use the combined drive ID and change ID as an identifier.
       */
      public java.lang.String getDriveId() {
        return driveId;
      }

      /**
       * The shared drive from which changes will be returned. If specified the change IDs will be
       * reflective of the shared drive; use the combined drive ID and change ID as an identifier.
       */
      public List setDriveId(java.lang.String driveId) {
        this.driveId = driveId;
        return this;
      }

      /**
       * Whether changes should include the file resource if the file is still accessible by the
       * user at the time of the request, even when a file was removed from the list of changes and
       * there will be no further change entries for this file.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeCorpusRemovals;

      /** Whether changes should include the file resource if the file is still accessible by the user at the
     time of the request, even when a file was removed from the list of changes and there will be no
     further change entries for this file. [default: false]
       */
      public java.lang.Boolean getIncludeCorpusRemovals() {
        return includeCorpusRemovals;
      }

      /**
       * Whether changes should include the file resource if the file is still accessible by the
       * user at the time of the request, even when a file was removed from the list of changes and
       * there will be no further change entries for this file.
       */
      public List setIncludeCorpusRemovals(java.lang.Boolean includeCorpusRemovals) {
        this.includeCorpusRemovals = includeCorpusRemovals;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether changes should include the file resource if the file is still accessible by the user at the
     time of the request, even when a file was removed from the list of changes and there will be no
     further change entries for this file.
       * </p>
       */
      public boolean isIncludeCorpusRemovals() {
        if (includeCorpusRemovals == null || includeCorpusRemovals == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return includeCorpusRemovals;
      }

      /** Whether both My Drive and shared drive items should be included in results. */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeItemsFromAllDrives;

      /** Whether both My Drive and shared drive items should be included in results. [default: false]
       */
      public java.lang.Boolean getIncludeItemsFromAllDrives() {
        return includeItemsFromAllDrives;
      }

      /** Whether both My Drive and shared drive items should be included in results. */
      public List setIncludeItemsFromAllDrives(java.lang.Boolean includeItemsFromAllDrives) {
        this.includeItemsFromAllDrives = includeItemsFromAllDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether both My Drive and shared drive items should be included in results.
       * </p>
       */
      public boolean isIncludeItemsFromAllDrives() {
        if (includeItemsFromAllDrives == null || includeItemsFromAllDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return includeItemsFromAllDrives;
      }

      /**
       * A comma-separated list of IDs of labels to include in the `labelInfo` part of the response.
       */
      @com.google.api.client.util.Key
      private java.lang.String includeLabels;

      /** A comma-separated list of IDs of labels to include in the `labelInfo` part of the response.
       */
      public java.lang.String getIncludeLabels() {
        return includeLabels;
      }

      /**
       * A comma-separated list of IDs of labels to include in the `labelInfo` part of the response.
       */
      public List setIncludeLabels(java.lang.String includeLabels) {
        this.includeLabels = includeLabels;
        return this;
      }

      /**
       * Specifies which additional view's permissions to include in the response. Only 'published'
       * is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String includePermissionsForView;

      /** Specifies which additional view's permissions to include in the response. Only 'published' is
     supported.
       */
      public java.lang.String getIncludePermissionsForView() {
        return includePermissionsForView;
      }

      /**
       * Specifies which additional view's permissions to include in the response. Only 'published'
       * is supported.
       */
      public List setIncludePermissionsForView(java.lang.String includePermissionsForView) {
        this.includePermissionsForView = includePermissionsForView;
        return this;
      }

      /**
       * Whether to include changes indicating that items have been removed from the list of
       * changes, for example by deletion or loss of access.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeRemoved;

      /** Whether to include changes indicating that items have been removed from the list of changes, for
     example by deletion or loss of access. [default: true]
       */
      public java.lang.Boolean getIncludeRemoved() {
        return includeRemoved;
      }

      /**
       * Whether to include changes indicating that items have been removed from the list of
       * changes, for example by deletion or loss of access.
       */
      public List setIncludeRemoved(java.lang.Boolean includeRemoved) {
        this.includeRemoved = includeRemoved;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to include changes indicating that items have been removed from the list of changes, for
     example by deletion or loss of access.
       * </p>
       */
      public boolean isIncludeRemoved() {
        if (includeRemoved == null || includeRemoved == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return true;
        }
        return includeRemoved;
      }

      /** Deprecated: Use `includeItemsFromAllDrives` instead. */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeTeamDriveItems;

      /** Deprecated: Use `includeItemsFromAllDrives` instead. [default: false]
       */
      public java.lang.Boolean getIncludeTeamDriveItems() {
        return includeTeamDriveItems;
      }

      /** Deprecated: Use `includeItemsFromAllDrives` instead. */
      public List setIncludeTeamDriveItems(java.lang.Boolean includeTeamDriveItems) {
        this.includeTeamDriveItems = includeTeamDriveItems;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Deprecated: Use `includeItemsFromAllDrives` instead.
       * </p>
       */
      public boolean isIncludeTeamDriveItems() {
        if (includeTeamDriveItems == null || includeTeamDriveItems == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return includeTeamDriveItems;
      }

      /** The maximum number of changes to return per page. */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** The maximum number of changes to return per page. [default: 100] [minimum: 1] [maximum: 1000]
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /** The maximum number of changes to return per page. */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /**
       * Whether to restrict the results to changes inside the My Drive hierarchy. This omits
       * changes to files such as those in the Application Data folder or shared files which have
       * not been added to My Drive.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean restrictToMyDrive;

      /** Whether to restrict the results to changes inside the My Drive hierarchy. This omits changes to
     files such as those in the Application Data folder or shared files which have not been added to My
     Drive. [default: false]
       */
      public java.lang.Boolean getRestrictToMyDrive() {
        return restrictToMyDrive;
      }

      /**
       * Whether to restrict the results to changes inside the My Drive hierarchy. This omits
       * changes to files such as those in the Application Data folder or shared files which have
       * not been added to My Drive.
       */
      public List setRestrictToMyDrive(java.lang.Boolean restrictToMyDrive) {
        this.restrictToMyDrive = restrictToMyDrive;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to restrict the results to changes inside the My Drive hierarchy. This omits changes to
     files such as those in the Application Data folder or shared files which have not been added to My
     Drive.
       * </p>
       */
      public boolean isRestrictToMyDrive() {
        if (restrictToMyDrive == null || restrictToMyDrive == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return restrictToMyDrive;
      }

      /**
       * A comma-separated list of spaces to query within the corpora. Supported values are 'drive'
       * and 'appDataFolder'.
       */
      @com.google.api.client.util.Key
      private java.lang.String spaces;

      /** A comma-separated list of spaces to query within the corpora. Supported values are 'drive' and
     'appDataFolder'. [default: drive]
       */
      public java.lang.String getSpaces() {
        return spaces;
      }

      /**
       * A comma-separated list of spaces to query within the corpora. Supported values are 'drive'
       * and 'appDataFolder'.
       */
      public List setSpaces(java.lang.String spaces) {
        this.spaces = spaces;
        return this;
      }

      /** Whether the requesting application supports both My Drives and shared drives. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsAllDrives;

      /** Whether the requesting application supports both My Drives and shared drives. [default: false]
       */
      public java.lang.Boolean getSupportsAllDrives() {
        return supportsAllDrives;
      }

      /** Whether the requesting application supports both My Drives and shared drives. */
      public List setSupportsAllDrives(java.lang.Boolean supportsAllDrives) {
        this.supportsAllDrives = supportsAllDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the requesting application supports both My Drives and shared drives.
       * </p>
       */
      public boolean isSupportsAllDrives() {
        if (supportsAllDrives == null || supportsAllDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsAllDrives;
      }

      /** Deprecated: Use `supportsAllDrives` instead. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsTeamDrives;

      /** Deprecated: Use `supportsAllDrives` instead. [default: false]
       */
      public java.lang.Boolean getSupportsTeamDrives() {
        return supportsTeamDrives;
      }

      /** Deprecated: Use `supportsAllDrives` instead. */
      public List setSupportsTeamDrives(java.lang.Boolean supportsTeamDrives) {
        this.supportsTeamDrives = supportsTeamDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Deprecated: Use `supportsAllDrives` instead.
       * </p>
       */
      public boolean isSupportsTeamDrives() {
        if (supportsTeamDrives == null || supportsTeamDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsTeamDrives;
      }

      /** Deprecated: Use `driveId` instead. */
      @com.google.api.client.util.Key
      private java.lang.String teamDriveId;

      /** Deprecated: Use `driveId` instead.
       */
      public java.lang.String getTeamDriveId() {
        return teamDriveId;
      }

      /** Deprecated: Use `driveId` instead. */
      public List setTeamDriveId(java.lang.String teamDriveId) {
        this.teamDriveId = teamDriveId;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Subscribes to changes for a user. For more information, see [Notifications for resource
     * changes](https://developers.google.com/workspace/drive/api/guides/push).
     *
     * Create a request for the method "changes.watch".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Watch#execute()} method to invoke the remote operation.
     *
     * @param pageToken The token for continuing a previous list request on the next page. This should be set to the value
     *        of 'nextPageToken' from the previous response or to the response from the
     *        getStartPageToken method.
     * @param content the {@link com.google.api.services.drive.model.Channel}
     * @return the request
     */
    public Watch watch(java.lang.String pageToken, com.google.api.services.drive.model.Channel content) throws java.io.IOException {
      Watch result = new Watch(pageToken, content);
      initialize(result);
      return result;
    }

    public class Watch extends DriveRequest<com.google.api.services.drive.model.Channel> {

      private static final String REST_PATH = "changes/watch";

      /**
       * Subscribes to changes for a user. For more information, see [Notifications for resource
       * changes](https://developers.google.com/workspace/drive/api/guides/push).
       *
       * Create a request for the method "changes.watch".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Watch#execute()} method to invoke the remote operation. <p> {@link
       * Watch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param pageToken The token for continuing a previous list request on the next page. This should be set to the value
     *        of 'nextPageToken' from the previous response or to the response from the
     *        getStartPageToken method.
       * @param content the {@link com.google.api.services.drive.model.Channel}
       * @since 1.13
       */
      protected Watch(java.lang.String pageToken, com.google.api.services.drive.model.Channel content) {
        super(Drive.this, "POST", REST_PATH, content, com.google.api.services.drive.model.Channel.class);
        this.pageToken = com.google.api.client.util.Preconditions.checkNotNull(pageToken, "Required parameter pageToken must be specified.");
      }

      @Override
      public Watch set$Xgafv(java.lang.String $Xgafv) {
        return (Watch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Watch setAccessToken(java.lang.String accessToken) {
        return (Watch) super.setAccessToken(accessToken);
      }

      @Override
      public Watch setAlt(java.lang.String alt) {
        return (Watch) super.setAlt(alt);
      }

      @Override
      public Watch setCallback(java.lang.String callback) {
        return (Watch) super.setCallback(callback);
      }

      @Override
      public Watch setFields(java.lang.String fields) {
        return (Watch) super.setFields(fields);
      }

      @Override
      public Watch setKey(java.lang.String key) {
        return (Watch) super.setKey(key);
      }

      @Override
      public Watch setOauthToken(java.lang.String oauthToken) {
        return (Watch) super.setOauthToken(oauthToken);
      }

      @Override
      public Watch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Watch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Watch setQuotaUser(java.lang.String quotaUser) {
        return (Watch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Watch setUploadType(java.lang.String uploadType) {
        return (Watch) super.setUploadType(uploadType);
      }

      @Override
      public Watch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Watch) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The token for continuing a previous list request on the next page. This should be set to
       * the value of 'nextPageToken' from the previous response or to the response from the
       * getStartPageToken method.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The token for continuing a previous list request on the next page. This should be set to the value
     of 'nextPageToken' from the previous response or to the response from the getStartPageToken method.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The token for continuing a previous list request on the next page. This should be set to
       * the value of 'nextPageToken' from the previous response or to the response from the
       * getStartPageToken method.
       */
      public Watch setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * The shared drive from which changes will be returned. If specified the change IDs will be
       * reflective of the shared drive; use the combined drive ID and change ID as an identifier.
       */
      @com.google.api.client.util.Key
      private java.lang.String driveId;

      /** The shared drive from which changes will be returned. If specified the change IDs will be
     reflective of the shared drive; use the combined drive ID and change ID as an identifier.
       */
      public java.lang.String getDriveId() {
        return driveId;
      }

      /**
       * The shared drive from which changes will be returned. If specified the change IDs will be
       * reflective of the shared drive; use the combined drive ID and change ID as an identifier.
       */
      public Watch setDriveId(java.lang.String driveId) {
        this.driveId = driveId;
        return this;
      }

      /**
       * Whether changes should include the file resource if the file is still accessible by the
       * user at the time of the request, even when a file was removed from the list of changes and
       * there will be no further change entries for this file.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeCorpusRemovals;

      /** Whether changes should include the file resource if the file is still accessible by the user at the
     time of the request, even when a file was removed from the list of changes and there will be no
     further change entries for this file. [default: false]
       */
      public java.lang.Boolean getIncludeCorpusRemovals() {
        return includeCorpusRemovals;
      }

      /**
       * Whether changes should include the file resource if the file is still accessible by the
       * user at the time of the request, even when a file was removed from the list of changes and
       * there will be no further change entries for this file.
       */
      public Watch setIncludeCorpusRemovals(java.lang.Boolean includeCorpusRemovals) {
        this.includeCorpusRemovals = includeCorpusRemovals;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether changes should include the file resource if the file is still accessible by the user at the
     time of the request, even when a file was removed from the list of changes and there will be no
     further change entries for this file.
       * </p>
       */
      public boolean isIncludeCorpusRemovals() {
        if (includeCorpusRemovals == null || includeCorpusRemovals == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return includeCorpusRemovals;
      }

      /** Whether both My Drive and shared drive items should be included in results. */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeItemsFromAllDrives;

      /** Whether both My Drive and shared drive items should be included in results. [default: false]
       */
      public java.lang.Boolean getIncludeItemsFromAllDrives() {
        return includeItemsFromAllDrives;
      }

      /** Whether both My Drive and shared drive items should be included in results. */
      public Watch setIncludeItemsFromAllDrives(java.lang.Boolean includeItemsFromAllDrives) {
        this.includeItemsFromAllDrives = includeItemsFromAllDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether both My Drive and shared drive items should be included in results.
       * </p>
       */
      public boolean isIncludeItemsFromAllDrives() {
        if (includeItemsFromAllDrives == null || includeItemsFromAllDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return includeItemsFromAllDrives;
      }

      /**
       * A comma-separated list of IDs of labels to include in the `labelInfo` part of the response.
       */
      @com.google.api.client.util.Key
      private java.lang.String includeLabels;

      /** A comma-separated list of IDs of labels to include in the `labelInfo` part of the response.
       */
      public java.lang.String getIncludeLabels() {
        return includeLabels;
      }

      /**
       * A comma-separated list of IDs of labels to include in the `labelInfo` part of the response.
       */
      public Watch setIncludeLabels(java.lang.String includeLabels) {
        this.includeLabels = includeLabels;
        return this;
      }

      /**
       * Specifies which additional view's permissions to include in the response. Only 'published'
       * is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String includePermissionsForView;

      /** Specifies which additional view's permissions to include in the response. Only 'published' is
     supported.
       */
      public java.lang.String getIncludePermissionsForView() {
        return includePermissionsForView;
      }

      /**
       * Specifies which additional view's permissions to include in the response. Only 'published'
       * is supported.
       */
      public Watch setIncludePermissionsForView(java.lang.String includePermissionsForView) {
        this.includePermissionsForView = includePermissionsForView;
        return this;
      }

      /**
       * Whether to include changes indicating that items have been removed from the list of
       * changes, for example by deletion or loss of access.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeRemoved;

      /** Whether to include changes indicating that items have been removed from the list of changes, for
     example by deletion or loss of access. [default: true]
       */
      public java.lang.Boolean getIncludeRemoved() {
        return includeRemoved;
      }

      /**
       * Whether to include changes indicating that items have been removed from the list of
       * changes, for example by deletion or loss of access.
       */
      public Watch setIncludeRemoved(java.lang.Boolean includeRemoved) {
        this.includeRemoved = includeRemoved;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to include changes indicating that items have been removed from the list of changes, for
     example by deletion or loss of access.
       * </p>
       */
      public boolean isIncludeRemoved() {
        if (includeRemoved == null || includeRemoved == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return true;
        }
        return includeRemoved;
      }

      /** Deprecated: Use `includeItemsFromAllDrives` instead. */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeTeamDriveItems;

      /** Deprecated: Use `includeItemsFromAllDrives` instead. [default: false]
       */
      public java.lang.Boolean getIncludeTeamDriveItems() {
        return includeTeamDriveItems;
      }

      /** Deprecated: Use `includeItemsFromAllDrives` instead. */
      public Watch setIncludeTeamDriveItems(java.lang.Boolean includeTeamDriveItems) {
        this.includeTeamDriveItems = includeTeamDriveItems;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Deprecated: Use `includeItemsFromAllDrives` instead.
       * </p>
       */
      public boolean isIncludeTeamDriveItems() {
        if (includeTeamDriveItems == null || includeTeamDriveItems == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return includeTeamDriveItems;
      }

      /** The maximum number of changes to return per page. */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** The maximum number of changes to return per page. [default: 100] [minimum: 1] [maximum: 1000]
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /** The maximum number of changes to return per page. */
      public Watch setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /**
       * Whether to restrict the results to changes inside the My Drive hierarchy. This omits
       * changes to files such as those in the Application Data folder or shared files which have
       * not been added to My Drive.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean restrictToMyDrive;

      /** Whether to restrict the results to changes inside the My Drive hierarchy. This omits changes to
     files such as those in the Application Data folder or shared files which have not been added to My
     Drive. [default: false]
       */
      public java.lang.Boolean getRestrictToMyDrive() {
        return restrictToMyDrive;
      }

      /**
       * Whether to restrict the results to changes inside the My Drive hierarchy. This omits
       * changes to files such as those in the Application Data folder or shared files which have
       * not been added to My Drive.
       */
      public Watch setRestrictToMyDrive(java.lang.Boolean restrictToMyDrive) {
        this.restrictToMyDrive = restrictToMyDrive;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to restrict the results to changes inside the My Drive hierarchy. This omits changes to
     files such as those in the Application Data folder or shared files which have not been added to My
     Drive.
       * </p>
       */
      public boolean isRestrictToMyDrive() {
        if (restrictToMyDrive == null || restrictToMyDrive == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return restrictToMyDrive;
      }

      /**
       * A comma-separated list of spaces to query within the corpora. Supported values are 'drive'
       * and 'appDataFolder'.
       */
      @com.google.api.client.util.Key
      private java.lang.String spaces;

      /** A comma-separated list of spaces to query within the corpora. Supported values are 'drive' and
     'appDataFolder'. [default: drive]
       */
      public java.lang.String getSpaces() {
        return spaces;
      }

      /**
       * A comma-separated list of spaces to query within the corpora. Supported values are 'drive'
       * and 'appDataFolder'.
       */
      public Watch setSpaces(java.lang.String spaces) {
        this.spaces = spaces;
        return this;
      }

      /** Whether the requesting application supports both My Drives and shared drives. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsAllDrives;

      /** Whether the requesting application supports both My Drives and shared drives. [default: false]
       */
      public java.lang.Boolean getSupportsAllDrives() {
        return supportsAllDrives;
      }

      /** Whether the requesting application supports both My Drives and shared drives. */
      public Watch setSupportsAllDrives(java.lang.Boolean supportsAllDrives) {
        this.supportsAllDrives = supportsAllDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the requesting application supports both My Drives and shared drives.
       * </p>
       */
      public boolean isSupportsAllDrives() {
        if (supportsAllDrives == null || supportsAllDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsAllDrives;
      }

      /** Deprecated: Use `supportsAllDrives` instead. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsTeamDrives;

      /** Deprecated: Use `supportsAllDrives` instead. [default: false]
       */
      public java.lang.Boolean getSupportsTeamDrives() {
        return supportsTeamDrives;
      }

      /** Deprecated: Use `supportsAllDrives` instead. */
      public Watch setSupportsTeamDrives(java.lang.Boolean supportsTeamDrives) {
        this.supportsTeamDrives = supportsTeamDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Deprecated: Use `supportsAllDrives` instead.
       * </p>
       */
      public boolean isSupportsTeamDrives() {
        if (supportsTeamDrives == null || supportsTeamDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsTeamDrives;
      }

      /** Deprecated: Use `driveId` instead. */
      @com.google.api.client.util.Key
      private java.lang.String teamDriveId;

      /** Deprecated: Use `driveId` instead.
       */
      public java.lang.String getTeamDriveId() {
        return teamDriveId;
      }

      /** Deprecated: Use `driveId` instead. */
      public Watch setTeamDriveId(java.lang.String teamDriveId) {
        this.teamDriveId = teamDriveId;
        return this;
      }

      @Override
      public Watch set(String parameterName, Object value) {
        return (Watch) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Channels collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Channels.List request = drive.channels().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Channels channels() {
    return new Channels();
  }

  /**
   * The "channels" collection of methods.
   */
  public class Channels {

    /**
     * Stops watching resources through this channel. For more information, see [Notifications for
     * resource changes](https://developers.google.com/workspace/drive/api/guides/push).
     *
     * Create a request for the method "channels.stop".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Stop#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.drive.model.Channel}
     * @return the request
     */
    public Stop stop(com.google.api.services.drive.model.Channel content) throws java.io.IOException {
      Stop result = new Stop(content);
      initialize(result);
      return result;
    }

    public class Stop extends DriveRequest<Void> {

      private static final String REST_PATH = "channels/stop";

      /**
       * Stops watching resources through this channel. For more information, see [Notifications for
       * resource changes](https://developers.google.com/workspace/drive/api/guides/push).
       *
       * Create a request for the method "channels.stop".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Stop#execute()} method to invoke the remote operation. <p> {@link
       * Stop#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.drive.model.Channel}
       * @since 1.13
       */
      protected Stop(com.google.api.services.drive.model.Channel content) {
        super(Drive.this, "POST", REST_PATH, content, Void.class);
      }

      @Override
      public Stop set$Xgafv(java.lang.String $Xgafv) {
        return (Stop) super.set$Xgafv($Xgafv);
      }

      @Override
      public Stop setAccessToken(java.lang.String accessToken) {
        return (Stop) super.setAccessToken(accessToken);
      }

      @Override
      public Stop setAlt(java.lang.String alt) {
        return (Stop) super.setAlt(alt);
      }

      @Override
      public Stop setCallback(java.lang.String callback) {
        return (Stop) super.setCallback(callback);
      }

      @Override
      public Stop setFields(java.lang.String fields) {
        return (Stop) super.setFields(fields);
      }

      @Override
      public Stop setKey(java.lang.String key) {
        return (Stop) super.setKey(key);
      }

      @Override
      public Stop setOauthToken(java.lang.String oauthToken) {
        return (Stop) super.setOauthToken(oauthToken);
      }

      @Override
      public Stop setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Stop) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Stop setQuotaUser(java.lang.String quotaUser) {
        return (Stop) super.setQuotaUser(quotaUser);
      }

      @Override
      public Stop setUploadType(java.lang.String uploadType) {
        return (Stop) super.setUploadType(uploadType);
      }

      @Override
      public Stop setUploadProtocol(java.lang.String uploadProtocol) {
        return (Stop) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Stop set(String parameterName, Object value) {
        return (Stop) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Comments collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Comments.List request = drive.comments().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Comments comments() {
    return new Comments();
  }

  /**
   * The "comments" collection of methods.
   */
  public class Comments {

    /**
     * Creates a comment on a file. For more information, see [Manage comments and
     * replies](https://developers.google.com/workspace/drive/api/guides/manage-comments). Required: The
     * `fields` parameter must be set. To return the exact fields you need, see [Return specific
     * fields](https://developers.google.com/workspace/drive/api/guides/fields-parameter).
     *
     * Create a request for the method "comments.create".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Create#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param content the {@link com.google.api.services.drive.model.Comment}
     * @return the request
     */
    public Create create(java.lang.String fileId, com.google.api.services.drive.model.Comment content) throws java.io.IOException {
      Create result = new Create(fileId, content);
      initialize(result);
      return result;
    }

    public class Create extends DriveRequest<com.google.api.services.drive.model.Comment> {

      private static final String REST_PATH = "files/{fileId}/comments";

      /**
       * Creates a comment on a file. For more information, see [Manage comments and
       * replies](https://developers.google.com/workspace/drive/api/guides/manage-comments). Required:
       * The `fields` parameter must be set. To return the exact fields you need, see [Return specific
       * fields](https://developers.google.com/workspace/drive/api/guides/fields-parameter).
       *
       * Create a request for the method "comments.create".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
       * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param content the {@link com.google.api.services.drive.model.Comment}
       * @since 1.13
       */
      protected Create(java.lang.String fileId, com.google.api.services.drive.model.Comment content) {
        super(Drive.this, "POST", REST_PATH, content, com.google.api.services.drive.model.Comment.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getContent(), "Comment.getContent()");
      }

      @Override
      public Create set$Xgafv(java.lang.String $Xgafv) {
        return (Create) super.set$Xgafv($Xgafv);
      }

      @Override
      public Create setAccessToken(java.lang.String accessToken) {
        return (Create) super.setAccessToken(accessToken);
      }

      @Override
      public Create setAlt(java.lang.String alt) {
        return (Create) super.setAlt(alt);
      }

      @Override
      public Create setCallback(java.lang.String callback) {
        return (Create) super.setCallback(callback);
      }

      @Override
      public Create setFields(java.lang.String fields) {
        return (Create) super.setFields(fields);
      }

      @Override
      public Create setKey(java.lang.String key) {
        return (Create) super.setKey(key);
      }

      @Override
      public Create setOauthToken(java.lang.String oauthToken) {
        return (Create) super.setOauthToken(oauthToken);
      }

      @Override
      public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Create) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Create setQuotaUser(java.lang.String quotaUser) {
        return (Create) super.setQuotaUser(quotaUser);
      }

      @Override
      public Create setUploadType(java.lang.String uploadType) {
        return (Create) super.setUploadType(uploadType);
      }

      @Override
      public Create setUploadProtocol(java.lang.String uploadProtocol) {
        return (Create) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Create setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      @Override
      public Create set(String parameterName, Object value) {
        return (Create) super.set(parameterName, value);
      }
    }
    /**
     * Deletes a comment. For more information, see [Manage comments and
     * replies](https://developers.google.com/workspace/drive/api/guides/manage-comments).
     *
     * Create a request for the method "comments.delete".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param commentId The ID of the comment.
     * @return the request
     */
    public Delete delete(java.lang.String fileId, java.lang.String commentId) throws java.io.IOException {
      Delete result = new Delete(fileId, commentId);
      initialize(result);
      return result;
    }

    public class Delete extends DriveRequest<Void> {

      private static final String REST_PATH = "files/{fileId}/comments/{commentId}";

      /**
       * Deletes a comment. For more information, see [Manage comments and
       * replies](https://developers.google.com/workspace/drive/api/guides/manage-comments).
       *
       * Create a request for the method "comments.delete".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param commentId The ID of the comment.
       * @since 1.13
       */
      protected Delete(java.lang.String fileId, java.lang.String commentId) {
        super(Drive.this, "DELETE", REST_PATH, null, Void.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.commentId = com.google.api.client.util.Preconditions.checkNotNull(commentId, "Required parameter commentId must be specified.");
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Delete setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the comment. */
      @com.google.api.client.util.Key
      private java.lang.String commentId;

      /** The ID of the comment.
       */
      public java.lang.String getCommentId() {
        return commentId;
      }

      /** The ID of the comment. */
      public Delete setCommentId(java.lang.String commentId) {
        this.commentId = commentId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Gets a comment by ID. For more information, see [Manage comments and
     * replies](https://developers.google.com/workspace/drive/api/guides/manage-comments). Required: The
     * `fields` parameter must be set. To return the exact fields you need, see [Return specific
     * fields](https://developers.google.com/workspace/drive/api/guides/fields-parameter).
     *
     * Create a request for the method "comments.get".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param commentId The ID of the comment.
     * @return the request
     */
    public Get get(java.lang.String fileId, java.lang.String commentId) throws java.io.IOException {
      Get result = new Get(fileId, commentId);
      initialize(result);
      return result;
    }

    public class Get extends DriveRequest<com.google.api.services.drive.model.Comment> {

      private static final String REST_PATH = "files/{fileId}/comments/{commentId}";

      /**
       * Gets a comment by ID. For more information, see [Manage comments and
       * replies](https://developers.google.com/workspace/drive/api/guides/manage-comments). Required:
       * The `fields` parameter must be set. To return the exact fields you need, see [Return specific
       * fields](https://developers.google.com/workspace/drive/api/guides/fields-parameter).
       *
       * Create a request for the method "comments.get".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param commentId The ID of the comment.
       * @since 1.13
       */
      protected Get(java.lang.String fileId, java.lang.String commentId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.Comment.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.commentId = com.google.api.client.util.Preconditions.checkNotNull(commentId, "Required parameter commentId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Get setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the comment. */
      @com.google.api.client.util.Key
      private java.lang.String commentId;

      /** The ID of the comment.
       */
      public java.lang.String getCommentId() {
        return commentId;
      }

      /** The ID of the comment. */
      public Get setCommentId(java.lang.String commentId) {
        this.commentId = commentId;
        return this;
      }

      /**
       * Whether to return deleted comments. Deleted comments will not include their original
       * content.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeDeleted;

      /** Whether to return deleted comments. Deleted comments will not include their original content.
     [default: false]
       */
      public java.lang.Boolean getIncludeDeleted() {
        return includeDeleted;
      }

      /**
       * Whether to return deleted comments. Deleted comments will not include their original
       * content.
       */
      public Get setIncludeDeleted(java.lang.Boolean includeDeleted) {
        this.includeDeleted = includeDeleted;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to return deleted comments. Deleted comments will not include their original content.
       * </p>
       */
      public boolean isIncludeDeleted() {
        if (includeDeleted == null || includeDeleted == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return includeDeleted;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Lists a file's comments. For more information, see [Manage comments and
     * replies](https://developers.google.com/workspace/drive/api/guides/manage-comments). Required: The
     * `fields` parameter must be set. To return the exact fields you need, see [Return specific
     * fields](https://developers.google.com/workspace/drive/api/guides/fields-parameter).
     *
     * Create a request for the method "comments.list".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @return the request
     */
    public List list(java.lang.String fileId) throws java.io.IOException {
      List result = new List(fileId);
      initialize(result);
      return result;
    }

    public class List extends DriveRequest<com.google.api.services.drive.model.CommentList> {

      private static final String REST_PATH = "files/{fileId}/comments";

      /**
       * Lists a file's comments. For more information, see [Manage comments and
       * replies](https://developers.google.com/workspace/drive/api/guides/manage-comments). Required:
       * The `fields` parameter must be set. To return the exact fields you need, see [Return specific
       * fields](https://developers.google.com/workspace/drive/api/guides/fields-parameter).
       *
       * Create a request for the method "comments.list".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @since 1.13
       */
      protected List(java.lang.String fileId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.CommentList.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public List setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /**
       * Whether to include deleted comments. Deleted comments will not include their original
       * content.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeDeleted;

      /** Whether to include deleted comments. Deleted comments will not include their original content.
     [default: false]
       */
      public java.lang.Boolean getIncludeDeleted() {
        return includeDeleted;
      }

      /**
       * Whether to include deleted comments. Deleted comments will not include their original
       * content.
       */
      public List setIncludeDeleted(java.lang.Boolean includeDeleted) {
        this.includeDeleted = includeDeleted;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to include deleted comments. Deleted comments will not include their original content.
       * </p>
       */
      public boolean isIncludeDeleted() {
        if (includeDeleted == null || includeDeleted == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return includeDeleted;
      }

      /** The maximum number of comments to return per page. */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** The maximum number of comments to return per page. [default: 20] [minimum: 1] [maximum: 100]
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /** The maximum number of comments to return per page. */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /**
       * The token for continuing a previous list request on the next page. This should be set to
       * the value of 'nextPageToken' from the previous response.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The token for continuing a previous list request on the next page. This should be set to the value
     of 'nextPageToken' from the previous response.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The token for continuing a previous list request on the next page. This should be set to
       * the value of 'nextPageToken' from the previous response.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** The minimum value of 'modifiedTime' for the result comments (RFC 3339 date-time). */
      @com.google.api.client.util.Key
      private java.lang.String startModifiedTime;

      /** The minimum value of 'modifiedTime' for the result comments (RFC 3339 date-time).
       */
      public java.lang.String getStartModifiedTime() {
        return startModifiedTime;
      }

      /** The minimum value of 'modifiedTime' for the result comments (RFC 3339 date-time). */
      public List setStartModifiedTime(java.lang.String startModifiedTime) {
        this.startModifiedTime = startModifiedTime;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates a comment with patch semantics. For more information, see [Manage comments and
     * replies](https://developers.google.com/workspace/drive/api/guides/manage-comments). Required: The
     * `fields` parameter must be set. To return the exact fields you need, see [Return specific
     * fields](https://developers.google.com/workspace/drive/api/guides/fields-parameter).
     *
     * Create a request for the method "comments.update".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param commentId The ID of the comment.
     * @param content the {@link com.google.api.services.drive.model.Comment}
     * @return the request
     */
    public Update update(java.lang.String fileId, java.lang.String commentId, com.google.api.services.drive.model.Comment content) throws java.io.IOException {
      Update result = new Update(fileId, commentId, content);
      initialize(result);
      return result;
    }

    public class Update extends DriveRequest<com.google.api.services.drive.model.Comment> {

      private static final String REST_PATH = "files/{fileId}/comments/{commentId}";

      /**
       * Updates a comment with patch semantics. For more information, see [Manage comments and
       * replies](https://developers.google.com/workspace/drive/api/guides/manage-comments). Required:
       * The `fields` parameter must be set. To return the exact fields you need, see [Return specific
       * fields](https://developers.google.com/workspace/drive/api/guides/fields-parameter).
       *
       * Create a request for the method "comments.update".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param commentId The ID of the comment.
       * @param content the {@link com.google.api.services.drive.model.Comment}
       * @since 1.13
       */
      protected Update(java.lang.String fileId, java.lang.String commentId, com.google.api.services.drive.model.Comment content) {
        super(Drive.this, "PATCH", REST_PATH, content, com.google.api.services.drive.model.Comment.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.commentId = com.google.api.client.util.Preconditions.checkNotNull(commentId, "Required parameter commentId must be specified.");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getContent(), "Comment.getContent()");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Update setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the comment. */
      @com.google.api.client.util.Key
      private java.lang.String commentId;

      /** The ID of the comment.
       */
      public java.lang.String getCommentId() {
        return commentId;
      }

      /** The ID of the comment. */
      public Update setCommentId(java.lang.String commentId) {
        this.commentId = commentId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Drives collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Drives.List request = drive.drives().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Drives drives() {
    return new Drives();
  }

  /**
   * The "drives" collection of methods.
   */
  public class Drives {

    /**
     * Creates a shared drive. For more information, see [Manage shared
     * drives](https://developers.google.com/workspace/drive/api/guides/manage-shareddrives).
     *
     * Create a request for the method "drives.create".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Create#execute()} method to invoke the remote operation.
     *
     * @param requestId Required. An ID, such as a random UUID, which uniquely identifies this user's request for idempotent
     *        creation of a shared drive. A repeated request by the same user and with the same request
     *        ID will avoid creating duplicates by attempting to create the same shared drive. If the
     *        shared drive already exists a 409 error will be returned.
     * @param content the {@link com.google.api.services.drive.model.Drive}
     * @return the request
     */
    public Create create(java.lang.String requestId, com.google.api.services.drive.model.Drive content) throws java.io.IOException {
      Create result = new Create(requestId, content);
      initialize(result);
      return result;
    }

    public class Create extends DriveRequest<com.google.api.services.drive.model.Drive> {

      private static final String REST_PATH = "drives";

      /**
       * Creates a shared drive. For more information, see [Manage shared
       * drives](https://developers.google.com/workspace/drive/api/guides/manage-shareddrives).
       *
       * Create a request for the method "drives.create".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
       * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param requestId Required. An ID, such as a random UUID, which uniquely identifies this user's request for idempotent
     *        creation of a shared drive. A repeated request by the same user and with the same request
     *        ID will avoid creating duplicates by attempting to create the same shared drive. If the
     *        shared drive already exists a 409 error will be returned.
       * @param content the {@link com.google.api.services.drive.model.Drive}
       * @since 1.13
       */
      protected Create(java.lang.String requestId, com.google.api.services.drive.model.Drive content) {
        super(Drive.this, "POST", REST_PATH, content, com.google.api.services.drive.model.Drive.class);
        this.requestId = com.google.api.client.util.Preconditions.checkNotNull(requestId, "Required parameter requestId must be specified.");
      }

      @Override
      public Create set$Xgafv(java.lang.String $Xgafv) {
        return (Create) super.set$Xgafv($Xgafv);
      }

      @Override
      public Create setAccessToken(java.lang.String accessToken) {
        return (Create) super.setAccessToken(accessToken);
      }

      @Override
      public Create setAlt(java.lang.String alt) {
        return (Create) super.setAlt(alt);
      }

      @Override
      public Create setCallback(java.lang.String callback) {
        return (Create) super.setCallback(callback);
      }

      @Override
      public Create setFields(java.lang.String fields) {
        return (Create) super.setFields(fields);
      }

      @Override
      public Create setKey(java.lang.String key) {
        return (Create) super.setKey(key);
      }

      @Override
      public Create setOauthToken(java.lang.String oauthToken) {
        return (Create) super.setOauthToken(oauthToken);
      }

      @Override
      public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Create) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Create setQuotaUser(java.lang.String quotaUser) {
        return (Create) super.setQuotaUser(quotaUser);
      }

      @Override
      public Create setUploadType(java.lang.String uploadType) {
        return (Create) super.setUploadType(uploadType);
      }

      @Override
      public Create setUploadProtocol(java.lang.String uploadProtocol) {
        return (Create) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Required. An ID, such as a random UUID, which uniquely identifies this user's request for
       * idempotent creation of a shared drive. A repeated request by the same user and with the
       * same request ID will avoid creating duplicates by attempting to create the same shared
       * drive. If the shared drive already exists a 409 error will be returned.
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** Required. An ID, such as a random UUID, which uniquely identifies this user's request for
     idempotent creation of a shared drive. A repeated request by the same user and with the same
     request ID will avoid creating duplicates by attempting to create the same shared drive. If the
     shared drive already exists a 409 error will be returned.
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * Required. An ID, such as a random UUID, which uniquely identifies this user's request for
       * idempotent creation of a shared drive. A repeated request by the same user and with the
       * same request ID will avoid creating duplicates by attempting to create the same shared
       * drive. If the shared drive already exists a 409 error will be returned.
       */
      public Create setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Create set(String parameterName, Object value) {
        return (Create) super.set(parameterName, value);
      }
    }
    /**
     * Permanently deletes a shared drive for which the user is an `organizer`. The shared drive cannot
     * contain any untrashed items. For more information, see [Manage shared
     * drives](https://developers.google.com/workspace/drive/api/guides/manage-shareddrives).
     *
     * Create a request for the method "drives.delete".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param driveId The ID of the shared drive.
     * @return the request
     */
    public Delete delete(java.lang.String driveId) throws java.io.IOException {
      Delete result = new Delete(driveId);
      initialize(result);
      return result;
    }

    public class Delete extends DriveRequest<Void> {

      private static final String REST_PATH = "drives/{driveId}";

      /**
       * Permanently deletes a shared drive for which the user is an `organizer`. The shared drive
       * cannot contain any untrashed items. For more information, see [Manage shared
       * drives](https://developers.google.com/workspace/drive/api/guides/manage-shareddrives).
       *
       * Create a request for the method "drives.delete".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param driveId The ID of the shared drive.
       * @since 1.13
       */
      protected Delete(java.lang.String driveId) {
        super(Drive.this, "DELETE", REST_PATH, null, Void.class);
        this.driveId = com.google.api.client.util.Preconditions.checkNotNull(driveId, "Required parameter driveId must be specified.");
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the shared drive. */
      @com.google.api.client.util.Key
      private java.lang.String driveId;

      /** The ID of the shared drive.
       */
      public java.lang.String getDriveId() {
        return driveId;
      }

      /** The ID of the shared drive. */
      public Delete setDriveId(java.lang.String driveId) {
        this.driveId = driveId;
        return this;
      }

      /**
       * Whether any items inside the shared drive should also be deleted. This option is only
       * supported when `useDomainAdminAccess` is also set to `true`.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean allowItemDeletion;

      /** Whether any items inside the shared drive should also be deleted. This option is only supported
     when `useDomainAdminAccess` is also set to `true`. [default: false]
       */
      public java.lang.Boolean getAllowItemDeletion() {
        return allowItemDeletion;
      }

      /**
       * Whether any items inside the shared drive should also be deleted. This option is only
       * supported when `useDomainAdminAccess` is also set to `true`.
       */
      public Delete setAllowItemDeletion(java.lang.Boolean allowItemDeletion) {
        this.allowItemDeletion = allowItemDeletion;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether any items inside the shared drive should also be deleted. This option is only supported
     when `useDomainAdminAccess` is also set to `true`.
       * </p>
       */
      public boolean isAllowItemDeletion() {
        if (allowItemDeletion == null || allowItemDeletion == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return allowItemDeletion;
      }

      /**
       * Issue the request as a domain administrator; if set to true, then the requester will be
       * granted access if they are an administrator of the domain to which the shared drive
       * belongs.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean useDomainAdminAccess;

      /** Issue the request as a domain administrator; if set to true, then the requester will be granted
     access if they are an administrator of the domain to which the shared drive belongs. [default:
     false]
       */
      public java.lang.Boolean getUseDomainAdminAccess() {
        return useDomainAdminAccess;
      }

      /**
       * Issue the request as a domain administrator; if set to true, then the requester will be
       * granted access if they are an administrator of the domain to which the shared drive
       * belongs.
       */
      public Delete setUseDomainAdminAccess(java.lang.Boolean useDomainAdminAccess) {
        this.useDomainAdminAccess = useDomainAdminAccess;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Issue the request as a domain administrator; if set to true, then the requester will be granted
     access if they are an administrator of the domain to which the shared drive belongs.
       * </p>
       */
      public boolean isUseDomainAdminAccess() {
        if (useDomainAdminAccess == null || useDomainAdminAccess == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return useDomainAdminAccess;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Gets a shared drive's metadata by ID. For more information, see [Manage shared
     * drives](https://developers.google.com/workspace/drive/api/guides/manage-shareddrives).
     *
     * Create a request for the method "drives.get".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param driveId The ID of the shared drive.
     * @return the request
     */
    public Get get(java.lang.String driveId) throws java.io.IOException {
      Get result = new Get(driveId);
      initialize(result);
      return result;
    }

    public class Get extends DriveRequest<com.google.api.services.drive.model.Drive> {

      private static final String REST_PATH = "drives/{driveId}";

      /**
       * Gets a shared drive's metadata by ID. For more information, see [Manage shared
       * drives](https://developers.google.com/workspace/drive/api/guides/manage-shareddrives).
       *
       * Create a request for the method "drives.get".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param driveId The ID of the shared drive.
       * @since 1.13
       */
      protected Get(java.lang.String driveId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.Drive.class);
        this.driveId = com.google.api.client.util.Preconditions.checkNotNull(driveId, "Required parameter driveId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the shared drive. */
      @com.google.api.client.util.Key
      private java.lang.String driveId;

      /** The ID of the shared drive.
       */
      public java.lang.String getDriveId() {
        return driveId;
      }

      /** The ID of the shared drive. */
      public Get setDriveId(java.lang.String driveId) {
        this.driveId = driveId;
        return this;
      }

      /**
       * Issue the request as a domain administrator; if set to true, then the requester will be
       * granted access if they are an administrator of the domain to which the shared drive
       * belongs.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean useDomainAdminAccess;

      /** Issue the request as a domain administrator; if set to true, then the requester will be granted
     access if they are an administrator of the domain to which the shared drive belongs. [default:
     false]
       */
      public java.lang.Boolean getUseDomainAdminAccess() {
        return useDomainAdminAccess;
      }

      /**
       * Issue the request as a domain administrator; if set to true, then the requester will be
       * granted access if they are an administrator of the domain to which the shared drive
       * belongs.
       */
      public Get setUseDomainAdminAccess(java.lang.Boolean useDomainAdminAccess) {
        this.useDomainAdminAccess = useDomainAdminAccess;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Issue the request as a domain administrator; if set to true, then the requester will be granted
     access if they are an administrator of the domain to which the shared drive belongs.
       * </p>
       */
      public boolean isUseDomainAdminAccess() {
        if (useDomainAdminAccess == null || useDomainAdminAccess == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return useDomainAdminAccess;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Hides a shared drive from the default view. For more information, see [Manage shared
     * drives](https://developers.google.com/workspace/drive/api/guides/manage-shareddrives).
     *
     * Create a request for the method "drives.hide".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Hide#execute()} method to invoke the remote operation.
     *
     * @param driveId The ID of the shared drive.
     * @return the request
     */
    public Hide hide(java.lang.String driveId) throws java.io.IOException {
      Hide result = new Hide(driveId);
      initialize(result);
      return result;
    }

    public class Hide extends DriveRequest<com.google.api.services.drive.model.Drive> {

      private static final String REST_PATH = "drives/{driveId}/hide";

      /**
       * Hides a shared drive from the default view. For more information, see [Manage shared
       * drives](https://developers.google.com/workspace/drive/api/guides/manage-shareddrives).
       *
       * Create a request for the method "drives.hide".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Hide#execute()} method to invoke the remote operation. <p> {@link
       * Hide#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param driveId The ID of the shared drive.
       * @since 1.13
       */
      protected Hide(java.lang.String driveId) {
        super(Drive.this, "POST", REST_PATH, null, com.google.api.services.drive.model.Drive.class);
        this.driveId = com.google.api.client.util.Preconditions.checkNotNull(driveId, "Required parameter driveId must be specified.");
      }

      @Override
      public Hide set$Xgafv(java.lang.String $Xgafv) {
        return (Hide) super.set$Xgafv($Xgafv);
      }

      @Override
      public Hide setAccessToken(java.lang.String accessToken) {
        return (Hide) super.setAccessToken(accessToken);
      }

      @Override
      public Hide setAlt(java.lang.String alt) {
        return (Hide) super.setAlt(alt);
      }

      @Override
      public Hide setCallback(java.lang.String callback) {
        return (Hide) super.setCallback(callback);
      }

      @Override
      public Hide setFields(java.lang.String fields) {
        return (Hide) super.setFields(fields);
      }

      @Override
      public Hide setKey(java.lang.String key) {
        return (Hide) super.setKey(key);
      }

      @Override
      public Hide setOauthToken(java.lang.String oauthToken) {
        return (Hide) super.setOauthToken(oauthToken);
      }

      @Override
      public Hide setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Hide) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Hide setQuotaUser(java.lang.String quotaUser) {
        return (Hide) super.setQuotaUser(quotaUser);
      }

      @Override
      public Hide setUploadType(java.lang.String uploadType) {
        return (Hide) super.setUploadType(uploadType);
      }

      @Override
      public Hide setUploadProtocol(java.lang.String uploadProtocol) {
        return (Hide) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the shared drive. */
      @com.google.api.client.util.Key
      private java.lang.String driveId;

      /** The ID of the shared drive.
       */
      public java.lang.String getDriveId() {
        return driveId;
      }

      /** The ID of the shared drive. */
      public Hide setDriveId(java.lang.String driveId) {
        this.driveId = driveId;
        return this;
      }

      @Override
      public Hide set(String parameterName, Object value) {
        return (Hide) super.set(parameterName, value);
      }
    }
    /**
     * Lists the user's shared drives. This method accepts the `q` parameter, which is a search query
     * combining one or more search terms. For more information, see the [Search for shared
     * drives](/workspace/drive/api/guides/search-shareddrives) guide.
     *
     * Create a request for the method "drives.list".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends DriveRequest<com.google.api.services.drive.model.DriveList> {

      private static final String REST_PATH = "drives";

      /**
       * Lists the user's shared drives. This method accepts the `q` parameter, which is a search query
       * combining one or more search terms. For more information, see the [Search for shared
       * drives](/workspace/drive/api/guides/search-shareddrives) guide.
       *
       * Create a request for the method "drives.list".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.DriveList.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** Maximum number of shared drives to return per page. */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** Maximum number of shared drives to return per page. [default: 10] [minimum: 1] [maximum: 100]
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /** Maximum number of shared drives to return per page. */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /** Page token for shared drives. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Page token for shared drives.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Page token for shared drives. */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Query string for searching shared drives. */
      @com.google.api.client.util.Key
      private java.lang.String q;

      /** Query string for searching shared drives.
       */
      public java.lang.String getQ() {
        return q;
      }

      /** Query string for searching shared drives. */
      public List setQ(java.lang.String q) {
        this.q = q;
        return this;
      }

      /**
       * Issue the request as a domain administrator; if set to true, then all shared drives of the
       * domain in which the requester is an administrator are returned.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean useDomainAdminAccess;

      /** Issue the request as a domain administrator; if set to true, then all shared drives of the domain
     in which the requester is an administrator are returned. [default: false]
       */
      public java.lang.Boolean getUseDomainAdminAccess() {
        return useDomainAdminAccess;
      }

      /**
       * Issue the request as a domain administrator; if set to true, then all shared drives of the
       * domain in which the requester is an administrator are returned.
       */
      public List setUseDomainAdminAccess(java.lang.Boolean useDomainAdminAccess) {
        this.useDomainAdminAccess = useDomainAdminAccess;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Issue the request as a domain administrator; if set to true, then all shared drives of the domain
     in which the requester is an administrator are returned.
       * </p>
       */
      public boolean isUseDomainAdminAccess() {
        if (useDomainAdminAccess == null || useDomainAdminAccess == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return useDomainAdminAccess;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Restores a shared drive to the default view. For more information, see [Manage shared
     * drives](https://developers.google.com/workspace/drive/api/guides/manage-shareddrives).
     *
     * Create a request for the method "drives.unhide".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Unhide#execute()} method to invoke the remote operation.
     *
     * @param driveId The ID of the shared drive.
     * @return the request
     */
    public Unhide unhide(java.lang.String driveId) throws java.io.IOException {
      Unhide result = new Unhide(driveId);
      initialize(result);
      return result;
    }

    public class Unhide extends DriveRequest<com.google.api.services.drive.model.Drive> {

      private static final String REST_PATH = "drives/{driveId}/unhide";

      /**
       * Restores a shared drive to the default view. For more information, see [Manage shared
       * drives](https://developers.google.com/workspace/drive/api/guides/manage-shareddrives).
       *
       * Create a request for the method "drives.unhide".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Unhide#execute()} method to invoke the remote operation. <p> {@link
       * Unhide#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param driveId The ID of the shared drive.
       * @since 1.13
       */
      protected Unhide(java.lang.String driveId) {
        super(Drive.this, "POST", REST_PATH, null, com.google.api.services.drive.model.Drive.class);
        this.driveId = com.google.api.client.util.Preconditions.checkNotNull(driveId, "Required parameter driveId must be specified.");
      }

      @Override
      public Unhide set$Xgafv(java.lang.String $Xgafv) {
        return (Unhide) super.set$Xgafv($Xgafv);
      }

      @Override
      public Unhide setAccessToken(java.lang.String accessToken) {
        return (Unhide) super.setAccessToken(accessToken);
      }

      @Override
      public Unhide setAlt(java.lang.String alt) {
        return (Unhide) super.setAlt(alt);
      }

      @Override
      public Unhide setCallback(java.lang.String callback) {
        return (Unhide) super.setCallback(callback);
      }

      @Override
      public Unhide setFields(java.lang.String fields) {
        return (Unhide) super.setFields(fields);
      }

      @Override
      public Unhide setKey(java.lang.String key) {
        return (Unhide) super.setKey(key);
      }

      @Override
      public Unhide setOauthToken(java.lang.String oauthToken) {
        return (Unhide) super.setOauthToken(oauthToken);
      }

      @Override
      public Unhide setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Unhide) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Unhide setQuotaUser(java.lang.String quotaUser) {
        return (Unhide) super.setQuotaUser(quotaUser);
      }

      @Override
      public Unhide setUploadType(java.lang.String uploadType) {
        return (Unhide) super.setUploadType(uploadType);
      }

      @Override
      public Unhide setUploadProtocol(java.lang.String uploadProtocol) {
        return (Unhide) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the shared drive. */
      @com.google.api.client.util.Key
      private java.lang.String driveId;

      /** The ID of the shared drive.
       */
      public java.lang.String getDriveId() {
        return driveId;
      }

      /** The ID of the shared drive. */
      public Unhide setDriveId(java.lang.String driveId) {
        this.driveId = driveId;
        return this;
      }

      @Override
      public Unhide set(String parameterName, Object value) {
        return (Unhide) super.set(parameterName, value);
      }
    }
    /**
     * Updates the metadata for a shared drive. For more information, see [Manage shared
     * drives](https://developers.google.com/workspace/drive/api/guides/manage-shareddrives).
     *
     * Create a request for the method "drives.update".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param driveId The ID of the shared drive.
     * @param content the {@link com.google.api.services.drive.model.Drive}
     * @return the request
     */
    public Update update(java.lang.String driveId, com.google.api.services.drive.model.Drive content) throws java.io.IOException {
      Update result = new Update(driveId, content);
      initialize(result);
      return result;
    }

    public class Update extends DriveRequest<com.google.api.services.drive.model.Drive> {

      private static final String REST_PATH = "drives/{driveId}";

      /**
       * Updates the metadata for a shared drive. For more information, see [Manage shared
       * drives](https://developers.google.com/workspace/drive/api/guides/manage-shareddrives).
       *
       * Create a request for the method "drives.update".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param driveId The ID of the shared drive.
       * @param content the {@link com.google.api.services.drive.model.Drive}
       * @since 1.13
       */
      protected Update(java.lang.String driveId, com.google.api.services.drive.model.Drive content) {
        super(Drive.this, "PATCH", REST_PATH, content, com.google.api.services.drive.model.Drive.class);
        this.driveId = com.google.api.client.util.Preconditions.checkNotNull(driveId, "Required parameter driveId must be specified.");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the shared drive. */
      @com.google.api.client.util.Key
      private java.lang.String driveId;

      /** The ID of the shared drive.
       */
      public java.lang.String getDriveId() {
        return driveId;
      }

      /** The ID of the shared drive. */
      public Update setDriveId(java.lang.String driveId) {
        this.driveId = driveId;
        return this;
      }

      /**
       * Issue the request as a domain administrator; if set to true, then the requester will be
       * granted access if they are an administrator of the domain to which the shared drive
       * belongs.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean useDomainAdminAccess;

      /** Issue the request as a domain administrator; if set to true, then the requester will be granted
     access if they are an administrator of the domain to which the shared drive belongs. [default:
     false]
       */
      public java.lang.Boolean getUseDomainAdminAccess() {
        return useDomainAdminAccess;
      }

      /**
       * Issue the request as a domain administrator; if set to true, then the requester will be
       * granted access if they are an administrator of the domain to which the shared drive
       * belongs.
       */
      public Update setUseDomainAdminAccess(java.lang.Boolean useDomainAdminAccess) {
        this.useDomainAdminAccess = useDomainAdminAccess;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Issue the request as a domain administrator; if set to true, then the requester will be granted
     access if they are an administrator of the domain to which the shared drive belongs.
       * </p>
       */
      public boolean isUseDomainAdminAccess() {
        if (useDomainAdminAccess == null || useDomainAdminAccess == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return useDomainAdminAccess;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Files collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Files.List request = drive.files().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Files files() {
    return new Files();
  }

  /**
   * The "files" collection of methods.
   */
  public class Files {

    /**
     * Creates a copy of a file and applies any requested updates with patch semantics. For more
     * information, see [Create and manage
     * files](https://developers.google.com/workspace/drive/api/guides/create-file).
     *
     * Create a request for the method "files.copy".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Copy#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param content the {@link com.google.api.services.drive.model.File}
     * @return the request
     */
    public Copy copy(java.lang.String fileId, com.google.api.services.drive.model.File content) throws java.io.IOException {
      Copy result = new Copy(fileId, content);
      initialize(result);
      return result;
    }

    public class Copy extends DriveRequest<com.google.api.services.drive.model.File> {

      private static final String REST_PATH = "files/{fileId}/copy";

      /**
       * Creates a copy of a file and applies any requested updates with patch semantics. For more
       * information, see [Create and manage
       * files](https://developers.google.com/workspace/drive/api/guides/create-file).
       *
       * Create a request for the method "files.copy".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Copy#execute()} method to invoke the remote operation. <p> {@link
       * Copy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param content the {@link com.google.api.services.drive.model.File}
       * @since 1.13
       */
      protected Copy(java.lang.String fileId, com.google.api.services.drive.model.File content) {
        super(Drive.this, "POST", REST_PATH, content, com.google.api.services.drive.model.File.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }

      @Override
      public Copy set$Xgafv(java.lang.String $Xgafv) {
        return (Copy) super.set$Xgafv($Xgafv);
      }

      @Override
      public Copy setAccessToken(java.lang.String accessToken) {
        return (Copy) super.setAccessToken(accessToken);
      }

      @Override
      public Copy setAlt(java.lang.String alt) {
        return (Copy) super.setAlt(alt);
      }

      @Override
      public Copy setCallback(java.lang.String callback) {
        return (Copy) super.setCallback(callback);
      }

      @Override
      public Copy setFields(java.lang.String fields) {
        return (Copy) super.setFields(fields);
      }

      @Override
      public Copy setKey(java.lang.String key) {
        return (Copy) super.setKey(key);
      }

      @Override
      public Copy setOauthToken(java.lang.String oauthToken) {
        return (Copy) super.setOauthToken(oauthToken);
      }

      @Override
      public Copy setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Copy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Copy setQuotaUser(java.lang.String quotaUser) {
        return (Copy) super.setQuotaUser(quotaUser);
      }

      @Override
      public Copy setUploadType(java.lang.String uploadType) {
        return (Copy) super.setUploadType(uploadType);
      }

      @Override
      public Copy setUploadProtocol(java.lang.String uploadProtocol) {
        return (Copy) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Copy setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /**
       * Deprecated: Copying files into multiple folders is no longer supported. Use shortcuts
       * instead.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean enforceSingleParent;

      /** Deprecated: Copying files into multiple folders is no longer supported. Use shortcuts instead.
     [default: false]
       */
      public java.lang.Boolean getEnforceSingleParent() {
        return enforceSingleParent;
      }

      /**
       * Deprecated: Copying files into multiple folders is no longer supported. Use shortcuts
       * instead.
       */
      public Copy setEnforceSingleParent(java.lang.Boolean enforceSingleParent) {
        this.enforceSingleParent = enforceSingleParent;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Deprecated: Copying files into multiple folders is no longer supported. Use shortcuts instead.
       * </p>
       */
      public boolean isEnforceSingleParent() {
        if (enforceSingleParent == null || enforceSingleParent == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return enforceSingleParent;
      }

      /**
       * Whether to ignore the domain's default visibility settings for the created file. Domain
       * administrators can choose to make all uploaded files visible to the domain by default; this
       * parameter bypasses that behavior for the request. Permissions are still inherited from
       * parent folders.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean ignoreDefaultVisibility;

      /** Whether to ignore the domain's default visibility settings for the created file. Domain
     administrators can choose to make all uploaded files visible to the domain by default; this
     parameter bypasses that behavior for the request. Permissions are still inherited from parent
     folders. [default: false]
       */
      public java.lang.Boolean getIgnoreDefaultVisibility() {
        return ignoreDefaultVisibility;
      }

      /**
       * Whether to ignore the domain's default visibility settings for the created file. Domain
       * administrators can choose to make all uploaded files visible to the domain by default; this
       * parameter bypasses that behavior for the request. Permissions are still inherited from
       * parent folders.
       */
      public Copy setIgnoreDefaultVisibility(java.lang.Boolean ignoreDefaultVisibility) {
        this.ignoreDefaultVisibility = ignoreDefaultVisibility;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to ignore the domain's default visibility settings for the created file. Domain
     administrators can choose to make all uploaded files visible to the domain by default; this
     parameter bypasses that behavior for the request. Permissions are still inherited from parent
     folders.
       * </p>
       */
      public boolean isIgnoreDefaultVisibility() {
        if (ignoreDefaultVisibility == null || ignoreDefaultVisibility == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return ignoreDefaultVisibility;
      }

      /**
       * A comma-separated list of IDs of labels to include in the `labelInfo` part of the response.
       */
      @com.google.api.client.util.Key
      private java.lang.String includeLabels;

      /** A comma-separated list of IDs of labels to include in the `labelInfo` part of the response.
       */
      public java.lang.String getIncludeLabels() {
        return includeLabels;
      }

      /**
       * A comma-separated list of IDs of labels to include in the `labelInfo` part of the response.
       */
      public Copy setIncludeLabels(java.lang.String includeLabels) {
        this.includeLabels = includeLabels;
        return this;
      }

      /**
       * Specifies which additional view's permissions to include in the response. Only `published`
       * is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String includePermissionsForView;

      /** Specifies which additional view's permissions to include in the response. Only `published` is
     supported.
       */
      public java.lang.String getIncludePermissionsForView() {
        return includePermissionsForView;
      }

      /**
       * Specifies which additional view's permissions to include in the response. Only `published`
       * is supported.
       */
      public Copy setIncludePermissionsForView(java.lang.String includePermissionsForView) {
        this.includePermissionsForView = includePermissionsForView;
        return this;
      }

      /**
       * Whether to set the `keepForever` field in the new head revision. This is only applicable to
       * files with binary content in Google Drive. Only 200 revisions for the file can be kept
       * forever. If the limit is reached, try deleting pinned revisions.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean keepRevisionForever;

      /** Whether to set the `keepForever` field in the new head revision. This is only applicable to files
     with binary content in Google Drive. Only 200 revisions for the file can be kept forever. If the
     limit is reached, try deleting pinned revisions. [default: false]
       */
      public java.lang.Boolean getKeepRevisionForever() {
        return keepRevisionForever;
      }

      /**
       * Whether to set the `keepForever` field in the new head revision. This is only applicable to
       * files with binary content in Google Drive. Only 200 revisions for the file can be kept
       * forever. If the limit is reached, try deleting pinned revisions.
       */
      public Copy setKeepRevisionForever(java.lang.Boolean keepRevisionForever) {
        this.keepRevisionForever = keepRevisionForever;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to set the `keepForever` field in the new head revision. This is only applicable to files
     with binary content in Google Drive. Only 200 revisions for the file can be kept forever. If the
     limit is reached, try deleting pinned revisions.
       * </p>
       */
      public boolean isKeepRevisionForever() {
        if (keepRevisionForever == null || keepRevisionForever == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return keepRevisionForever;
      }

      /** A language hint for OCR processing during image import (ISO 639-1 code). */
      @com.google.api.client.util.Key
      private java.lang.String ocrLanguage;

      /** A language hint for OCR processing during image import (ISO 639-1 code).
       */
      public java.lang.String getOcrLanguage() {
        return ocrLanguage;
      }

      /** A language hint for OCR processing during image import (ISO 639-1 code). */
      public Copy setOcrLanguage(java.lang.String ocrLanguage) {
        this.ocrLanguage = ocrLanguage;
        return this;
      }

      /** Whether the requesting application supports both My Drives and shared drives. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsAllDrives;

      /** Whether the requesting application supports both My Drives and shared drives. [default: false]
       */
      public java.lang.Boolean getSupportsAllDrives() {
        return supportsAllDrives;
      }

      /** Whether the requesting application supports both My Drives and shared drives. */
      public Copy setSupportsAllDrives(java.lang.Boolean supportsAllDrives) {
        this.supportsAllDrives = supportsAllDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the requesting application supports both My Drives and shared drives.
       * </p>
       */
      public boolean isSupportsAllDrives() {
        if (supportsAllDrives == null || supportsAllDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsAllDrives;
      }

      /** Deprecated: Use `supportsAllDrives` instead. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsTeamDrives;

      /** Deprecated: Use `supportsAllDrives` instead. [default: false]
       */
      public java.lang.Boolean getSupportsTeamDrives() {
        return supportsTeamDrives;
      }

      /** Deprecated: Use `supportsAllDrives` instead. */
      public Copy setSupportsTeamDrives(java.lang.Boolean supportsTeamDrives) {
        this.supportsTeamDrives = supportsTeamDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Deprecated: Use `supportsAllDrives` instead.
       * </p>
       */
      public boolean isSupportsTeamDrives() {
        if (supportsTeamDrives == null || supportsTeamDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsTeamDrives;
      }

      @Override
      public Copy set(String parameterName, Object value) {
        return (Copy) super.set(parameterName, value);
      }
    }
    /**
     * Creates a file. For more information, see [Create and manage
     * files](/workspace/drive/api/guides/create-file). This method supports an upload* URI and accepts
     * uploaded media with the following characteristics: - *Maximum file size:* 5,120 GB - *Accepted
     * Media MIME types:* `*` (Specify a valid MIME type, rather than the literal `*` value. The literal
     * `*` is only used to indicate that any valid MIME type can be uploaded. For more information, see
     * [Google Workspace and Google Drive supported MIME types](/workspace/drive/api/guides/mime-
     * types).) For more information on uploading files, see [Upload file
     * data](/workspace/drive/api/guides/manage-uploads). Apps creating shortcuts with the `create`
     * method must specify the MIME type `application/vnd.google-apps.shortcut`. Apps should specify a
     * file extension in the `name` property when inserting files with the API. For example, an
     * operation to insert a JPEG file should specify something like `"name": "cat.jpg"` in the
     * metadata. Subsequent `GET` requests include the read-only `fileExtension` property populated with
     * the extension originally specified in the `name` property. When a Google Drive user requests to
     * download a file, or when the file is downloaded through the sync client, Drive builds a full
     * filename (with extension) based on the name. In cases where the extension is missing, Drive
     * attempts to determine the extension based on the file's MIME type.
     *
     * Create a request for the method "files.create".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Create#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.drive.model.File}
     * @return the request
     */
    public Create create(com.google.api.services.drive.model.File content) throws java.io.IOException {
      Create result = new Create(content);
      initialize(result);
      return result;
    }

    /**
     * Creates a file. For more information, see [Create and manage
     * files](/workspace/drive/api/guides/create-file). This method supports an upload* URI and accepts
     * uploaded media with the following characteristics: - *Maximum file size:* 5,120 GB - *Accepted
     * Media MIME types:* `*` (Specify a valid MIME type, rather than the literal `*` value. The literal
     * `*` is only used to indicate that any valid MIME type can be uploaded. For more information, see
     * [Google Workspace and Google Drive supported MIME types](/workspace/drive/api/guides/mime-
     * types).) For more information on uploading files, see [Upload file
     * data](/workspace/drive/api/guides/manage-uploads). Apps creating shortcuts with the `create`
     * method must specify the MIME type `application/vnd.google-apps.shortcut`. Apps should specify a
     * file extension in the `name` property when inserting files with the API. For example, an
     * operation to insert a JPEG file should specify something like `"name": "cat.jpg"` in the
     * metadata. Subsequent `GET` requests include the read-only `fileExtension` property populated with
     * the extension originally specified in the `name` property. When a Google Drive user requests to
     * download a file, or when the file is downloaded through the sync client, Drive builds a full
     * filename (with extension) based on the name. In cases where the extension is missing, Drive
     * attempts to determine the extension based on the file's MIME type.
     *
     * Create a request for the method "files.create".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Create#execute()} method to invoke the remote operation.
     *
     * <p>
     * This method should be used for uploading media content.
     * </p>
     *
     *
     * @param content the {@link com.google.api.services.drive.model.File} media metadata or {@code null} if none
     * @param mediaContent The media HTTP content.
     * @return the request
     * @throws java.io.IOException if the initialization of the request fails
     */
    public Create create(com.google.api.services.drive.model.File content, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
      Create result = new Create(content, mediaContent);
      initialize(result);
      return result;
    }

    public class Create extends DriveRequest<com.google.api.services.drive.model.File> {

      private static final String REST_PATH = "files";

      /**
       * Creates a file. For more information, see [Create and manage
       * files](/workspace/drive/api/guides/create-file). This method supports an upload* URI and
       * accepts uploaded media with the following characteristics: - *Maximum file size:* 5,120 GB -
       * *Accepted Media MIME types:* `*` (Specify a valid MIME type, rather than the literal `*` value.
       * The literal `*` is only used to indicate that any valid MIME type can be uploaded. For more
       * information, see [Google Workspace and Google Drive supported MIME
       * types](/workspace/drive/api/guides/mime-types).) For more information on uploading files, see
       * [Upload file data](/workspace/drive/api/guides/manage-uploads). Apps creating shortcuts with
       * the `create` method must specify the MIME type `application/vnd.google-apps.shortcut`. Apps
       * should specify a file extension in the `name` property when inserting files with the API. For
       * example, an operation to insert a JPEG file should specify something like `"name": "cat.jpg"`
       * in the metadata. Subsequent `GET` requests include the read-only `fileExtension` property
       * populated with the extension originally specified in the `name` property. When a Google Drive
       * user requests to download a file, or when the file is downloaded through the sync client, Drive
       * builds a full filename (with extension) based on the name. In cases where the extension is
       * missing, Drive attempts to determine the extension based on the file's MIME type.
       *
       * Create a request for the method "files.create".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
       * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.drive.model.File}
       * @since 1.13
       */
      protected Create(com.google.api.services.drive.model.File content) {
        super(Drive.this, "POST", REST_PATH, content, com.google.api.services.drive.model.File.class);
      }

      /**
       * Creates a file. For more information, see [Create and manage
       * files](/workspace/drive/api/guides/create-file). This method supports an upload* URI and
       * accepts uploaded media with the following characteristics: - *Maximum file size:* 5,120 GB -
       * *Accepted Media MIME types:* `*` (Specify a valid MIME type, rather than the literal `*` value.
       * The literal `*` is only used to indicate that any valid MIME type can be uploaded. For more
       * information, see [Google Workspace and Google Drive supported MIME
       * types](/workspace/drive/api/guides/mime-types).) For more information on uploading files, see
       * [Upload file data](/workspace/drive/api/guides/manage-uploads). Apps creating shortcuts with
       * the `create` method must specify the MIME type `application/vnd.google-apps.shortcut`. Apps
       * should specify a file extension in the `name` property when inserting files with the API. For
       * example, an operation to insert a JPEG file should specify something like `"name": "cat.jpg"`
       * in the metadata. Subsequent `GET` requests include the read-only `fileExtension` property
       * populated with the extension originally specified in the `name` property. When a Google Drive
       * user requests to download a file, or when the file is downloaded through the sync client, Drive
       * builds a full filename (with extension) based on the name. In cases where the extension is
       * missing, Drive attempts to determine the extension based on the file's MIME type.
       *
       * Create a request for the method "files.create".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
       * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * <p>
       * This constructor should be used for uploading media content.
       * </p>
       *
       *
       * @param content the {@link com.google.api.services.drive.model.File} media metadata or {@code null} if none
       * @param mediaContent The media HTTP content.
       * @since 1.13
       */
      protected Create(com.google.api.services.drive.model.File content, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(Drive.this, "POST", "/upload/" + getServicePath() + REST_PATH, content, com.google.api.services.drive.model.File.class);
        com.google.api.client.util.Preconditions.checkNotNull(mediaContent, "Required parameter mediaContent must be specified.");
        initializeMediaUpload(mediaContent);
      }

      @Override
      public Create set$Xgafv(java.lang.String $Xgafv) {
        return (Create) super.set$Xgafv($Xgafv);
      }

      @Override
      public Create setAccessToken(java.lang.String accessToken) {
        return (Create) super.setAccessToken(accessToken);
      }

      @Override
      public Create setAlt(java.lang.String alt) {
        return (Create) super.setAlt(alt);
      }

      @Override
      public Create setCallback(java.lang.String callback) {
        return (Create) super.setCallback(callback);
      }

      @Override
      public Create setFields(java.lang.String fields) {
        return (Create) super.setFields(fields);
      }

      @Override
      public Create setKey(java.lang.String key) {
        return (Create) super.setKey(key);
      }

      @Override
      public Create setOauthToken(java.lang.String oauthToken) {
        return (Create) super.setOauthToken(oauthToken);
      }

      @Override
      public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Create) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Create setQuotaUser(java.lang.String quotaUser) {
        return (Create) super.setQuotaUser(quotaUser);
      }

      @Override
      public Create setUploadType(java.lang.String uploadType) {
        return (Create) super.setUploadType(uploadType);
      }

      @Override
      public Create setUploadProtocol(java.lang.String uploadProtocol) {
        return (Create) super.setUploadProtocol(uploadProtocol);
      }

      /** Deprecated: Creating files in multiple folders is no longer supported. */
      @com.google.api.client.util.Key
      private java.lang.Boolean enforceSingleParent;

      /** Deprecated: Creating files in multiple folders is no longer supported. [default: false]
       */
      public java.lang.Boolean getEnforceSingleParent() {
        return enforceSingleParent;
      }

      /** Deprecated: Creating files in multiple folders is no longer supported. */
      public Create setEnforceSingleParent(java.lang.Boolean enforceSingleParent) {
        this.enforceSingleParent = enforceSingleParent;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Deprecated: Creating files in multiple folders is no longer supported.
       * </p>
       */
      public boolean isEnforceSingleParent() {
        if (enforceSingleParent == null || enforceSingleParent == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return enforceSingleParent;
      }

      /**
       * Whether to ignore the domain's default visibility settings for the created file. Domain
       * administrators can choose to make all uploaded files visible to the domain by default; this
       * parameter bypasses that behavior for the request. Permissions are still inherited from
       * parent folders.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean ignoreDefaultVisibility;

      /** Whether to ignore the domain's default visibility settings for the created file. Domain
     administrators can choose to make all uploaded files visible to the domain by default; this
     parameter bypasses that behavior for the request. Permissions are still inherited from parent
     folders. [default: false]
       */
      public java.lang.Boolean getIgnoreDefaultVisibility() {
        return ignoreDefaultVisibility;
      }

      /**
       * Whether to ignore the domain's default visibility settings for the created file. Domain
       * administrators can choose to make all uploaded files visible to the domain by default; this
       * parameter bypasses that behavior for the request. Permissions are still inherited from
       * parent folders.
       */
      public Create setIgnoreDefaultVisibility(java.lang.Boolean ignoreDefaultVisibility) {
        this.ignoreDefaultVisibility = ignoreDefaultVisibility;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to ignore the domain's default visibility settings for the created file. Domain
     administrators can choose to make all uploaded files visible to the domain by default; this
     parameter bypasses that behavior for the request. Permissions are still inherited from parent
     folders.
       * </p>
       */
      public boolean isIgnoreDefaultVisibility() {
        if (ignoreDefaultVisibility == null || ignoreDefaultVisibility == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return ignoreDefaultVisibility;
      }

      /**
       * A comma-separated list of IDs of labels to include in the `labelInfo` part of the response.
       */
      @com.google.api.client.util.Key
      private java.lang.String includeLabels;

      /** A comma-separated list of IDs of labels to include in the `labelInfo` part of the response.
       */
      public java.lang.String getIncludeLabels() {
        return includeLabels;
      }

      /**
       * A comma-separated list of IDs of labels to include in the `labelInfo` part of the response.
       */
      public Create setIncludeLabels(java.lang.String includeLabels) {
        this.includeLabels = includeLabels;
        return this;
      }

      /**
       * Specifies which additional view's permissions to include in the response. Only `published`
       * is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String includePermissionsForView;

      /** Specifies which additional view's permissions to include in the response. Only `published` is
     supported.
       */
      public java.lang.String getIncludePermissionsForView() {
        return includePermissionsForView;
      }

      /**
       * Specifies which additional view's permissions to include in the response. Only `published`
       * is supported.
       */
      public Create setIncludePermissionsForView(java.lang.String includePermissionsForView) {
        this.includePermissionsForView = includePermissionsForView;
        return this;
      }

      /**
       * Whether to set the `keepForever` field in the new head revision. This is only applicable to
       * files with binary content in Google Drive. Only 200 revisions for the file can be kept
       * forever. If the limit is reached, try deleting pinned revisions.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean keepRevisionForever;

      /** Whether to set the `keepForever` field in the new head revision. This is only applicable to files
     with binary content in Google Drive. Only 200 revisions for the file can be kept forever. If the
     limit is reached, try deleting pinned revisions. [default: false]
       */
      public java.lang.Boolean getKeepRevisionForever() {
        return keepRevisionForever;
      }

      /**
       * Whether to set the `keepForever` field in the new head revision. This is only applicable to
       * files with binary content in Google Drive. Only 200 revisions for the file can be kept
       * forever. If the limit is reached, try deleting pinned revisions.
       */
      public Create setKeepRevisionForever(java.lang.Boolean keepRevisionForever) {
        this.keepRevisionForever = keepRevisionForever;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to set the `keepForever` field in the new head revision. This is only applicable to files
     with binary content in Google Drive. Only 200 revisions for the file can be kept forever. If the
     limit is reached, try deleting pinned revisions.
       * </p>
       */
      public boolean isKeepRevisionForever() {
        if (keepRevisionForever == null || keepRevisionForever == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return keepRevisionForever;
      }

      /** A language hint for OCR processing during image import (ISO 639-1 code). */
      @com.google.api.client.util.Key
      private java.lang.String ocrLanguage;

      /** A language hint for OCR processing during image import (ISO 639-1 code).
       */
      public java.lang.String getOcrLanguage() {
        return ocrLanguage;
      }

      /** A language hint for OCR processing during image import (ISO 639-1 code). */
      public Create setOcrLanguage(java.lang.String ocrLanguage) {
        this.ocrLanguage = ocrLanguage;
        return this;
      }

      /** Whether the requesting application supports both My Drives and shared drives. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsAllDrives;

      /** Whether the requesting application supports both My Drives and shared drives. [default: false]
       */
      public java.lang.Boolean getSupportsAllDrives() {
        return supportsAllDrives;
      }

      /** Whether the requesting application supports both My Drives and shared drives. */
      public Create setSupportsAllDrives(java.lang.Boolean supportsAllDrives) {
        this.supportsAllDrives = supportsAllDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the requesting application supports both My Drives and shared drives.
       * </p>
       */
      public boolean isSupportsAllDrives() {
        if (supportsAllDrives == null || supportsAllDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsAllDrives;
      }

      /** Deprecated: Use `supportsAllDrives` instead. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsTeamDrives;

      /** Deprecated: Use `supportsAllDrives` instead. [default: false]
       */
      public java.lang.Boolean getSupportsTeamDrives() {
        return supportsTeamDrives;
      }

      /** Deprecated: Use `supportsAllDrives` instead. */
      public Create setSupportsTeamDrives(java.lang.Boolean supportsTeamDrives) {
        this.supportsTeamDrives = supportsTeamDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Deprecated: Use `supportsAllDrives` instead.
       * </p>
       */
      public boolean isSupportsTeamDrives() {
        if (supportsTeamDrives == null || supportsTeamDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsTeamDrives;
      }

      /** Whether to use the uploaded content as indexable text. */
      @com.google.api.client.util.Key
      private java.lang.Boolean useContentAsIndexableText;

      /** Whether to use the uploaded content as indexable text. [default: false]
       */
      public java.lang.Boolean getUseContentAsIndexableText() {
        return useContentAsIndexableText;
      }

      /** Whether to use the uploaded content as indexable text. */
      public Create setUseContentAsIndexableText(java.lang.Boolean useContentAsIndexableText) {
        this.useContentAsIndexableText = useContentAsIndexableText;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to use the uploaded content as indexable text.
       * </p>
       */
      public boolean isUseContentAsIndexableText() {
        if (useContentAsIndexableText == null || useContentAsIndexableText == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return useContentAsIndexableText;
      }

      @Override
      public Create set(String parameterName, Object value) {
        return (Create) super.set(parameterName, value);
      }
    }
    /**
     * Permanently deletes a file owned by the user without moving it to the trash. For more
     * information, see [Trash or delete files and
     * folders](https://developers.google.com/workspace/drive/api/guides/delete). If the file belongs to
     * a shared drive, the user must be an `organizer` on the parent folder. If the target is a folder,
     * all descendants owned by the user are also deleted.
     *
     * Create a request for the method "files.delete".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @return the request
     */
    public Delete delete(java.lang.String fileId) throws java.io.IOException {
      Delete result = new Delete(fileId);
      initialize(result);
      return result;
    }

    public class Delete extends DriveRequest<Void> {

      private static final String REST_PATH = "files/{fileId}";

      /**
       * Permanently deletes a file owned by the user without moving it to the trash. For more
       * information, see [Trash or delete files and
       * folders](https://developers.google.com/workspace/drive/api/guides/delete). If the file belongs
       * to a shared drive, the user must be an `organizer` on the parent folder. If the target is a
       * folder, all descendants owned by the user are also deleted.
       *
       * Create a request for the method "files.delete".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @since 1.13
       */
      protected Delete(java.lang.String fileId) {
        super(Drive.this, "DELETE", REST_PATH, null, Void.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Delete setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /**
       * Deprecated: If an item isn't in a shared drive and its last parent is deleted but the item
       * itself isn't, the item will be placed under its owner's root.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean enforceSingleParent;

      /** Deprecated: If an item isn't in a shared drive and its last parent is deleted but the item itself
     isn't, the item will be placed under its owner's root. [default: false]
       */
      public java.lang.Boolean getEnforceSingleParent() {
        return enforceSingleParent;
      }

      /**
       * Deprecated: If an item isn't in a shared drive and its last parent is deleted but the item
       * itself isn't, the item will be placed under its owner's root.
       */
      public Delete setEnforceSingleParent(java.lang.Boolean enforceSingleParent) {
        this.enforceSingleParent = enforceSingleParent;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Deprecated: If an item isn't in a shared drive and its last parent is deleted but the item itself
     isn't, the item will be placed under its owner's root.
       * </p>
       */
      public boolean isEnforceSingleParent() {
        if (enforceSingleParent == null || enforceSingleParent == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return enforceSingleParent;
      }

      /** Whether the requesting application supports both My Drives and shared drives. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsAllDrives;

      /** Whether the requesting application supports both My Drives and shared drives. [default: false]
       */
      public java.lang.Boolean getSupportsAllDrives() {
        return supportsAllDrives;
      }

      /** Whether the requesting application supports both My Drives and shared drives. */
      public Delete setSupportsAllDrives(java.lang.Boolean supportsAllDrives) {
        this.supportsAllDrives = supportsAllDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the requesting application supports both My Drives and shared drives.
       * </p>
       */
      public boolean isSupportsAllDrives() {
        if (supportsAllDrives == null || supportsAllDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsAllDrives;
      }

      /** Deprecated: Use `supportsAllDrives` instead. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsTeamDrives;

      /** Deprecated: Use `supportsAllDrives` instead. [default: false]
       */
      public java.lang.Boolean getSupportsTeamDrives() {
        return supportsTeamDrives;
      }

      /** Deprecated: Use `supportsAllDrives` instead. */
      public Delete setSupportsTeamDrives(java.lang.Boolean supportsTeamDrives) {
        this.supportsTeamDrives = supportsTeamDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Deprecated: Use `supportsAllDrives` instead.
       * </p>
       */
      public boolean isSupportsTeamDrives() {
        if (supportsTeamDrives == null || supportsTeamDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsTeamDrives;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Downloads the content of a file. For more information, see [Download and export
     * files](https://developers.google.com/workspace/drive/api/guides/manage-downloads). Operations are
     * valid for 24 hours from the time of creation.
     *
     * Create a request for the method "files.download".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Download#execute()} method to invoke the remote operation.
     *
     * @param fileId Required. The ID of the file to download.
     * @return the request
     */
    public Download download(java.lang.String fileId) throws java.io.IOException {
      Download result = new Download(fileId);
      initialize(result);
      return result;
    }

    public class Download extends DriveRequest<com.google.api.services.drive.model.Operation> {

      private static final String REST_PATH = "files/{fileId}/download";

      /**
       * Downloads the content of a file. For more information, see [Download and export
       * files](https://developers.google.com/workspace/drive/api/guides/manage-downloads). Operations
       * are valid for 24 hours from the time of creation.
       *
       * Create a request for the method "files.download".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Download#execute()} method to invoke the remote operation. <p>
       * {@link
       * Download#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId Required. The ID of the file to download.
       * @since 1.13
       */
      protected Download(java.lang.String fileId) {
        super(Drive.this, "POST", REST_PATH, null, com.google.api.services.drive.model.Operation.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }

      @Override
      public Download set$Xgafv(java.lang.String $Xgafv) {
        return (Download) super.set$Xgafv($Xgafv);
      }

      @Override
      public Download setAccessToken(java.lang.String accessToken) {
        return (Download) super.setAccessToken(accessToken);
      }

      @Override
      public Download setAlt(java.lang.String alt) {
        return (Download) super.setAlt(alt);
      }

      @Override
      public Download setCallback(java.lang.String callback) {
        return (Download) super.setCallback(callback);
      }

      @Override
      public Download setFields(java.lang.String fields) {
        return (Download) super.setFields(fields);
      }

      @Override
      public Download setKey(java.lang.String key) {
        return (Download) super.setKey(key);
      }

      @Override
      public Download setOauthToken(java.lang.String oauthToken) {
        return (Download) super.setOauthToken(oauthToken);
      }

      @Override
      public Download setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Download) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Download setQuotaUser(java.lang.String quotaUser) {
        return (Download) super.setQuotaUser(quotaUser);
      }

      @Override
      public Download setUploadType(java.lang.String uploadType) {
        return (Download) super.setUploadType(uploadType);
      }

      @Override
      public Download setUploadProtocol(java.lang.String uploadProtocol) {
        return (Download) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. The ID of the file to download. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** Required. The ID of the file to download.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** Required. The ID of the file to download. */
      public Download setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /**
       * Optional. The MIME type the file should be downloaded as. This field can only be set when
       * downloading Google Workspace documents. For a list of supported MIME types, see [Export
       * MIME types for Google Workspace documents](/workspace/drive/api/guides/ref-export-formats).
       * If not set, a Google Workspace document is downloaded with a default MIME type. The default
       * MIME type might change in the future.
       */
      @com.google.api.client.util.Key
      private java.lang.String mimeType;

      /** Optional. The MIME type the file should be downloaded as. This field can only be set when
     downloading Google Workspace documents. For a list of supported MIME types, see [Export MIME types
     for Google Workspace documents](/workspace/drive/api/guides/ref-export-formats). If not set, a
     Google Workspace document is downloaded with a default MIME type. The default MIME type might
     change in the future.
       */
      public java.lang.String getMimeType() {
        return mimeType;
      }

      /**
       * Optional. The MIME type the file should be downloaded as. This field can only be set when
       * downloading Google Workspace documents. For a list of supported MIME types, see [Export
       * MIME types for Google Workspace documents](/workspace/drive/api/guides/ref-export-formats).
       * If not set, a Google Workspace document is downloaded with a default MIME type. The default
       * MIME type might change in the future.
       */
      public Download setMimeType(java.lang.String mimeType) {
        this.mimeType = mimeType;
        return this;
      }

      /**
       * Optional. The revision ID of the file to download. This field can only be set when
       * downloading blob files, Google Docs, and Google Sheets. Returns `INVALID_ARGUMENT` if
       * downloading a specific revision on the file is unsupported.
       */
      @com.google.api.client.util.Key
      private java.lang.String revisionId;

      /** Optional. The revision ID of the file to download. This field can only be set when downloading blob
     files, Google Docs, and Google Sheets. Returns `INVALID_ARGUMENT` if downloading a specific
     revision on the file is unsupported.
       */
      public java.lang.String getRevisionId() {
        return revisionId;
      }

      /**
       * Optional. The revision ID of the file to download. This field can only be set when
       * downloading blob files, Google Docs, and Google Sheets. Returns `INVALID_ARGUMENT` if
       * downloading a specific revision on the file is unsupported.
       */
      public Download setRevisionId(java.lang.String revisionId) {
        this.revisionId = revisionId;
        return this;
      }

      @Override
      public Download set(String parameterName, Object value) {
        return (Download) super.set(parameterName, value);
      }
    }
    /**
     * Permanently deletes all of the user's trashed files. For more information, see [Trash or delete
     * files and folders](https://developers.google.com/workspace/drive/api/guides/delete).
     *
     * Create a request for the method "files.emptyTrash".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link EmptyTrash#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public EmptyTrash emptyTrash() throws java.io.IOException {
      EmptyTrash result = new EmptyTrash();
      initialize(result);
      return result;
    }

    public class EmptyTrash extends DriveRequest<Void> {

      private static final String REST_PATH = "files/trash";

      /**
       * Permanently deletes all of the user's trashed files. For more information, see [Trash or delete
       * files and folders](https://developers.google.com/workspace/drive/api/guides/delete).
       *
       * Create a request for the method "files.emptyTrash".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link EmptyTrash#execute()} method to invoke the remote operation. <p>
       * {@link
       * EmptyTrash#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected EmptyTrash() {
        super(Drive.this, "DELETE", REST_PATH, null, Void.class);
      }

      @Override
      public EmptyTrash set$Xgafv(java.lang.String $Xgafv) {
        return (EmptyTrash) super.set$Xgafv($Xgafv);
      }

      @Override
      public EmptyTrash setAccessToken(java.lang.String accessToken) {
        return (EmptyTrash) super.setAccessToken(accessToken);
      }

      @Override
      public EmptyTrash setAlt(java.lang.String alt) {
        return (EmptyTrash) super.setAlt(alt);
      }

      @Override
      public EmptyTrash setCallback(java.lang.String callback) {
        return (EmptyTrash) super.setCallback(callback);
      }

      @Override
      public EmptyTrash setFields(java.lang.String fields) {
        return (EmptyTrash) super.setFields(fields);
      }

      @Override
      public EmptyTrash setKey(java.lang.String key) {
        return (EmptyTrash) super.setKey(key);
      }

      @Override
      public EmptyTrash setOauthToken(java.lang.String oauthToken) {
        return (EmptyTrash) super.setOauthToken(oauthToken);
      }

      @Override
      public EmptyTrash setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (EmptyTrash) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public EmptyTrash setQuotaUser(java.lang.String quotaUser) {
        return (EmptyTrash) super.setQuotaUser(quotaUser);
      }

      @Override
      public EmptyTrash setUploadType(java.lang.String uploadType) {
        return (EmptyTrash) super.setUploadType(uploadType);
      }

      @Override
      public EmptyTrash setUploadProtocol(java.lang.String uploadProtocol) {
        return (EmptyTrash) super.setUploadProtocol(uploadProtocol);
      }

      /** If set, empties the trash of the provided shared drive. */
      @com.google.api.client.util.Key
      private java.lang.String driveId;

      /** If set, empties the trash of the provided shared drive.
       */
      public java.lang.String getDriveId() {
        return driveId;
      }

      /** If set, empties the trash of the provided shared drive. */
      public EmptyTrash setDriveId(java.lang.String driveId) {
        this.driveId = driveId;
        return this;
      }

      /**
       * Deprecated: If an item isn't in a shared drive and its last parent is deleted but the item
       * itself isn't, the item will be placed under its owner's root.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean enforceSingleParent;

      /** Deprecated: If an item isn't in a shared drive and its last parent is deleted but the item itself
     isn't, the item will be placed under its owner's root. [default: false]
       */
      public java.lang.Boolean getEnforceSingleParent() {
        return enforceSingleParent;
      }

      /**
       * Deprecated: If an item isn't in a shared drive and its last parent is deleted but the item
       * itself isn't, the item will be placed under its owner's root.
       */
      public EmptyTrash setEnforceSingleParent(java.lang.Boolean enforceSingleParent) {
        this.enforceSingleParent = enforceSingleParent;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Deprecated: If an item isn't in a shared drive and its last parent is deleted but the item itself
     isn't, the item will be placed under its owner's root.
       * </p>
       */
      public boolean isEnforceSingleParent() {
        if (enforceSingleParent == null || enforceSingleParent == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return enforceSingleParent;
      }

      @Override
      public EmptyTrash set(String parameterName, Object value) {
        return (EmptyTrash) super.set(parameterName, value);
      }
    }
    /**
     * Exports a Google Workspace document to the requested MIME type and returns exported byte content.
     * For more information, see [Download and export
     * files](https://developers.google.com/workspace/drive/api/guides/manage-downloads). Note that the
     * exported content is limited to 10 MB.
     *
     * Create a request for the method "files.export".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Export#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param mimeType Required. The MIME type of the format requested for this export. For a list of supported MIME types,
     *        see [Export MIME types for Google Workspace documents](/workspace/drive/api/guides/ref-
     *        export-formats).
     * @return the request
     */
    public Export export(java.lang.String fileId, java.lang.String mimeType) throws java.io.IOException {
      Export result = new Export(fileId, mimeType);
      initialize(result);
      return result;
    }

    public class Export extends DriveRequest<Void> {

      private static final String REST_PATH = "files/{fileId}/export";

      /**
       * Exports a Google Workspace document to the requested MIME type and returns exported byte
       * content. For more information, see [Download and export
       * files](https://developers.google.com/workspace/drive/api/guides/manage-downloads). Note that
       * the exported content is limited to 10 MB.
       *
       * Create a request for the method "files.export".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Export#execute()} method to invoke the remote operation. <p> {@link
       * Export#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param mimeType Required. The MIME type of the format requested for this export. For a list of supported MIME types,
     *        see [Export MIME types for Google Workspace documents](/workspace/drive/api/guides/ref-
     *        export-formats).
       * @since 1.13
       */
      protected Export(java.lang.String fileId, java.lang.String mimeType) {
        super(Drive.this, "GET", REST_PATH, null, Void.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.mimeType = com.google.api.client.util.Preconditions.checkNotNull(mimeType, "Required parameter mimeType must be specified.");
        initializeMediaDownload();
      }

      @Override
      public void executeMediaAndDownloadTo(java.io.OutputStream outputStream) throws java.io.IOException {
        super.executeMediaAndDownloadTo(outputStream);
      }

      @Override
      public java.io.InputStream executeMediaAsInputStream() throws java.io.IOException {
        return super.executeMediaAsInputStream();
      }

      @Override
      public com.google.api.client.http.HttpResponse executeMedia() throws java.io.IOException {
        return super.executeMedia();
      }

      @Override
      public com.google.api.client.http.GenericUrl buildHttpRequestUrl() {
        java.lang.String baseUrl = ("media".equals(get("alt")) && getMediaHttpUploader() == null)
            ? getRootUrl() + "download/" + getServicePath() : getBaseUrl();
        return new com.google.api.client.http.GenericUrl(
            com.google.api.client.http.UriTemplate.expand(baseUrl, getUriTemplate(), this, true));
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Export set$Xgafv(java.lang.String $Xgafv) {
        return (Export) super.set$Xgafv($Xgafv);
      }

      @Override
      public Export setAccessToken(java.lang.String accessToken) {
        return (Export) super.setAccessToken(accessToken);
      }

      @Override
      public Export setAlt(java.lang.String alt) {
        return (Export) super.setAlt(alt);
      }

      @Override
      public Export setCallback(java.lang.String callback) {
        return (Export) super.setCallback(callback);
      }

      @Override
      public Export setFields(java.lang.String fields) {
        return (Export) super.setFields(fields);
      }

      @Override
      public Export setKey(java.lang.String key) {
        return (Export) super.setKey(key);
      }

      @Override
      public Export setOauthToken(java.lang.String oauthToken) {
        return (Export) super.setOauthToken(oauthToken);
      }

      @Override
      public Export setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Export) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Export setQuotaUser(java.lang.String quotaUser) {
        return (Export) super.setQuotaUser(quotaUser);
      }

      @Override
      public Export setUploadType(java.lang.String uploadType) {
        return (Export) super.setUploadType(uploadType);
      }

      @Override
      public Export setUploadProtocol(java.lang.String uploadProtocol) {
        return (Export) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Export setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /**
       * Required. The MIME type of the format requested for this export. For a list of supported
       * MIME types, see [Export MIME types for Google Workspace
       * documents](/workspace/drive/api/guides/ref-export-formats).
       */
      @com.google.api.client.util.Key
      private java.lang.String mimeType;

      /** Required. The MIME type of the format requested for this export. For a list of supported MIME
     types, see [Export MIME types for Google Workspace documents](/workspace/drive/api/guides/ref-
     export-formats).
       */
      public java.lang.String getMimeType() {
        return mimeType;
      }

      /**
       * Required. The MIME type of the format requested for this export. For a list of supported
       * MIME types, see [Export MIME types for Google Workspace
       * documents](/workspace/drive/api/guides/ref-export-formats).
       */
      public Export setMimeType(java.lang.String mimeType) {
        this.mimeType = mimeType;
        return this;
      }

      @Override
      public Export set(String parameterName, Object value) {
        return (Export) super.set(parameterName, value);
      }
    }
    /**
     * Generates a set of file IDs which can be provided in create or copy requests. For more
     * information, see [Create and manage
     * files](https://developers.google.com/workspace/drive/api/guides/create-file).
     *
     * Create a request for the method "files.generateIds".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link GenerateIds#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public GenerateIds generateIds() throws java.io.IOException {
      GenerateIds result = new GenerateIds();
      initialize(result);
      return result;
    }

    public class GenerateIds extends DriveRequest<com.google.api.services.drive.model.GeneratedIds> {

      private static final String REST_PATH = "files/generateIds";

      /**
       * Generates a set of file IDs which can be provided in create or copy requests. For more
       * information, see [Create and manage
       * files](https://developers.google.com/workspace/drive/api/guides/create-file).
       *
       * Create a request for the method "files.generateIds".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link GenerateIds#execute()} method to invoke the remote operation. <p>
       * {@link
       * GenerateIds#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected GenerateIds() {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.GeneratedIds.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GenerateIds set$Xgafv(java.lang.String $Xgafv) {
        return (GenerateIds) super.set$Xgafv($Xgafv);
      }

      @Override
      public GenerateIds setAccessToken(java.lang.String accessToken) {
        return (GenerateIds) super.setAccessToken(accessToken);
      }

      @Override
      public GenerateIds setAlt(java.lang.String alt) {
        return (GenerateIds) super.setAlt(alt);
      }

      @Override
      public GenerateIds setCallback(java.lang.String callback) {
        return (GenerateIds) super.setCallback(callback);
      }

      @Override
      public GenerateIds setFields(java.lang.String fields) {
        return (GenerateIds) super.setFields(fields);
      }

      @Override
      public GenerateIds setKey(java.lang.String key) {
        return (GenerateIds) super.setKey(key);
      }

      @Override
      public GenerateIds setOauthToken(java.lang.String oauthToken) {
        return (GenerateIds) super.setOauthToken(oauthToken);
      }

      @Override
      public GenerateIds setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GenerateIds) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GenerateIds setQuotaUser(java.lang.String quotaUser) {
        return (GenerateIds) super.setQuotaUser(quotaUser);
      }

      @Override
      public GenerateIds setUploadType(java.lang.String uploadType) {
        return (GenerateIds) super.setUploadType(uploadType);
      }

      @Override
      public GenerateIds setUploadProtocol(java.lang.String uploadProtocol) {
        return (GenerateIds) super.setUploadProtocol(uploadProtocol);
      }

      /** The number of IDs to return. */
      @com.google.api.client.util.Key
      private java.lang.Integer count;

      /** The number of IDs to return. [default: 10] [minimum: 1] [maximum: 1000]
       */
      public java.lang.Integer getCount() {
        return count;
      }

      /** The number of IDs to return. */
      public GenerateIds setCount(java.lang.Integer count) {
        this.count = count;
        return this;
      }

      /**
       * The space in which the IDs can be used to create files. Supported values are `drive` and
       * `appDataFolder`. (Default: `drive`.) For more information, see [File
       * organization](https://developers.google.com/workspace/drive/api/guides/about-files#file-
       * organization).
       */
      @com.google.api.client.util.Key
      private java.lang.String space;

      /** The space in which the IDs can be used to create files. Supported values are `drive` and
     `appDataFolder`. (Default: `drive`.) For more information, see [File
     organization](https://developers.google.com/workspace/drive/api/guides/about-files#file-
     organization). [default: drive]
       */
      public java.lang.String getSpace() {
        return space;
      }

      /**
       * The space in which the IDs can be used to create files. Supported values are `drive` and
       * `appDataFolder`. (Default: `drive`.) For more information, see [File
       * organization](https://developers.google.com/workspace/drive/api/guides/about-files#file-
       * organization).
       */
      public GenerateIds setSpace(java.lang.String space) {
        this.space = space;
        return this;
      }

      /**
       * The type of items which the IDs can be used for. Supported values are `files` and
       * `shortcuts`. Note that `shortcuts` are only supported in the `drive` `space`. (Default:
       * `files`.) For more information, see [File
       * organization](https://developers.google.com/workspace/drive/api/guides/about-files#file-
       * organization).
       */
      @com.google.api.client.util.Key
      private java.lang.String type;

      /** The type of items which the IDs can be used for. Supported values are `files` and `shortcuts`. Note
     that `shortcuts` are only supported in the `drive` `space`. (Default: `files`.) For more
     information, see [File
     organization](https://developers.google.com/workspace/drive/api/guides/about-files#file-
     organization). [default: files]
       */
      public java.lang.String getType() {
        return type;
      }

      /**
       * The type of items which the IDs can be used for. Supported values are `files` and
       * `shortcuts`. Note that `shortcuts` are only supported in the `drive` `space`. (Default:
       * `files`.) For more information, see [File
       * organization](https://developers.google.com/workspace/drive/api/guides/about-files#file-
       * organization).
       */
      public GenerateIds setType(java.lang.String type) {
        this.type = type;
        return this;
      }

      @Override
      public GenerateIds set(String parameterName, Object value) {
        return (GenerateIds) super.set(parameterName, value);
      }
    }
    /**
     * Gets a file's metadata or content by ID. For more information, see [Search for files and
     * folders](/workspace/drive/api/guides/search-files). If you provide the URL parameter `alt=media`,
     * then the response includes the file contents in the response body. Downloading content with
     * `alt=media` only works if the file is stored in Drive. To download Google Docs, Sheets, and
     * Slides use [`files.export`](/workspace/drive/api/reference/rest/v3/files/export) instead. For
     * more information, see [Download and export files](/workspace/drive/api/guides/manage-downloads).
     *
     * Create a request for the method "files.get".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @return the request
     */
    public Get get(java.lang.String fileId) throws java.io.IOException {
      Get result = new Get(fileId);
      initialize(result);
      return result;
    }

    public class Get extends DriveRequest<com.google.api.services.drive.model.File> {

      private static final String REST_PATH = "files/{fileId}";

      /**
       * Gets a file's metadata or content by ID. For more information, see [Search for files and
       * folders](/workspace/drive/api/guides/search-files). If you provide the URL parameter
       * `alt=media`, then the response includes the file contents in the response body. Downloading
       * content with `alt=media` only works if the file is stored in Drive. To download Google Docs,
       * Sheets, and Slides use [`files.export`](/workspace/drive/api/reference/rest/v3/files/export)
       * instead. For more information, see [Download and export
       * files](/workspace/drive/api/guides/manage-downloads).
       *
       * Create a request for the method "files.get".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @since 1.13
       */
      protected Get(java.lang.String fileId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.File.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        initializeMediaDownload();
      }

      @Override
      public void executeMediaAndDownloadTo(java.io.OutputStream outputStream) throws java.io.IOException {
        super.executeMediaAndDownloadTo(outputStream);
      }

      @Override
      public java.io.InputStream executeMediaAsInputStream() throws java.io.IOException {
        return super.executeMediaAsInputStream();
      }

      @Override
      public com.google.api.client.http.HttpResponse executeMedia() throws java.io.IOException {
        return super.executeMedia();
      }

      @Override
      public com.google.api.client.http.GenericUrl buildHttpRequestUrl() {
        java.lang.String baseUrl = ("media".equals(get("alt")) && getMediaHttpUploader() == null)
            ? getRootUrl() + "download/" + getServicePath() : getBaseUrl();
        return new com.google.api.client.http.GenericUrl(
            com.google.api.client.http.UriTemplate.expand(baseUrl, getUriTemplate(), this, true));
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Get setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /**
       * Whether the user is acknowledging the risk of downloading known malware or other abusive
       * files. This is only applicable when the `alt` parameter is set to `media` and the user is
       * the owner of the file or an organizer of the shared drive in which the file resides.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean acknowledgeAbuse;

      /** Whether the user is acknowledging the risk of downloading known malware or other abusive files.
     This is only applicable when the `alt` parameter is set to `media` and the user is the owner of the
     file or an organizer of the shared drive in which the file resides. [default: false]
       */
      public java.lang.Boolean getAcknowledgeAbuse() {
        return acknowledgeAbuse;
      }

      /**
       * Whether the user is acknowledging the risk of downloading known malware or other abusive
       * files. This is only applicable when the `alt` parameter is set to `media` and the user is
       * the owner of the file or an organizer of the shared drive in which the file resides.
       */
      public Get setAcknowledgeAbuse(java.lang.Boolean acknowledgeAbuse) {
        this.acknowledgeAbuse = acknowledgeAbuse;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the user is acknowledging the risk of downloading known malware or other abusive files.
     This is only applicable when the `alt` parameter is set to `media` and the user is the owner of the
     file or an organizer of the shared drive in which the file resides.
       * </p>
       */
      public boolean isAcknowledgeAbuse() {
        if (acknowledgeAbuse == null || acknowledgeAbuse == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return acknowledgeAbuse;
      }

      /**
       * A comma-separated list of IDs of labels to include in the `labelInfo` part of the response.
       */
      @com.google.api.client.util.Key
      private java.lang.String includeLabels;

      /** A comma-separated list of IDs of labels to include in the `labelInfo` part of the response.
       */
      public java.lang.String getIncludeLabels() {
        return includeLabels;
      }

      /**
       * A comma-separated list of IDs of labels to include in the `labelInfo` part of the response.
       */
      public Get setIncludeLabels(java.lang.String includeLabels) {
        this.includeLabels = includeLabels;
        return this;
      }

      /**
       * Specifies which additional view's permissions to include in the response. Only `published`
       * is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String includePermissionsForView;

      /** Specifies which additional view's permissions to include in the response. Only `published` is
     supported.
       */
      public java.lang.String getIncludePermissionsForView() {
        return includePermissionsForView;
      }

      /**
       * Specifies which additional view's permissions to include in the response. Only `published`
       * is supported.
       */
      public Get setIncludePermissionsForView(java.lang.String includePermissionsForView) {
        this.includePermissionsForView = includePermissionsForView;
        return this;
      }

      /** Whether the requesting application supports both My Drives and shared drives. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsAllDrives;

      /** Whether the requesting application supports both My Drives and shared drives. [default: false]
       */
      public java.lang.Boolean getSupportsAllDrives() {
        return supportsAllDrives;
      }

      /** Whether the requesting application supports both My Drives and shared drives. */
      public Get setSupportsAllDrives(java.lang.Boolean supportsAllDrives) {
        this.supportsAllDrives = supportsAllDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the requesting application supports both My Drives and shared drives.
       * </p>
       */
      public boolean isSupportsAllDrives() {
        if (supportsAllDrives == null || supportsAllDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsAllDrives;
      }

      /** Deprecated: Use `supportsAllDrives` instead. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsTeamDrives;

      /** Deprecated: Use `supportsAllDrives` instead. [default: false]
       */
      public java.lang.Boolean getSupportsTeamDrives() {
        return supportsTeamDrives;
      }

      /** Deprecated: Use `supportsAllDrives` instead. */
      public Get setSupportsTeamDrives(java.lang.Boolean supportsTeamDrives) {
        this.supportsTeamDrives = supportsTeamDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Deprecated: Use `supportsAllDrives` instead.
       * </p>
       */
      public boolean isSupportsTeamDrives() {
        if (supportsTeamDrives == null || supportsTeamDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsTeamDrives;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Lists the user's files. For more information, see [Search for files and
     * folders](/workspace/drive/api/guides/search-files). This method accepts the `q` parameter, which
     * is a search query combining one or more search terms. This method returns *all* files by default,
     * including trashed files. If you don't want trashed files to appear in the list, use the
     * `trashed=false` query parameter to remove trashed files from the results.
     *
     * Create a request for the method "files.list".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends DriveRequest<com.google.api.services.drive.model.FileList> {

      private static final String REST_PATH = "files";

      /**
       * Lists the user's files. For more information, see [Search for files and
       * folders](/workspace/drive/api/guides/search-files). This method accepts the `q` parameter,
       * which is a search query combining one or more search terms. This method returns *all* files by
       * default, including trashed files. If you don't want trashed files to appear in the list, use
       * the `trashed=false` query parameter to remove trashed files from the results.
       *
       * Create a request for the method "files.list".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.FileList.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Bodies of items (files or documents) to which the query applies. Supported bodies are: *
       * `user` * `domain` * `drive` * `allDrives` Prefer `user` or `drive` to `allDrives` for
       * efficiency. By default, corpora is set to `user`. However, this can change depending on the
       * filter set through the `q` parameter. For more information, see [File
       * organization](https://developers.google.com/workspace/drive/api/guides/about-files#file-
       * organization).
       */
      @com.google.api.client.util.Key
      private java.lang.String corpora;

      /** Bodies of items (files or documents) to which the query applies. Supported bodies are: * `user` *
     `domain` * `drive` * `allDrives` Prefer `user` or `drive` to `allDrives` for efficiency. By
     default, corpora is set to `user`. However, this can change depending on the filter set through the
     `q` parameter. For more information, see [File
     organization](https://developers.google.com/workspace/drive/api/guides/about-files#file-
     organization).
       */
      public java.lang.String getCorpora() {
        return corpora;
      }

      /**
       * Bodies of items (files or documents) to which the query applies. Supported bodies are: *
       * `user` * `domain` * `drive` * `allDrives` Prefer `user` or `drive` to `allDrives` for
       * efficiency. By default, corpora is set to `user`. However, this can change depending on the
       * filter set through the `q` parameter. For more information, see [File
       * organization](https://developers.google.com/workspace/drive/api/guides/about-files#file-
       * organization).
       */
      public List setCorpora(java.lang.String corpora) {
        this.corpora = corpora;
        return this;
      }

      /** Deprecated: The source of files to list. Use `corpora` instead. */
      @com.google.api.client.util.Key
      private java.lang.String corpus;

      /** Deprecated: The source of files to list. Use `corpora` instead.
       */
      public java.lang.String getCorpus() {
        return corpus;
      }

      /** Deprecated: The source of files to list. Use `corpora` instead. */
      public List setCorpus(java.lang.String corpus) {
        this.corpus = corpus;
        return this;
      }

      /** ID of the shared drive to search. */
      @com.google.api.client.util.Key
      private java.lang.String driveId;

      /** ID of the shared drive to search.
       */
      public java.lang.String getDriveId() {
        return driveId;
      }

      /** ID of the shared drive to search. */
      public List setDriveId(java.lang.String driveId) {
        this.driveId = driveId;
        return this;
      }

      /** Whether both My Drive and shared drive items should be included in results. */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeItemsFromAllDrives;

      /** Whether both My Drive and shared drive items should be included in results. [default: false]
       */
      public java.lang.Boolean getIncludeItemsFromAllDrives() {
        return includeItemsFromAllDrives;
      }

      /** Whether both My Drive and shared drive items should be included in results. */
      public List setIncludeItemsFromAllDrives(java.lang.Boolean includeItemsFromAllDrives) {
        this.includeItemsFromAllDrives = includeItemsFromAllDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether both My Drive and shared drive items should be included in results.
       * </p>
       */
      public boolean isIncludeItemsFromAllDrives() {
        if (includeItemsFromAllDrives == null || includeItemsFromAllDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return includeItemsFromAllDrives;
      }

      /**
       * A comma-separated list of IDs of labels to include in the `labelInfo` part of the response.
       */
      @com.google.api.client.util.Key
      private java.lang.String includeLabels;

      /** A comma-separated list of IDs of labels to include in the `labelInfo` part of the response.
       */
      public java.lang.String getIncludeLabels() {
        return includeLabels;
      }

      /**
       * A comma-separated list of IDs of labels to include in the `labelInfo` part of the response.
       */
      public List setIncludeLabels(java.lang.String includeLabels) {
        this.includeLabels = includeLabels;
        return this;
      }

      /**
       * Specifies which additional view's permissions to include in the response. Only `published`
       * is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String includePermissionsForView;

      /** Specifies which additional view's permissions to include in the response. Only `published` is
     supported.
       */
      public java.lang.String getIncludePermissionsForView() {
        return includePermissionsForView;
      }

      /**
       * Specifies which additional view's permissions to include in the response. Only `published`
       * is supported.
       */
      public List setIncludePermissionsForView(java.lang.String includePermissionsForView) {
        this.includePermissionsForView = includePermissionsForView;
        return this;
      }

      /** Deprecated: Use `includeItemsFromAllDrives` instead. */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeTeamDriveItems;

      /** Deprecated: Use `includeItemsFromAllDrives` instead. [default: false]
       */
      public java.lang.Boolean getIncludeTeamDriveItems() {
        return includeTeamDriveItems;
      }

      /** Deprecated: Use `includeItemsFromAllDrives` instead. */
      public List setIncludeTeamDriveItems(java.lang.Boolean includeTeamDriveItems) {
        this.includeTeamDriveItems = includeTeamDriveItems;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Deprecated: Use `includeItemsFromAllDrives` instead.
       * </p>
       */
      public boolean isIncludeTeamDriveItems() {
        if (includeTeamDriveItems == null || includeTeamDriveItems == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return includeTeamDriveItems;
      }

      /**
       * A comma-separated list of sort keys. Valid keys are: * `createdTime`: When the file was
       * created. * `folder`: The folder ID. This field is sorted using alphabetical ordering. *
       * `modifiedByMeTime`: The last time the file was modified by the user. * `modifiedTime`: The
       * last time the file was modified by anyone. * `name`: The name of the file. This field is
       * sorted using alphabetical ordering, so 1, 12, 2, 22. * `name_natural`: The name of the
       * file. This field is sorted using natural sort ordering, so 1, 2, 12, 22. *
       * `quotaBytesUsed`: The number of storage quota bytes used by the file. * `recency`: The most
       * recent timestamp from the file's date-time fields. * `sharedWithMeTime`: When the file was
       * shared with the user, if applicable. * `starred`: Whether the user has starred the file. *
       * `viewedByMeTime`: The last time the file was viewed by the user. Each key sorts ascending
       * by default, but can be reversed with the `desc` modifier. Example usage:
       * `?orderBy=folder,modifiedTime desc,name`.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** A comma-separated list of sort keys. Valid keys are: * `createdTime`: When the file was created. *
     `folder`: The folder ID. This field is sorted using alphabetical ordering. * `modifiedByMeTime`:
     The last time the file was modified by the user. * `modifiedTime`: The last time the file was
     modified by anyone. * `name`: The name of the file. This field is sorted using alphabetical
     ordering, so 1, 12, 2, 22. * `name_natural`: The name of the file. This field is sorted using
     natural sort ordering, so 1, 2, 12, 22. * `quotaBytesUsed`: The number of storage quota bytes used
     by the file. * `recency`: The most recent timestamp from the file's date-time fields. *
     `sharedWithMeTime`: When the file was shared with the user, if applicable. * `starred`: Whether the
     user has starred the file. * `viewedByMeTime`: The last time the file was viewed by the user. Each
     key sorts ascending by default, but can be reversed with the `desc` modifier. Example usage:
     `?orderBy=folder,modifiedTime desc,name`.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * A comma-separated list of sort keys. Valid keys are: * `createdTime`: When the file was
       * created. * `folder`: The folder ID. This field is sorted using alphabetical ordering. *
       * `modifiedByMeTime`: The last time the file was modified by the user. * `modifiedTime`: The
       * last time the file was modified by anyone. * `name`: The name of the file. This field is
       * sorted using alphabetical ordering, so 1, 12, 2, 22. * `name_natural`: The name of the
       * file. This field is sorted using natural sort ordering, so 1, 2, 12, 22. *
       * `quotaBytesUsed`: The number of storage quota bytes used by the file. * `recency`: The most
       * recent timestamp from the file's date-time fields. * `sharedWithMeTime`: When the file was
       * shared with the user, if applicable. * `starred`: Whether the user has starred the file. *
       * `viewedByMeTime`: The last time the file was viewed by the user. Each key sorts ascending
       * by default, but can be reversed with the `desc` modifier. Example usage:
       * `?orderBy=folder,modifiedTime desc,name`.
       */
      public List setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * The maximum number of files to return per page. Partial or empty result pages are possible
       * even before the end of the files list has been reached.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** The maximum number of files to return per page. Partial or empty result pages are possible even
     before the end of the files list has been reached. [default: 100] [minimum: 1] [maximum: 1000]
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /**
       * The maximum number of files to return per page. Partial or empty result pages are possible
       * even before the end of the files list has been reached.
       */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /**
       * The token for continuing a previous list request on the next page. This should be set to
       * the value of `nextPageToken` from the previous response.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The token for continuing a previous list request on the next page. This should be set to the value
     of `nextPageToken` from the previous response.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The token for continuing a previous list request on the next page. This should be set to
       * the value of `nextPageToken` from the previous response.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * A query for filtering the file results. For supported syntax, see [Search for files and
       * folders](/workspace/drive/api/guides/search-files).
       */
      @com.google.api.client.util.Key
      private java.lang.String q;

      /** A query for filtering the file results. For supported syntax, see [Search for files and
     folders](/workspace/drive/api/guides/search-files).
       */
      public java.lang.String getQ() {
        return q;
      }

      /**
       * A query for filtering the file results. For supported syntax, see [Search for files and
       * folders](/workspace/drive/api/guides/search-files).
       */
      public List setQ(java.lang.String q) {
        this.q = q;
        return this;
      }

      /**
       * A comma-separated list of spaces to query within the corpora. Supported values are `drive`
       * and `appDataFolder`. For more information, see [File
       * organization](https://developers.google.com/workspace/drive/api/guides/about-files#file-
       * organization).
       */
      @com.google.api.client.util.Key
      private java.lang.String spaces;

      /** A comma-separated list of spaces to query within the corpora. Supported values are `drive` and
     `appDataFolder`. For more information, see [File
     organization](https://developers.google.com/workspace/drive/api/guides/about-files#file-
     organization). [default: drive]
       */
      public java.lang.String getSpaces() {
        return spaces;
      }

      /**
       * A comma-separated list of spaces to query within the corpora. Supported values are `drive`
       * and `appDataFolder`. For more information, see [File
       * organization](https://developers.google.com/workspace/drive/api/guides/about-files#file-
       * organization).
       */
      public List setSpaces(java.lang.String spaces) {
        this.spaces = spaces;
        return this;
      }

      /** Whether the requesting application supports both My Drives and shared drives. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsAllDrives;

      /** Whether the requesting application supports both My Drives and shared drives. [default: false]
       */
      public java.lang.Boolean getSupportsAllDrives() {
        return supportsAllDrives;
      }

      /** Whether the requesting application supports both My Drives and shared drives. */
      public List setSupportsAllDrives(java.lang.Boolean supportsAllDrives) {
        this.supportsAllDrives = supportsAllDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the requesting application supports both My Drives and shared drives.
       * </p>
       */
      public boolean isSupportsAllDrives() {
        if (supportsAllDrives == null || supportsAllDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsAllDrives;
      }

      /** Deprecated: Use `supportsAllDrives` instead. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsTeamDrives;

      /** Deprecated: Use `supportsAllDrives` instead. [default: false]
       */
      public java.lang.Boolean getSupportsTeamDrives() {
        return supportsTeamDrives;
      }

      /** Deprecated: Use `supportsAllDrives` instead. */
      public List setSupportsTeamDrives(java.lang.Boolean supportsTeamDrives) {
        this.supportsTeamDrives = supportsTeamDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Deprecated: Use `supportsAllDrives` instead.
       * </p>
       */
      public boolean isSupportsTeamDrives() {
        if (supportsTeamDrives == null || supportsTeamDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsTeamDrives;
      }

      /** Deprecated: Use `driveId` instead. */
      @com.google.api.client.util.Key
      private java.lang.String teamDriveId;

      /** Deprecated: Use `driveId` instead.
       */
      public java.lang.String getTeamDriveId() {
        return teamDriveId;
      }

      /** Deprecated: Use `driveId` instead. */
      public List setTeamDriveId(java.lang.String teamDriveId) {
        this.teamDriveId = teamDriveId;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Lists the labels on a file. For more information, see [List labels on a
     * file](https://developers.google.com/workspace/drive/api/guides/list-labels).
     *
     * Create a request for the method "files.listLabels".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link ListLabels#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID for the file.
     * @return the request
     */
    public ListLabels listLabels(java.lang.String fileId) throws java.io.IOException {
      ListLabels result = new ListLabels(fileId);
      initialize(result);
      return result;
    }

    public class ListLabels extends DriveRequest<com.google.api.services.drive.model.LabelList> {

      private static final String REST_PATH = "files/{fileId}/listLabels";

      /**
       * Lists the labels on a file. For more information, see [List labels on a
       * file](https://developers.google.com/workspace/drive/api/guides/list-labels).
       *
       * Create a request for the method "files.listLabels".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link ListLabels#execute()} method to invoke the remote operation. <p>
       * {@link
       * ListLabels#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID for the file.
       * @since 1.13
       */
      protected ListLabels(java.lang.String fileId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.LabelList.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public ListLabels set$Xgafv(java.lang.String $Xgafv) {
        return (ListLabels) super.set$Xgafv($Xgafv);
      }

      @Override
      public ListLabels setAccessToken(java.lang.String accessToken) {
        return (ListLabels) super.setAccessToken(accessToken);
      }

      @Override
      public ListLabels setAlt(java.lang.String alt) {
        return (ListLabels) super.setAlt(alt);
      }

      @Override
      public ListLabels setCallback(java.lang.String callback) {
        return (ListLabels) super.setCallback(callback);
      }

      @Override
      public ListLabels setFields(java.lang.String fields) {
        return (ListLabels) super.setFields(fields);
      }

      @Override
      public ListLabels setKey(java.lang.String key) {
        return (ListLabels) super.setKey(key);
      }

      @Override
      public ListLabels setOauthToken(java.lang.String oauthToken) {
        return (ListLabels) super.setOauthToken(oauthToken);
      }

      @Override
      public ListLabels setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ListLabels) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ListLabels setQuotaUser(java.lang.String quotaUser) {
        return (ListLabels) super.setQuotaUser(quotaUser);
      }

      @Override
      public ListLabels setUploadType(java.lang.String uploadType) {
        return (ListLabels) super.setUploadType(uploadType);
      }

      @Override
      public ListLabels setUploadProtocol(java.lang.String uploadProtocol) {
        return (ListLabels) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID for the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID for the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID for the file. */
      public ListLabels setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The maximum number of labels to return per page. When not set, defaults to 100. */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** The maximum number of labels to return per page. When not set, defaults to 100. [default: 100]
     [minimum: 1] [maximum: 100]
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /** The maximum number of labels to return per page. When not set, defaults to 100. */
      public ListLabels setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * The token for continuing a previous list request on the next page. This should be set to
       * the value of `nextPageToken` from the previous response.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The token for continuing a previous list request on the next page. This should be set to the value
     of `nextPageToken` from the previous response.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The token for continuing a previous list request on the next page. This should be set to
       * the value of `nextPageToken` from the previous response.
       */
      public ListLabels setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public ListLabels set(String parameterName, Object value) {
        return (ListLabels) super.set(parameterName, value);
      }
    }
    /**
     * Modifies the set of labels applied to a file. For more information, see [Set a label field on a
     * file](https://developers.google.com/workspace/drive/api/guides/set-label). Returns a list of the
     * labels that were added or modified.
     *
     * Create a request for the method "files.modifyLabels".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link ModifyLabels#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file to which the labels belong.
     * @param content the {@link com.google.api.services.drive.model.ModifyLabelsRequest}
     * @return the request
     */
    public ModifyLabels modifyLabels(java.lang.String fileId, com.google.api.services.drive.model.ModifyLabelsRequest content) throws java.io.IOException {
      ModifyLabels result = new ModifyLabels(fileId, content);
      initialize(result);
      return result;
    }

    public class ModifyLabels extends DriveRequest<com.google.api.services.drive.model.ModifyLabelsResponse> {

      private static final String REST_PATH = "files/{fileId}/modifyLabels";

      /**
       * Modifies the set of labels applied to a file. For more information, see [Set a label field on a
       * file](https://developers.google.com/workspace/drive/api/guides/set-label). Returns a list of
       * the labels that were added or modified.
       *
       * Create a request for the method "files.modifyLabels".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link ModifyLabels#execute()} method to invoke the remote operation. <p>
       * {@link
       * ModifyLabels#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file to which the labels belong.
       * @param content the {@link com.google.api.services.drive.model.ModifyLabelsRequest}
       * @since 1.13
       */
      protected ModifyLabels(java.lang.String fileId, com.google.api.services.drive.model.ModifyLabelsRequest content) {
        super(Drive.this, "POST", REST_PATH, content, com.google.api.services.drive.model.ModifyLabelsResponse.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }

      @Override
      public ModifyLabels set$Xgafv(java.lang.String $Xgafv) {
        return (ModifyLabels) super.set$Xgafv($Xgafv);
      }

      @Override
      public ModifyLabels setAccessToken(java.lang.String accessToken) {
        return (ModifyLabels) super.setAccessToken(accessToken);
      }

      @Override
      public ModifyLabels setAlt(java.lang.String alt) {
        return (ModifyLabels) super.setAlt(alt);
      }

      @Override
      public ModifyLabels setCallback(java.lang.String callback) {
        return (ModifyLabels) super.setCallback(callback);
      }

      @Override
      public ModifyLabels setFields(java.lang.String fields) {
        return (ModifyLabels) super.setFields(fields);
      }

      @Override
      public ModifyLabels setKey(java.lang.String key) {
        return (ModifyLabels) super.setKey(key);
      }

      @Override
      public ModifyLabels setOauthToken(java.lang.String oauthToken) {
        return (ModifyLabels) super.setOauthToken(oauthToken);
      }

      @Override
      public ModifyLabels setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ModifyLabels) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ModifyLabels setQuotaUser(java.lang.String quotaUser) {
        return (ModifyLabels) super.setQuotaUser(quotaUser);
      }

      @Override
      public ModifyLabels setUploadType(java.lang.String uploadType) {
        return (ModifyLabels) super.setUploadType(uploadType);
      }

      @Override
      public ModifyLabels setUploadProtocol(java.lang.String uploadProtocol) {
        return (ModifyLabels) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the file to which the labels belong. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file to which the labels belong.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file to which the labels belong. */
      public ModifyLabels setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      @Override
      public ModifyLabels set(String parameterName, Object value) {
        return (ModifyLabels) super.set(parameterName, value);
      }
    }
    /**
     * Updates a file's metadata, content, or both. When calling this method, only populate fields in
     * the request that you want to modify. When updating fields, some fields might be changed
     * automatically, such as `modifiedDate`. This method supports patch semantics. This method supports
     * an upload* URI and accepts uploaded media with the following characteristics: - *Maximum file
     * size:* 5,120 GB - *Accepted Media MIME types:* `*` (Specify a valid MIME type, rather than the
     * literal `*` value. The literal `*` is only used to indicate that any valid MIME type can be
     * uploaded. For more information, see [Google Workspace and Google Drive supported MIME
     * types](/workspace/drive/api/guides/mime-types).) For more information on uploading files, see
     * [Upload file data](/workspace/drive/api/guides/manage-uploads).
     *
     * Create a request for the method "files.update".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param content the {@link com.google.api.services.drive.model.File}
     * @return the request
     */
    public Update update(java.lang.String fileId, com.google.api.services.drive.model.File content) throws java.io.IOException {
      Update result = new Update(fileId, content);
      initialize(result);
      return result;
    }

    /**
     * Updates a file's metadata, content, or both. When calling this method, only populate fields in
     * the request that you want to modify. When updating fields, some fields might be changed
     * automatically, such as `modifiedDate`. This method supports patch semantics. This method supports
     * an upload* URI and accepts uploaded media with the following characteristics: - *Maximum file
     * size:* 5,120 GB - *Accepted Media MIME types:* `*` (Specify a valid MIME type, rather than the
     * literal `*` value. The literal `*` is only used to indicate that any valid MIME type can be
     * uploaded. For more information, see [Google Workspace and Google Drive supported MIME
     * types](/workspace/drive/api/guides/mime-types).) For more information on uploading files, see
     * [Upload file data](/workspace/drive/api/guides/manage-uploads).
     *
     * Create a request for the method "files.update".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * <p>
     * This method should be used for uploading media content.
     * </p>
     *
     * @param fileId The ID of the file.
     * @param content the {@link com.google.api.services.drive.model.File} media metadata or {@code null} if none
     * @param mediaContent The media HTTP content.
     * @return the request
     * @throws java.io.IOException if the initialization of the request fails
     */
    public Update update(java.lang.String fileId, com.google.api.services.drive.model.File content, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
      Update result = new Update(fileId, content, mediaContent);
      initialize(result);
      return result;
    }

    public class Update extends DriveRequest<com.google.api.services.drive.model.File> {

      private static final String REST_PATH = "files/{fileId}";

      /**
       * Updates a file's metadata, content, or both. When calling this method, only populate fields in
       * the request that you want to modify. When updating fields, some fields might be changed
       * automatically, such as `modifiedDate`. This method supports patch semantics. This method
       * supports an upload* URI and accepts uploaded media with the following characteristics: -
       * *Maximum file size:* 5,120 GB - *Accepted Media MIME types:* `*` (Specify a valid MIME type,
       * rather than the literal `*` value. The literal `*` is only used to indicate that any valid MIME
       * type can be uploaded. For more information, see [Google Workspace and Google Drive supported
       * MIME types](/workspace/drive/api/guides/mime-types).) For more information on uploading files,
       * see [Upload file data](/workspace/drive/api/guides/manage-uploads).
       *
       * Create a request for the method "files.update".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param content the {@link com.google.api.services.drive.model.File}
       * @since 1.13
       */
      protected Update(java.lang.String fileId, com.google.api.services.drive.model.File content) {
        super(Drive.this, "PATCH", REST_PATH, content, com.google.api.services.drive.model.File.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }

      /**
       * Updates a file's metadata, content, or both. When calling this method, only populate fields in
       * the request that you want to modify. When updating fields, some fields might be changed
       * automatically, such as `modifiedDate`. This method supports patch semantics. This method
       * supports an upload* URI and accepts uploaded media with the following characteristics: -
       * *Maximum file size:* 5,120 GB - *Accepted Media MIME types:* `*` (Specify a valid MIME type,
       * rather than the literal `*` value. The literal `*` is only used to indicate that any valid MIME
       * type can be uploaded. For more information, see [Google Workspace and Google Drive supported
       * MIME types](/workspace/drive/api/guides/mime-types).) For more information on uploading files,
       * see [Upload file data](/workspace/drive/api/guides/manage-uploads).
       *
       * Create a request for the method "files.update".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * <p>
       * This constructor should be used for uploading media content.
       * </p>
       *
       * @param fileId The ID of the file.
       * @param content the {@link com.google.api.services.drive.model.File} media metadata or {@code null} if none
       * @param mediaContent The media HTTP content.
       * @since 1.13
       */
      protected Update(java.lang.String fileId, com.google.api.services.drive.model.File content, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(Drive.this, "PATCH", "/upload/" + getServicePath() + REST_PATH, content, com.google.api.services.drive.model.File.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        com.google.api.client.util.Preconditions.checkNotNull(mediaContent, "Required parameter mediaContent must be specified.");
        initializeMediaUpload(mediaContent);
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Update setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** A comma-separated list of parent IDs to add. */
      @com.google.api.client.util.Key
      private java.lang.String addParents;

      /** A comma-separated list of parent IDs to add.
       */
      public java.lang.String getAddParents() {
        return addParents;
      }

      /** A comma-separated list of parent IDs to add. */
      public Update setAddParents(java.lang.String addParents) {
        this.addParents = addParents;
        return this;
      }

      /**
       * Deprecated: Adding files to multiple folders is no longer supported. Use shortcuts instead.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean enforceSingleParent;

      /** Deprecated: Adding files to multiple folders is no longer supported. Use shortcuts instead.
     [default: false]
       */
      public java.lang.Boolean getEnforceSingleParent() {
        return enforceSingleParent;
      }

      /**
       * Deprecated: Adding files to multiple folders is no longer supported. Use shortcuts instead.
       */
      public Update setEnforceSingleParent(java.lang.Boolean enforceSingleParent) {
        this.enforceSingleParent = enforceSingleParent;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Deprecated: Adding files to multiple folders is no longer supported. Use shortcuts instead.
       * </p>
       */
      public boolean isEnforceSingleParent() {
        if (enforceSingleParent == null || enforceSingleParent == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return enforceSingleParent;
      }

      /**
       * A comma-separated list of IDs of labels to include in the `labelInfo` part of the response.
       */
      @com.google.api.client.util.Key
      private java.lang.String includeLabels;

      /** A comma-separated list of IDs of labels to include in the `labelInfo` part of the response.
       */
      public java.lang.String getIncludeLabels() {
        return includeLabels;
      }

      /**
       * A comma-separated list of IDs of labels to include in the `labelInfo` part of the response.
       */
      public Update setIncludeLabels(java.lang.String includeLabels) {
        this.includeLabels = includeLabels;
        return this;
      }

      /**
       * Specifies which additional view's permissions to include in the response. Only `published`
       * is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String includePermissionsForView;

      /** Specifies which additional view's permissions to include in the response. Only `published` is
     supported.
       */
      public java.lang.String getIncludePermissionsForView() {
        return includePermissionsForView;
      }

      /**
       * Specifies which additional view's permissions to include in the response. Only `published`
       * is supported.
       */
      public Update setIncludePermissionsForView(java.lang.String includePermissionsForView) {
        this.includePermissionsForView = includePermissionsForView;
        return this;
      }

      /**
       * Whether to set the `keepForever` field in the new head revision. This is only applicable to
       * files with binary content in Google Drive. Only 200 revisions for the file can be kept
       * forever. If the limit is reached, try deleting pinned revisions.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean keepRevisionForever;

      /** Whether to set the `keepForever` field in the new head revision. This is only applicable to files
     with binary content in Google Drive. Only 200 revisions for the file can be kept forever. If the
     limit is reached, try deleting pinned revisions. [default: false]
       */
      public java.lang.Boolean getKeepRevisionForever() {
        return keepRevisionForever;
      }

      /**
       * Whether to set the `keepForever` field in the new head revision. This is only applicable to
       * files with binary content in Google Drive. Only 200 revisions for the file can be kept
       * forever. If the limit is reached, try deleting pinned revisions.
       */
      public Update setKeepRevisionForever(java.lang.Boolean keepRevisionForever) {
        this.keepRevisionForever = keepRevisionForever;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to set the `keepForever` field in the new head revision. This is only applicable to files
     with binary content in Google Drive. Only 200 revisions for the file can be kept forever. If the
     limit is reached, try deleting pinned revisions.
       * </p>
       */
      public boolean isKeepRevisionForever() {
        if (keepRevisionForever == null || keepRevisionForever == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return keepRevisionForever;
      }

      /** A language hint for OCR processing during image import (ISO 639-1 code). */
      @com.google.api.client.util.Key
      private java.lang.String ocrLanguage;

      /** A language hint for OCR processing during image import (ISO 639-1 code).
       */
      public java.lang.String getOcrLanguage() {
        return ocrLanguage;
      }

      /** A language hint for OCR processing during image import (ISO 639-1 code). */
      public Update setOcrLanguage(java.lang.String ocrLanguage) {
        this.ocrLanguage = ocrLanguage;
        return this;
      }

      /** A comma-separated list of parent IDs to remove. */
      @com.google.api.client.util.Key
      private java.lang.String removeParents;

      /** A comma-separated list of parent IDs to remove.
       */
      public java.lang.String getRemoveParents() {
        return removeParents;
      }

      /** A comma-separated list of parent IDs to remove. */
      public Update setRemoveParents(java.lang.String removeParents) {
        this.removeParents = removeParents;
        return this;
      }

      /** Whether the requesting application supports both My Drives and shared drives. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsAllDrives;

      /** Whether the requesting application supports both My Drives and shared drives. [default: false]
       */
      public java.lang.Boolean getSupportsAllDrives() {
        return supportsAllDrives;
      }

      /** Whether the requesting application supports both My Drives and shared drives. */
      public Update setSupportsAllDrives(java.lang.Boolean supportsAllDrives) {
        this.supportsAllDrives = supportsAllDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the requesting application supports both My Drives and shared drives.
       * </p>
       */
      public boolean isSupportsAllDrives() {
        if (supportsAllDrives == null || supportsAllDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsAllDrives;
      }

      /** Deprecated: Use `supportsAllDrives` instead. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsTeamDrives;

      /** Deprecated: Use `supportsAllDrives` instead. [default: false]
       */
      public java.lang.Boolean getSupportsTeamDrives() {
        return supportsTeamDrives;
      }

      /** Deprecated: Use `supportsAllDrives` instead. */
      public Update setSupportsTeamDrives(java.lang.Boolean supportsTeamDrives) {
        this.supportsTeamDrives = supportsTeamDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Deprecated: Use `supportsAllDrives` instead.
       * </p>
       */
      public boolean isSupportsTeamDrives() {
        if (supportsTeamDrives == null || supportsTeamDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsTeamDrives;
      }

      /** Whether to use the uploaded content as indexable text. */
      @com.google.api.client.util.Key
      private java.lang.Boolean useContentAsIndexableText;

      /** Whether to use the uploaded content as indexable text. [default: false]
       */
      public java.lang.Boolean getUseContentAsIndexableText() {
        return useContentAsIndexableText;
      }

      /** Whether to use the uploaded content as indexable text. */
      public Update setUseContentAsIndexableText(java.lang.Boolean useContentAsIndexableText) {
        this.useContentAsIndexableText = useContentAsIndexableText;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to use the uploaded content as indexable text.
       * </p>
       */
      public boolean isUseContentAsIndexableText() {
        if (useContentAsIndexableText == null || useContentAsIndexableText == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return useContentAsIndexableText;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }
    /**
     * Subscribes to changes to a file. For more information, see [Notifications for resource
     * changes](https://developers.google.com/workspace/drive/api/guides/push).
     *
     * Create a request for the method "files.watch".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Watch#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param content the {@link com.google.api.services.drive.model.Channel}
     * @return the request
     */
    public Watch watch(java.lang.String fileId, com.google.api.services.drive.model.Channel content) throws java.io.IOException {
      Watch result = new Watch(fileId, content);
      initialize(result);
      return result;
    }

    public class Watch extends DriveRequest<com.google.api.services.drive.model.Channel> {

      private static final String REST_PATH = "files/{fileId}/watch";

      /**
       * Subscribes to changes to a file. For more information, see [Notifications for resource
       * changes](https://developers.google.com/workspace/drive/api/guides/push).
       *
       * Create a request for the method "files.watch".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Watch#execute()} method to invoke the remote operation. <p> {@link
       * Watch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param content the {@link com.google.api.services.drive.model.Channel}
       * @since 1.13
       */
      protected Watch(java.lang.String fileId, com.google.api.services.drive.model.Channel content) {
        super(Drive.this, "POST", REST_PATH, content, com.google.api.services.drive.model.Channel.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }

      @Override
      public Watch set$Xgafv(java.lang.String $Xgafv) {
        return (Watch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Watch setAccessToken(java.lang.String accessToken) {
        return (Watch) super.setAccessToken(accessToken);
      }

      @Override
      public Watch setAlt(java.lang.String alt) {
        return (Watch) super.setAlt(alt);
      }

      @Override
      public Watch setCallback(java.lang.String callback) {
        return (Watch) super.setCallback(callback);
      }

      @Override
      public Watch setFields(java.lang.String fields) {
        return (Watch) super.setFields(fields);
      }

      @Override
      public Watch setKey(java.lang.String key) {
        return (Watch) super.setKey(key);
      }

      @Override
      public Watch setOauthToken(java.lang.String oauthToken) {
        return (Watch) super.setOauthToken(oauthToken);
      }

      @Override
      public Watch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Watch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Watch setQuotaUser(java.lang.String quotaUser) {
        return (Watch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Watch setUploadType(java.lang.String uploadType) {
        return (Watch) super.setUploadType(uploadType);
      }

      @Override
      public Watch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Watch) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Watch setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /**
       * Whether the user is acknowledging the risk of downloading known malware or other abusive
       * files. This is only applicable when the `alt` parameter is set to `media` and the user is
       * the owner of the file or an organizer of the shared drive in which the file resides.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean acknowledgeAbuse;

      /** Whether the user is acknowledging the risk of downloading known malware or other abusive files.
     This is only applicable when the `alt` parameter is set to `media` and the user is the owner of the
     file or an organizer of the shared drive in which the file resides. [default: false]
       */
      public java.lang.Boolean getAcknowledgeAbuse() {
        return acknowledgeAbuse;
      }

      /**
       * Whether the user is acknowledging the risk of downloading known malware or other abusive
       * files. This is only applicable when the `alt` parameter is set to `media` and the user is
       * the owner of the file or an organizer of the shared drive in which the file resides.
       */
      public Watch setAcknowledgeAbuse(java.lang.Boolean acknowledgeAbuse) {
        this.acknowledgeAbuse = acknowledgeAbuse;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the user is acknowledging the risk of downloading known malware or other abusive files.
     This is only applicable when the `alt` parameter is set to `media` and the user is the owner of the
     file or an organizer of the shared drive in which the file resides.
       * </p>
       */
      public boolean isAcknowledgeAbuse() {
        if (acknowledgeAbuse == null || acknowledgeAbuse == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return acknowledgeAbuse;
      }

      /**
       * A comma-separated list of IDs of labels to include in the `labelInfo` part of the response.
       */
      @com.google.api.client.util.Key
      private java.lang.String includeLabels;

      /** A comma-separated list of IDs of labels to include in the `labelInfo` part of the response.
       */
      public java.lang.String getIncludeLabels() {
        return includeLabels;
      }

      /**
       * A comma-separated list of IDs of labels to include in the `labelInfo` part of the response.
       */
      public Watch setIncludeLabels(java.lang.String includeLabels) {
        this.includeLabels = includeLabels;
        return this;
      }

      /**
       * Specifies which additional view's permissions to include in the response. Only `published`
       * is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String includePermissionsForView;

      /** Specifies which additional view's permissions to include in the response. Only `published` is
     supported.
       */
      public java.lang.String getIncludePermissionsForView() {
        return includePermissionsForView;
      }

      /**
       * Specifies which additional view's permissions to include in the response. Only `published`
       * is supported.
       */
      public Watch setIncludePermissionsForView(java.lang.String includePermissionsForView) {
        this.includePermissionsForView = includePermissionsForView;
        return this;
      }

      /** Whether the requesting application supports both My Drives and shared drives. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsAllDrives;

      /** Whether the requesting application supports both My Drives and shared drives. [default: false]
       */
      public java.lang.Boolean getSupportsAllDrives() {
        return supportsAllDrives;
      }

      /** Whether the requesting application supports both My Drives and shared drives. */
      public Watch setSupportsAllDrives(java.lang.Boolean supportsAllDrives) {
        this.supportsAllDrives = supportsAllDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the requesting application supports both My Drives and shared drives.
       * </p>
       */
      public boolean isSupportsAllDrives() {
        if (supportsAllDrives == null || supportsAllDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsAllDrives;
      }

      /** Deprecated: Use `supportsAllDrives` instead. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsTeamDrives;

      /** Deprecated: Use `supportsAllDrives` instead. [default: false]
       */
      public java.lang.Boolean getSupportsTeamDrives() {
        return supportsTeamDrives;
      }

      /** Deprecated: Use `supportsAllDrives` instead. */
      public Watch setSupportsTeamDrives(java.lang.Boolean supportsTeamDrives) {
        this.supportsTeamDrives = supportsTeamDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Deprecated: Use `supportsAllDrives` instead.
       * </p>
       */
      public boolean isSupportsTeamDrives() {
        if (supportsTeamDrives == null || supportsTeamDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsTeamDrives;
      }

      @Override
      public Watch set(String parameterName, Object value) {
        return (Watch) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Operations collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Operations.List request = drive.operations().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Operations operations() {
    return new Operations();
  }

  /**
   * The "operations" collection of methods.
   */
  public class Operations {

    /**
     * Gets the latest state of a long-running operation. Clients can use this method to poll the
     * operation result at intervals as recommended by the API service.
     *
     * Create a request for the method "operations.get".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param name The name of the operation resource.
     * @return the request
     */
    public Get get(java.lang.String name) throws java.io.IOException {
      Get result = new Get(name);
      initialize(result);
      return result;
    }

    public class Get extends DriveRequest<com.google.api.services.drive.model.Operation> {

      private static final String REST_PATH = "operations/{name}";

      /**
       * Gets the latest state of a long-running operation. Clients can use this method to poll the
       * operation result at intervals as recommended by the API service.
       *
       * Create a request for the method "operations.get".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name The name of the operation resource.
       * @since 1.13
       */
      protected Get(java.lang.String name) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.Operation.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** The name of the operation resource. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** The name of the operation resource.
       */
      public java.lang.String getName() {
        return name;
      }

      /** The name of the operation resource. */
      public Get setName(java.lang.String name) {
        this.name = name;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Permissions collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Permissions.List request = drive.permissions().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Permissions permissions() {
    return new Permissions();
  }

  /**
   * The "permissions" collection of methods.
   */
  public class Permissions {

    /**
     * Creates a permission for a file or shared drive. For more information, see [Share files, folders,
     * and drives](https://developers.google.com/workspace/drive/api/guides/manage-sharing).
     * **Warning:** Concurrent permissions operations on the same file aren't supported; only the last
     * update is applied.
     *
     * Create a request for the method "permissions.create".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Create#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file or shared drive.
     * @param content the {@link com.google.api.services.drive.model.Permission}
     * @return the request
     */
    public Create create(java.lang.String fileId, com.google.api.services.drive.model.Permission content) throws java.io.IOException {
      Create result = new Create(fileId, content);
      initialize(result);
      return result;
    }

    public class Create extends DriveRequest<com.google.api.services.drive.model.Permission> {

      private static final String REST_PATH = "files/{fileId}/permissions";

      /**
       * Creates a permission for a file or shared drive. For more information, see [Share files,
       * folders, and drives](https://developers.google.com/workspace/drive/api/guides/manage-sharing).
       * **Warning:** Concurrent permissions operations on the same file aren't supported; only the last
       * update is applied.
       *
       * Create a request for the method "permissions.create".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
       * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file or shared drive.
       * @param content the {@link com.google.api.services.drive.model.Permission}
       * @since 1.13
       */
      protected Create(java.lang.String fileId, com.google.api.services.drive.model.Permission content) {
        super(Drive.this, "POST", REST_PATH, content, com.google.api.services.drive.model.Permission.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getRole(), "Permission.getRole()");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getType(), "Permission.getType()");
      }

      @Override
      public Create set$Xgafv(java.lang.String $Xgafv) {
        return (Create) super.set$Xgafv($Xgafv);
      }

      @Override
      public Create setAccessToken(java.lang.String accessToken) {
        return (Create) super.setAccessToken(accessToken);
      }

      @Override
      public Create setAlt(java.lang.String alt) {
        return (Create) super.setAlt(alt);
      }

      @Override
      public Create setCallback(java.lang.String callback) {
        return (Create) super.setCallback(callback);
      }

      @Override
      public Create setFields(java.lang.String fields) {
        return (Create) super.setFields(fields);
      }

      @Override
      public Create setKey(java.lang.String key) {
        return (Create) super.setKey(key);
      }

      @Override
      public Create setOauthToken(java.lang.String oauthToken) {
        return (Create) super.setOauthToken(oauthToken);
      }

      @Override
      public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Create) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Create setQuotaUser(java.lang.String quotaUser) {
        return (Create) super.setQuotaUser(quotaUser);
      }

      @Override
      public Create setUploadType(java.lang.String uploadType) {
        return (Create) super.setUploadType(uploadType);
      }

      @Override
      public Create setUploadProtocol(java.lang.String uploadProtocol) {
        return (Create) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the file or shared drive. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file or shared drive.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file or shared drive. */
      public Create setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** A plain text custom message to include in the notification email. */
      @com.google.api.client.util.Key
      private java.lang.String emailMessage;

      /** A plain text custom message to include in the notification email.
       */
      public java.lang.String getEmailMessage() {
        return emailMessage;
      }

      /** A plain text custom message to include in the notification email. */
      public Create setEmailMessage(java.lang.String emailMessage) {
        this.emailMessage = emailMessage;
        return this;
      }

      /** Whether the request should enforce expansive access rules. */
      @com.google.api.client.util.Key
      private java.lang.Boolean enforceExpansiveAccess;

      /** Whether the request should enforce expansive access rules. [default: false]
       */
      public java.lang.Boolean getEnforceExpansiveAccess() {
        return enforceExpansiveAccess;
      }

      /** Whether the request should enforce expansive access rules. */
      public Create setEnforceExpansiveAccess(java.lang.Boolean enforceExpansiveAccess) {
        this.enforceExpansiveAccess = enforceExpansiveAccess;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the request should enforce expansive access rules.
       * </p>
       */
      public boolean isEnforceExpansiveAccess() {
        if (enforceExpansiveAccess == null || enforceExpansiveAccess == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return enforceExpansiveAccess;
      }

      /** Deprecated: See `moveToNewOwnersRoot` for details. */
      @com.google.api.client.util.Key
      private java.lang.Boolean enforceSingleParent;

      /** Deprecated: See `moveToNewOwnersRoot` for details. [default: false]
       */
      public java.lang.Boolean getEnforceSingleParent() {
        return enforceSingleParent;
      }

      /** Deprecated: See `moveToNewOwnersRoot` for details. */
      public Create setEnforceSingleParent(java.lang.Boolean enforceSingleParent) {
        this.enforceSingleParent = enforceSingleParent;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Deprecated: See `moveToNewOwnersRoot` for details.
       * </p>
       */
      public boolean isEnforceSingleParent() {
        if (enforceSingleParent == null || enforceSingleParent == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return enforceSingleParent;
      }

      /**
       * This parameter only takes effect if the item isn't in a shared drive and the request is
       * attempting to transfer the ownership of the item. If set to `true`, the item is moved to
       * the new owner's My Drive root folder and all prior parents removed. If set to `false`,
       * parents aren't changed.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean moveToNewOwnersRoot;

      /** This parameter only takes effect if the item isn't in a shared drive and the request is attempting
     to transfer the ownership of the item. If set to `true`, the item is moved to the new owner's My
     Drive root folder and all prior parents removed. If set to `false`, parents aren't changed.
     [default: false]
       */
      public java.lang.Boolean getMoveToNewOwnersRoot() {
        return moveToNewOwnersRoot;
      }

      /**
       * This parameter only takes effect if the item isn't in a shared drive and the request is
       * attempting to transfer the ownership of the item. If set to `true`, the item is moved to
       * the new owner's My Drive root folder and all prior parents removed. If set to `false`,
       * parents aren't changed.
       */
      public Create setMoveToNewOwnersRoot(java.lang.Boolean moveToNewOwnersRoot) {
        this.moveToNewOwnersRoot = moveToNewOwnersRoot;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * This parameter only takes effect if the item isn't in a shared drive and the request is attempting
     to transfer the ownership of the item. If set to `true`, the item is moved to the new owner's My
     Drive root folder and all prior parents removed. If set to `false`, parents aren't changed.
       * </p>
       */
      public boolean isMoveToNewOwnersRoot() {
        if (moveToNewOwnersRoot == null || moveToNewOwnersRoot == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return moveToNewOwnersRoot;
      }

      /**
       * Whether to send a notification email when sharing to users or groups. This defaults to
       * `true` for users and groups, and is not allowed for other requests. It must not be disabled
       * for ownership transfers.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean sendNotificationEmail;

      /** Whether to send a notification email when sharing to users or groups. This defaults to `true` for
     users and groups, and is not allowed for other requests. It must not be disabled for ownership
     transfers.
       */
      public java.lang.Boolean getSendNotificationEmail() {
        return sendNotificationEmail;
      }

      /**
       * Whether to send a notification email when sharing to users or groups. This defaults to
       * `true` for users and groups, and is not allowed for other requests. It must not be disabled
       * for ownership transfers.
       */
      public Create setSendNotificationEmail(java.lang.Boolean sendNotificationEmail) {
        this.sendNotificationEmail = sendNotificationEmail;
        return this;
      }

      /** Whether the requesting application supports both My Drives and shared drives. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsAllDrives;

      /** Whether the requesting application supports both My Drives and shared drives. [default: false]
       */
      public java.lang.Boolean getSupportsAllDrives() {
        return supportsAllDrives;
      }

      /** Whether the requesting application supports both My Drives and shared drives. */
      public Create setSupportsAllDrives(java.lang.Boolean supportsAllDrives) {
        this.supportsAllDrives = supportsAllDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the requesting application supports both My Drives and shared drives.
       * </p>
       */
      public boolean isSupportsAllDrives() {
        if (supportsAllDrives == null || supportsAllDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsAllDrives;
      }

      /** Deprecated: Use `supportsAllDrives` instead. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsTeamDrives;

      /** Deprecated: Use `supportsAllDrives` instead. [default: false]
       */
      public java.lang.Boolean getSupportsTeamDrives() {
        return supportsTeamDrives;
      }

      /** Deprecated: Use `supportsAllDrives` instead. */
      public Create setSupportsTeamDrives(java.lang.Boolean supportsTeamDrives) {
        this.supportsTeamDrives = supportsTeamDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Deprecated: Use `supportsAllDrives` instead.
       * </p>
       */
      public boolean isSupportsTeamDrives() {
        if (supportsTeamDrives == null || supportsTeamDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsTeamDrives;
      }

      /**
       * Whether to transfer ownership to the specified user and downgrade the current owner to a
       * writer. This parameter is required as an acknowledgement of the side effect. For more
       * information, see [Transfer file
       * ownership](https://developers.google.com/workspace/drive/api/guides/transfer-file).
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean transferOwnership;

      /** Whether to transfer ownership to the specified user and downgrade the current owner to a writer.
     This parameter is required as an acknowledgement of the side effect. For more information, see
     [Transfer file ownership](https://developers.google.com/workspace/drive/api/guides/transfer-file).
     [default: false]
       */
      public java.lang.Boolean getTransferOwnership() {
        return transferOwnership;
      }

      /**
       * Whether to transfer ownership to the specified user and downgrade the current owner to a
       * writer. This parameter is required as an acknowledgement of the side effect. For more
       * information, see [Transfer file
       * ownership](https://developers.google.com/workspace/drive/api/guides/transfer-file).
       */
      public Create setTransferOwnership(java.lang.Boolean transferOwnership) {
        this.transferOwnership = transferOwnership;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to transfer ownership to the specified user and downgrade the current owner to a writer.
     This parameter is required as an acknowledgement of the side effect. For more information, see
     [Transfer file ownership](https://developers.google.com/workspace/drive/api/guides/transfer-file).
       * </p>
       */
      public boolean isTransferOwnership() {
        if (transferOwnership == null || transferOwnership == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return transferOwnership;
      }

      /**
       * Issue the request as a domain administrator. If set to `true`, and if the following
       * additional conditions are met, the requester is granted access: 1. The file ID parameter
       * refers to a shared drive. 2. The requester is an administrator of the domain to which the
       * shared drive belongs. For more information, see [Manage shared drives as domain
       * administrators](https://developers.google.com/workspace/drive/api/guides/manage-
       * shareddrives#manage-administrators).
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean useDomainAdminAccess;

      /** Issue the request as a domain administrator. If set to `true`, and if the following additional
     conditions are met, the requester is granted access: 1. The file ID parameter refers to a shared
     drive. 2. The requester is an administrator of the domain to which the shared drive belongs. For
     more information, see [Manage shared drives as domain
     administrators](https://developers.google.com/workspace/drive/api/guides/manage-
     shareddrives#manage-administrators). [default: false]
       */
      public java.lang.Boolean getUseDomainAdminAccess() {
        return useDomainAdminAccess;
      }

      /**
       * Issue the request as a domain administrator. If set to `true`, and if the following
       * additional conditions are met, the requester is granted access: 1. The file ID parameter
       * refers to a shared drive. 2. The requester is an administrator of the domain to which the
       * shared drive belongs. For more information, see [Manage shared drives as domain
       * administrators](https://developers.google.com/workspace/drive/api/guides/manage-
       * shareddrives#manage-administrators).
       */
      public Create setUseDomainAdminAccess(java.lang.Boolean useDomainAdminAccess) {
        this.useDomainAdminAccess = useDomainAdminAccess;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Issue the request as a domain administrator. If set to `true`, and if the following additional
     conditions are met, the requester is granted access: 1. The file ID parameter refers to a shared
     drive. 2. The requester is an administrator of the domain to which the shared drive belongs. For
     more information, see [Manage shared drives as domain
     administrators](https://developers.google.com/workspace/drive/api/guides/manage-
     shareddrives#manage-administrators).
       * </p>
       */
      public boolean isUseDomainAdminAccess() {
        if (useDomainAdminAccess == null || useDomainAdminAccess == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return useDomainAdminAccess;
      }

      @Override
      public Create set(String parameterName, Object value) {
        return (Create) super.set(parameterName, value);
      }
    }
    /**
     * Deletes a permission. For more information, see [Share files, folders, and
     * drives](https://developers.google.com/workspace/drive/api/guides/manage-sharing). **Warning:**
     * Concurrent permissions operations on the same file aren't supported; only the last update is
     * applied.
     *
     * Create a request for the method "permissions.delete".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file or shared drive.
     * @param permissionId The ID of the permission.
     * @return the request
     */
    public Delete delete(java.lang.String fileId, java.lang.String permissionId) throws java.io.IOException {
      Delete result = new Delete(fileId, permissionId);
      initialize(result);
      return result;
    }

    public class Delete extends DriveRequest<Void> {

      private static final String REST_PATH = "files/{fileId}/permissions/{permissionId}";

      /**
       * Deletes a permission. For more information, see [Share files, folders, and
       * drives](https://developers.google.com/workspace/drive/api/guides/manage-sharing). **Warning:**
       * Concurrent permissions operations on the same file aren't supported; only the last update is
       * applied.
       *
       * Create a request for the method "permissions.delete".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file or shared drive.
       * @param permissionId The ID of the permission.
       * @since 1.13
       */
      protected Delete(java.lang.String fileId, java.lang.String permissionId) {
        super(Drive.this, "DELETE", REST_PATH, null, Void.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.permissionId = com.google.api.client.util.Preconditions.checkNotNull(permissionId, "Required parameter permissionId must be specified.");
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the file or shared drive. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file or shared drive.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file or shared drive. */
      public Delete setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the permission. */
      @com.google.api.client.util.Key
      private java.lang.String permissionId;

      /** The ID of the permission.
       */
      public java.lang.String getPermissionId() {
        return permissionId;
      }

      /** The ID of the permission. */
      public Delete setPermissionId(java.lang.String permissionId) {
        this.permissionId = permissionId;
        return this;
      }

      /** Whether the request should enforce expansive access rules. */
      @com.google.api.client.util.Key
      private java.lang.Boolean enforceExpansiveAccess;

      /** Whether the request should enforce expansive access rules. [default: false]
       */
      public java.lang.Boolean getEnforceExpansiveAccess() {
        return enforceExpansiveAccess;
      }

      /** Whether the request should enforce expansive access rules. */
      public Delete setEnforceExpansiveAccess(java.lang.Boolean enforceExpansiveAccess) {
        this.enforceExpansiveAccess = enforceExpansiveAccess;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the request should enforce expansive access rules.
       * </p>
       */
      public boolean isEnforceExpansiveAccess() {
        if (enforceExpansiveAccess == null || enforceExpansiveAccess == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return enforceExpansiveAccess;
      }

      /** Whether the requesting application supports both My Drives and shared drives. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsAllDrives;

      /** Whether the requesting application supports both My Drives and shared drives. [default: false]
       */
      public java.lang.Boolean getSupportsAllDrives() {
        return supportsAllDrives;
      }

      /** Whether the requesting application supports both My Drives and shared drives. */
      public Delete setSupportsAllDrives(java.lang.Boolean supportsAllDrives) {
        this.supportsAllDrives = supportsAllDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the requesting application supports both My Drives and shared drives.
       * </p>
       */
      public boolean isSupportsAllDrives() {
        if (supportsAllDrives == null || supportsAllDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsAllDrives;
      }

      /** Deprecated: Use `supportsAllDrives` instead. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsTeamDrives;

      /** Deprecated: Use `supportsAllDrives` instead. [default: false]
       */
      public java.lang.Boolean getSupportsTeamDrives() {
        return supportsTeamDrives;
      }

      /** Deprecated: Use `supportsAllDrives` instead. */
      public Delete setSupportsTeamDrives(java.lang.Boolean supportsTeamDrives) {
        this.supportsTeamDrives = supportsTeamDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Deprecated: Use `supportsAllDrives` instead.
       * </p>
       */
      public boolean isSupportsTeamDrives() {
        if (supportsTeamDrives == null || supportsTeamDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsTeamDrives;
      }

      /**
       * Issue the request as a domain administrator. If set to `true`, and if the following
       * additional conditions are met, the requester is granted access: 1. The file ID parameter
       * refers to a shared drive. 2. The requester is an administrator of the domain to which the
       * shared drive belongs. For more information, see [Manage shared drives as domain
       * administrators](https://developers.google.com/workspace/drive/api/guides/manage-
       * shareddrives#manage-administrators).
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean useDomainAdminAccess;

      /** Issue the request as a domain administrator. If set to `true`, and if the following additional
     conditions are met, the requester is granted access: 1. The file ID parameter refers to a shared
     drive. 2. The requester is an administrator of the domain to which the shared drive belongs. For
     more information, see [Manage shared drives as domain
     administrators](https://developers.google.com/workspace/drive/api/guides/manage-
     shareddrives#manage-administrators). [default: false]
       */
      public java.lang.Boolean getUseDomainAdminAccess() {
        return useDomainAdminAccess;
      }

      /**
       * Issue the request as a domain administrator. If set to `true`, and if the following
       * additional conditions are met, the requester is granted access: 1. The file ID parameter
       * refers to a shared drive. 2. The requester is an administrator of the domain to which the
       * shared drive belongs. For more information, see [Manage shared drives as domain
       * administrators](https://developers.google.com/workspace/drive/api/guides/manage-
       * shareddrives#manage-administrators).
       */
      public Delete setUseDomainAdminAccess(java.lang.Boolean useDomainAdminAccess) {
        this.useDomainAdminAccess = useDomainAdminAccess;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Issue the request as a domain administrator. If set to `true`, and if the following additional
     conditions are met, the requester is granted access: 1. The file ID parameter refers to a shared
     drive. 2. The requester is an administrator of the domain to which the shared drive belongs. For
     more information, see [Manage shared drives as domain
     administrators](https://developers.google.com/workspace/drive/api/guides/manage-
     shareddrives#manage-administrators).
       * </p>
       */
      public boolean isUseDomainAdminAccess() {
        if (useDomainAdminAccess == null || useDomainAdminAccess == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return useDomainAdminAccess;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Gets a permission by ID. For more information, see [Share files, folders, and
     * drives](https://developers.google.com/workspace/drive/api/guides/manage-sharing).
     *
     * Create a request for the method "permissions.get".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param permissionId The ID of the permission.
     * @return the request
     */
    public Get get(java.lang.String fileId, java.lang.String permissionId) throws java.io.IOException {
      Get result = new Get(fileId, permissionId);
      initialize(result);
      return result;
    }

    public class Get extends DriveRequest<com.google.api.services.drive.model.Permission> {

      private static final String REST_PATH = "files/{fileId}/permissions/{permissionId}";

      /**
       * Gets a permission by ID. For more information, see [Share files, folders, and
       * drives](https://developers.google.com/workspace/drive/api/guides/manage-sharing).
       *
       * Create a request for the method "permissions.get".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param permissionId The ID of the permission.
       * @since 1.13
       */
      protected Get(java.lang.String fileId, java.lang.String permissionId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.Permission.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.permissionId = com.google.api.client.util.Preconditions.checkNotNull(permissionId, "Required parameter permissionId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Get setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the permission. */
      @com.google.api.client.util.Key
      private java.lang.String permissionId;

      /** The ID of the permission.
       */
      public java.lang.String getPermissionId() {
        return permissionId;
      }

      /** The ID of the permission. */
      public Get setPermissionId(java.lang.String permissionId) {
        this.permissionId = permissionId;
        return this;
      }

      /** Whether the requesting application supports both My Drives and shared drives. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsAllDrives;

      /** Whether the requesting application supports both My Drives and shared drives. [default: false]
       */
      public java.lang.Boolean getSupportsAllDrives() {
        return supportsAllDrives;
      }

      /** Whether the requesting application supports both My Drives and shared drives. */
      public Get setSupportsAllDrives(java.lang.Boolean supportsAllDrives) {
        this.supportsAllDrives = supportsAllDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the requesting application supports both My Drives and shared drives.
       * </p>
       */
      public boolean isSupportsAllDrives() {
        if (supportsAllDrives == null || supportsAllDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsAllDrives;
      }

      /** Deprecated: Use `supportsAllDrives` instead. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsTeamDrives;

      /** Deprecated: Use `supportsAllDrives` instead. [default: false]
       */
      public java.lang.Boolean getSupportsTeamDrives() {
        return supportsTeamDrives;
      }

      /** Deprecated: Use `supportsAllDrives` instead. */
      public Get setSupportsTeamDrives(java.lang.Boolean supportsTeamDrives) {
        this.supportsTeamDrives = supportsTeamDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Deprecated: Use `supportsAllDrives` instead.
       * </p>
       */
      public boolean isSupportsTeamDrives() {
        if (supportsTeamDrives == null || supportsTeamDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsTeamDrives;
      }

      /**
       * Issue the request as a domain administrator. If set to `true`, and if the following
       * additional conditions are met, the requester is granted access: 1. The file ID parameter
       * refers to a shared drive. 2. The requester is an administrator of the domain to which the
       * shared drive belongs. For more information, see [Manage shared drives as domain
       * administrators](https://developers.google.com/workspace/drive/api/guides/manage-
       * shareddrives#manage-administrators).
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean useDomainAdminAccess;

      /** Issue the request as a domain administrator. If set to `true`, and if the following additional
     conditions are met, the requester is granted access: 1. The file ID parameter refers to a shared
     drive. 2. The requester is an administrator of the domain to which the shared drive belongs. For
     more information, see [Manage shared drives as domain
     administrators](https://developers.google.com/workspace/drive/api/guides/manage-
     shareddrives#manage-administrators). [default: false]
       */
      public java.lang.Boolean getUseDomainAdminAccess() {
        return useDomainAdminAccess;
      }

      /**
       * Issue the request as a domain administrator. If set to `true`, and if the following
       * additional conditions are met, the requester is granted access: 1. The file ID parameter
       * refers to a shared drive. 2. The requester is an administrator of the domain to which the
       * shared drive belongs. For more information, see [Manage shared drives as domain
       * administrators](https://developers.google.com/workspace/drive/api/guides/manage-
       * shareddrives#manage-administrators).
       */
      public Get setUseDomainAdminAccess(java.lang.Boolean useDomainAdminAccess) {
        this.useDomainAdminAccess = useDomainAdminAccess;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Issue the request as a domain administrator. If set to `true`, and if the following additional
     conditions are met, the requester is granted access: 1. The file ID parameter refers to a shared
     drive. 2. The requester is an administrator of the domain to which the shared drive belongs. For
     more information, see [Manage shared drives as domain
     administrators](https://developers.google.com/workspace/drive/api/guides/manage-
     shareddrives#manage-administrators).
       * </p>
       */
      public boolean isUseDomainAdminAccess() {
        if (useDomainAdminAccess == null || useDomainAdminAccess == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return useDomainAdminAccess;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Lists a file's or shared drive's permissions. For more information, see [Share files, folders,
     * and drives](https://developers.google.com/workspace/drive/api/guides/manage-sharing).
     *
     * Create a request for the method "permissions.list".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file or shared drive.
     * @return the request
     */
    public List list(java.lang.String fileId) throws java.io.IOException {
      List result = new List(fileId);
      initialize(result);
      return result;
    }

    public class List extends DriveRequest<com.google.api.services.drive.model.PermissionList> {

      private static final String REST_PATH = "files/{fileId}/permissions";

      /**
       * Lists a file's or shared drive's permissions. For more information, see [Share files, folders,
       * and drives](https://developers.google.com/workspace/drive/api/guides/manage-sharing).
       *
       * Create a request for the method "permissions.list".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file or shared drive.
       * @since 1.13
       */
      protected List(java.lang.String fileId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.PermissionList.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the file or shared drive. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file or shared drive.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file or shared drive. */
      public List setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /**
       * Specifies which additional view's permissions to include in the response. Only `published`
       * is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String includePermissionsForView;

      /** Specifies which additional view's permissions to include in the response. Only `published` is
     supported.
       */
      public java.lang.String getIncludePermissionsForView() {
        return includePermissionsForView;
      }

      /**
       * Specifies which additional view's permissions to include in the response. Only `published`
       * is supported.
       */
      public List setIncludePermissionsForView(java.lang.String includePermissionsForView) {
        this.includePermissionsForView = includePermissionsForView;
        return this;
      }

      /**
       * The maximum number of permissions to return per page. When not set for files in a shared
       * drive, at most 100 results will be returned. When not set for files that are not in a
       * shared drive, the entire list will be returned.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** The maximum number of permissions to return per page. When not set for files in a shared drive, at
     most 100 results will be returned. When not set for files that are not in a shared drive, the
     entire list will be returned.

     [minimum: 1] [maximum: 100]
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /**
       * The maximum number of permissions to return per page. When not set for files in a shared
       * drive, at most 100 results will be returned. When not set for files that are not in a
       * shared drive, the entire list will be returned.
       */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /**
       * The token for continuing a previous list request on the next page. This should be set to
       * the value of `nextPageToken` from the previous response.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The token for continuing a previous list request on the next page. This should be set to the value
     of `nextPageToken` from the previous response.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The token for continuing a previous list request on the next page. This should be set to
       * the value of `nextPageToken` from the previous response.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Whether the requesting application supports both My Drives and shared drives. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsAllDrives;

      /** Whether the requesting application supports both My Drives and shared drives. [default: false]
       */
      public java.lang.Boolean getSupportsAllDrives() {
        return supportsAllDrives;
      }

      /** Whether the requesting application supports both My Drives and shared drives. */
      public List setSupportsAllDrives(java.lang.Boolean supportsAllDrives) {
        this.supportsAllDrives = supportsAllDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the requesting application supports both My Drives and shared drives.
       * </p>
       */
      public boolean isSupportsAllDrives() {
        if (supportsAllDrives == null || supportsAllDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsAllDrives;
      }

      /** Deprecated: Use `supportsAllDrives` instead. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsTeamDrives;

      /** Deprecated: Use `supportsAllDrives` instead. [default: false]
       */
      public java.lang.Boolean getSupportsTeamDrives() {
        return supportsTeamDrives;
      }

      /** Deprecated: Use `supportsAllDrives` instead. */
      public List setSupportsTeamDrives(java.lang.Boolean supportsTeamDrives) {
        this.supportsTeamDrives = supportsTeamDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Deprecated: Use `supportsAllDrives` instead.
       * </p>
       */
      public boolean isSupportsTeamDrives() {
        if (supportsTeamDrives == null || supportsTeamDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsTeamDrives;
      }

      /**
       * Issue the request as a domain administrator. If set to `true`, and if the following
       * additional conditions are met, the requester is granted access: 1. The file ID parameter
       * refers to a shared drive. 2. The requester is an administrator of the domain to which the
       * shared drive belongs. For more information, see [Manage shared drives as domain
       * administrators](https://developers.google.com/workspace/drive/api/guides/manage-
       * shareddrives#manage-administrators).
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean useDomainAdminAccess;

      /** Issue the request as a domain administrator. If set to `true`, and if the following additional
     conditions are met, the requester is granted access: 1. The file ID parameter refers to a shared
     drive. 2. The requester is an administrator of the domain to which the shared drive belongs. For
     more information, see [Manage shared drives as domain
     administrators](https://developers.google.com/workspace/drive/api/guides/manage-
     shareddrives#manage-administrators). [default: false]
       */
      public java.lang.Boolean getUseDomainAdminAccess() {
        return useDomainAdminAccess;
      }

      /**
       * Issue the request as a domain administrator. If set to `true`, and if the following
       * additional conditions are met, the requester is granted access: 1. The file ID parameter
       * refers to a shared drive. 2. The requester is an administrator of the domain to which the
       * shared drive belongs. For more information, see [Manage shared drives as domain
       * administrators](https://developers.google.com/workspace/drive/api/guides/manage-
       * shareddrives#manage-administrators).
       */
      public List setUseDomainAdminAccess(java.lang.Boolean useDomainAdminAccess) {
        this.useDomainAdminAccess = useDomainAdminAccess;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Issue the request as a domain administrator. If set to `true`, and if the following additional
     conditions are met, the requester is granted access: 1. The file ID parameter refers to a shared
     drive. 2. The requester is an administrator of the domain to which the shared drive belongs. For
     more information, see [Manage shared drives as domain
     administrators](https://developers.google.com/workspace/drive/api/guides/manage-
     shareddrives#manage-administrators).
       * </p>
       */
      public boolean isUseDomainAdminAccess() {
        if (useDomainAdminAccess == null || useDomainAdminAccess == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return useDomainAdminAccess;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates a permission with patch semantics. For more information, see [Share files, folders, and
     * drives](https://developers.google.com/workspace/drive/api/guides/manage-sharing). **Warning:**
     * Concurrent permissions operations on the same file aren't supported; only the last update is
     * applied.
     *
     * Create a request for the method "permissions.update".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file or shared drive.
     * @param permissionId The ID of the permission.
     * @param content the {@link com.google.api.services.drive.model.Permission}
     * @return the request
     */
    public Update update(java.lang.String fileId, java.lang.String permissionId, com.google.api.services.drive.model.Permission content) throws java.io.IOException {
      Update result = new Update(fileId, permissionId, content);
      initialize(result);
      return result;
    }

    public class Update extends DriveRequest<com.google.api.services.drive.model.Permission> {

      private static final String REST_PATH = "files/{fileId}/permissions/{permissionId}";

      /**
       * Updates a permission with patch semantics. For more information, see [Share files, folders, and
       * drives](https://developers.google.com/workspace/drive/api/guides/manage-sharing). **Warning:**
       * Concurrent permissions operations on the same file aren't supported; only the last update is
       * applied.
       *
       * Create a request for the method "permissions.update".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file or shared drive.
       * @param permissionId The ID of the permission.
       * @param content the {@link com.google.api.services.drive.model.Permission}
       * @since 1.13
       */
      protected Update(java.lang.String fileId, java.lang.String permissionId, com.google.api.services.drive.model.Permission content) {
        super(Drive.this, "PATCH", REST_PATH, content, com.google.api.services.drive.model.Permission.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.permissionId = com.google.api.client.util.Preconditions.checkNotNull(permissionId, "Required parameter permissionId must be specified.");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the file or shared drive. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file or shared drive.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file or shared drive. */
      public Update setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the permission. */
      @com.google.api.client.util.Key
      private java.lang.String permissionId;

      /** The ID of the permission.
       */
      public java.lang.String getPermissionId() {
        return permissionId;
      }

      /** The ID of the permission. */
      public Update setPermissionId(java.lang.String permissionId) {
        this.permissionId = permissionId;
        return this;
      }

      /** Whether the request should enforce expansive access rules. */
      @com.google.api.client.util.Key
      private java.lang.Boolean enforceExpansiveAccess;

      /** Whether the request should enforce expansive access rules. [default: false]
       */
      public java.lang.Boolean getEnforceExpansiveAccess() {
        return enforceExpansiveAccess;
      }

      /** Whether the request should enforce expansive access rules. */
      public Update setEnforceExpansiveAccess(java.lang.Boolean enforceExpansiveAccess) {
        this.enforceExpansiveAccess = enforceExpansiveAccess;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the request should enforce expansive access rules.
       * </p>
       */
      public boolean isEnforceExpansiveAccess() {
        if (enforceExpansiveAccess == null || enforceExpansiveAccess == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return enforceExpansiveAccess;
      }

      /** Whether to remove the expiration date. */
      @com.google.api.client.util.Key
      private java.lang.Boolean removeExpiration;

      /** Whether to remove the expiration date. [default: false]
       */
      public java.lang.Boolean getRemoveExpiration() {
        return removeExpiration;
      }

      /** Whether to remove the expiration date. */
      public Update setRemoveExpiration(java.lang.Boolean removeExpiration) {
        this.removeExpiration = removeExpiration;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to remove the expiration date.
       * </p>
       */
      public boolean isRemoveExpiration() {
        if (removeExpiration == null || removeExpiration == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return removeExpiration;
      }

      /** Whether the requesting application supports both My Drives and shared drives. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsAllDrives;

      /** Whether the requesting application supports both My Drives and shared drives. [default: false]
       */
      public java.lang.Boolean getSupportsAllDrives() {
        return supportsAllDrives;
      }

      /** Whether the requesting application supports both My Drives and shared drives. */
      public Update setSupportsAllDrives(java.lang.Boolean supportsAllDrives) {
        this.supportsAllDrives = supportsAllDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the requesting application supports both My Drives and shared drives.
       * </p>
       */
      public boolean isSupportsAllDrives() {
        if (supportsAllDrives == null || supportsAllDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsAllDrives;
      }

      /** Deprecated: Use `supportsAllDrives` instead. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsTeamDrives;

      /** Deprecated: Use `supportsAllDrives` instead. [default: false]
       */
      public java.lang.Boolean getSupportsTeamDrives() {
        return supportsTeamDrives;
      }

      /** Deprecated: Use `supportsAllDrives` instead. */
      public Update setSupportsTeamDrives(java.lang.Boolean supportsTeamDrives) {
        this.supportsTeamDrives = supportsTeamDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Deprecated: Use `supportsAllDrives` instead.
       * </p>
       */
      public boolean isSupportsTeamDrives() {
        if (supportsTeamDrives == null || supportsTeamDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsTeamDrives;
      }

      /**
       * Whether to transfer ownership to the specified user and downgrade the current owner to a
       * writer. This parameter is required as an acknowledgement of the side effect. For more
       * information, see [Transfer file
       * ownership](https://developers.google.com//workspace/drive/api/guides/transfer-file).
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean transferOwnership;

      /** Whether to transfer ownership to the specified user and downgrade the current owner to a writer.
     This parameter is required as an acknowledgement of the side effect. For more information, see
     [Transfer file ownership](https://developers.google.com//workspace/drive/api/guides/transfer-file).
     [default: false]
       */
      public java.lang.Boolean getTransferOwnership() {
        return transferOwnership;
      }

      /**
       * Whether to transfer ownership to the specified user and downgrade the current owner to a
       * writer. This parameter is required as an acknowledgement of the side effect. For more
       * information, see [Transfer file
       * ownership](https://developers.google.com//workspace/drive/api/guides/transfer-file).
       */
      public Update setTransferOwnership(java.lang.Boolean transferOwnership) {
        this.transferOwnership = transferOwnership;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to transfer ownership to the specified user and downgrade the current owner to a writer.
     This parameter is required as an acknowledgement of the side effect. For more information, see
     [Transfer file ownership](https://developers.google.com//workspace/drive/api/guides/transfer-file).
       * </p>
       */
      public boolean isTransferOwnership() {
        if (transferOwnership == null || transferOwnership == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return transferOwnership;
      }

      /**
       * Issue the request as a domain administrator. If set to `true`, and if the following
       * additional conditions are met, the requester is granted access: 1. The file ID parameter
       * refers to a shared drive. 2. The requester is an administrator of the domain to which the
       * shared drive belongs. For more information, see [Manage shared drives as domain
       * administrators](https://developers.google.com/workspace/drive/api/guides/manage-
       * shareddrives#manage-administrators).
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean useDomainAdminAccess;

      /** Issue the request as a domain administrator. If set to `true`, and if the following additional
     conditions are met, the requester is granted access: 1. The file ID parameter refers to a shared
     drive. 2. The requester is an administrator of the domain to which the shared drive belongs. For
     more information, see [Manage shared drives as domain
     administrators](https://developers.google.com/workspace/drive/api/guides/manage-
     shareddrives#manage-administrators). [default: false]
       */
      public java.lang.Boolean getUseDomainAdminAccess() {
        return useDomainAdminAccess;
      }

      /**
       * Issue the request as a domain administrator. If set to `true`, and if the following
       * additional conditions are met, the requester is granted access: 1. The file ID parameter
       * refers to a shared drive. 2. The requester is an administrator of the domain to which the
       * shared drive belongs. For more information, see [Manage shared drives as domain
       * administrators](https://developers.google.com/workspace/drive/api/guides/manage-
       * shareddrives#manage-administrators).
       */
      public Update setUseDomainAdminAccess(java.lang.Boolean useDomainAdminAccess) {
        this.useDomainAdminAccess = useDomainAdminAccess;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Issue the request as a domain administrator. If set to `true`, and if the following additional
     conditions are met, the requester is granted access: 1. The file ID parameter refers to a shared
     drive. 2. The requester is an administrator of the domain to which the shared drive belongs. For
     more information, see [Manage shared drives as domain
     administrators](https://developers.google.com/workspace/drive/api/guides/manage-
     shareddrives#manage-administrators).
       * </p>
       */
      public boolean isUseDomainAdminAccess() {
        if (useDomainAdminAccess == null || useDomainAdminAccess == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return useDomainAdminAccess;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Replies collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Replies.List request = drive.replies().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Replies replies() {
    return new Replies();
  }

  /**
   * The "replies" collection of methods.
   */
  public class Replies {

    /**
     * Creates a reply to a comment. For more information, see [Manage comments and
     * replies](https://developers.google.com/workspace/drive/api/guides/manage-comments).
     *
     * Create a request for the method "replies.create".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Create#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param commentId The ID of the comment.
     * @param content the {@link com.google.api.services.drive.model.Reply}
     * @return the request
     */
    public Create create(java.lang.String fileId, java.lang.String commentId, com.google.api.services.drive.model.Reply content) throws java.io.IOException {
      Create result = new Create(fileId, commentId, content);
      initialize(result);
      return result;
    }

    public class Create extends DriveRequest<com.google.api.services.drive.model.Reply> {

      private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies";

      /**
       * Creates a reply to a comment. For more information, see [Manage comments and
       * replies](https://developers.google.com/workspace/drive/api/guides/manage-comments).
       *
       * Create a request for the method "replies.create".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
       * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param commentId The ID of the comment.
       * @param content the {@link com.google.api.services.drive.model.Reply}
       * @since 1.13
       */
      protected Create(java.lang.String fileId, java.lang.String commentId, com.google.api.services.drive.model.Reply content) {
        super(Drive.this, "POST", REST_PATH, content, com.google.api.services.drive.model.Reply.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.commentId = com.google.api.client.util.Preconditions.checkNotNull(commentId, "Required parameter commentId must be specified.");
      }

      @Override
      public Create set$Xgafv(java.lang.String $Xgafv) {
        return (Create) super.set$Xgafv($Xgafv);
      }

      @Override
      public Create setAccessToken(java.lang.String accessToken) {
        return (Create) super.setAccessToken(accessToken);
      }

      @Override
      public Create setAlt(java.lang.String alt) {
        return (Create) super.setAlt(alt);
      }

      @Override
      public Create setCallback(java.lang.String callback) {
        return (Create) super.setCallback(callback);
      }

      @Override
      public Create setFields(java.lang.String fields) {
        return (Create) super.setFields(fields);
      }

      @Override
      public Create setKey(java.lang.String key) {
        return (Create) super.setKey(key);
      }

      @Override
      public Create setOauthToken(java.lang.String oauthToken) {
        return (Create) super.setOauthToken(oauthToken);
      }

      @Override
      public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Create) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Create setQuotaUser(java.lang.String quotaUser) {
        return (Create) super.setQuotaUser(quotaUser);
      }

      @Override
      public Create setUploadType(java.lang.String uploadType) {
        return (Create) super.setUploadType(uploadType);
      }

      @Override
      public Create setUploadProtocol(java.lang.String uploadProtocol) {
        return (Create) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Create setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the comment. */
      @com.google.api.client.util.Key
      private java.lang.String commentId;

      /** The ID of the comment.
       */
      public java.lang.String getCommentId() {
        return commentId;
      }

      /** The ID of the comment. */
      public Create setCommentId(java.lang.String commentId) {
        this.commentId = commentId;
        return this;
      }

      @Override
      public Create set(String parameterName, Object value) {
        return (Create) super.set(parameterName, value);
      }
    }
    /**
     * Deletes a reply. For more information, see [Manage comments and
     * replies](https://developers.google.com/workspace/drive/api/guides/manage-comments).
     *
     * Create a request for the method "replies.delete".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param commentId The ID of the comment.
     * @param replyId The ID of the reply.
     * @return the request
     */
    public Delete delete(java.lang.String fileId, java.lang.String commentId, java.lang.String replyId) throws java.io.IOException {
      Delete result = new Delete(fileId, commentId, replyId);
      initialize(result);
      return result;
    }

    public class Delete extends DriveRequest<Void> {

      private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies/{replyId}";

      /**
       * Deletes a reply. For more information, see [Manage comments and
       * replies](https://developers.google.com/workspace/drive/api/guides/manage-comments).
       *
       * Create a request for the method "replies.delete".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param commentId The ID of the comment.
       * @param replyId The ID of the reply.
       * @since 1.13
       */
      protected Delete(java.lang.String fileId, java.lang.String commentId, java.lang.String replyId) {
        super(Drive.this, "DELETE", REST_PATH, null, Void.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.commentId = com.google.api.client.util.Preconditions.checkNotNull(commentId, "Required parameter commentId must be specified.");
        this.replyId = com.google.api.client.util.Preconditions.checkNotNull(replyId, "Required parameter replyId must be specified.");
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Delete setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the comment. */
      @com.google.api.client.util.Key
      private java.lang.String commentId;

      /** The ID of the comment.
       */
      public java.lang.String getCommentId() {
        return commentId;
      }

      /** The ID of the comment. */
      public Delete setCommentId(java.lang.String commentId) {
        this.commentId = commentId;
        return this;
      }

      /** The ID of the reply. */
      @com.google.api.client.util.Key
      private java.lang.String replyId;

      /** The ID of the reply.
       */
      public java.lang.String getReplyId() {
        return replyId;
      }

      /** The ID of the reply. */
      public Delete setReplyId(java.lang.String replyId) {
        this.replyId = replyId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Gets a reply by ID. For more information, see [Manage comments and
     * replies](https://developers.google.com/workspace/drive/api/guides/manage-comments).
     *
     * Create a request for the method "replies.get".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param commentId The ID of the comment.
     * @param replyId The ID of the reply.
     * @return the request
     */
    public Get get(java.lang.String fileId, java.lang.String commentId, java.lang.String replyId) throws java.io.IOException {
      Get result = new Get(fileId, commentId, replyId);
      initialize(result);
      return result;
    }

    public class Get extends DriveRequest<com.google.api.services.drive.model.Reply> {

      private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies/{replyId}";

      /**
       * Gets a reply by ID. For more information, see [Manage comments and
       * replies](https://developers.google.com/workspace/drive/api/guides/manage-comments).
       *
       * Create a request for the method "replies.get".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param commentId The ID of the comment.
       * @param replyId The ID of the reply.
       * @since 1.13
       */
      protected Get(java.lang.String fileId, java.lang.String commentId, java.lang.String replyId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.Reply.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.commentId = com.google.api.client.util.Preconditions.checkNotNull(commentId, "Required parameter commentId must be specified.");
        this.replyId = com.google.api.client.util.Preconditions.checkNotNull(replyId, "Required parameter replyId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Get setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the comment. */
      @com.google.api.client.util.Key
      private java.lang.String commentId;

      /** The ID of the comment.
       */
      public java.lang.String getCommentId() {
        return commentId;
      }

      /** The ID of the comment. */
      public Get setCommentId(java.lang.String commentId) {
        this.commentId = commentId;
        return this;
      }

      /** The ID of the reply. */
      @com.google.api.client.util.Key
      private java.lang.String replyId;

      /** The ID of the reply.
       */
      public java.lang.String getReplyId() {
        return replyId;
      }

      /** The ID of the reply. */
      public Get setReplyId(java.lang.String replyId) {
        this.replyId = replyId;
        return this;
      }

      /**
       * Whether to return deleted replies. Deleted replies don't include their original content.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeDeleted;

      /** Whether to return deleted replies. Deleted replies don't include their original content. [default:
     false]
       */
      public java.lang.Boolean getIncludeDeleted() {
        return includeDeleted;
      }

      /**
       * Whether to return deleted replies. Deleted replies don't include their original content.
       */
      public Get setIncludeDeleted(java.lang.Boolean includeDeleted) {
        this.includeDeleted = includeDeleted;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to return deleted replies. Deleted replies don't include their original content.
       * </p>
       */
      public boolean isIncludeDeleted() {
        if (includeDeleted == null || includeDeleted == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return includeDeleted;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Lists a comment's replies. For more information, see [Manage comments and
     * replies](https://developers.google.com/workspace/drive/api/guides/manage-comments).
     *
     * Create a request for the method "replies.list".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param commentId The ID of the comment.
     * @return the request
     */
    public List list(java.lang.String fileId, java.lang.String commentId) throws java.io.IOException {
      List result = new List(fileId, commentId);
      initialize(result);
      return result;
    }

    public class List extends DriveRequest<com.google.api.services.drive.model.ReplyList> {

      private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies";

      /**
       * Lists a comment's replies. For more information, see [Manage comments and
       * replies](https://developers.google.com/workspace/drive/api/guides/manage-comments).
       *
       * Create a request for the method "replies.list".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param commentId The ID of the comment.
       * @since 1.13
       */
      protected List(java.lang.String fileId, java.lang.String commentId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.ReplyList.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.commentId = com.google.api.client.util.Preconditions.checkNotNull(commentId, "Required parameter commentId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public List setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the comment. */
      @com.google.api.client.util.Key
      private java.lang.String commentId;

      /** The ID of the comment.
       */
      public java.lang.String getCommentId() {
        return commentId;
      }

      /** The ID of the comment. */
      public List setCommentId(java.lang.String commentId) {
        this.commentId = commentId;
        return this;
      }

      /**
       * Whether to include deleted replies. Deleted replies don't include their original content.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeDeleted;

      /** Whether to include deleted replies. Deleted replies don't include their original content. [default:
     false]
       */
      public java.lang.Boolean getIncludeDeleted() {
        return includeDeleted;
      }

      /**
       * Whether to include deleted replies. Deleted replies don't include their original content.
       */
      public List setIncludeDeleted(java.lang.Boolean includeDeleted) {
        this.includeDeleted = includeDeleted;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to include deleted replies. Deleted replies don't include their original content.
       * </p>
       */
      public boolean isIncludeDeleted() {
        if (includeDeleted == null || includeDeleted == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return includeDeleted;
      }

      /** The maximum number of replies to return per page. */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** The maximum number of replies to return per page. [default: 20] [minimum: 1] [maximum: 100]
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /** The maximum number of replies to return per page. */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /**
       * The token for continuing a previous list request on the next page. This should be set to
       * the value of `nextPageToken` from the previous response.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The token for continuing a previous list request on the next page. This should be set to the value
     of `nextPageToken` from the previous response.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The token for continuing a previous list request on the next page. This should be set to
       * the value of `nextPageToken` from the previous response.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates a reply with patch semantics. For more information, see [Manage comments and
     * replies](https://developers.google.com/workspace/drive/api/guides/manage-comments).
     *
     * Create a request for the method "replies.update".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param commentId The ID of the comment.
     * @param replyId The ID of the reply.
     * @param content the {@link com.google.api.services.drive.model.Reply}
     * @return the request
     */
    public Update update(java.lang.String fileId, java.lang.String commentId, java.lang.String replyId, com.google.api.services.drive.model.Reply content) throws java.io.IOException {
      Update result = new Update(fileId, commentId, replyId, content);
      initialize(result);
      return result;
    }

    public class Update extends DriveRequest<com.google.api.services.drive.model.Reply> {

      private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies/{replyId}";

      /**
       * Updates a reply with patch semantics. For more information, see [Manage comments and
       * replies](https://developers.google.com/workspace/drive/api/guides/manage-comments).
       *
       * Create a request for the method "replies.update".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param commentId The ID of the comment.
       * @param replyId The ID of the reply.
       * @param content the {@link com.google.api.services.drive.model.Reply}
       * @since 1.13
       */
      protected Update(java.lang.String fileId, java.lang.String commentId, java.lang.String replyId, com.google.api.services.drive.model.Reply content) {
        super(Drive.this, "PATCH", REST_PATH, content, com.google.api.services.drive.model.Reply.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.commentId = com.google.api.client.util.Preconditions.checkNotNull(commentId, "Required parameter commentId must be specified.");
        this.replyId = com.google.api.client.util.Preconditions.checkNotNull(replyId, "Required parameter replyId must be specified.");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getContent(), "Reply.getContent()");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Update setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the comment. */
      @com.google.api.client.util.Key
      private java.lang.String commentId;

      /** The ID of the comment.
       */
      public java.lang.String getCommentId() {
        return commentId;
      }

      /** The ID of the comment. */
      public Update setCommentId(java.lang.String commentId) {
        this.commentId = commentId;
        return this;
      }

      /** The ID of the reply. */
      @com.google.api.client.util.Key
      private java.lang.String replyId;

      /** The ID of the reply.
       */
      public java.lang.String getReplyId() {
        return replyId;
      }

      /** The ID of the reply. */
      public Update setReplyId(java.lang.String replyId) {
        this.replyId = replyId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Revisions collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Revisions.List request = drive.revisions().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Revisions revisions() {
    return new Revisions();
  }

  /**
   * The "revisions" collection of methods.
   */
  public class Revisions {

    /**
     * Permanently deletes a file version. You can only delete revisions for files with binary content
     * in Google Drive, like images or videos. Revisions for other files, like Google Docs or Sheets,
     * and the last remaining file version can't be deleted. For more information, see [Manage file
     * revisions](https://developers.google.com/drive/api/guides/manage-revisions).
     *
     * Create a request for the method "revisions.delete".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param revisionId The ID of the revision.
     * @return the request
     */
    public Delete delete(java.lang.String fileId, java.lang.String revisionId) throws java.io.IOException {
      Delete result = new Delete(fileId, revisionId);
      initialize(result);
      return result;
    }

    public class Delete extends DriveRequest<Void> {

      private static final String REST_PATH = "files/{fileId}/revisions/{revisionId}";

      /**
       * Permanently deletes a file version. You can only delete revisions for files with binary content
       * in Google Drive, like images or videos. Revisions for other files, like Google Docs or Sheets,
       * and the last remaining file version can't be deleted. For more information, see [Manage file
       * revisions](https://developers.google.com/drive/api/guides/manage-revisions).
       *
       * Create a request for the method "revisions.delete".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param revisionId The ID of the revision.
       * @since 1.13
       */
      protected Delete(java.lang.String fileId, java.lang.String revisionId) {
        super(Drive.this, "DELETE", REST_PATH, null, Void.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.revisionId = com.google.api.client.util.Preconditions.checkNotNull(revisionId, "Required parameter revisionId must be specified.");
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Delete setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the revision. */
      @com.google.api.client.util.Key
      private java.lang.String revisionId;

      /** The ID of the revision.
       */
      public java.lang.String getRevisionId() {
        return revisionId;
      }

      /** The ID of the revision. */
      public Delete setRevisionId(java.lang.String revisionId) {
        this.revisionId = revisionId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Gets a revision's metadata or content by ID. For more information, see [Manage file
     * revisions](https://developers.google.com/workspace/drive/api/guides/manage-revisions).
     *
     * Create a request for the method "revisions.get".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param revisionId The ID of the revision.
     * @return the request
     */
    public Get get(java.lang.String fileId, java.lang.String revisionId) throws java.io.IOException {
      Get result = new Get(fileId, revisionId);
      initialize(result);
      return result;
    }

    public class Get extends DriveRequest<com.google.api.services.drive.model.Revision> {

      private static final String REST_PATH = "files/{fileId}/revisions/{revisionId}";

      /**
       * Gets a revision's metadata or content by ID. For more information, see [Manage file
       * revisions](https://developers.google.com/workspace/drive/api/guides/manage-revisions).
       *
       * Create a request for the method "revisions.get".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param revisionId The ID of the revision.
       * @since 1.13
       */
      protected Get(java.lang.String fileId, java.lang.String revisionId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.Revision.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.revisionId = com.google.api.client.util.Preconditions.checkNotNull(revisionId, "Required parameter revisionId must be specified.");
        initializeMediaDownload();
      }

      @Override
      public void executeMediaAndDownloadTo(java.io.OutputStream outputStream) throws java.io.IOException {
        super.executeMediaAndDownloadTo(outputStream);
      }

      @Override
      public java.io.InputStream executeMediaAsInputStream() throws java.io.IOException {
        return super.executeMediaAsInputStream();
      }

      @Override
      public com.google.api.client.http.HttpResponse executeMedia() throws java.io.IOException {
        return super.executeMedia();
      }

      @Override
      public com.google.api.client.http.GenericUrl buildHttpRequestUrl() {
        java.lang.String baseUrl = ("media".equals(get("alt")) && getMediaHttpUploader() == null)
            ? getRootUrl() + "download/" + getServicePath() : getBaseUrl();
        return new com.google.api.client.http.GenericUrl(
            com.google.api.client.http.UriTemplate.expand(baseUrl, getUriTemplate(), this, true));
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Get setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the revision. */
      @com.google.api.client.util.Key
      private java.lang.String revisionId;

      /** The ID of the revision.
       */
      public java.lang.String getRevisionId() {
        return revisionId;
      }

      /** The ID of the revision. */
      public Get setRevisionId(java.lang.String revisionId) {
        this.revisionId = revisionId;
        return this;
      }

      /**
       * Whether the user is acknowledging the risk of downloading known malware or other abusive
       * files. This is only applicable when the `alt` parameter is set to `media` and the user is
       * the owner of the file or an organizer of the shared drive in which the file resides.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean acknowledgeAbuse;

      /** Whether the user is acknowledging the risk of downloading known malware or other abusive files.
     This is only applicable when the `alt` parameter is set to `media` and the user is the owner of the
     file or an organizer of the shared drive in which the file resides. [default: false]
       */
      public java.lang.Boolean getAcknowledgeAbuse() {
        return acknowledgeAbuse;
      }

      /**
       * Whether the user is acknowledging the risk of downloading known malware or other abusive
       * files. This is only applicable when the `alt` parameter is set to `media` and the user is
       * the owner of the file or an organizer of the shared drive in which the file resides.
       */
      public Get setAcknowledgeAbuse(java.lang.Boolean acknowledgeAbuse) {
        this.acknowledgeAbuse = acknowledgeAbuse;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the user is acknowledging the risk of downloading known malware or other abusive files.
     This is only applicable when the `alt` parameter is set to `media` and the user is the owner of the
     file or an organizer of the shared drive in which the file resides.
       * </p>
       */
      public boolean isAcknowledgeAbuse() {
        if (acknowledgeAbuse == null || acknowledgeAbuse == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return acknowledgeAbuse;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Lists a file's revisions. For more information, see [Manage file
     * revisions](https://developers.google.com/workspace/drive/api/guides/manage-revisions).
     * **Important:** The list of revisions returned by this method might be incomplete for files with a
     * large revision history, including frequently edited Google Docs, Sheets, and Slides. Older
     * revisions might be omitted from the response, meaning the first revision returned may not be the
     * oldest existing revision. The revision history visible in the Workspace editor user interface
     * might be more complete than the list returned by the API.
     *
     * Create a request for the method "revisions.list".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @return the request
     */
    public List list(java.lang.String fileId) throws java.io.IOException {
      List result = new List(fileId);
      initialize(result);
      return result;
    }

    public class List extends DriveRequest<com.google.api.services.drive.model.RevisionList> {

      private static final String REST_PATH = "files/{fileId}/revisions";

      /**
       * Lists a file's revisions. For more information, see [Manage file
       * revisions](https://developers.google.com/workspace/drive/api/guides/manage-revisions).
       * **Important:** The list of revisions returned by this method might be incomplete for files with
       * a large revision history, including frequently edited Google Docs, Sheets, and Slides. Older
       * revisions might be omitted from the response, meaning the first revision returned may not be
       * the oldest existing revision. The revision history visible in the Workspace editor user
       * interface might be more complete than the list returned by the API.
       *
       * Create a request for the method "revisions.list".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @since 1.13
       */
      protected List(java.lang.String fileId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.RevisionList.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public List setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The maximum number of revisions to return per page. */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** The maximum number of revisions to return per page. [default: 200] [minimum: 1] [maximum: 1000]
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /** The maximum number of revisions to return per page. */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /**
       * The token for continuing a previous list request on the next page. This should be set to
       * the value of 'nextPageToken' from the previous response.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The token for continuing a previous list request on the next page. This should be set to the value
     of 'nextPageToken' from the previous response.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The token for continuing a previous list request on the next page. This should be set to
       * the value of 'nextPageToken' from the previous response.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates a revision with patch semantics. For more information, see [Manage file
     * revisions](https://developers.google.com/workspace/drive/api/guides/manage-revisions).
     *
     * Create a request for the method "revisions.update".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param revisionId The ID of the revision.
     * @param content the {@link com.google.api.services.drive.model.Revision}
     * @return the request
     */
    public Update update(java.lang.String fileId, java.lang.String revisionId, com.google.api.services.drive.model.Revision content) throws java.io.IOException {
      Update result = new Update(fileId, revisionId, content);
      initialize(result);
      return result;
    }

    public class Update extends DriveRequest<com.google.api.services.drive.model.Revision> {

      private static final String REST_PATH = "files/{fileId}/revisions/{revisionId}";

      /**
       * Updates a revision with patch semantics. For more information, see [Manage file
       * revisions](https://developers.google.com/workspace/drive/api/guides/manage-revisions).
       *
       * Create a request for the method "revisions.update".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param revisionId The ID of the revision.
       * @param content the {@link com.google.api.services.drive.model.Revision}
       * @since 1.13
       */
      protected Update(java.lang.String fileId, java.lang.String revisionId, com.google.api.services.drive.model.Revision content) {
        super(Drive.this, "PATCH", REST_PATH, content, com.google.api.services.drive.model.Revision.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.revisionId = com.google.api.client.util.Preconditions.checkNotNull(revisionId, "Required parameter revisionId must be specified.");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Update setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the revision. */
      @com.google.api.client.util.Key
      private java.lang.String revisionId;

      /** The ID of the revision.
       */
      public java.lang.String getRevisionId() {
        return revisionId;
      }

      /** The ID of the revision. */
      public Update setRevisionId(java.lang.String revisionId) {
        this.revisionId = revisionId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Teamdrives collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Teamdrives.List request = drive.teamdrives().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Teamdrives teamdrives() {
    return new Teamdrives();
  }

  /**
   * The "teamdrives" collection of methods.
   */
  public class Teamdrives {

    /**
     * Deprecated: Use `drives.create` instead.
     *
     * Create a request for the method "teamdrives.create".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Create#execute()} method to invoke the remote operation.
     *
     * @param requestId Required. An ID, such as a random UUID, which uniquely identifies this user's request for idempotent
     *        creation of a Team Drive. A repeated request by the same user and with the same request ID
     *        will avoid creating duplicates by attempting to create the same Team Drive. If the Team
     *        Drive already exists a 409 error will be returned.
     * @param content the {@link com.google.api.services.drive.model.TeamDrive}
     * @return the request
     */
    public Create create(java.lang.String requestId, com.google.api.services.drive.model.TeamDrive content) throws java.io.IOException {
      Create result = new Create(requestId, content);
      initialize(result);
      return result;
    }

    public class Create extends DriveRequest<com.google.api.services.drive.model.TeamDrive> {

      private static final String REST_PATH = "teamdrives";

      /**
       * Deprecated: Use `drives.create` instead.
       *
       * Create a request for the method "teamdrives.create".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
       * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param requestId Required. An ID, such as a random UUID, which uniquely identifies this user's request for idempotent
     *        creation of a Team Drive. A repeated request by the same user and with the same request ID
     *        will avoid creating duplicates by attempting to create the same Team Drive. If the Team
     *        Drive already exists a 409 error will be returned.
       * @param content the {@link com.google.api.services.drive.model.TeamDrive}
       * @since 1.13
       */
      protected Create(java.lang.String requestId, com.google.api.services.drive.model.TeamDrive content) {
        super(Drive.this, "POST", REST_PATH, content, com.google.api.services.drive.model.TeamDrive.class);
        this.requestId = com.google.api.client.util.Preconditions.checkNotNull(requestId, "Required parameter requestId must be specified.");
      }

      @Override
      public Create set$Xgafv(java.lang.String $Xgafv) {
        return (Create) super.set$Xgafv($Xgafv);
      }

      @Override
      public Create setAccessToken(java.lang.String accessToken) {
        return (Create) super.setAccessToken(accessToken);
      }

      @Override
      public Create setAlt(java.lang.String alt) {
        return (Create) super.setAlt(alt);
      }

      @Override
      public Create setCallback(java.lang.String callback) {
        return (Create) super.setCallback(callback);
      }

      @Override
      public Create setFields(java.lang.String fields) {
        return (Create) super.setFields(fields);
      }

      @Override
      public Create setKey(java.lang.String key) {
        return (Create) super.setKey(key);
      }

      @Override
      public Create setOauthToken(java.lang.String oauthToken) {
        return (Create) super.setOauthToken(oauthToken);
      }

      @Override
      public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Create) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Create setQuotaUser(java.lang.String quotaUser) {
        return (Create) super.setQuotaUser(quotaUser);
      }

      @Override
      public Create setUploadType(java.lang.String uploadType) {
        return (Create) super.setUploadType(uploadType);
      }

      @Override
      public Create setUploadProtocol(java.lang.String uploadProtocol) {
        return (Create) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Required. An ID, such as a random UUID, which uniquely identifies this user's request for
       * idempotent creation of a Team Drive. A repeated request by the same user and with the same
       * request ID will avoid creating duplicates by attempting to create the same Team Drive. If
       * the Team Drive already exists a 409 error will be returned.
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** Required. An ID, such as a random UUID, which uniquely identifies this user's request for
     idempotent creation of a Team Drive. A repeated request by the same user and with the same request
     ID will avoid creating duplicates by attempting to create the same Team Drive. If the Team Drive
     already exists a 409 error will be returned.
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * Required. An ID, such as a random UUID, which uniquely identifies this user's request for
       * idempotent creation of a Team Drive. A repeated request by the same user and with the same
       * request ID will avoid creating duplicates by attempting to create the same Team Drive. If
       * the Team Drive already exists a 409 error will be returned.
       */
      public Create setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Create set(String parameterName, Object value) {
        return (Create) super.set(parameterName, value);
      }
    }
    /**
     * Deprecated: Use `drives.delete` instead.
     *
     * Create a request for the method "teamdrives.delete".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param teamDriveId The ID of the Team Drive
     * @return the request
     */
    public Delete delete(java.lang.String teamDriveId) throws java.io.IOException {
      Delete result = new Delete(teamDriveId);
      initialize(result);
      return result;
    }

    public class Delete extends DriveRequest<Void> {

      private static final String REST_PATH = "teamdrives/{teamDriveId}";

      /**
       * Deprecated: Use `drives.delete` instead.
       *
       * Create a request for the method "teamdrives.delete".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param teamDriveId The ID of the Team Drive
       * @since 1.13
       */
      protected Delete(java.lang.String teamDriveId) {
        super(Drive.this, "DELETE", REST_PATH, null, Void.class);
        this.teamDriveId = com.google.api.client.util.Preconditions.checkNotNull(teamDriveId, "Required parameter teamDriveId must be specified.");
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the Team Drive */
      @com.google.api.client.util.Key
      private java.lang.String teamDriveId;

      /** The ID of the Team Drive
       */
      public java.lang.String getTeamDriveId() {
        return teamDriveId;
      }

      /** The ID of the Team Drive */
      public Delete setTeamDriveId(java.lang.String teamDriveId) {
        this.teamDriveId = teamDriveId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Deprecated: Use `drives.get` instead.
     *
     * Create a request for the method "teamdrives.get".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param teamDriveId The ID of the Team Drive
     * @return the request
     */
    public Get get(java.lang.String teamDriveId) throws java.io.IOException {
      Get result = new Get(teamDriveId);
      initialize(result);
      return result;
    }

    public class Get extends DriveRequest<com.google.api.services.drive.model.TeamDrive> {

      private static final String REST_PATH = "teamdrives/{teamDriveId}";

      /**
       * Deprecated: Use `drives.get` instead.
       *
       * Create a request for the method "teamdrives.get".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param teamDriveId The ID of the Team Drive
       * @since 1.13
       */
      protected Get(java.lang.String teamDriveId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.TeamDrive.class);
        this.teamDriveId = com.google.api.client.util.Preconditions.checkNotNull(teamDriveId, "Required parameter teamDriveId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the Team Drive */
      @com.google.api.client.util.Key
      private java.lang.String teamDriveId;

      /** The ID of the Team Drive
       */
      public java.lang.String getTeamDriveId() {
        return teamDriveId;
      }

      /** The ID of the Team Drive */
      public Get setTeamDriveId(java.lang.String teamDriveId) {
        this.teamDriveId = teamDriveId;
        return this;
      }

      /**
       * Issue the request as a domain administrator; if set to true, then the requester will be
       * granted access if they are an administrator of the domain to which the Team Drive belongs.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean useDomainAdminAccess;

      /** Issue the request as a domain administrator; if set to true, then the requester will be granted
     access if they are an administrator of the domain to which the Team Drive belongs. [default: false]
       */
      public java.lang.Boolean getUseDomainAdminAccess() {
        return useDomainAdminAccess;
      }

      /**
       * Issue the request as a domain administrator; if set to true, then the requester will be
       * granted access if they are an administrator of the domain to which the Team Drive belongs.
       */
      public Get setUseDomainAdminAccess(java.lang.Boolean useDomainAdminAccess) {
        this.useDomainAdminAccess = useDomainAdminAccess;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Issue the request as a domain administrator; if set to true, then the requester will be granted
     access if they are an administrator of the domain to which the Team Drive belongs.
       * </p>
       */
      public boolean isUseDomainAdminAccess() {
        if (useDomainAdminAccess == null || useDomainAdminAccess == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return useDomainAdminAccess;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Deprecated: Use `drives.list` instead.
     *
     * Create a request for the method "teamdrives.list".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends DriveRequest<com.google.api.services.drive.model.TeamDriveList> {

      private static final String REST_PATH = "teamdrives";

      /**
       * Deprecated: Use `drives.list` instead.
       *
       * Create a request for the method "teamdrives.list".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.TeamDriveList.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** Maximum number of Team Drives to return. */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** Maximum number of Team Drives to return. [default: 10] [minimum: 1] [maximum: 100]
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /** Maximum number of Team Drives to return. */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /** Page token for Team Drives. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Page token for Team Drives.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Page token for Team Drives. */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Query string for searching Team Drives. */
      @com.google.api.client.util.Key
      private java.lang.String q;

      /** Query string for searching Team Drives.
       */
      public java.lang.String getQ() {
        return q;
      }

      /** Query string for searching Team Drives. */
      public List setQ(java.lang.String q) {
        this.q = q;
        return this;
      }

      /**
       * Issue the request as a domain administrator; if set to true, then all Team Drives of the
       * domain in which the requester is an administrator are returned.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean useDomainAdminAccess;

      /** Issue the request as a domain administrator; if set to true, then all Team Drives of the domain in
     which the requester is an administrator are returned. [default: false]
       */
      public java.lang.Boolean getUseDomainAdminAccess() {
        return useDomainAdminAccess;
      }

      /**
       * Issue the request as a domain administrator; if set to true, then all Team Drives of the
       * domain in which the requester is an administrator are returned.
       */
      public List setUseDomainAdminAccess(java.lang.Boolean useDomainAdminAccess) {
        this.useDomainAdminAccess = useDomainAdminAccess;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Issue the request as a domain administrator; if set to true, then all Team Drives of the domain in
     which the requester is an administrator are returned.
       * </p>
       */
      public boolean isUseDomainAdminAccess() {
        if (useDomainAdminAccess == null || useDomainAdminAccess == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return useDomainAdminAccess;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Deprecated: Use `drives.update` instead.
     *
     * Create a request for the method "teamdrives.update".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param teamDriveId The ID of the Team Drive
     * @param content the {@link com.google.api.services.drive.model.TeamDrive}
     * @return the request
     */
    public Update update(java.lang.String teamDriveId, com.google.api.services.drive.model.TeamDrive content) throws java.io.IOException {
      Update result = new Update(teamDriveId, content);
      initialize(result);
      return result;
    }

    public class Update extends DriveRequest<com.google.api.services.drive.model.TeamDrive> {

      private static final String REST_PATH = "teamdrives/{teamDriveId}";

      /**
       * Deprecated: Use `drives.update` instead.
       *
       * Create a request for the method "teamdrives.update".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param teamDriveId The ID of the Team Drive
       * @param content the {@link com.google.api.services.drive.model.TeamDrive}
       * @since 1.13
       */
      protected Update(java.lang.String teamDriveId, com.google.api.services.drive.model.TeamDrive content) {
        super(Drive.this, "PATCH", REST_PATH, content, com.google.api.services.drive.model.TeamDrive.class);
        this.teamDriveId = com.google.api.client.util.Preconditions.checkNotNull(teamDriveId, "Required parameter teamDriveId must be specified.");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the Team Drive */
      @com.google.api.client.util.Key
      private java.lang.String teamDriveId;

      /** The ID of the Team Drive
       */
      public java.lang.String getTeamDriveId() {
        return teamDriveId;
      }

      /** The ID of the Team Drive */
      public Update setTeamDriveId(java.lang.String teamDriveId) {
        this.teamDriveId = teamDriveId;
        return this;
      }

      /**
       * Issue the request as a domain administrator; if set to true, then the requester will be
       * granted access if they are an administrator of the domain to which the Team Drive belongs.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean useDomainAdminAccess;

      /** Issue the request as a domain administrator; if set to true, then the requester will be granted
     access if they are an administrator of the domain to which the Team Drive belongs. [default: false]
       */
      public java.lang.Boolean getUseDomainAdminAccess() {
        return useDomainAdminAccess;
      }

      /**
       * Issue the request as a domain administrator; if set to true, then the requester will be
       * granted access if they are an administrator of the domain to which the Team Drive belongs.
       */
      public Update setUseDomainAdminAccess(java.lang.Boolean useDomainAdminAccess) {
        this.useDomainAdminAccess = useDomainAdminAccess;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Issue the request as a domain administrator; if set to true, then the requester will be granted
     access if they are an administrator of the domain to which the Team Drive belongs.
       * </p>
       */
      public boolean isUseDomainAdminAccess() {
        if (useDomainAdminAccess == null || useDomainAdminAccess == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return useDomainAdminAccess;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link Drive}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    private static String chooseEndpoint(com.google.api.client.http.HttpTransport transport) {
      // If the GOOGLE_API_USE_MTLS_ENDPOINT environment variable value is "always", use mTLS endpoint.
      // If the env variable is "auto", use mTLS endpoint if and only if the transport is mTLS.
      // Use the regular endpoint for all other cases.
      String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
      useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
      if ("always".equals(useMtlsEndpoint) || ("auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls())) {
        return DEFAULT_MTLS_ROOT_URL;
      }
      return DEFAULT_ROOT_URL;
    }

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          Builder.chooseEndpoint(transport),
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link Drive}. */
    @Override
    public Drive build() {
      return new Drive(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link DriveRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setDriveRequestInitializer(
        DriveRequestInitializer driveRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(driveRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }

    @Override
    public Builder setUniverseDomain(String universeDomain) {
      return (Builder) super.setUniverseDomain(universeDomain);
    }
  }
}
