/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * Model definition for AppIcons.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Drive API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AppIcons extends com.google.api.client.json.GenericJson {

  /**
   * Category of the icon. Allowed values are: * `application` - The icon for the application. *
   * `document` - The icon for a file associated with the app. * `documentShared` - The icon for a
   * shared file associated with the app.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String category;

  /**
   * URL for the icon.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String iconUrl;

  /**
   * Size of the icon. Represented as the maximum of the width and height.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer size;

  /**
   * Category of the icon. Allowed values are: * `application` - The icon for the application. *
   * `document` - The icon for a file associated with the app. * `documentShared` - The icon for a
   * shared file associated with the app.
   * @return value or {@code null} for none
   */
  public java.lang.String getCategory() {
    return category;
  }

  /**
   * Category of the icon. Allowed values are: * `application` - The icon for the application. *
   * `document` - The icon for a file associated with the app. * `documentShared` - The icon for a
   * shared file associated with the app.
   * @param category category or {@code null} for none
   */
  public AppIcons setCategory(java.lang.String category) {
    this.category = category;
    return this;
  }

  /**
   * URL for the icon.
   * @return value or {@code null} for none
   */
  public java.lang.String getIconUrl() {
    return iconUrl;
  }

  /**
   * URL for the icon.
   * @param iconUrl iconUrl or {@code null} for none
   */
  public AppIcons setIconUrl(java.lang.String iconUrl) {
    this.iconUrl = iconUrl;
    return this;
  }

  /**
   * Size of the icon. Represented as the maximum of the width and height.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getSize() {
    return size;
  }

  /**
   * Size of the icon. Represented as the maximum of the width and height.
   * @param size size or {@code null} for none
   */
  public AppIcons setSize(java.lang.Integer size) {
    this.size = size;
    return this;
  }

  @Override
  public AppIcons set(String fieldName, Object value) {
    return (AppIcons) super.set(fieldName, value);
  }

  @Override
  public AppIcons clone() {
    return (AppIcons) super.clone();
  }

}
