/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * Response to a ModifyLabels request. This contains only those labels which were added or updated
 * by the request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Drive API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ModifyLabelsResponse extends com.google.api.client.json.GenericJson {

  /**
   * This is always drive#modifyLabelsResponse
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The list of labels which were added or updated by the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Label> modifiedLabels;

  static {
    // hack to force ProGuard to consider Label used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Label.class);
  }

  /**
   * This is always drive#modifyLabelsResponse
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This is always drive#modifyLabelsResponse
   * @param kind kind or {@code null} for none
   */
  public ModifyLabelsResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The list of labels which were added or updated by the request.
   * @return value or {@code null} for none
   */
  public java.util.List<Label> getModifiedLabels() {
    return modifiedLabels;
  }

  /**
   * The list of labels which were added or updated by the request.
   * @param modifiedLabels modifiedLabels or {@code null} for none
   */
  public ModifyLabelsResponse setModifiedLabels(java.util.List<Label> modifiedLabels) {
    this.modifiedLabels = modifiedLabels;
    return this;
  }

  @Override
  public ModifyLabelsResponse set(String fieldName, Object value) {
    return (ModifyLabelsResponse) super.set(fieldName, value);
  }

  @Override
  public ModifyLabelsResponse clone() {
    return (ModifyLabelsResponse) super.clone();
  }

}
