/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.dataproc;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.dataproc.DataprocRequest;
import com.google.api.services.dataproc.DataprocRequestInitializer;
import com.google.api.services.dataproc.model.CancelJobRequest;
import com.google.api.services.dataproc.model.Cluster;
import com.google.api.services.dataproc.model.DiagnoseClusterRequest;
import com.google.api.services.dataproc.model.Empty;
import com.google.api.services.dataproc.model.GetIamPolicyRequest;
import com.google.api.services.dataproc.model.InstantiateWorkflowTemplateRequest;
import com.google.api.services.dataproc.model.Job;
import com.google.api.services.dataproc.model.ListClustersResponse;
import com.google.api.services.dataproc.model.ListJobsResponse;
import com.google.api.services.dataproc.model.ListOperationsResponse;
import com.google.api.services.dataproc.model.ListWorkflowTemplatesResponse;
import com.google.api.services.dataproc.model.Operation;
import com.google.api.services.dataproc.model.Policy;
import com.google.api.services.dataproc.model.SetIamPolicyRequest;
import com.google.api.services.dataproc.model.SubmitJobRequest;
import com.google.api.services.dataproc.model.TestIamPermissionsRequest;
import com.google.api.services.dataproc.model.TestIamPermissionsResponse;
import com.google.api.services.dataproc.model.WorkflowTemplate;
import java.io.IOException;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dataproc
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://dataproc.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://dataproc.googleapis.com/";

    public Dataproc(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Dataproc(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.25.0 of the Cloud Dataproc API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://dataproc.googleapis.com/", Dataproc.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Dataproc.DEFAULT_BATCH_PATH);
        }

        public Dataproc build() {
            return new Dataproc(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setDataprocRequestInitializer(DataprocRequestInitializer dataprocRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)dataprocRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public Locations locations() {
            return new Locations();
        }

        public Regions regions() {
            return new Regions();
        }

        public class Regions {
            public AutoscalingPolicies autoscalingPolicies() {
                return new AutoscalingPolicies();
            }

            public Clusters clusters() {
                return new Clusters();
            }

            public Jobs jobs() {
                return new Jobs();
            }

            public Operations operations() {
                return new Operations();
            }

            public WorkflowTemplates workflowTemplates() {
                return new WorkflowTemplates();
            }

            public class WorkflowTemplates {
                public Create create(String string, WorkflowTemplate workflowTemplate) throws IOException {
                    Create create = new Create(string, workflowTemplate);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)create);
                    return create;
                }

                public Delete delete(String string) throws IOException {
                    Delete delete = new Delete(string);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)delete);
                    return delete;
                }

                public Get get(String string) throws IOException {
                    Get get = new Get(string);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)get);
                    return get;
                }

                public GetIamPolicy getIamPolicy(String string, GetIamPolicyRequest getIamPolicyRequest) throws IOException {
                    GetIamPolicy getIamPolicy = new GetIamPolicy(string, getIamPolicyRequest);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)getIamPolicy);
                    return getIamPolicy;
                }

                public Instantiate instantiate(String string, InstantiateWorkflowTemplateRequest instantiateWorkflowTemplateRequest) throws IOException {
                    Instantiate instantiate = new Instantiate(string, instantiateWorkflowTemplateRequest);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)instantiate);
                    return instantiate;
                }

                public InstantiateInline instantiateInline(String string, WorkflowTemplate workflowTemplate) throws IOException {
                    InstantiateInline instantiateInline = new InstantiateInline(string, workflowTemplate);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)instantiateInline);
                    return instantiateInline;
                }

                public List list(String string) throws IOException {
                    List list = new List(string);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                public SetIamPolicy setIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) throws IOException {
                    SetIamPolicy setIamPolicy = new SetIamPolicy(string, setIamPolicyRequest);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)setIamPolicy);
                    return setIamPolicy;
                }

                public TestIamPermissions testIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) throws IOException {
                    TestIamPermissions testIamPermissions = new TestIamPermissions(string, testIamPermissionsRequest);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)testIamPermissions);
                    return testIamPermissions;
                }

                public Update update(String string, WorkflowTemplate workflowTemplate) throws IOException {
                    Update update = new Update(string, workflowTemplate);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)update);
                    return update;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Update
                extends DataprocRequest<WorkflowTemplate> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Update(String string, WorkflowTemplate workflowTemplate) {
                        super(Dataproc.this, "PUT", REST_PATH, (Object)workflowTemplate, WorkflowTemplate.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/regions/[^/]+/workflowTemplates/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/regions/[^/]+/workflowTemplates/[^/]+$");
                        }
                    }

                    public Update set$Xgafv(String string) {
                        return (Update)super.set$Xgafv(string);
                    }

                    public Update setAccessToken(String string) {
                        return (Update)super.setAccessToken(string);
                    }

                    public Update setAlt(String string) {
                        return (Update)super.setAlt(string);
                    }

                    public Update setCallback(String string) {
                        return (Update)super.setCallback(string);
                    }

                    public Update setFields(String string) {
                        return (Update)super.setFields(string);
                    }

                    public Update setKey(String string) {
                        return (Update)super.setKey(string);
                    }

                    public Update setOauthToken(String string) {
                        return (Update)super.setOauthToken(string);
                    }

                    public Update setPrettyPrint(Boolean bl) {
                        return (Update)super.setPrettyPrint(bl);
                    }

                    public Update setQuotaUser(String string) {
                        return (Update)super.setQuotaUser(string);
                    }

                    public Update setUploadType(String string) {
                        return (Update)super.setUploadType(string);
                    }

                    public Update setUploadProtocol(String string) {
                        return (Update)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Update setName(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/regions/[^/]+/workflowTemplates/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Update set(String string, Object object) {
                        return (Update)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class TestIamPermissions
                extends DataprocRequest<TestIamPermissionsResponse> {
                    private static final String REST_PATH = "v1/{+resource}:testIamPermissions";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected TestIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) {
                        super(Dataproc.this, "POST", REST_PATH, (Object)testIamPermissionsRequest, TestIamPermissionsResponse.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/regions/[^/]+/workflowTemplates/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/regions/[^/]+/workflowTemplates/[^/]+$");
                        }
                    }

                    public TestIamPermissions set$Xgafv(String string) {
                        return (TestIamPermissions)super.set$Xgafv(string);
                    }

                    public TestIamPermissions setAccessToken(String string) {
                        return (TestIamPermissions)super.setAccessToken(string);
                    }

                    public TestIamPermissions setAlt(String string) {
                        return (TestIamPermissions)super.setAlt(string);
                    }

                    public TestIamPermissions setCallback(String string) {
                        return (TestIamPermissions)super.setCallback(string);
                    }

                    public TestIamPermissions setFields(String string) {
                        return (TestIamPermissions)super.setFields(string);
                    }

                    public TestIamPermissions setKey(String string) {
                        return (TestIamPermissions)super.setKey(string);
                    }

                    public TestIamPermissions setOauthToken(String string) {
                        return (TestIamPermissions)super.setOauthToken(string);
                    }

                    public TestIamPermissions setPrettyPrint(Boolean bl) {
                        return (TestIamPermissions)super.setPrettyPrint(bl);
                    }

                    public TestIamPermissions setQuotaUser(String string) {
                        return (TestIamPermissions)super.setQuotaUser(string);
                    }

                    public TestIamPermissions setUploadType(String string) {
                        return (TestIamPermissions)super.setUploadType(string);
                    }

                    public TestIamPermissions setUploadProtocol(String string) {
                        return (TestIamPermissions)super.setUploadProtocol(string);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public TestIamPermissions setResource(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/regions/[^/]+/workflowTemplates/[^/]+$");
                        }
                        this.resource = string;
                        return this;
                    }

                    @Override
                    public TestIamPermissions set(String string, Object object) {
                        return (TestIamPermissions)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class SetIamPolicy
                extends DataprocRequest<Policy> {
                    private static final String REST_PATH = "v1/{+resource}:setIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected SetIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) {
                        super(Dataproc.this, "POST", REST_PATH, (Object)setIamPolicyRequest, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/regions/[^/]+/workflowTemplates/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/regions/[^/]+/workflowTemplates/[^/]+$");
                        }
                    }

                    public SetIamPolicy set$Xgafv(String string) {
                        return (SetIamPolicy)super.set$Xgafv(string);
                    }

                    public SetIamPolicy setAccessToken(String string) {
                        return (SetIamPolicy)super.setAccessToken(string);
                    }

                    public SetIamPolicy setAlt(String string) {
                        return (SetIamPolicy)super.setAlt(string);
                    }

                    public SetIamPolicy setCallback(String string) {
                        return (SetIamPolicy)super.setCallback(string);
                    }

                    public SetIamPolicy setFields(String string) {
                        return (SetIamPolicy)super.setFields(string);
                    }

                    public SetIamPolicy setKey(String string) {
                        return (SetIamPolicy)super.setKey(string);
                    }

                    public SetIamPolicy setOauthToken(String string) {
                        return (SetIamPolicy)super.setOauthToken(string);
                    }

                    public SetIamPolicy setPrettyPrint(Boolean bl) {
                        return (SetIamPolicy)super.setPrettyPrint(bl);
                    }

                    public SetIamPolicy setQuotaUser(String string) {
                        return (SetIamPolicy)super.setQuotaUser(string);
                    }

                    public SetIamPolicy setUploadType(String string) {
                        return (SetIamPolicy)super.setUploadType(string);
                    }

                    public SetIamPolicy setUploadProtocol(String string) {
                        return (SetIamPolicy)super.setUploadProtocol(string);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public SetIamPolicy setResource(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/regions/[^/]+/workflowTemplates/[^/]+$");
                        }
                        this.resource = string;
                        return this;
                    }

                    @Override
                    public SetIamPolicy set(String string, Object object) {
                        return (SetIamPolicy)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends DataprocRequest<ListWorkflowTemplatesResponse> {
                    private static final String REST_PATH = "v1/{+parent}/workflowTemplates";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String pageToken;
                    @Key
                    private Integer pageSize;

                    protected List(String string) {
                        super(Dataproc.this, "GET", REST_PATH, null, ListWorkflowTemplatesResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/regions/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/regions/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/regions/[^/]+$");
                        }
                        this.parent = string;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String string) {
                        this.pageToken = string;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer n) {
                        this.pageSize = n;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class InstantiateInline
                extends DataprocRequest<Operation> {
                    private static final String REST_PATH = "v1/{+parent}/workflowTemplates:instantiateInline";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String requestId;

                    protected InstantiateInline(String string, WorkflowTemplate workflowTemplate) {
                        super(Dataproc.this, "POST", REST_PATH, (Object)workflowTemplate, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/regions/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/regions/[^/]+$");
                        }
                    }

                    public InstantiateInline set$Xgafv(String string) {
                        return (InstantiateInline)super.set$Xgafv(string);
                    }

                    public InstantiateInline setAccessToken(String string) {
                        return (InstantiateInline)super.setAccessToken(string);
                    }

                    public InstantiateInline setAlt(String string) {
                        return (InstantiateInline)super.setAlt(string);
                    }

                    public InstantiateInline setCallback(String string) {
                        return (InstantiateInline)super.setCallback(string);
                    }

                    public InstantiateInline setFields(String string) {
                        return (InstantiateInline)super.setFields(string);
                    }

                    public InstantiateInline setKey(String string) {
                        return (InstantiateInline)super.setKey(string);
                    }

                    public InstantiateInline setOauthToken(String string) {
                        return (InstantiateInline)super.setOauthToken(string);
                    }

                    public InstantiateInline setPrettyPrint(Boolean bl) {
                        return (InstantiateInline)super.setPrettyPrint(bl);
                    }

                    public InstantiateInline setQuotaUser(String string) {
                        return (InstantiateInline)super.setQuotaUser(string);
                    }

                    public InstantiateInline setUploadType(String string) {
                        return (InstantiateInline)super.setUploadType(string);
                    }

                    public InstantiateInline setUploadProtocol(String string) {
                        return (InstantiateInline)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public InstantiateInline setParent(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/regions/[^/]+$");
                        }
                        this.parent = string;
                        return this;
                    }

                    public String getRequestId() {
                        return this.requestId;
                    }

                    public InstantiateInline setRequestId(String string) {
                        this.requestId = string;
                        return this;
                    }

                    @Override
                    public InstantiateInline set(String string, Object object) {
                        return (InstantiateInline)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Instantiate
                extends DataprocRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}:instantiate";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Instantiate(String string, InstantiateWorkflowTemplateRequest instantiateWorkflowTemplateRequest) {
                        super(Dataproc.this, "POST", REST_PATH, (Object)instantiateWorkflowTemplateRequest, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/regions/[^/]+/workflowTemplates/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/regions/[^/]+/workflowTemplates/[^/]+$");
                        }
                    }

                    public Instantiate set$Xgafv(String string) {
                        return (Instantiate)super.set$Xgafv(string);
                    }

                    public Instantiate setAccessToken(String string) {
                        return (Instantiate)super.setAccessToken(string);
                    }

                    public Instantiate setAlt(String string) {
                        return (Instantiate)super.setAlt(string);
                    }

                    public Instantiate setCallback(String string) {
                        return (Instantiate)super.setCallback(string);
                    }

                    public Instantiate setFields(String string) {
                        return (Instantiate)super.setFields(string);
                    }

                    public Instantiate setKey(String string) {
                        return (Instantiate)super.setKey(string);
                    }

                    public Instantiate setOauthToken(String string) {
                        return (Instantiate)super.setOauthToken(string);
                    }

                    public Instantiate setPrettyPrint(Boolean bl) {
                        return (Instantiate)super.setPrettyPrint(bl);
                    }

                    public Instantiate setQuotaUser(String string) {
                        return (Instantiate)super.setQuotaUser(string);
                    }

                    public Instantiate setUploadType(String string) {
                        return (Instantiate)super.setUploadType(string);
                    }

                    public Instantiate setUploadProtocol(String string) {
                        return (Instantiate)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Instantiate setName(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/regions/[^/]+/workflowTemplates/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Instantiate set(String string, Object object) {
                        return (Instantiate)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class GetIamPolicy
                extends DataprocRequest<Policy> {
                    private static final String REST_PATH = "v1/{+resource}:getIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected GetIamPolicy(String string, GetIamPolicyRequest getIamPolicyRequest) {
                        super(Dataproc.this, "POST", REST_PATH, (Object)getIamPolicyRequest, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/regions/[^/]+/workflowTemplates/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/regions/[^/]+/workflowTemplates/[^/]+$");
                        }
                    }

                    public GetIamPolicy set$Xgafv(String string) {
                        return (GetIamPolicy)super.set$Xgafv(string);
                    }

                    public GetIamPolicy setAccessToken(String string) {
                        return (GetIamPolicy)super.setAccessToken(string);
                    }

                    public GetIamPolicy setAlt(String string) {
                        return (GetIamPolicy)super.setAlt(string);
                    }

                    public GetIamPolicy setCallback(String string) {
                        return (GetIamPolicy)super.setCallback(string);
                    }

                    public GetIamPolicy setFields(String string) {
                        return (GetIamPolicy)super.setFields(string);
                    }

                    public GetIamPolicy setKey(String string) {
                        return (GetIamPolicy)super.setKey(string);
                    }

                    public GetIamPolicy setOauthToken(String string) {
                        return (GetIamPolicy)super.setOauthToken(string);
                    }

                    public GetIamPolicy setPrettyPrint(Boolean bl) {
                        return (GetIamPolicy)super.setPrettyPrint(bl);
                    }

                    public GetIamPolicy setQuotaUser(String string) {
                        return (GetIamPolicy)super.setQuotaUser(string);
                    }

                    public GetIamPolicy setUploadType(String string) {
                        return (GetIamPolicy)super.setUploadType(string);
                    }

                    public GetIamPolicy setUploadProtocol(String string) {
                        return (GetIamPolicy)super.setUploadProtocol(string);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public GetIamPolicy setResource(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/regions/[^/]+/workflowTemplates/[^/]+$");
                        }
                        this.resource = string;
                        return this;
                    }

                    @Override
                    public GetIamPolicy set(String string, Object object) {
                        return (GetIamPolicy)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends DataprocRequest<WorkflowTemplate> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private Integer version;

                    protected Get(String string) {
                        super(Dataproc.this, "GET", REST_PATH, null, WorkflowTemplate.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/regions/[^/]+/workflowTemplates/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/regions/[^/]+/workflowTemplates/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String string) {
                        return (Get)super.set$Xgafv(string);
                    }

                    public Get setAccessToken(String string) {
                        return (Get)super.setAccessToken(string);
                    }

                    public Get setAlt(String string) {
                        return (Get)super.setAlt(string);
                    }

                    public Get setCallback(String string) {
                        return (Get)super.setCallback(string);
                    }

                    public Get setFields(String string) {
                        return (Get)super.setFields(string);
                    }

                    public Get setKey(String string) {
                        return (Get)super.setKey(string);
                    }

                    public Get setOauthToken(String string) {
                        return (Get)super.setOauthToken(string);
                    }

                    public Get setPrettyPrint(Boolean bl) {
                        return (Get)super.setPrettyPrint(bl);
                    }

                    public Get setQuotaUser(String string) {
                        return (Get)super.setQuotaUser(string);
                    }

                    public Get setUploadType(String string) {
                        return (Get)super.setUploadType(string);
                    }

                    public Get setUploadProtocol(String string) {
                        return (Get)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/regions/[^/]+/workflowTemplates/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    public Integer getVersion() {
                        return this.version;
                    }

                    public Get setVersion(Integer n) {
                        this.version = n;
                        return this;
                    }

                    @Override
                    public Get set(String string, Object object) {
                        return (Get)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Delete
                extends DataprocRequest<Empty> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private Integer version;

                    protected Delete(String string) {
                        super(Dataproc.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/regions/[^/]+/workflowTemplates/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/regions/[^/]+/workflowTemplates/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String string) {
                        return (Delete)super.set$Xgafv(string);
                    }

                    public Delete setAccessToken(String string) {
                        return (Delete)super.setAccessToken(string);
                    }

                    public Delete setAlt(String string) {
                        return (Delete)super.setAlt(string);
                    }

                    public Delete setCallback(String string) {
                        return (Delete)super.setCallback(string);
                    }

                    public Delete setFields(String string) {
                        return (Delete)super.setFields(string);
                    }

                    public Delete setKey(String string) {
                        return (Delete)super.setKey(string);
                    }

                    public Delete setOauthToken(String string) {
                        return (Delete)super.setOauthToken(string);
                    }

                    public Delete setPrettyPrint(Boolean bl) {
                        return (Delete)super.setPrettyPrint(bl);
                    }

                    public Delete setQuotaUser(String string) {
                        return (Delete)super.setQuotaUser(string);
                    }

                    public Delete setUploadType(String string) {
                        return (Delete)super.setUploadType(string);
                    }

                    public Delete setUploadProtocol(String string) {
                        return (Delete)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/regions/[^/]+/workflowTemplates/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    public Integer getVersion() {
                        return this.version;
                    }

                    public Delete setVersion(Integer n) {
                        this.version = n;
                        return this;
                    }

                    @Override
                    public Delete set(String string, Object object) {
                        return (Delete)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Create
                extends DataprocRequest<WorkflowTemplate> {
                    private static final String REST_PATH = "v1/{+parent}/workflowTemplates";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected Create(String string, WorkflowTemplate workflowTemplate) {
                        super(Dataproc.this, "POST", REST_PATH, (Object)workflowTemplate, WorkflowTemplate.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/regions/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/regions/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String string) {
                        return (Create)super.set$Xgafv(string);
                    }

                    public Create setAccessToken(String string) {
                        return (Create)super.setAccessToken(string);
                    }

                    public Create setAlt(String string) {
                        return (Create)super.setAlt(string);
                    }

                    public Create setCallback(String string) {
                        return (Create)super.setCallback(string);
                    }

                    public Create setFields(String string) {
                        return (Create)super.setFields(string);
                    }

                    public Create setKey(String string) {
                        return (Create)super.setKey(string);
                    }

                    public Create setOauthToken(String string) {
                        return (Create)super.setOauthToken(string);
                    }

                    public Create setPrettyPrint(Boolean bl) {
                        return (Create)super.setPrettyPrint(bl);
                    }

                    public Create setQuotaUser(String string) {
                        return (Create)super.setQuotaUser(string);
                    }

                    public Create setUploadType(String string) {
                        return (Create)super.setUploadType(string);
                    }

                    public Create setUploadProtocol(String string) {
                        return (Create)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/regions/[^/]+$");
                        }
                        this.parent = string;
                        return this;
                    }

                    @Override
                    public Create set(String string, Object object) {
                        return (Create)super.set(string, object);
                    }
                }
            }

            public class Operations {
                public Cancel cancel(String string) throws IOException {
                    Cancel cancel = new Cancel(string);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)cancel);
                    return cancel;
                }

                public Delete delete(String string) throws IOException {
                    Delete delete = new Delete(string);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)delete);
                    return delete;
                }

                public Get get(String string) throws IOException {
                    Get get = new Get(string);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)get);
                    return get;
                }

                public GetIamPolicy getIamPolicy(String string, GetIamPolicyRequest getIamPolicyRequest) throws IOException {
                    GetIamPolicy getIamPolicy = new GetIamPolicy(string, getIamPolicyRequest);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)getIamPolicy);
                    return getIamPolicy;
                }

                public List list(String string) throws IOException {
                    List list = new List(string);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                public SetIamPolicy setIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) throws IOException {
                    SetIamPolicy setIamPolicy = new SetIamPolicy(string, setIamPolicyRequest);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)setIamPolicy);
                    return setIamPolicy;
                }

                public TestIamPermissions testIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) throws IOException {
                    TestIamPermissions testIamPermissions = new TestIamPermissions(string, testIamPermissionsRequest);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)testIamPermissions);
                    return testIamPermissions;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class TestIamPermissions
                extends DataprocRequest<TestIamPermissionsResponse> {
                    private static final String REST_PATH = "v1/{+resource}:testIamPermissions";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected TestIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) {
                        super(Dataproc.this, "POST", REST_PATH, (Object)testIamPermissionsRequest, TestIamPermissionsResponse.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/regions/[^/]+/operations/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/regions/[^/]+/operations/[^/]+$");
                        }
                    }

                    public TestIamPermissions set$Xgafv(String string) {
                        return (TestIamPermissions)super.set$Xgafv(string);
                    }

                    public TestIamPermissions setAccessToken(String string) {
                        return (TestIamPermissions)super.setAccessToken(string);
                    }

                    public TestIamPermissions setAlt(String string) {
                        return (TestIamPermissions)super.setAlt(string);
                    }

                    public TestIamPermissions setCallback(String string) {
                        return (TestIamPermissions)super.setCallback(string);
                    }

                    public TestIamPermissions setFields(String string) {
                        return (TestIamPermissions)super.setFields(string);
                    }

                    public TestIamPermissions setKey(String string) {
                        return (TestIamPermissions)super.setKey(string);
                    }

                    public TestIamPermissions setOauthToken(String string) {
                        return (TestIamPermissions)super.setOauthToken(string);
                    }

                    public TestIamPermissions setPrettyPrint(Boolean bl) {
                        return (TestIamPermissions)super.setPrettyPrint(bl);
                    }

                    public TestIamPermissions setQuotaUser(String string) {
                        return (TestIamPermissions)super.setQuotaUser(string);
                    }

                    public TestIamPermissions setUploadType(String string) {
                        return (TestIamPermissions)super.setUploadType(string);
                    }

                    public TestIamPermissions setUploadProtocol(String string) {
                        return (TestIamPermissions)super.setUploadProtocol(string);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public TestIamPermissions setResource(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/regions/[^/]+/operations/[^/]+$");
                        }
                        this.resource = string;
                        return this;
                    }

                    @Override
                    public TestIamPermissions set(String string, Object object) {
                        return (TestIamPermissions)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class SetIamPolicy
                extends DataprocRequest<Policy> {
                    private static final String REST_PATH = "v1/{+resource}:setIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected SetIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) {
                        super(Dataproc.this, "POST", REST_PATH, (Object)setIamPolicyRequest, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/regions/[^/]+/operations/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/regions/[^/]+/operations/[^/]+$");
                        }
                    }

                    public SetIamPolicy set$Xgafv(String string) {
                        return (SetIamPolicy)super.set$Xgafv(string);
                    }

                    public SetIamPolicy setAccessToken(String string) {
                        return (SetIamPolicy)super.setAccessToken(string);
                    }

                    public SetIamPolicy setAlt(String string) {
                        return (SetIamPolicy)super.setAlt(string);
                    }

                    public SetIamPolicy setCallback(String string) {
                        return (SetIamPolicy)super.setCallback(string);
                    }

                    public SetIamPolicy setFields(String string) {
                        return (SetIamPolicy)super.setFields(string);
                    }

                    public SetIamPolicy setKey(String string) {
                        return (SetIamPolicy)super.setKey(string);
                    }

                    public SetIamPolicy setOauthToken(String string) {
                        return (SetIamPolicy)super.setOauthToken(string);
                    }

                    public SetIamPolicy setPrettyPrint(Boolean bl) {
                        return (SetIamPolicy)super.setPrettyPrint(bl);
                    }

                    public SetIamPolicy setQuotaUser(String string) {
                        return (SetIamPolicy)super.setQuotaUser(string);
                    }

                    public SetIamPolicy setUploadType(String string) {
                        return (SetIamPolicy)super.setUploadType(string);
                    }

                    public SetIamPolicy setUploadProtocol(String string) {
                        return (SetIamPolicy)super.setUploadProtocol(string);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public SetIamPolicy setResource(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/regions/[^/]+/operations/[^/]+$");
                        }
                        this.resource = string;
                        return this;
                    }

                    @Override
                    public SetIamPolicy set(String string, Object object) {
                        return (SetIamPolicy)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends DataprocRequest<ListOperationsResponse> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String filter;
                    @Key
                    private String pageToken;
                    @Key
                    private Integer pageSize;

                    protected List(String string) {
                        super(Dataproc.this, "GET", REST_PATH, null, ListOperationsResponse.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/regions/[^/]+/operations$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/regions/[^/]+/operations$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public List setName(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/regions/[^/]+/operations$");
                        }
                        this.name = string;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String string) {
                        this.filter = string;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String string) {
                        this.pageToken = string;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer n) {
                        this.pageSize = n;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class GetIamPolicy
                extends DataprocRequest<Policy> {
                    private static final String REST_PATH = "v1/{+resource}:getIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected GetIamPolicy(String string, GetIamPolicyRequest getIamPolicyRequest) {
                        super(Dataproc.this, "POST", REST_PATH, (Object)getIamPolicyRequest, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/regions/[^/]+/operations/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/regions/[^/]+/operations/[^/]+$");
                        }
                    }

                    public GetIamPolicy set$Xgafv(String string) {
                        return (GetIamPolicy)super.set$Xgafv(string);
                    }

                    public GetIamPolicy setAccessToken(String string) {
                        return (GetIamPolicy)super.setAccessToken(string);
                    }

                    public GetIamPolicy setAlt(String string) {
                        return (GetIamPolicy)super.setAlt(string);
                    }

                    public GetIamPolicy setCallback(String string) {
                        return (GetIamPolicy)super.setCallback(string);
                    }

                    public GetIamPolicy setFields(String string) {
                        return (GetIamPolicy)super.setFields(string);
                    }

                    public GetIamPolicy setKey(String string) {
                        return (GetIamPolicy)super.setKey(string);
                    }

                    public GetIamPolicy setOauthToken(String string) {
                        return (GetIamPolicy)super.setOauthToken(string);
                    }

                    public GetIamPolicy setPrettyPrint(Boolean bl) {
                        return (GetIamPolicy)super.setPrettyPrint(bl);
                    }

                    public GetIamPolicy setQuotaUser(String string) {
                        return (GetIamPolicy)super.setQuotaUser(string);
                    }

                    public GetIamPolicy setUploadType(String string) {
                        return (GetIamPolicy)super.setUploadType(string);
                    }

                    public GetIamPolicy setUploadProtocol(String string) {
                        return (GetIamPolicy)super.setUploadProtocol(string);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public GetIamPolicy setResource(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/regions/[^/]+/operations/[^/]+$");
                        }
                        this.resource = string;
                        return this;
                    }

                    @Override
                    public GetIamPolicy set(String string, Object object) {
                        return (GetIamPolicy)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends DataprocRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String string) {
                        super(Dataproc.this, "GET", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/regions/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/regions/[^/]+/operations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String string) {
                        return (Get)super.set$Xgafv(string);
                    }

                    public Get setAccessToken(String string) {
                        return (Get)super.setAccessToken(string);
                    }

                    public Get setAlt(String string) {
                        return (Get)super.setAlt(string);
                    }

                    public Get setCallback(String string) {
                        return (Get)super.setCallback(string);
                    }

                    public Get setFields(String string) {
                        return (Get)super.setFields(string);
                    }

                    public Get setKey(String string) {
                        return (Get)super.setKey(string);
                    }

                    public Get setOauthToken(String string) {
                        return (Get)super.setOauthToken(string);
                    }

                    public Get setPrettyPrint(Boolean bl) {
                        return (Get)super.setPrettyPrint(bl);
                    }

                    public Get setQuotaUser(String string) {
                        return (Get)super.setQuotaUser(string);
                    }

                    public Get setUploadType(String string) {
                        return (Get)super.setUploadType(string);
                    }

                    public Get setUploadProtocol(String string) {
                        return (Get)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/regions/[^/]+/operations/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Get set(String string, Object object) {
                        return (Get)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Delete
                extends DataprocRequest<Empty> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String string) {
                        super(Dataproc.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/regions/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/regions/[^/]+/operations/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String string) {
                        return (Delete)super.set$Xgafv(string);
                    }

                    public Delete setAccessToken(String string) {
                        return (Delete)super.setAccessToken(string);
                    }

                    public Delete setAlt(String string) {
                        return (Delete)super.setAlt(string);
                    }

                    public Delete setCallback(String string) {
                        return (Delete)super.setCallback(string);
                    }

                    public Delete setFields(String string) {
                        return (Delete)super.setFields(string);
                    }

                    public Delete setKey(String string) {
                        return (Delete)super.setKey(string);
                    }

                    public Delete setOauthToken(String string) {
                        return (Delete)super.setOauthToken(string);
                    }

                    public Delete setPrettyPrint(Boolean bl) {
                        return (Delete)super.setPrettyPrint(bl);
                    }

                    public Delete setQuotaUser(String string) {
                        return (Delete)super.setQuotaUser(string);
                    }

                    public Delete setUploadType(String string) {
                        return (Delete)super.setUploadType(string);
                    }

                    public Delete setUploadProtocol(String string) {
                        return (Delete)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/regions/[^/]+/operations/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Delete set(String string, Object object) {
                        return (Delete)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Cancel
                extends DataprocRequest<Empty> {
                    private static final String REST_PATH = "v1/{+name}:cancel";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Cancel(String string) {
                        super(Dataproc.this, "POST", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/regions/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/regions/[^/]+/operations/[^/]+$");
                        }
                    }

                    public Cancel set$Xgafv(String string) {
                        return (Cancel)super.set$Xgafv(string);
                    }

                    public Cancel setAccessToken(String string) {
                        return (Cancel)super.setAccessToken(string);
                    }

                    public Cancel setAlt(String string) {
                        return (Cancel)super.setAlt(string);
                    }

                    public Cancel setCallback(String string) {
                        return (Cancel)super.setCallback(string);
                    }

                    public Cancel setFields(String string) {
                        return (Cancel)super.setFields(string);
                    }

                    public Cancel setKey(String string) {
                        return (Cancel)super.setKey(string);
                    }

                    public Cancel setOauthToken(String string) {
                        return (Cancel)super.setOauthToken(string);
                    }

                    public Cancel setPrettyPrint(Boolean bl) {
                        return (Cancel)super.setPrettyPrint(bl);
                    }

                    public Cancel setQuotaUser(String string) {
                        return (Cancel)super.setQuotaUser(string);
                    }

                    public Cancel setUploadType(String string) {
                        return (Cancel)super.setUploadType(string);
                    }

                    public Cancel setUploadProtocol(String string) {
                        return (Cancel)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Cancel setName(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/regions/[^/]+/operations/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Cancel set(String string, Object object) {
                        return (Cancel)super.set(string, object);
                    }
                }
            }

            public class Jobs {
                public Cancel cancel(String string, String string2, String string3, CancelJobRequest cancelJobRequest) throws IOException {
                    Cancel cancel = new Cancel(string, string2, string3, cancelJobRequest);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)cancel);
                    return cancel;
                }

                public Delete delete(String string, String string2, String string3) throws IOException {
                    Delete delete = new Delete(string, string2, string3);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)delete);
                    return delete;
                }

                public Get get(String string, String string2, String string3) throws IOException {
                    Get get = new Get(string, string2, string3);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)get);
                    return get;
                }

                public GetIamPolicy getIamPolicy(String string, GetIamPolicyRequest getIamPolicyRequest) throws IOException {
                    GetIamPolicy getIamPolicy = new GetIamPolicy(string, getIamPolicyRequest);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)getIamPolicy);
                    return getIamPolicy;
                }

                public List list(String string, String string2) throws IOException {
                    List list = new List(string, string2);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                public Patch patch(String string, String string2, String string3, Job job) throws IOException {
                    Patch patch = new Patch(string, string2, string3, job);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)patch);
                    return patch;
                }

                public SetIamPolicy setIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) throws IOException {
                    SetIamPolicy setIamPolicy = new SetIamPolicy(string, setIamPolicyRequest);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)setIamPolicy);
                    return setIamPolicy;
                }

                public Submit submit(String string, String string2, SubmitJobRequest submitJobRequest) throws IOException {
                    Submit submit = new Submit(string, string2, submitJobRequest);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)submit);
                    return submit;
                }

                public TestIamPermissions testIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) throws IOException {
                    TestIamPermissions testIamPermissions = new TestIamPermissions(string, testIamPermissionsRequest);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)testIamPermissions);
                    return testIamPermissions;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class TestIamPermissions
                extends DataprocRequest<TestIamPermissionsResponse> {
                    private static final String REST_PATH = "v1/{+resource}:testIamPermissions";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected TestIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) {
                        super(Dataproc.this, "POST", REST_PATH, (Object)testIamPermissionsRequest, TestIamPermissionsResponse.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/regions/[^/]+/jobs/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/regions/[^/]+/jobs/[^/]+$");
                        }
                    }

                    public TestIamPermissions set$Xgafv(String string) {
                        return (TestIamPermissions)super.set$Xgafv(string);
                    }

                    public TestIamPermissions setAccessToken(String string) {
                        return (TestIamPermissions)super.setAccessToken(string);
                    }

                    public TestIamPermissions setAlt(String string) {
                        return (TestIamPermissions)super.setAlt(string);
                    }

                    public TestIamPermissions setCallback(String string) {
                        return (TestIamPermissions)super.setCallback(string);
                    }

                    public TestIamPermissions setFields(String string) {
                        return (TestIamPermissions)super.setFields(string);
                    }

                    public TestIamPermissions setKey(String string) {
                        return (TestIamPermissions)super.setKey(string);
                    }

                    public TestIamPermissions setOauthToken(String string) {
                        return (TestIamPermissions)super.setOauthToken(string);
                    }

                    public TestIamPermissions setPrettyPrint(Boolean bl) {
                        return (TestIamPermissions)super.setPrettyPrint(bl);
                    }

                    public TestIamPermissions setQuotaUser(String string) {
                        return (TestIamPermissions)super.setQuotaUser(string);
                    }

                    public TestIamPermissions setUploadType(String string) {
                        return (TestIamPermissions)super.setUploadType(string);
                    }

                    public TestIamPermissions setUploadProtocol(String string) {
                        return (TestIamPermissions)super.setUploadProtocol(string);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public TestIamPermissions setResource(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/regions/[^/]+/jobs/[^/]+$");
                        }
                        this.resource = string;
                        return this;
                    }

                    @Override
                    public TestIamPermissions set(String string, Object object) {
                        return (TestIamPermissions)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Submit
                extends DataprocRequest<Job> {
                    private static final String REST_PATH = "v1/projects/{projectId}/regions/{region}/jobs:submit";
                    @Key
                    private String projectId;
                    @Key
                    private String region;

                    protected Submit(String string, String string2, SubmitJobRequest submitJobRequest) {
                        super(Dataproc.this, "POST", REST_PATH, (Object)submitJobRequest, Job.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                    }

                    public Submit set$Xgafv(String string) {
                        return (Submit)super.set$Xgafv(string);
                    }

                    public Submit setAccessToken(String string) {
                        return (Submit)super.setAccessToken(string);
                    }

                    public Submit setAlt(String string) {
                        return (Submit)super.setAlt(string);
                    }

                    public Submit setCallback(String string) {
                        return (Submit)super.setCallback(string);
                    }

                    public Submit setFields(String string) {
                        return (Submit)super.setFields(string);
                    }

                    public Submit setKey(String string) {
                        return (Submit)super.setKey(string);
                    }

                    public Submit setOauthToken(String string) {
                        return (Submit)super.setOauthToken(string);
                    }

                    public Submit setPrettyPrint(Boolean bl) {
                        return (Submit)super.setPrettyPrint(bl);
                    }

                    public Submit setQuotaUser(String string) {
                        return (Submit)super.setQuotaUser(string);
                    }

                    public Submit setUploadType(String string) {
                        return (Submit)super.setUploadType(string);
                    }

                    public Submit setUploadProtocol(String string) {
                        return (Submit)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Submit setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getRegion() {
                        return this.region;
                    }

                    public Submit setRegion(String string) {
                        this.region = string;
                        return this;
                    }

                    @Override
                    public Submit set(String string, Object object) {
                        return (Submit)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class SetIamPolicy
                extends DataprocRequest<Policy> {
                    private static final String REST_PATH = "v1/{+resource}:setIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected SetIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) {
                        super(Dataproc.this, "POST", REST_PATH, (Object)setIamPolicyRequest, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/regions/[^/]+/jobs/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/regions/[^/]+/jobs/[^/]+$");
                        }
                    }

                    public SetIamPolicy set$Xgafv(String string) {
                        return (SetIamPolicy)super.set$Xgafv(string);
                    }

                    public SetIamPolicy setAccessToken(String string) {
                        return (SetIamPolicy)super.setAccessToken(string);
                    }

                    public SetIamPolicy setAlt(String string) {
                        return (SetIamPolicy)super.setAlt(string);
                    }

                    public SetIamPolicy setCallback(String string) {
                        return (SetIamPolicy)super.setCallback(string);
                    }

                    public SetIamPolicy setFields(String string) {
                        return (SetIamPolicy)super.setFields(string);
                    }

                    public SetIamPolicy setKey(String string) {
                        return (SetIamPolicy)super.setKey(string);
                    }

                    public SetIamPolicy setOauthToken(String string) {
                        return (SetIamPolicy)super.setOauthToken(string);
                    }

                    public SetIamPolicy setPrettyPrint(Boolean bl) {
                        return (SetIamPolicy)super.setPrettyPrint(bl);
                    }

                    public SetIamPolicy setQuotaUser(String string) {
                        return (SetIamPolicy)super.setQuotaUser(string);
                    }

                    public SetIamPolicy setUploadType(String string) {
                        return (SetIamPolicy)super.setUploadType(string);
                    }

                    public SetIamPolicy setUploadProtocol(String string) {
                        return (SetIamPolicy)super.setUploadProtocol(string);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public SetIamPolicy setResource(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/regions/[^/]+/jobs/[^/]+$");
                        }
                        this.resource = string;
                        return this;
                    }

                    @Override
                    public SetIamPolicy set(String string, Object object) {
                        return (SetIamPolicy)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Patch
                extends DataprocRequest<Job> {
                    private static final String REST_PATH = "v1/projects/{projectId}/regions/{region}/jobs/{jobId}";
                    @Key
                    private String projectId;
                    @Key
                    private String region;
                    @Key
                    private String jobId;
                    @Key
                    private String updateMask;

                    protected Patch(String string, String string2, String string3, Job job) {
                        super(Dataproc.this, "PATCH", REST_PATH, (Object)job, Job.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                        this.jobId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter jobId must be specified.");
                    }

                    public Patch set$Xgafv(String string) {
                        return (Patch)super.set$Xgafv(string);
                    }

                    public Patch setAccessToken(String string) {
                        return (Patch)super.setAccessToken(string);
                    }

                    public Patch setAlt(String string) {
                        return (Patch)super.setAlt(string);
                    }

                    public Patch setCallback(String string) {
                        return (Patch)super.setCallback(string);
                    }

                    public Patch setFields(String string) {
                        return (Patch)super.setFields(string);
                    }

                    public Patch setKey(String string) {
                        return (Patch)super.setKey(string);
                    }

                    public Patch setOauthToken(String string) {
                        return (Patch)super.setOauthToken(string);
                    }

                    public Patch setPrettyPrint(Boolean bl) {
                        return (Patch)super.setPrettyPrint(bl);
                    }

                    public Patch setQuotaUser(String string) {
                        return (Patch)super.setQuotaUser(string);
                    }

                    public Patch setUploadType(String string) {
                        return (Patch)super.setUploadType(string);
                    }

                    public Patch setUploadProtocol(String string) {
                        return (Patch)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Patch setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getRegion() {
                        return this.region;
                    }

                    public Patch setRegion(String string) {
                        this.region = string;
                        return this;
                    }

                    public String getJobId() {
                        return this.jobId;
                    }

                    public Patch setJobId(String string) {
                        this.jobId = string;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String string) {
                        this.updateMask = string;
                        return this;
                    }

                    @Override
                    public Patch set(String string, Object object) {
                        return (Patch)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends DataprocRequest<ListJobsResponse> {
                    private static final String REST_PATH = "v1/projects/{projectId}/regions/{region}/jobs";
                    @Key
                    private String projectId;
                    @Key
                    private String region;
                    @Key
                    private String clusterName;
                    @Key
                    private String filter;
                    @Key
                    private String jobStateMatcher;
                    @Key
                    private String pageToken;
                    @Key
                    private Integer pageSize;

                    protected List(String string, String string2) {
                        super(Dataproc.this, "GET", REST_PATH, null, ListJobsResponse.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public List setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getRegion() {
                        return this.region;
                    }

                    public List setRegion(String string) {
                        this.region = string;
                        return this;
                    }

                    public String getClusterName() {
                        return this.clusterName;
                    }

                    public List setClusterName(String string) {
                        this.clusterName = string;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String string) {
                        this.filter = string;
                        return this;
                    }

                    public String getJobStateMatcher() {
                        return this.jobStateMatcher;
                    }

                    public List setJobStateMatcher(String string) {
                        this.jobStateMatcher = string;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String string) {
                        this.pageToken = string;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer n) {
                        this.pageSize = n;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class GetIamPolicy
                extends DataprocRequest<Policy> {
                    private static final String REST_PATH = "v1/{+resource}:getIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected GetIamPolicy(String string, GetIamPolicyRequest getIamPolicyRequest) {
                        super(Dataproc.this, "POST", REST_PATH, (Object)getIamPolicyRequest, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/regions/[^/]+/jobs/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/regions/[^/]+/jobs/[^/]+$");
                        }
                    }

                    public GetIamPolicy set$Xgafv(String string) {
                        return (GetIamPolicy)super.set$Xgafv(string);
                    }

                    public GetIamPolicy setAccessToken(String string) {
                        return (GetIamPolicy)super.setAccessToken(string);
                    }

                    public GetIamPolicy setAlt(String string) {
                        return (GetIamPolicy)super.setAlt(string);
                    }

                    public GetIamPolicy setCallback(String string) {
                        return (GetIamPolicy)super.setCallback(string);
                    }

                    public GetIamPolicy setFields(String string) {
                        return (GetIamPolicy)super.setFields(string);
                    }

                    public GetIamPolicy setKey(String string) {
                        return (GetIamPolicy)super.setKey(string);
                    }

                    public GetIamPolicy setOauthToken(String string) {
                        return (GetIamPolicy)super.setOauthToken(string);
                    }

                    public GetIamPolicy setPrettyPrint(Boolean bl) {
                        return (GetIamPolicy)super.setPrettyPrint(bl);
                    }

                    public GetIamPolicy setQuotaUser(String string) {
                        return (GetIamPolicy)super.setQuotaUser(string);
                    }

                    public GetIamPolicy setUploadType(String string) {
                        return (GetIamPolicy)super.setUploadType(string);
                    }

                    public GetIamPolicy setUploadProtocol(String string) {
                        return (GetIamPolicy)super.setUploadProtocol(string);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public GetIamPolicy setResource(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/regions/[^/]+/jobs/[^/]+$");
                        }
                        this.resource = string;
                        return this;
                    }

                    @Override
                    public GetIamPolicy set(String string, Object object) {
                        return (GetIamPolicy)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends DataprocRequest<Job> {
                    private static final String REST_PATH = "v1/projects/{projectId}/regions/{region}/jobs/{jobId}";
                    @Key
                    private String projectId;
                    @Key
                    private String region;
                    @Key
                    private String jobId;

                    protected Get(String string, String string2, String string3) {
                        super(Dataproc.this, "GET", REST_PATH, null, Job.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                        this.jobId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter jobId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String string) {
                        return (Get)super.set$Xgafv(string);
                    }

                    public Get setAccessToken(String string) {
                        return (Get)super.setAccessToken(string);
                    }

                    public Get setAlt(String string) {
                        return (Get)super.setAlt(string);
                    }

                    public Get setCallback(String string) {
                        return (Get)super.setCallback(string);
                    }

                    public Get setFields(String string) {
                        return (Get)super.setFields(string);
                    }

                    public Get setKey(String string) {
                        return (Get)super.setKey(string);
                    }

                    public Get setOauthToken(String string) {
                        return (Get)super.setOauthToken(string);
                    }

                    public Get setPrettyPrint(Boolean bl) {
                        return (Get)super.setPrettyPrint(bl);
                    }

                    public Get setQuotaUser(String string) {
                        return (Get)super.setQuotaUser(string);
                    }

                    public Get setUploadType(String string) {
                        return (Get)super.setUploadType(string);
                    }

                    public Get setUploadProtocol(String string) {
                        return (Get)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Get setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getRegion() {
                        return this.region;
                    }

                    public Get setRegion(String string) {
                        this.region = string;
                        return this;
                    }

                    public String getJobId() {
                        return this.jobId;
                    }

                    public Get setJobId(String string) {
                        this.jobId = string;
                        return this;
                    }

                    @Override
                    public Get set(String string, Object object) {
                        return (Get)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Delete
                extends DataprocRequest<Empty> {
                    private static final String REST_PATH = "v1/projects/{projectId}/regions/{region}/jobs/{jobId}";
                    @Key
                    private String projectId;
                    @Key
                    private String region;
                    @Key
                    private String jobId;

                    protected Delete(String string, String string2, String string3) {
                        super(Dataproc.this, "DELETE", REST_PATH, null, Empty.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                        this.jobId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter jobId must be specified.");
                    }

                    public Delete set$Xgafv(String string) {
                        return (Delete)super.set$Xgafv(string);
                    }

                    public Delete setAccessToken(String string) {
                        return (Delete)super.setAccessToken(string);
                    }

                    public Delete setAlt(String string) {
                        return (Delete)super.setAlt(string);
                    }

                    public Delete setCallback(String string) {
                        return (Delete)super.setCallback(string);
                    }

                    public Delete setFields(String string) {
                        return (Delete)super.setFields(string);
                    }

                    public Delete setKey(String string) {
                        return (Delete)super.setKey(string);
                    }

                    public Delete setOauthToken(String string) {
                        return (Delete)super.setOauthToken(string);
                    }

                    public Delete setPrettyPrint(Boolean bl) {
                        return (Delete)super.setPrettyPrint(bl);
                    }

                    public Delete setQuotaUser(String string) {
                        return (Delete)super.setQuotaUser(string);
                    }

                    public Delete setUploadType(String string) {
                        return (Delete)super.setUploadType(string);
                    }

                    public Delete setUploadProtocol(String string) {
                        return (Delete)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Delete setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getRegion() {
                        return this.region;
                    }

                    public Delete setRegion(String string) {
                        this.region = string;
                        return this;
                    }

                    public String getJobId() {
                        return this.jobId;
                    }

                    public Delete setJobId(String string) {
                        this.jobId = string;
                        return this;
                    }

                    @Override
                    public Delete set(String string, Object object) {
                        return (Delete)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Cancel
                extends DataprocRequest<Job> {
                    private static final String REST_PATH = "v1/projects/{projectId}/regions/{region}/jobs/{jobId}:cancel";
                    @Key
                    private String projectId;
                    @Key
                    private String region;
                    @Key
                    private String jobId;

                    protected Cancel(String string, String string2, String string3, CancelJobRequest cancelJobRequest) {
                        super(Dataproc.this, "POST", REST_PATH, (Object)cancelJobRequest, Job.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                        this.jobId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter jobId must be specified.");
                    }

                    public Cancel set$Xgafv(String string) {
                        return (Cancel)super.set$Xgafv(string);
                    }

                    public Cancel setAccessToken(String string) {
                        return (Cancel)super.setAccessToken(string);
                    }

                    public Cancel setAlt(String string) {
                        return (Cancel)super.setAlt(string);
                    }

                    public Cancel setCallback(String string) {
                        return (Cancel)super.setCallback(string);
                    }

                    public Cancel setFields(String string) {
                        return (Cancel)super.setFields(string);
                    }

                    public Cancel setKey(String string) {
                        return (Cancel)super.setKey(string);
                    }

                    public Cancel setOauthToken(String string) {
                        return (Cancel)super.setOauthToken(string);
                    }

                    public Cancel setPrettyPrint(Boolean bl) {
                        return (Cancel)super.setPrettyPrint(bl);
                    }

                    public Cancel setQuotaUser(String string) {
                        return (Cancel)super.setQuotaUser(string);
                    }

                    public Cancel setUploadType(String string) {
                        return (Cancel)super.setUploadType(string);
                    }

                    public Cancel setUploadProtocol(String string) {
                        return (Cancel)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Cancel setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getRegion() {
                        return this.region;
                    }

                    public Cancel setRegion(String string) {
                        this.region = string;
                        return this;
                    }

                    public String getJobId() {
                        return this.jobId;
                    }

                    public Cancel setJobId(String string) {
                        this.jobId = string;
                        return this;
                    }

                    @Override
                    public Cancel set(String string, Object object) {
                        return (Cancel)super.set(string, object);
                    }
                }
            }

            public class Clusters {
                public Create create(String string, String string2, Cluster cluster) throws IOException {
                    Create create = new Create(string, string2, cluster);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)create);
                    return create;
                }

                public Delete delete(String string, String string2, String string3) throws IOException {
                    Delete delete = new Delete(string, string2, string3);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)delete);
                    return delete;
                }

                public Diagnose diagnose(String string, String string2, String string3, DiagnoseClusterRequest diagnoseClusterRequest) throws IOException {
                    Diagnose diagnose = new Diagnose(string, string2, string3, diagnoseClusterRequest);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)diagnose);
                    return diagnose;
                }

                public Get get(String string, String string2, String string3) throws IOException {
                    Get get = new Get(string, string2, string3);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)get);
                    return get;
                }

                public GetIamPolicy getIamPolicy(String string, GetIamPolicyRequest getIamPolicyRequest) throws IOException {
                    GetIamPolicy getIamPolicy = new GetIamPolicy(string, getIamPolicyRequest);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)getIamPolicy);
                    return getIamPolicy;
                }

                public List list(String string, String string2) throws IOException {
                    List list = new List(string, string2);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                public Patch patch(String string, String string2, String string3, Cluster cluster) throws IOException {
                    Patch patch = new Patch(string, string2, string3, cluster);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)patch);
                    return patch;
                }

                public SetIamPolicy setIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) throws IOException {
                    SetIamPolicy setIamPolicy = new SetIamPolicy(string, setIamPolicyRequest);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)setIamPolicy);
                    return setIamPolicy;
                }

                public TestIamPermissions testIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) throws IOException {
                    TestIamPermissions testIamPermissions = new TestIamPermissions(string, testIamPermissionsRequest);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)testIamPermissions);
                    return testIamPermissions;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class TestIamPermissions
                extends DataprocRequest<TestIamPermissionsResponse> {
                    private static final String REST_PATH = "v1/{+resource}:testIamPermissions";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected TestIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) {
                        super(Dataproc.this, "POST", REST_PATH, (Object)testIamPermissionsRequest, TestIamPermissionsResponse.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/regions/[^/]+/clusters/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/regions/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public TestIamPermissions set$Xgafv(String string) {
                        return (TestIamPermissions)super.set$Xgafv(string);
                    }

                    public TestIamPermissions setAccessToken(String string) {
                        return (TestIamPermissions)super.setAccessToken(string);
                    }

                    public TestIamPermissions setAlt(String string) {
                        return (TestIamPermissions)super.setAlt(string);
                    }

                    public TestIamPermissions setCallback(String string) {
                        return (TestIamPermissions)super.setCallback(string);
                    }

                    public TestIamPermissions setFields(String string) {
                        return (TestIamPermissions)super.setFields(string);
                    }

                    public TestIamPermissions setKey(String string) {
                        return (TestIamPermissions)super.setKey(string);
                    }

                    public TestIamPermissions setOauthToken(String string) {
                        return (TestIamPermissions)super.setOauthToken(string);
                    }

                    public TestIamPermissions setPrettyPrint(Boolean bl) {
                        return (TestIamPermissions)super.setPrettyPrint(bl);
                    }

                    public TestIamPermissions setQuotaUser(String string) {
                        return (TestIamPermissions)super.setQuotaUser(string);
                    }

                    public TestIamPermissions setUploadType(String string) {
                        return (TestIamPermissions)super.setUploadType(string);
                    }

                    public TestIamPermissions setUploadProtocol(String string) {
                        return (TestIamPermissions)super.setUploadProtocol(string);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public TestIamPermissions setResource(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/regions/[^/]+/clusters/[^/]+$");
                        }
                        this.resource = string;
                        return this;
                    }

                    @Override
                    public TestIamPermissions set(String string, Object object) {
                        return (TestIamPermissions)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class SetIamPolicy
                extends DataprocRequest<Policy> {
                    private static final String REST_PATH = "v1/{+resource}:setIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected SetIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) {
                        super(Dataproc.this, "POST", REST_PATH, (Object)setIamPolicyRequest, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/regions/[^/]+/clusters/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/regions/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public SetIamPolicy set$Xgafv(String string) {
                        return (SetIamPolicy)super.set$Xgafv(string);
                    }

                    public SetIamPolicy setAccessToken(String string) {
                        return (SetIamPolicy)super.setAccessToken(string);
                    }

                    public SetIamPolicy setAlt(String string) {
                        return (SetIamPolicy)super.setAlt(string);
                    }

                    public SetIamPolicy setCallback(String string) {
                        return (SetIamPolicy)super.setCallback(string);
                    }

                    public SetIamPolicy setFields(String string) {
                        return (SetIamPolicy)super.setFields(string);
                    }

                    public SetIamPolicy setKey(String string) {
                        return (SetIamPolicy)super.setKey(string);
                    }

                    public SetIamPolicy setOauthToken(String string) {
                        return (SetIamPolicy)super.setOauthToken(string);
                    }

                    public SetIamPolicy setPrettyPrint(Boolean bl) {
                        return (SetIamPolicy)super.setPrettyPrint(bl);
                    }

                    public SetIamPolicy setQuotaUser(String string) {
                        return (SetIamPolicy)super.setQuotaUser(string);
                    }

                    public SetIamPolicy setUploadType(String string) {
                        return (SetIamPolicy)super.setUploadType(string);
                    }

                    public SetIamPolicy setUploadProtocol(String string) {
                        return (SetIamPolicy)super.setUploadProtocol(string);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public SetIamPolicy setResource(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/regions/[^/]+/clusters/[^/]+$");
                        }
                        this.resource = string;
                        return this;
                    }

                    @Override
                    public SetIamPolicy set(String string, Object object) {
                        return (SetIamPolicy)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Patch
                extends DataprocRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/regions/{region}/clusters/{clusterName}";
                    @Key
                    private String projectId;
                    @Key
                    private String region;
                    @Key
                    private String clusterName;
                    @Key
                    private String gracefulDecommissionTimeout;
                    @Key
                    private String requestId;
                    @Key
                    private String updateMask;

                    protected Patch(String string, String string2, String string3, Cluster cluster) {
                        super(Dataproc.this, "PATCH", REST_PATH, (Object)cluster, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                        this.clusterName = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter clusterName must be specified.");
                    }

                    public Patch set$Xgafv(String string) {
                        return (Patch)super.set$Xgafv(string);
                    }

                    public Patch setAccessToken(String string) {
                        return (Patch)super.setAccessToken(string);
                    }

                    public Patch setAlt(String string) {
                        return (Patch)super.setAlt(string);
                    }

                    public Patch setCallback(String string) {
                        return (Patch)super.setCallback(string);
                    }

                    public Patch setFields(String string) {
                        return (Patch)super.setFields(string);
                    }

                    public Patch setKey(String string) {
                        return (Patch)super.setKey(string);
                    }

                    public Patch setOauthToken(String string) {
                        return (Patch)super.setOauthToken(string);
                    }

                    public Patch setPrettyPrint(Boolean bl) {
                        return (Patch)super.setPrettyPrint(bl);
                    }

                    public Patch setQuotaUser(String string) {
                        return (Patch)super.setQuotaUser(string);
                    }

                    public Patch setUploadType(String string) {
                        return (Patch)super.setUploadType(string);
                    }

                    public Patch setUploadProtocol(String string) {
                        return (Patch)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Patch setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getRegion() {
                        return this.region;
                    }

                    public Patch setRegion(String string) {
                        this.region = string;
                        return this;
                    }

                    public String getClusterName() {
                        return this.clusterName;
                    }

                    public Patch setClusterName(String string) {
                        this.clusterName = string;
                        return this;
                    }

                    public String getGracefulDecommissionTimeout() {
                        return this.gracefulDecommissionTimeout;
                    }

                    public Patch setGracefulDecommissionTimeout(String string) {
                        this.gracefulDecommissionTimeout = string;
                        return this;
                    }

                    public String getRequestId() {
                        return this.requestId;
                    }

                    public Patch setRequestId(String string) {
                        this.requestId = string;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String string) {
                        this.updateMask = string;
                        return this;
                    }

                    @Override
                    public Patch set(String string, Object object) {
                        return (Patch)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends DataprocRequest<ListClustersResponse> {
                    private static final String REST_PATH = "v1/projects/{projectId}/regions/{region}/clusters";
                    @Key
                    private String projectId;
                    @Key
                    private String region;
                    @Key
                    private String pageToken;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String filter;

                    protected List(String string, String string2) {
                        super(Dataproc.this, "GET", REST_PATH, null, ListClustersResponse.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public List setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getRegion() {
                        return this.region;
                    }

                    public List setRegion(String string) {
                        this.region = string;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String string) {
                        this.pageToken = string;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer n) {
                        this.pageSize = n;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String string) {
                        this.filter = string;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class GetIamPolicy
                extends DataprocRequest<Policy> {
                    private static final String REST_PATH = "v1/{+resource}:getIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected GetIamPolicy(String string, GetIamPolicyRequest getIamPolicyRequest) {
                        super(Dataproc.this, "POST", REST_PATH, (Object)getIamPolicyRequest, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/regions/[^/]+/clusters/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/regions/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public GetIamPolicy set$Xgafv(String string) {
                        return (GetIamPolicy)super.set$Xgafv(string);
                    }

                    public GetIamPolicy setAccessToken(String string) {
                        return (GetIamPolicy)super.setAccessToken(string);
                    }

                    public GetIamPolicy setAlt(String string) {
                        return (GetIamPolicy)super.setAlt(string);
                    }

                    public GetIamPolicy setCallback(String string) {
                        return (GetIamPolicy)super.setCallback(string);
                    }

                    public GetIamPolicy setFields(String string) {
                        return (GetIamPolicy)super.setFields(string);
                    }

                    public GetIamPolicy setKey(String string) {
                        return (GetIamPolicy)super.setKey(string);
                    }

                    public GetIamPolicy setOauthToken(String string) {
                        return (GetIamPolicy)super.setOauthToken(string);
                    }

                    public GetIamPolicy setPrettyPrint(Boolean bl) {
                        return (GetIamPolicy)super.setPrettyPrint(bl);
                    }

                    public GetIamPolicy setQuotaUser(String string) {
                        return (GetIamPolicy)super.setQuotaUser(string);
                    }

                    public GetIamPolicy setUploadType(String string) {
                        return (GetIamPolicy)super.setUploadType(string);
                    }

                    public GetIamPolicy setUploadProtocol(String string) {
                        return (GetIamPolicy)super.setUploadProtocol(string);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public GetIamPolicy setResource(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/regions/[^/]+/clusters/[^/]+$");
                        }
                        this.resource = string;
                        return this;
                    }

                    @Override
                    public GetIamPolicy set(String string, Object object) {
                        return (GetIamPolicy)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends DataprocRequest<Cluster> {
                    private static final String REST_PATH = "v1/projects/{projectId}/regions/{region}/clusters/{clusterName}";
                    @Key
                    private String projectId;
                    @Key
                    private String region;
                    @Key
                    private String clusterName;

                    protected Get(String string, String string2, String string3) {
                        super(Dataproc.this, "GET", REST_PATH, null, Cluster.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                        this.clusterName = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter clusterName must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String string) {
                        return (Get)super.set$Xgafv(string);
                    }

                    public Get setAccessToken(String string) {
                        return (Get)super.setAccessToken(string);
                    }

                    public Get setAlt(String string) {
                        return (Get)super.setAlt(string);
                    }

                    public Get setCallback(String string) {
                        return (Get)super.setCallback(string);
                    }

                    public Get setFields(String string) {
                        return (Get)super.setFields(string);
                    }

                    public Get setKey(String string) {
                        return (Get)super.setKey(string);
                    }

                    public Get setOauthToken(String string) {
                        return (Get)super.setOauthToken(string);
                    }

                    public Get setPrettyPrint(Boolean bl) {
                        return (Get)super.setPrettyPrint(bl);
                    }

                    public Get setQuotaUser(String string) {
                        return (Get)super.setQuotaUser(string);
                    }

                    public Get setUploadType(String string) {
                        return (Get)super.setUploadType(string);
                    }

                    public Get setUploadProtocol(String string) {
                        return (Get)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Get setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getRegion() {
                        return this.region;
                    }

                    public Get setRegion(String string) {
                        this.region = string;
                        return this;
                    }

                    public String getClusterName() {
                        return this.clusterName;
                    }

                    public Get setClusterName(String string) {
                        this.clusterName = string;
                        return this;
                    }

                    @Override
                    public Get set(String string, Object object) {
                        return (Get)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Diagnose
                extends DataprocRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/regions/{region}/clusters/{clusterName}:diagnose";
                    @Key
                    private String projectId;
                    @Key
                    private String region;
                    @Key
                    private String clusterName;

                    protected Diagnose(String string, String string2, String string3, DiagnoseClusterRequest diagnoseClusterRequest) {
                        super(Dataproc.this, "POST", REST_PATH, (Object)diagnoseClusterRequest, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                        this.clusterName = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter clusterName must be specified.");
                    }

                    public Diagnose set$Xgafv(String string) {
                        return (Diagnose)super.set$Xgafv(string);
                    }

                    public Diagnose setAccessToken(String string) {
                        return (Diagnose)super.setAccessToken(string);
                    }

                    public Diagnose setAlt(String string) {
                        return (Diagnose)super.setAlt(string);
                    }

                    public Diagnose setCallback(String string) {
                        return (Diagnose)super.setCallback(string);
                    }

                    public Diagnose setFields(String string) {
                        return (Diagnose)super.setFields(string);
                    }

                    public Diagnose setKey(String string) {
                        return (Diagnose)super.setKey(string);
                    }

                    public Diagnose setOauthToken(String string) {
                        return (Diagnose)super.setOauthToken(string);
                    }

                    public Diagnose setPrettyPrint(Boolean bl) {
                        return (Diagnose)super.setPrettyPrint(bl);
                    }

                    public Diagnose setQuotaUser(String string) {
                        return (Diagnose)super.setQuotaUser(string);
                    }

                    public Diagnose setUploadType(String string) {
                        return (Diagnose)super.setUploadType(string);
                    }

                    public Diagnose setUploadProtocol(String string) {
                        return (Diagnose)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Diagnose setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getRegion() {
                        return this.region;
                    }

                    public Diagnose setRegion(String string) {
                        this.region = string;
                        return this;
                    }

                    public String getClusterName() {
                        return this.clusterName;
                    }

                    public Diagnose setClusterName(String string) {
                        this.clusterName = string;
                        return this;
                    }

                    @Override
                    public Diagnose set(String string, Object object) {
                        return (Diagnose)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Delete
                extends DataprocRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/regions/{region}/clusters/{clusterName}";
                    @Key
                    private String projectId;
                    @Key
                    private String region;
                    @Key
                    private String clusterName;
                    @Key
                    private String clusterUuid;
                    @Key
                    private String requestId;

                    protected Delete(String string, String string2, String string3) {
                        super(Dataproc.this, "DELETE", REST_PATH, null, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                        this.clusterName = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter clusterName must be specified.");
                    }

                    public Delete set$Xgafv(String string) {
                        return (Delete)super.set$Xgafv(string);
                    }

                    public Delete setAccessToken(String string) {
                        return (Delete)super.setAccessToken(string);
                    }

                    public Delete setAlt(String string) {
                        return (Delete)super.setAlt(string);
                    }

                    public Delete setCallback(String string) {
                        return (Delete)super.setCallback(string);
                    }

                    public Delete setFields(String string) {
                        return (Delete)super.setFields(string);
                    }

                    public Delete setKey(String string) {
                        return (Delete)super.setKey(string);
                    }

                    public Delete setOauthToken(String string) {
                        return (Delete)super.setOauthToken(string);
                    }

                    public Delete setPrettyPrint(Boolean bl) {
                        return (Delete)super.setPrettyPrint(bl);
                    }

                    public Delete setQuotaUser(String string) {
                        return (Delete)super.setQuotaUser(string);
                    }

                    public Delete setUploadType(String string) {
                        return (Delete)super.setUploadType(string);
                    }

                    public Delete setUploadProtocol(String string) {
                        return (Delete)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Delete setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getRegion() {
                        return this.region;
                    }

                    public Delete setRegion(String string) {
                        this.region = string;
                        return this;
                    }

                    public String getClusterName() {
                        return this.clusterName;
                    }

                    public Delete setClusterName(String string) {
                        this.clusterName = string;
                        return this;
                    }

                    public String getClusterUuid() {
                        return this.clusterUuid;
                    }

                    public Delete setClusterUuid(String string) {
                        this.clusterUuid = string;
                        return this;
                    }

                    public String getRequestId() {
                        return this.requestId;
                    }

                    public Delete setRequestId(String string) {
                        this.requestId = string;
                        return this;
                    }

                    @Override
                    public Delete set(String string, Object object) {
                        return (Delete)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Create
                extends DataprocRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/regions/{region}/clusters";
                    @Key
                    private String projectId;
                    @Key
                    private String region;
                    @Key
                    private String requestId;

                    protected Create(String string, String string2, Cluster cluster) {
                        super(Dataproc.this, "POST", REST_PATH, (Object)cluster, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                    }

                    public Create set$Xgafv(String string) {
                        return (Create)super.set$Xgafv(string);
                    }

                    public Create setAccessToken(String string) {
                        return (Create)super.setAccessToken(string);
                    }

                    public Create setAlt(String string) {
                        return (Create)super.setAlt(string);
                    }

                    public Create setCallback(String string) {
                        return (Create)super.setCallback(string);
                    }

                    public Create setFields(String string) {
                        return (Create)super.setFields(string);
                    }

                    public Create setKey(String string) {
                        return (Create)super.setKey(string);
                    }

                    public Create setOauthToken(String string) {
                        return (Create)super.setOauthToken(string);
                    }

                    public Create setPrettyPrint(Boolean bl) {
                        return (Create)super.setPrettyPrint(bl);
                    }

                    public Create setQuotaUser(String string) {
                        return (Create)super.setQuotaUser(string);
                    }

                    public Create setUploadType(String string) {
                        return (Create)super.setUploadType(string);
                    }

                    public Create setUploadProtocol(String string) {
                        return (Create)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Create setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getRegion() {
                        return this.region;
                    }

                    public Create setRegion(String string) {
                        this.region = string;
                        return this;
                    }

                    public String getRequestId() {
                        return this.requestId;
                    }

                    public Create setRequestId(String string) {
                        this.requestId = string;
                        return this;
                    }

                    @Override
                    public Create set(String string, Object object) {
                        return (Create)super.set(string, object);
                    }
                }
            }

            public class AutoscalingPolicies {
                public GetIamPolicy getIamPolicy(String string, GetIamPolicyRequest getIamPolicyRequest) throws IOException {
                    GetIamPolicy getIamPolicy = new GetIamPolicy(string, getIamPolicyRequest);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)getIamPolicy);
                    return getIamPolicy;
                }

                public SetIamPolicy setIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) throws IOException {
                    SetIamPolicy setIamPolicy = new SetIamPolicy(string, setIamPolicyRequest);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)setIamPolicy);
                    return setIamPolicy;
                }

                public TestIamPermissions testIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) throws IOException {
                    TestIamPermissions testIamPermissions = new TestIamPermissions(string, testIamPermissionsRequest);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)testIamPermissions);
                    return testIamPermissions;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class TestIamPermissions
                extends DataprocRequest<TestIamPermissionsResponse> {
                    private static final String REST_PATH = "v1/{+resource}:testIamPermissions";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected TestIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) {
                        super(Dataproc.this, "POST", REST_PATH, (Object)testIamPermissionsRequest, TestIamPermissionsResponse.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/regions/[^/]+/autoscalingPolicies/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/regions/[^/]+/autoscalingPolicies/[^/]+$");
                        }
                    }

                    public TestIamPermissions set$Xgafv(String string) {
                        return (TestIamPermissions)super.set$Xgafv(string);
                    }

                    public TestIamPermissions setAccessToken(String string) {
                        return (TestIamPermissions)super.setAccessToken(string);
                    }

                    public TestIamPermissions setAlt(String string) {
                        return (TestIamPermissions)super.setAlt(string);
                    }

                    public TestIamPermissions setCallback(String string) {
                        return (TestIamPermissions)super.setCallback(string);
                    }

                    public TestIamPermissions setFields(String string) {
                        return (TestIamPermissions)super.setFields(string);
                    }

                    public TestIamPermissions setKey(String string) {
                        return (TestIamPermissions)super.setKey(string);
                    }

                    public TestIamPermissions setOauthToken(String string) {
                        return (TestIamPermissions)super.setOauthToken(string);
                    }

                    public TestIamPermissions setPrettyPrint(Boolean bl) {
                        return (TestIamPermissions)super.setPrettyPrint(bl);
                    }

                    public TestIamPermissions setQuotaUser(String string) {
                        return (TestIamPermissions)super.setQuotaUser(string);
                    }

                    public TestIamPermissions setUploadType(String string) {
                        return (TestIamPermissions)super.setUploadType(string);
                    }

                    public TestIamPermissions setUploadProtocol(String string) {
                        return (TestIamPermissions)super.setUploadProtocol(string);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public TestIamPermissions setResource(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/regions/[^/]+/autoscalingPolicies/[^/]+$");
                        }
                        this.resource = string;
                        return this;
                    }

                    @Override
                    public TestIamPermissions set(String string, Object object) {
                        return (TestIamPermissions)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class SetIamPolicy
                extends DataprocRequest<Policy> {
                    private static final String REST_PATH = "v1/{+resource}:setIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected SetIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) {
                        super(Dataproc.this, "POST", REST_PATH, (Object)setIamPolicyRequest, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/regions/[^/]+/autoscalingPolicies/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/regions/[^/]+/autoscalingPolicies/[^/]+$");
                        }
                    }

                    public SetIamPolicy set$Xgafv(String string) {
                        return (SetIamPolicy)super.set$Xgafv(string);
                    }

                    public SetIamPolicy setAccessToken(String string) {
                        return (SetIamPolicy)super.setAccessToken(string);
                    }

                    public SetIamPolicy setAlt(String string) {
                        return (SetIamPolicy)super.setAlt(string);
                    }

                    public SetIamPolicy setCallback(String string) {
                        return (SetIamPolicy)super.setCallback(string);
                    }

                    public SetIamPolicy setFields(String string) {
                        return (SetIamPolicy)super.setFields(string);
                    }

                    public SetIamPolicy setKey(String string) {
                        return (SetIamPolicy)super.setKey(string);
                    }

                    public SetIamPolicy setOauthToken(String string) {
                        return (SetIamPolicy)super.setOauthToken(string);
                    }

                    public SetIamPolicy setPrettyPrint(Boolean bl) {
                        return (SetIamPolicy)super.setPrettyPrint(bl);
                    }

                    public SetIamPolicy setQuotaUser(String string) {
                        return (SetIamPolicy)super.setQuotaUser(string);
                    }

                    public SetIamPolicy setUploadType(String string) {
                        return (SetIamPolicy)super.setUploadType(string);
                    }

                    public SetIamPolicy setUploadProtocol(String string) {
                        return (SetIamPolicy)super.setUploadProtocol(string);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public SetIamPolicy setResource(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/regions/[^/]+/autoscalingPolicies/[^/]+$");
                        }
                        this.resource = string;
                        return this;
                    }

                    @Override
                    public SetIamPolicy set(String string, Object object) {
                        return (SetIamPolicy)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class GetIamPolicy
                extends DataprocRequest<Policy> {
                    private static final String REST_PATH = "v1/{+resource}:getIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected GetIamPolicy(String string, GetIamPolicyRequest getIamPolicyRequest) {
                        super(Dataproc.this, "POST", REST_PATH, (Object)getIamPolicyRequest, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/regions/[^/]+/autoscalingPolicies/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/regions/[^/]+/autoscalingPolicies/[^/]+$");
                        }
                    }

                    public GetIamPolicy set$Xgafv(String string) {
                        return (GetIamPolicy)super.set$Xgafv(string);
                    }

                    public GetIamPolicy setAccessToken(String string) {
                        return (GetIamPolicy)super.setAccessToken(string);
                    }

                    public GetIamPolicy setAlt(String string) {
                        return (GetIamPolicy)super.setAlt(string);
                    }

                    public GetIamPolicy setCallback(String string) {
                        return (GetIamPolicy)super.setCallback(string);
                    }

                    public GetIamPolicy setFields(String string) {
                        return (GetIamPolicy)super.setFields(string);
                    }

                    public GetIamPolicy setKey(String string) {
                        return (GetIamPolicy)super.setKey(string);
                    }

                    public GetIamPolicy setOauthToken(String string) {
                        return (GetIamPolicy)super.setOauthToken(string);
                    }

                    public GetIamPolicy setPrettyPrint(Boolean bl) {
                        return (GetIamPolicy)super.setPrettyPrint(bl);
                    }

                    public GetIamPolicy setQuotaUser(String string) {
                        return (GetIamPolicy)super.setQuotaUser(string);
                    }

                    public GetIamPolicy setUploadType(String string) {
                        return (GetIamPolicy)super.setUploadType(string);
                    }

                    public GetIamPolicy setUploadProtocol(String string) {
                        return (GetIamPolicy)super.setUploadProtocol(string);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public GetIamPolicy setResource(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/regions/[^/]+/autoscalingPolicies/[^/]+$");
                        }
                        this.resource = string;
                        return this;
                    }

                    @Override
                    public GetIamPolicy set(String string, Object object) {
                        return (GetIamPolicy)super.set(string, object);
                    }
                }
            }
        }

        public class Locations {
            public AutoscalingPolicies autoscalingPolicies() {
                return new AutoscalingPolicies();
            }

            public WorkflowTemplates workflowTemplates() {
                return new WorkflowTemplates();
            }

            public class WorkflowTemplates {
                public Create create(String string, WorkflowTemplate workflowTemplate) throws IOException {
                    Create create = new Create(string, workflowTemplate);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)create);
                    return create;
                }

                public Delete delete(String string) throws IOException {
                    Delete delete = new Delete(string);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)delete);
                    return delete;
                }

                public Get get(String string) throws IOException {
                    Get get = new Get(string);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)get);
                    return get;
                }

                public GetIamPolicy getIamPolicy(String string, GetIamPolicyRequest getIamPolicyRequest) throws IOException {
                    GetIamPolicy getIamPolicy = new GetIamPolicy(string, getIamPolicyRequest);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)getIamPolicy);
                    return getIamPolicy;
                }

                public Instantiate instantiate(String string, InstantiateWorkflowTemplateRequest instantiateWorkflowTemplateRequest) throws IOException {
                    Instantiate instantiate = new Instantiate(string, instantiateWorkflowTemplateRequest);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)instantiate);
                    return instantiate;
                }

                public InstantiateInline instantiateInline(String string, WorkflowTemplate workflowTemplate) throws IOException {
                    InstantiateInline instantiateInline = new InstantiateInline(string, workflowTemplate);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)instantiateInline);
                    return instantiateInline;
                }

                public List list(String string) throws IOException {
                    List list = new List(string);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                public SetIamPolicy setIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) throws IOException {
                    SetIamPolicy setIamPolicy = new SetIamPolicy(string, setIamPolicyRequest);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)setIamPolicy);
                    return setIamPolicy;
                }

                public TestIamPermissions testIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) throws IOException {
                    TestIamPermissions testIamPermissions = new TestIamPermissions(string, testIamPermissionsRequest);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)testIamPermissions);
                    return testIamPermissions;
                }

                public Update update(String string, WorkflowTemplate workflowTemplate) throws IOException {
                    Update update = new Update(string, workflowTemplate);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)update);
                    return update;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Update
                extends DataprocRequest<WorkflowTemplate> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Update(String string, WorkflowTemplate workflowTemplate) {
                        super(Dataproc.this, "PUT", REST_PATH, (Object)workflowTemplate, WorkflowTemplate.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/workflowTemplates/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/workflowTemplates/[^/]+$");
                        }
                    }

                    public Update set$Xgafv(String string) {
                        return (Update)super.set$Xgafv(string);
                    }

                    public Update setAccessToken(String string) {
                        return (Update)super.setAccessToken(string);
                    }

                    public Update setAlt(String string) {
                        return (Update)super.setAlt(string);
                    }

                    public Update setCallback(String string) {
                        return (Update)super.setCallback(string);
                    }

                    public Update setFields(String string) {
                        return (Update)super.setFields(string);
                    }

                    public Update setKey(String string) {
                        return (Update)super.setKey(string);
                    }

                    public Update setOauthToken(String string) {
                        return (Update)super.setOauthToken(string);
                    }

                    public Update setPrettyPrint(Boolean bl) {
                        return (Update)super.setPrettyPrint(bl);
                    }

                    public Update setQuotaUser(String string) {
                        return (Update)super.setQuotaUser(string);
                    }

                    public Update setUploadType(String string) {
                        return (Update)super.setUploadType(string);
                    }

                    public Update setUploadProtocol(String string) {
                        return (Update)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Update setName(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/workflowTemplates/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Update set(String string, Object object) {
                        return (Update)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class TestIamPermissions
                extends DataprocRequest<TestIamPermissionsResponse> {
                    private static final String REST_PATH = "v1/{+resource}:testIamPermissions";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected TestIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) {
                        super(Dataproc.this, "POST", REST_PATH, (Object)testIamPermissionsRequest, TestIamPermissionsResponse.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/workflowTemplates/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/workflowTemplates/[^/]+$");
                        }
                    }

                    public TestIamPermissions set$Xgafv(String string) {
                        return (TestIamPermissions)super.set$Xgafv(string);
                    }

                    public TestIamPermissions setAccessToken(String string) {
                        return (TestIamPermissions)super.setAccessToken(string);
                    }

                    public TestIamPermissions setAlt(String string) {
                        return (TestIamPermissions)super.setAlt(string);
                    }

                    public TestIamPermissions setCallback(String string) {
                        return (TestIamPermissions)super.setCallback(string);
                    }

                    public TestIamPermissions setFields(String string) {
                        return (TestIamPermissions)super.setFields(string);
                    }

                    public TestIamPermissions setKey(String string) {
                        return (TestIamPermissions)super.setKey(string);
                    }

                    public TestIamPermissions setOauthToken(String string) {
                        return (TestIamPermissions)super.setOauthToken(string);
                    }

                    public TestIamPermissions setPrettyPrint(Boolean bl) {
                        return (TestIamPermissions)super.setPrettyPrint(bl);
                    }

                    public TestIamPermissions setQuotaUser(String string) {
                        return (TestIamPermissions)super.setQuotaUser(string);
                    }

                    public TestIamPermissions setUploadType(String string) {
                        return (TestIamPermissions)super.setUploadType(string);
                    }

                    public TestIamPermissions setUploadProtocol(String string) {
                        return (TestIamPermissions)super.setUploadProtocol(string);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public TestIamPermissions setResource(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/workflowTemplates/[^/]+$");
                        }
                        this.resource = string;
                        return this;
                    }

                    @Override
                    public TestIamPermissions set(String string, Object object) {
                        return (TestIamPermissions)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class SetIamPolicy
                extends DataprocRequest<Policy> {
                    private static final String REST_PATH = "v1/{+resource}:setIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected SetIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) {
                        super(Dataproc.this, "POST", REST_PATH, (Object)setIamPolicyRequest, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/workflowTemplates/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/workflowTemplates/[^/]+$");
                        }
                    }

                    public SetIamPolicy set$Xgafv(String string) {
                        return (SetIamPolicy)super.set$Xgafv(string);
                    }

                    public SetIamPolicy setAccessToken(String string) {
                        return (SetIamPolicy)super.setAccessToken(string);
                    }

                    public SetIamPolicy setAlt(String string) {
                        return (SetIamPolicy)super.setAlt(string);
                    }

                    public SetIamPolicy setCallback(String string) {
                        return (SetIamPolicy)super.setCallback(string);
                    }

                    public SetIamPolicy setFields(String string) {
                        return (SetIamPolicy)super.setFields(string);
                    }

                    public SetIamPolicy setKey(String string) {
                        return (SetIamPolicy)super.setKey(string);
                    }

                    public SetIamPolicy setOauthToken(String string) {
                        return (SetIamPolicy)super.setOauthToken(string);
                    }

                    public SetIamPolicy setPrettyPrint(Boolean bl) {
                        return (SetIamPolicy)super.setPrettyPrint(bl);
                    }

                    public SetIamPolicy setQuotaUser(String string) {
                        return (SetIamPolicy)super.setQuotaUser(string);
                    }

                    public SetIamPolicy setUploadType(String string) {
                        return (SetIamPolicy)super.setUploadType(string);
                    }

                    public SetIamPolicy setUploadProtocol(String string) {
                        return (SetIamPolicy)super.setUploadProtocol(string);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public SetIamPolicy setResource(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/workflowTemplates/[^/]+$");
                        }
                        this.resource = string;
                        return this;
                    }

                    @Override
                    public SetIamPolicy set(String string, Object object) {
                        return (SetIamPolicy)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends DataprocRequest<ListWorkflowTemplatesResponse> {
                    private static final String REST_PATH = "v1/{+parent}/workflowTemplates";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String pageToken;
                    @Key
                    private Integer pageSize;

                    protected List(String string) {
                        super(Dataproc.this, "GET", REST_PATH, null, ListWorkflowTemplatesResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = string;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String string) {
                        this.pageToken = string;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer n) {
                        this.pageSize = n;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class InstantiateInline
                extends DataprocRequest<Operation> {
                    private static final String REST_PATH = "v1/{+parent}/workflowTemplates:instantiateInline";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String requestId;

                    protected InstantiateInline(String string, WorkflowTemplate workflowTemplate) {
                        super(Dataproc.this, "POST", REST_PATH, (Object)workflowTemplate, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public InstantiateInline set$Xgafv(String string) {
                        return (InstantiateInline)super.set$Xgafv(string);
                    }

                    public InstantiateInline setAccessToken(String string) {
                        return (InstantiateInline)super.setAccessToken(string);
                    }

                    public InstantiateInline setAlt(String string) {
                        return (InstantiateInline)super.setAlt(string);
                    }

                    public InstantiateInline setCallback(String string) {
                        return (InstantiateInline)super.setCallback(string);
                    }

                    public InstantiateInline setFields(String string) {
                        return (InstantiateInline)super.setFields(string);
                    }

                    public InstantiateInline setKey(String string) {
                        return (InstantiateInline)super.setKey(string);
                    }

                    public InstantiateInline setOauthToken(String string) {
                        return (InstantiateInline)super.setOauthToken(string);
                    }

                    public InstantiateInline setPrettyPrint(Boolean bl) {
                        return (InstantiateInline)super.setPrettyPrint(bl);
                    }

                    public InstantiateInline setQuotaUser(String string) {
                        return (InstantiateInline)super.setQuotaUser(string);
                    }

                    public InstantiateInline setUploadType(String string) {
                        return (InstantiateInline)super.setUploadType(string);
                    }

                    public InstantiateInline setUploadProtocol(String string) {
                        return (InstantiateInline)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public InstantiateInline setParent(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = string;
                        return this;
                    }

                    public String getRequestId() {
                        return this.requestId;
                    }

                    public InstantiateInline setRequestId(String string) {
                        this.requestId = string;
                        return this;
                    }

                    @Override
                    public InstantiateInline set(String string, Object object) {
                        return (InstantiateInline)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Instantiate
                extends DataprocRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}:instantiate";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Instantiate(String string, InstantiateWorkflowTemplateRequest instantiateWorkflowTemplateRequest) {
                        super(Dataproc.this, "POST", REST_PATH, (Object)instantiateWorkflowTemplateRequest, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/workflowTemplates/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/workflowTemplates/[^/]+$");
                        }
                    }

                    public Instantiate set$Xgafv(String string) {
                        return (Instantiate)super.set$Xgafv(string);
                    }

                    public Instantiate setAccessToken(String string) {
                        return (Instantiate)super.setAccessToken(string);
                    }

                    public Instantiate setAlt(String string) {
                        return (Instantiate)super.setAlt(string);
                    }

                    public Instantiate setCallback(String string) {
                        return (Instantiate)super.setCallback(string);
                    }

                    public Instantiate setFields(String string) {
                        return (Instantiate)super.setFields(string);
                    }

                    public Instantiate setKey(String string) {
                        return (Instantiate)super.setKey(string);
                    }

                    public Instantiate setOauthToken(String string) {
                        return (Instantiate)super.setOauthToken(string);
                    }

                    public Instantiate setPrettyPrint(Boolean bl) {
                        return (Instantiate)super.setPrettyPrint(bl);
                    }

                    public Instantiate setQuotaUser(String string) {
                        return (Instantiate)super.setQuotaUser(string);
                    }

                    public Instantiate setUploadType(String string) {
                        return (Instantiate)super.setUploadType(string);
                    }

                    public Instantiate setUploadProtocol(String string) {
                        return (Instantiate)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Instantiate setName(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/workflowTemplates/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Instantiate set(String string, Object object) {
                        return (Instantiate)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class GetIamPolicy
                extends DataprocRequest<Policy> {
                    private static final String REST_PATH = "v1/{+resource}:getIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected GetIamPolicy(String string, GetIamPolicyRequest getIamPolicyRequest) {
                        super(Dataproc.this, "POST", REST_PATH, (Object)getIamPolicyRequest, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/workflowTemplates/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/workflowTemplates/[^/]+$");
                        }
                    }

                    public GetIamPolicy set$Xgafv(String string) {
                        return (GetIamPolicy)super.set$Xgafv(string);
                    }

                    public GetIamPolicy setAccessToken(String string) {
                        return (GetIamPolicy)super.setAccessToken(string);
                    }

                    public GetIamPolicy setAlt(String string) {
                        return (GetIamPolicy)super.setAlt(string);
                    }

                    public GetIamPolicy setCallback(String string) {
                        return (GetIamPolicy)super.setCallback(string);
                    }

                    public GetIamPolicy setFields(String string) {
                        return (GetIamPolicy)super.setFields(string);
                    }

                    public GetIamPolicy setKey(String string) {
                        return (GetIamPolicy)super.setKey(string);
                    }

                    public GetIamPolicy setOauthToken(String string) {
                        return (GetIamPolicy)super.setOauthToken(string);
                    }

                    public GetIamPolicy setPrettyPrint(Boolean bl) {
                        return (GetIamPolicy)super.setPrettyPrint(bl);
                    }

                    public GetIamPolicy setQuotaUser(String string) {
                        return (GetIamPolicy)super.setQuotaUser(string);
                    }

                    public GetIamPolicy setUploadType(String string) {
                        return (GetIamPolicy)super.setUploadType(string);
                    }

                    public GetIamPolicy setUploadProtocol(String string) {
                        return (GetIamPolicy)super.setUploadProtocol(string);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public GetIamPolicy setResource(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/workflowTemplates/[^/]+$");
                        }
                        this.resource = string;
                        return this;
                    }

                    @Override
                    public GetIamPolicy set(String string, Object object) {
                        return (GetIamPolicy)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends DataprocRequest<WorkflowTemplate> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private Integer version;

                    protected Get(String string) {
                        super(Dataproc.this, "GET", REST_PATH, null, WorkflowTemplate.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/workflowTemplates/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/workflowTemplates/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String string) {
                        return (Get)super.set$Xgafv(string);
                    }

                    public Get setAccessToken(String string) {
                        return (Get)super.setAccessToken(string);
                    }

                    public Get setAlt(String string) {
                        return (Get)super.setAlt(string);
                    }

                    public Get setCallback(String string) {
                        return (Get)super.setCallback(string);
                    }

                    public Get setFields(String string) {
                        return (Get)super.setFields(string);
                    }

                    public Get setKey(String string) {
                        return (Get)super.setKey(string);
                    }

                    public Get setOauthToken(String string) {
                        return (Get)super.setOauthToken(string);
                    }

                    public Get setPrettyPrint(Boolean bl) {
                        return (Get)super.setPrettyPrint(bl);
                    }

                    public Get setQuotaUser(String string) {
                        return (Get)super.setQuotaUser(string);
                    }

                    public Get setUploadType(String string) {
                        return (Get)super.setUploadType(string);
                    }

                    public Get setUploadProtocol(String string) {
                        return (Get)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/workflowTemplates/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    public Integer getVersion() {
                        return this.version;
                    }

                    public Get setVersion(Integer n) {
                        this.version = n;
                        return this;
                    }

                    @Override
                    public Get set(String string, Object object) {
                        return (Get)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Delete
                extends DataprocRequest<Empty> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private Integer version;

                    protected Delete(String string) {
                        super(Dataproc.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/workflowTemplates/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/workflowTemplates/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String string) {
                        return (Delete)super.set$Xgafv(string);
                    }

                    public Delete setAccessToken(String string) {
                        return (Delete)super.setAccessToken(string);
                    }

                    public Delete setAlt(String string) {
                        return (Delete)super.setAlt(string);
                    }

                    public Delete setCallback(String string) {
                        return (Delete)super.setCallback(string);
                    }

                    public Delete setFields(String string) {
                        return (Delete)super.setFields(string);
                    }

                    public Delete setKey(String string) {
                        return (Delete)super.setKey(string);
                    }

                    public Delete setOauthToken(String string) {
                        return (Delete)super.setOauthToken(string);
                    }

                    public Delete setPrettyPrint(Boolean bl) {
                        return (Delete)super.setPrettyPrint(bl);
                    }

                    public Delete setQuotaUser(String string) {
                        return (Delete)super.setQuotaUser(string);
                    }

                    public Delete setUploadType(String string) {
                        return (Delete)super.setUploadType(string);
                    }

                    public Delete setUploadProtocol(String string) {
                        return (Delete)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/workflowTemplates/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    public Integer getVersion() {
                        return this.version;
                    }

                    public Delete setVersion(Integer n) {
                        this.version = n;
                        return this;
                    }

                    @Override
                    public Delete set(String string, Object object) {
                        return (Delete)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Create
                extends DataprocRequest<WorkflowTemplate> {
                    private static final String REST_PATH = "v1/{+parent}/workflowTemplates";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected Create(String string, WorkflowTemplate workflowTemplate) {
                        super(Dataproc.this, "POST", REST_PATH, (Object)workflowTemplate, WorkflowTemplate.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String string) {
                        return (Create)super.set$Xgafv(string);
                    }

                    public Create setAccessToken(String string) {
                        return (Create)super.setAccessToken(string);
                    }

                    public Create setAlt(String string) {
                        return (Create)super.setAlt(string);
                    }

                    public Create setCallback(String string) {
                        return (Create)super.setCallback(string);
                    }

                    public Create setFields(String string) {
                        return (Create)super.setFields(string);
                    }

                    public Create setKey(String string) {
                        return (Create)super.setKey(string);
                    }

                    public Create setOauthToken(String string) {
                        return (Create)super.setOauthToken(string);
                    }

                    public Create setPrettyPrint(Boolean bl) {
                        return (Create)super.setPrettyPrint(bl);
                    }

                    public Create setQuotaUser(String string) {
                        return (Create)super.setQuotaUser(string);
                    }

                    public Create setUploadType(String string) {
                        return (Create)super.setUploadType(string);
                    }

                    public Create setUploadProtocol(String string) {
                        return (Create)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = string;
                        return this;
                    }

                    @Override
                    public Create set(String string, Object object) {
                        return (Create)super.set(string, object);
                    }
                }
            }

            public class AutoscalingPolicies {
                public GetIamPolicy getIamPolicy(String string, GetIamPolicyRequest getIamPolicyRequest) throws IOException {
                    GetIamPolicy getIamPolicy = new GetIamPolicy(string, getIamPolicyRequest);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)getIamPolicy);
                    return getIamPolicy;
                }

                public SetIamPolicy setIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) throws IOException {
                    SetIamPolicy setIamPolicy = new SetIamPolicy(string, setIamPolicyRequest);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)setIamPolicy);
                    return setIamPolicy;
                }

                public TestIamPermissions testIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) throws IOException {
                    TestIamPermissions testIamPermissions = new TestIamPermissions(string, testIamPermissionsRequest);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)testIamPermissions);
                    return testIamPermissions;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class TestIamPermissions
                extends DataprocRequest<TestIamPermissionsResponse> {
                    private static final String REST_PATH = "v1/{+resource}:testIamPermissions";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected TestIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) {
                        super(Dataproc.this, "POST", REST_PATH, (Object)testIamPermissionsRequest, TestIamPermissionsResponse.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/autoscalingPolicies/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/autoscalingPolicies/[^/]+$");
                        }
                    }

                    public TestIamPermissions set$Xgafv(String string) {
                        return (TestIamPermissions)super.set$Xgafv(string);
                    }

                    public TestIamPermissions setAccessToken(String string) {
                        return (TestIamPermissions)super.setAccessToken(string);
                    }

                    public TestIamPermissions setAlt(String string) {
                        return (TestIamPermissions)super.setAlt(string);
                    }

                    public TestIamPermissions setCallback(String string) {
                        return (TestIamPermissions)super.setCallback(string);
                    }

                    public TestIamPermissions setFields(String string) {
                        return (TestIamPermissions)super.setFields(string);
                    }

                    public TestIamPermissions setKey(String string) {
                        return (TestIamPermissions)super.setKey(string);
                    }

                    public TestIamPermissions setOauthToken(String string) {
                        return (TestIamPermissions)super.setOauthToken(string);
                    }

                    public TestIamPermissions setPrettyPrint(Boolean bl) {
                        return (TestIamPermissions)super.setPrettyPrint(bl);
                    }

                    public TestIamPermissions setQuotaUser(String string) {
                        return (TestIamPermissions)super.setQuotaUser(string);
                    }

                    public TestIamPermissions setUploadType(String string) {
                        return (TestIamPermissions)super.setUploadType(string);
                    }

                    public TestIamPermissions setUploadProtocol(String string) {
                        return (TestIamPermissions)super.setUploadProtocol(string);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public TestIamPermissions setResource(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/autoscalingPolicies/[^/]+$");
                        }
                        this.resource = string;
                        return this;
                    }

                    @Override
                    public TestIamPermissions set(String string, Object object) {
                        return (TestIamPermissions)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class SetIamPolicy
                extends DataprocRequest<Policy> {
                    private static final String REST_PATH = "v1/{+resource}:setIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected SetIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) {
                        super(Dataproc.this, "POST", REST_PATH, (Object)setIamPolicyRequest, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/autoscalingPolicies/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/autoscalingPolicies/[^/]+$");
                        }
                    }

                    public SetIamPolicy set$Xgafv(String string) {
                        return (SetIamPolicy)super.set$Xgafv(string);
                    }

                    public SetIamPolicy setAccessToken(String string) {
                        return (SetIamPolicy)super.setAccessToken(string);
                    }

                    public SetIamPolicy setAlt(String string) {
                        return (SetIamPolicy)super.setAlt(string);
                    }

                    public SetIamPolicy setCallback(String string) {
                        return (SetIamPolicy)super.setCallback(string);
                    }

                    public SetIamPolicy setFields(String string) {
                        return (SetIamPolicy)super.setFields(string);
                    }

                    public SetIamPolicy setKey(String string) {
                        return (SetIamPolicy)super.setKey(string);
                    }

                    public SetIamPolicy setOauthToken(String string) {
                        return (SetIamPolicy)super.setOauthToken(string);
                    }

                    public SetIamPolicy setPrettyPrint(Boolean bl) {
                        return (SetIamPolicy)super.setPrettyPrint(bl);
                    }

                    public SetIamPolicy setQuotaUser(String string) {
                        return (SetIamPolicy)super.setQuotaUser(string);
                    }

                    public SetIamPolicy setUploadType(String string) {
                        return (SetIamPolicy)super.setUploadType(string);
                    }

                    public SetIamPolicy setUploadProtocol(String string) {
                        return (SetIamPolicy)super.setUploadProtocol(string);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public SetIamPolicy setResource(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/autoscalingPolicies/[^/]+$");
                        }
                        this.resource = string;
                        return this;
                    }

                    @Override
                    public SetIamPolicy set(String string, Object object) {
                        return (SetIamPolicy)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class GetIamPolicy
                extends DataprocRequest<Policy> {
                    private static final String REST_PATH = "v1/{+resource}:getIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected GetIamPolicy(String string, GetIamPolicyRequest getIamPolicyRequest) {
                        super(Dataproc.this, "POST", REST_PATH, (Object)getIamPolicyRequest, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/autoscalingPolicies/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/autoscalingPolicies/[^/]+$");
                        }
                    }

                    public GetIamPolicy set$Xgafv(String string) {
                        return (GetIamPolicy)super.set$Xgafv(string);
                    }

                    public GetIamPolicy setAccessToken(String string) {
                        return (GetIamPolicy)super.setAccessToken(string);
                    }

                    public GetIamPolicy setAlt(String string) {
                        return (GetIamPolicy)super.setAlt(string);
                    }

                    public GetIamPolicy setCallback(String string) {
                        return (GetIamPolicy)super.setCallback(string);
                    }

                    public GetIamPolicy setFields(String string) {
                        return (GetIamPolicy)super.setFields(string);
                    }

                    public GetIamPolicy setKey(String string) {
                        return (GetIamPolicy)super.setKey(string);
                    }

                    public GetIamPolicy setOauthToken(String string) {
                        return (GetIamPolicy)super.setOauthToken(string);
                    }

                    public GetIamPolicy setPrettyPrint(Boolean bl) {
                        return (GetIamPolicy)super.setPrettyPrint(bl);
                    }

                    public GetIamPolicy setQuotaUser(String string) {
                        return (GetIamPolicy)super.setQuotaUser(string);
                    }

                    public GetIamPolicy setUploadType(String string) {
                        return (GetIamPolicy)super.setUploadType(string);
                    }

                    public GetIamPolicy setUploadProtocol(String string) {
                        return (GetIamPolicy)super.setUploadProtocol(string);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public GetIamPolicy setResource(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/autoscalingPolicies/[^/]+$");
                        }
                        this.resource = string;
                        return this;
                    }

                    @Override
                    public GetIamPolicy set(String string, Object object) {
                        return (GetIamPolicy)super.set(string, object);
                    }
                }
            }
        }
    }
}

