/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-05-24 at 08:48:09 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dataproc.model;

/**
 * A YARN application created by a job. Application information is a subset of
 * org.apache.hadoop.yarn.proto.YarnProtos.ApplicationReportProto.Beta Feature: This report is
 * available for testing purposes only. It may be changed before final release.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Dataproc API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class YarnApplication extends com.google.api.client.json.GenericJson {

  /**
   * Required. The application name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Required. The numerical progress of the application, from 1 to 100.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float progress;

  /**
   * Required. The application state.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * Optional. The HTTP URL of the ApplicationMaster, HistoryServer, or TimelineServer that provides
   * application-specific information. The URL uses the internal hostname, and requires a proxy
   * server for resolution and, possibly, access.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String trackingUrl;

  /**
   * Required. The application name.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Required. The application name.
   * @param name name or {@code null} for none
   */
  public YarnApplication setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Required. The numerical progress of the application, from 1 to 100.
   * @return value or {@code null} for none
   */
  public java.lang.Float getProgress() {
    return progress;
  }

  /**
   * Required. The numerical progress of the application, from 1 to 100.
   * @param progress progress or {@code null} for none
   */
  public YarnApplication setProgress(java.lang.Float progress) {
    this.progress = progress;
    return this;
  }

  /**
   * Required. The application state.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * Required. The application state.
   * @param state state or {@code null} for none
   */
  public YarnApplication setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  /**
   * Optional. The HTTP URL of the ApplicationMaster, HistoryServer, or TimelineServer that provides
   * application-specific information. The URL uses the internal hostname, and requires a proxy
   * server for resolution and, possibly, access.
   * @return value or {@code null} for none
   */
  public java.lang.String getTrackingUrl() {
    return trackingUrl;
  }

  /**
   * Optional. The HTTP URL of the ApplicationMaster, HistoryServer, or TimelineServer that provides
   * application-specific information. The URL uses the internal hostname, and requires a proxy
   * server for resolution and, possibly, access.
   * @param trackingUrl trackingUrl or {@code null} for none
   */
  public YarnApplication setTrackingUrl(java.lang.String trackingUrl) {
    this.trackingUrl = trackingUrl;
    return this;
  }

  @Override
  public YarnApplication set(String fieldName, Object value) {
    return (YarnApplication) super.set(fieldName, value);
  }

  @Override
  public YarnApplication clone() {
    return (YarnApplication) super.clone();
  }

}
