/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-05-24 at 08:48:09 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dataproc.model;

/**
 * A list of queries to run on a cluster.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Dataproc API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class QueryList extends com.google.api.client.json.GenericJson {

  /**
   * Required. The queries to execute. You do not need to terminate a query with a semicolon.
   * Multiple queries can be specified in one string by separating each with a semicolon. Here is an
   * example of an Cloud Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob":
   * {   "queryList": {     "queries": [       "query1",       "query2",       "query3;query4",
   * ]   } }
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> queries;

  /**
   * Required. The queries to execute. You do not need to terminate a query with a semicolon.
   * Multiple queries can be specified in one string by separating each with a semicolon. Here is an
   * example of an Cloud Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob":
   * {   "queryList": {     "queries": [       "query1",       "query2",       "query3;query4",
   * ]   } }
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getQueries() {
    return queries;
  }

  /**
   * Required. The queries to execute. You do not need to terminate a query with a semicolon.
   * Multiple queries can be specified in one string by separating each with a semicolon. Here is an
   * example of an Cloud Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob":
   * {   "queryList": {     "queries": [       "query1",       "query2",       "query3;query4",
   * ]   } }
   * @param queries queries or {@code null} for none
   */
  public QueryList setQueries(java.util.List<java.lang.String> queries) {
    this.queries = queries;
    return this;
  }

  @Override
  public QueryList set(String fieldName, Object value) {
    return (QueryList) super.set(fieldName, value);
  }

  @Override
  public QueryList clone() {
    return (QueryList) super.clone();
  }

}
