/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-05-24 at 08:48:09 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dataproc.model;

/**
 * Configuration for parameter validation.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Dataproc API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ParameterValidation extends com.google.api.client.json.GenericJson {

  /**
   * Validation based on regular expressions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RegexValidation regex;

  /**
   * Validation based on a list of allowed values.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ValueValidation values;

  /**
   * Validation based on regular expressions.
   * @return value or {@code null} for none
   */
  public RegexValidation getRegex() {
    return regex;
  }

  /**
   * Validation based on regular expressions.
   * @param regex regex or {@code null} for none
   */
  public ParameterValidation setRegex(RegexValidation regex) {
    this.regex = regex;
    return this;
  }

  /**
   * Validation based on a list of allowed values.
   * @return value or {@code null} for none
   */
  public ValueValidation getValues() {
    return values;
  }

  /**
   * Validation based on a list of allowed values.
   * @param values values or {@code null} for none
   */
  public ParameterValidation setValues(ValueValidation values) {
    this.values = values;
    return this;
  }

  @Override
  public ParameterValidation set(String fieldName, Object value) {
    return (ParameterValidation) super.set(fieldName, value);
  }

  @Override
  public ParameterValidation clone() {
    return (ParameterValidation) super.clone();
  }

}
