/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-05-24 at 08:48:09 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dataproc.model;

/**
 * Cluster that is managed by the workflow.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Dataproc API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ManagedCluster extends com.google.api.client.json.GenericJson {

  /**
   * Required. The cluster name prefix. A unique cluster name will be formed by appending a random
   * suffix.The name must contain only lower-case letters (a-z), numbers (0-9), and hyphens (-).
   * Must begin with a letter. Cannot begin or end with hyphen. Must consist of between 2 and 35
   * characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String clusterName;

  /**
   * Required. The cluster configuration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ClusterConfig config;

  /**
   * Optional. The labels to associate with this cluster.Label keys must be between 1 and 63
   * characters long, and must conform to the following PCRE regular expression:
   * \p{Ll}\p{Lo}{0,62}Label values must be between 1 and 63 characters long, and must conform to
   * the following PCRE regular expression: \p{Ll}\p{Lo}\p{N}_-{0,63}No more than 32 labels can be
   * associated with a given cluster.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> labels;

  /**
   * Required. The cluster name prefix. A unique cluster name will be formed by appending a random
   * suffix.The name must contain only lower-case letters (a-z), numbers (0-9), and hyphens (-).
   * Must begin with a letter. Cannot begin or end with hyphen. Must consist of between 2 and 35
   * characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getClusterName() {
    return clusterName;
  }

  /**
   * Required. The cluster name prefix. A unique cluster name will be formed by appending a random
   * suffix.The name must contain only lower-case letters (a-z), numbers (0-9), and hyphens (-).
   * Must begin with a letter. Cannot begin or end with hyphen. Must consist of between 2 and 35
   * characters.
   * @param clusterName clusterName or {@code null} for none
   */
  public ManagedCluster setClusterName(java.lang.String clusterName) {
    this.clusterName = clusterName;
    return this;
  }

  /**
   * Required. The cluster configuration.
   * @return value or {@code null} for none
   */
  public ClusterConfig getConfig() {
    return config;
  }

  /**
   * Required. The cluster configuration.
   * @param config config or {@code null} for none
   */
  public ManagedCluster setConfig(ClusterConfig config) {
    this.config = config;
    return this;
  }

  /**
   * Optional. The labels to associate with this cluster.Label keys must be between 1 and 63
   * characters long, and must conform to the following PCRE regular expression:
   * \p{Ll}\p{Lo}{0,62}Label values must be between 1 and 63 characters long, and must conform to
   * the following PCRE regular expression: \p{Ll}\p{Lo}\p{N}_-{0,63}No more than 32 labels can be
   * associated with a given cluster.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getLabels() {
    return labels;
  }

  /**
   * Optional. The labels to associate with this cluster.Label keys must be between 1 and 63
   * characters long, and must conform to the following PCRE regular expression:
   * \p{Ll}\p{Lo}{0,62}Label values must be between 1 and 63 characters long, and must conform to
   * the following PCRE regular expression: \p{Ll}\p{Lo}\p{N}_-{0,63}No more than 32 labels can be
   * associated with a given cluster.
   * @param labels labels or {@code null} for none
   */
  public ManagedCluster setLabels(java.util.Map<String, java.lang.String> labels) {
    this.labels = labels;
    return this;
  }

  @Override
  public ManagedCluster set(String fieldName, Object value) {
    return (ManagedCluster) super.set(fieldName, value);
  }

  @Override
  public ManagedCluster clone() {
    return (ManagedCluster) super.clone();
  }

}
