/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-05-24 at 08:48:09 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dataproc.model;

/**
 * Cloud Dataproc job status.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Dataproc API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class JobStatus extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Optional job state details, such as an error description if the state is ERROR.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String details;

  /**
   * Output only. A state message specifying the overall job state.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * Output only. The time when this state was entered.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String stateStartTime;

  /**
   * Output only. Additional state information, which includes status reported by the agent.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String substate;

  /**
   * Output only. Optional job state details, such as an error description if the state is ERROR.
   * @return value or {@code null} for none
   */
  public java.lang.String getDetails() {
    return details;
  }

  /**
   * Output only. Optional job state details, such as an error description if the state is ERROR.
   * @param details details or {@code null} for none
   */
  public JobStatus setDetails(java.lang.String details) {
    this.details = details;
    return this;
  }

  /**
   * Output only. A state message specifying the overall job state.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * Output only. A state message specifying the overall job state.
   * @param state state or {@code null} for none
   */
  public JobStatus setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  /**
   * Output only. The time when this state was entered.
   * @return value or {@code null} for none
   */
  public String getStateStartTime() {
    return stateStartTime;
  }

  /**
   * Output only. The time when this state was entered.
   * @param stateStartTime stateStartTime or {@code null} for none
   */
  public JobStatus setStateStartTime(String stateStartTime) {
    this.stateStartTime = stateStartTime;
    return this;
  }

  /**
   * Output only. Additional state information, which includes status reported by the agent.
   * @return value or {@code null} for none
   */
  public java.lang.String getSubstate() {
    return substate;
  }

  /**
   * Output only. Additional state information, which includes status reported by the agent.
   * @param substate substate or {@code null} for none
   */
  public JobStatus setSubstate(java.lang.String substate) {
    this.substate = substate;
    return this;
  }

  @Override
  public JobStatus set(String fieldName, Object value) {
    return (JobStatus) super.set(fieldName, value);
  }

  @Override
  public JobStatus clone() {
    return (JobStatus) super.clone();
  }

}
