/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-05-24 at 08:48:09 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dataproc.model;

/**
 * A selector that chooses target cluster for jobs based on metadata.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Dataproc API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ClusterSelector extends com.google.api.client.json.GenericJson {

  /**
   * Required. The cluster labels. Cluster must have all labels to match.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> clusterLabels;

  /**
   * Optional. The zone where workflow process executes. This parameter does not affect the
   * selection of the cluster.If unspecified, the zone of the first cluster matching the selector is
   * used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String zone;

  /**
   * Required. The cluster labels. Cluster must have all labels to match.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getClusterLabels() {
    return clusterLabels;
  }

  /**
   * Required. The cluster labels. Cluster must have all labels to match.
   * @param clusterLabels clusterLabels or {@code null} for none
   */
  public ClusterSelector setClusterLabels(java.util.Map<String, java.lang.String> clusterLabels) {
    this.clusterLabels = clusterLabels;
    return this;
  }

  /**
   * Optional. The zone where workflow process executes. This parameter does not affect the
   * selection of the cluster.If unspecified, the zone of the first cluster matching the selector is
   * used.
   * @return value or {@code null} for none
   */
  public java.lang.String getZone() {
    return zone;
  }

  /**
   * Optional. The zone where workflow process executes. This parameter does not affect the
   * selection of the cluster.If unspecified, the zone of the first cluster matching the selector is
   * used.
   * @param zone zone or {@code null} for none
   */
  public ClusterSelector setZone(java.lang.String zone) {
    this.zone = zone;
    return this;
  }

  @Override
  public ClusterSelector set(String fieldName, Object value) {
    return (ClusterSelector) super.set(fieldName, value);
  }

  @Override
  public ClusterSelector clone() {
    return (ClusterSelector) super.clone();
  }

}
