/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-05-24 at 08:48:09 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dataproc.model;

/**
 * The cluster operation triggered by a workflow.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Dataproc API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ClusterOperation extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Indicates the operation is done.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean done;

  /**
   * Output only. Error, if operation failed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String error;

  /**
   * Output only. The id of the cluster operation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String operationId;

  /**
   * Output only. Indicates the operation is done.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDone() {
    return done;
  }

  /**
   * Output only. Indicates the operation is done.
   * @param done done or {@code null} for none
   */
  public ClusterOperation setDone(java.lang.Boolean done) {
    this.done = done;
    return this;
  }

  /**
   * Output only. Error, if operation failed.
   * @return value or {@code null} for none
   */
  public java.lang.String getError() {
    return error;
  }

  /**
   * Output only. Error, if operation failed.
   * @param error error or {@code null} for none
   */
  public ClusterOperation setError(java.lang.String error) {
    this.error = error;
    return this;
  }

  /**
   * Output only. The id of the cluster operation.
   * @return value or {@code null} for none
   */
  public java.lang.String getOperationId() {
    return operationId;
  }

  /**
   * Output only. The id of the cluster operation.
   * @param operationId operationId or {@code null} for none
   */
  public ClusterOperation setOperationId(java.lang.String operationId) {
    this.operationId = operationId;
    return this;
  }

  @Override
  public ClusterOperation set(String fieldName, Object value) {
    return (ClusterOperation) super.set(fieldName, value);
  }

  @Override
  public ClusterOperation clone() {
    return (ClusterOperation) super.clone();
  }

}
