/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudresourcemanager.model;

/**
 * The response returned from the `SearchOrganizations` method.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Resource Manager API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SearchOrganizationsResponse extends com.google.api.client.json.GenericJson {

  /**
   * A pagination token to be used to retrieve the next page of results. If the result is too large
   * to fit within the page size specified in the request, this field will be set with a token that
   * can be used to fetch the next page of results. If this field is empty, it indicates that this
   * response contains the last page of results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The list of Organizations that matched the search query, possibly paginated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Organization> organizations;

  static {
    // hack to force ProGuard to consider Organization used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Organization.class);
  }

  /**
   * A pagination token to be used to retrieve the next page of results. If the result is too large
   * to fit within the page size specified in the request, this field will be set with a token that
   * can be used to fetch the next page of results. If this field is empty, it indicates that this
   * response contains the last page of results.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * A pagination token to be used to retrieve the next page of results. If the result is too large
   * to fit within the page size specified in the request, this field will be set with a token that
   * can be used to fetch the next page of results. If this field is empty, it indicates that this
   * response contains the last page of results.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public SearchOrganizationsResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * The list of Organizations that matched the search query, possibly paginated.
   * @return value or {@code null} for none
   */
  public java.util.List<Organization> getOrganizations() {
    return organizations;
  }

  /**
   * The list of Organizations that matched the search query, possibly paginated.
   * @param organizations organizations or {@code null} for none
   */
  public SearchOrganizationsResponse setOrganizations(java.util.List<Organization> organizations) {
    this.organizations = organizations;
    return this;
  }

  @Override
  public SearchOrganizationsResponse set(String fieldName, Object value) {
    return (SearchOrganizationsResponse) super.set(fieldName, value);
  }

  @Override
  public SearchOrganizationsResponse clone() {
    return (SearchOrganizationsResponse) super.clone();
  }

}
