/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-02-10 at 01:52:18 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.calendar.model;

/**
 * Model definition for FreeBusyResponse.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Calendar API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FreeBusyResponse extends com.google.api.client.json.GenericJson {

  /**
   * List of free/busy information for calendars.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, FreeBusyCalendar> calendars;

  static {
    // hack to force ProGuard to consider FreeBusyCalendar used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(FreeBusyCalendar.class);
  }

  /**
   * Expansion of groups.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, FreeBusyGroup> groups;

  static {
    // hack to force ProGuard to consider FreeBusyGroup used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(FreeBusyGroup.class);
  }

  /**
   * Type of the resource ("calendar#freeBusy").
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The end of the interval.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime timeMax;

  /**
   * The start of the interval.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime timeMin;

  /**
   * List of free/busy information for calendars.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, FreeBusyCalendar> getCalendars() {
    return calendars;
  }

  /**
   * List of free/busy information for calendars.
   * @param calendars calendars or {@code null} for none
   */
  public FreeBusyResponse setCalendars(java.util.Map<String, FreeBusyCalendar> calendars) {
    this.calendars = calendars;
    return this;
  }

  /**
   * Expansion of groups.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, FreeBusyGroup> getGroups() {
    return groups;
  }

  /**
   * Expansion of groups.
   * @param groups groups or {@code null} for none
   */
  public FreeBusyResponse setGroups(java.util.Map<String, FreeBusyGroup> groups) {
    this.groups = groups;
    return this;
  }

  /**
   * Type of the resource ("calendar#freeBusy").
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Type of the resource ("calendar#freeBusy").
   * @param kind kind or {@code null} for none
   */
  public FreeBusyResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The end of the interval.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getTimeMax() {
    return timeMax;
  }

  /**
   * The end of the interval.
   * @param timeMax timeMax or {@code null} for none
   */
  public FreeBusyResponse setTimeMax(com.google.api.client.util.DateTime timeMax) {
    this.timeMax = timeMax;
    return this;
  }

  /**
   * The start of the interval.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getTimeMin() {
    return timeMin;
  }

  /**
   * The start of the interval.
   * @param timeMin timeMin or {@code null} for none
   */
  public FreeBusyResponse setTimeMin(com.google.api.client.util.DateTime timeMin) {
    this.timeMin = timeMin;
    return this;
  }

  @Override
  public FreeBusyResponse set(String fieldName, Object value) {
    return (FreeBusyResponse) super.set(fieldName, value);
  }

  @Override
  public FreeBusyResponse clone() {
    return (FreeBusyResponse) super.clone();
  }

}
